/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server.util;

import java.util.Locale;

public class OSUtils {
    public static final boolean DEBUG = false;
    public static final int OS_UNDEFINED = 0;
    public static final int OS_WINDOWS = 1;
    public static final int OS_LINUX = 2;
    public static final int OS_SOLARIS = 3;
    public static final int OS_HPUX = 4;
    public static final int OS_AIX = 5;
    public static final int OS_OPENVMS = 6;
    public static final int OS_ALX = 7;
    public static final int OS_MVS = 8;
    public static final int OS_MAC = 9;
    public static final int OS_ZOS = 10;
    public static final String OS_SUFFIX_SAX = "sax";
    public static final String OS_SUFFIX_S64 = "s64";
    public static final String OS_SUFFIX_LIX = "lix";
    public static final String OS_SUFFIX_LAX = "lax";
    public static final String OS_SUFFIX_LNX = "lnx";
    public static final String OS_SUFFIX_H6I = "h6i";
    public static final String OS_SUFFIX_H64 = "h64";
    public static final String OS_SUFFIX_R64 = "r64";
    public static final String OS_SUFFIX_ALX = "alx";
    public static final String OS_SUFFIX_W64 = "w64";
    public static final String OS_SUFFIX_WX6 = "wx6";
    public static final String OS_SUFFIX_WIN = "win";
    public static final String OS_SUFFIX_MVS = "mvs";
    public static final String OS_SUFFIX_MAC = "mac";
    public static final String OS_SUFFIX_VMI = "vmi";
    public static final String OS_SUFFIX_ZOS = "zos";
    public static final String OS_FAMILY_UNDEFINED = "Undefined";
    public static final String OS_FAMILY_UNIX = "Unix";
    public static final String OS_FAMILY_WINDOWS = "Windows";
    public static final String OS_FAMILY_MAC = "Macintosh";
    public static final String OS_FAMILY_MVS = "MVS";
    public static final String OS_FAMILY_ZOS = "ZOS";
    public static final String OS_FAMILY_VMS = "VMS";
    public static final String OS_3_UNIX = "unx";
    public static final String OS_3_WINDOWS = "win";
    public static final String OS_3_MAC = "mac";
    public static final String OS_3_ZOS = "zos";
    public static final String OS_3_UND = "und";
    private static final int MAX_BUNDLES_SEARCHED = 7;
    static int gc_count = 0;
    static int m_os = 0;
    static String m_osSuffix = null;

    public static String getOS_Family() {
        switch (OSUtils.getOS()) {
            case 0: {
                return OS_FAMILY_UNDEFINED;
            }
            case 1: {
                return OS_FAMILY_WINDOWS;
            }
            case 2: {
                return OS_FAMILY_UNIX;
            }
            case 3: {
                return OS_FAMILY_UNIX;
            }
            case 4: {
                return OS_FAMILY_UNIX;
            }
            case 5: {
                return OS_FAMILY_UNIX;
            }
            case 6: {
                return OS_FAMILY_VMS;
            }
            case 7: {
                return OS_FAMILY_UNIX;
            }
            case 8: {
                return OS_FAMILY_MVS;
            }
            case 9: {
                return OS_FAMILY_MAC;
            }
            case 10: {
                return OS_FAMILY_ZOS;
            }
        }
        return OS_FAMILY_UNDEFINED;
    }

    public static String getOS_3byte(String osName) {
        switch (OSUtils.getOS()) {
            case 0: {
                return OS_3_UND;
            }
            case 1: {
                return "win";
            }
            case 2: {
                return OS_3_UNIX;
            }
            case 3: {
                return OS_3_UNIX;
            }
            case 4: {
                return OS_3_UNIX;
            }
            case 5: {
                return OS_3_UNIX;
            }
            case 6: {
                return OS_3_UNIX;
            }
            case 7: {
                return OS_3_UNIX;
            }
            case 8: {
                return "zos";
            }
            case 9: {
                return "mac";
            }
            case 10: {
                return "zos";
            }
        }
        return OS_3_UND;
    }

    public static int getOS() {
        int rc = 0;
        String osName = System.getProperty("os.name");
        if (osName.startsWith(OS_FAMILY_WINDOWS)) {
            rc = 1;
        } else if (osName.equalsIgnoreCase("Linux")) {
            rc = 2;
        } else if (osName.equalsIgnoreCase("Solaris") || osName.equalsIgnoreCase("SunOS")) {
            rc = 3;
        } else if (osName.equalsIgnoreCase("HP-UX")) {
            rc = 4;
        } else if (osName.equalsIgnoreCase("AIX")) {
            rc = 5;
        } else if (osName.equalsIgnoreCase("OpenVMS")) {
            rc = 6;
        } else if (osName.equalsIgnoreCase("Compaq's Digital UNIX") || osName.equalsIgnoreCase("OSF1")) {
            rc = 7;
        } else if (osName.equalsIgnoreCase(OS_FAMILY_MVS)) {
            rc = 8;
        } else if (osName.equalsIgnoreCase("z/os")) {
            rc = 10;
        } else if (osName.startsWith("Mac")) {
            rc = 9;
        } else if (osName.startsWith("OpenVMS")) {
            rc = 6;
        }
        return rc;
    }

    public static String getOS_Suffix(String osName) {
        String suffix = "";
        if (m_osSuffix != null) {
            suffix = m_osSuffix;
        } else {
            String osArch = System.getProperty("os.arch");
            boolean itanium = osArch.length() >= 4 && osArch.substring(0, 4).equalsIgnoreCase("ia64");
            boolean x86 = osArch.length() >= 3 && osArch.substring(0, 3).equalsIgnoreCase("x86");
            boolean x86_64 = osArch.length() >= 5 && osArch.substring(0, 5).equalsIgnoreCase("amd64");
            switch (OSUtils.getOS()) {
                case 3: {
                    if (x86) {
                        suffix = OS_SUFFIX_SAX;
                        break;
                    }
                    suffix = OS_SUFFIX_S64;
                    break;
                }
                case 2: {
                    if (!x86_64) {
                        try {
                            String sascmd = "sh -c 'if [ `uname -m` = \"x86_64\" ] ; then exit 1 ; else exit 0 ; fi'";
                            Runtime runtime = Runtime.getRuntime();
                            Process process = runtime.exec(sascmd);
                            int rc = process.waitFor();
                            x86_64 = rc == 1;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (itanium) {
                        suffix = OS_SUFFIX_LIX;
                        break;
                    }
                    if (x86_64) {
                        suffix = OS_SUFFIX_LAX;
                        break;
                    }
                    suffix = OS_SUFFIX_LNX;
                    break;
                }
                case 4: {
                    if (itanium) {
                        suffix = OS_SUFFIX_H6I;
                        break;
                    }
                    suffix = OS_SUFFIX_H64;
                    break;
                }
                case 5: {
                    suffix = OS_SUFFIX_R64;
                    break;
                }
                case 6: {
                    suffix = OS_SUFFIX_VMI;
                    break;
                }
                case 7: {
                    suffix = OS_SUFFIX_ALX;
                    break;
                }
                case 1: {
                    if (itanium) {
                        suffix = OS_SUFFIX_W64;
                        break;
                    }
                    suffix = "win";
                    break;
                }
                case 8: {
                    suffix = OS_SUFFIX_MVS;
                    break;
                }
                case 9: {
                    suffix = "mac";
                    break;
                }
                case 10: {
                    suffix = "zos";
                }
            }
            m_osSuffix = suffix;
        }
        return suffix;
    }

    public static String getOSCode4Byte(String osSuffix) {
        String code4Byte = null;
        code4Byte = osSuffix.equalsIgnoreCase(OS_SUFFIX_SAX) ? "slx6" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_S64) ? "sl64" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_LIX) ? "lini" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_LAX) ? "lina" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_LNX) ? "linx" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_H6I) ? "hp6i" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_H64) ? "hp64" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_R64) ? "ar64" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_ALX) ? "aosf" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_W64) ? OS_SUFFIX_W64 : (osSuffix.equalsIgnoreCase(OS_SUFFIX_WX6) ? OS_SUFFIX_WX6 : (osSuffix.equalsIgnoreCase("win") ? "wndw" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_MVS) ? "os" : (osSuffix.equalsIgnoreCase("mac") ? "mac" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_VMI) ? "ivms" : ""))))))))))))));
        return code4Byte;
    }

    public static String getLocale() {
        return "" + Locale.getDefault();
    }

    public static String getEncoding() {
        return "" + System.getProperty("file.encoding");
    }

    public static String getArch() {
        return "" + System.getProperty("os.arch");
    }
}

