/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server.util;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.util.BackupServerConstants;
import com.sas.svcs.backup.server.util.BackupServerUtil;
import com.sas.svcs.backup.server.util.OSUtils;
import com.sas.svcs.backup.server.util.RB;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigurationHelper {
    private Logger logger = LogManager.getLogger(ConfigurationHelper.class);
    private Properties cProperties = null;

    public ConfigurationHelper(Properties prop) {
        this.cProperties = prop;
    }

    public void configure(Command command) throws BackupException {
        String antProjectFile = this.createANTProject();
        if (!"".equals(antProjectFile)) {
            try {
                BackupServerUtil.runANTProject(antProjectFile, command);
                this.CreateExexutable();
                this.CreateIniFile();
            }
            catch (Exception exception) {
                throw new BackupException(exception, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_RUNNING_ANT.getErrorCode());
            }
        }
    }

    private String createANTProject() {
        StringBuilder projectFile = new StringBuilder();
        String startEncode = "<?xml version=\"1.0\"?>";
        String projectFilePrePart = "<project name=\"ConfigureBackup\" default=\"configure\">";
        String projectFileConfigTargetPart = "<target name=\"configure\"><antcall target=\"mkDirs\" inheritrefs=\"true\"/></target>";
        String ConfigTargetMkdirPart = "<target name=\"mkDirs\" description=\"This will create directories\"><mkdir dir=\"" + this.cProperties.getProperty("backupserver.workspace.dir") + "\"/><mkdir dir=\"" + this.cProperties.getProperty("backupserver.vault.dir") + "\"/><mkdir dir=\"" + this.cProperties.getProperty("backupserver.result.dir") + "\"/><mkdir dir=\"" + this.cProperties.getProperty("backupserver.log.dir") + "\"/><mkdir dir=\"" + this.cProperties.getProperty("backupserver.drop.zone") + "\"/><mkdir dir=\"" + this.cProperties.getProperty("backupserver.drop.zone") + "/" + "config" + "\"/></target>";
        String projectFilePostPart = "</project>";
        projectFile.append(startEncode);
        projectFile.append(projectFilePrePart);
        projectFile.append(projectFileConfigTargetPart);
        projectFile.append(ConfigTargetMkdirPart);
        projectFile.append(projectFilePostPart);
        return projectFile.toString();
    }

    private void CreateExexutable() throws BackupException {
        String extension = null;
        String exeExtension = null;
        String FAMILY = OSUtils.getOS_Family();
        OS_FAMILY osfamily = OS_FAMILY.valueOf(FAMILY);
        switch (osfamily) {
            case Undefined: {
                this.logger.info(RB.getStringResource("ConfigurationHelper.os.not.found.txt"));
                break;
            }
            case Windows: {
                extension = ".bat";
                exeExtension = ".exe";
                this.CreateExe_winfamily(extension, exeExtension);
                this.CreateJCR_winFamily(extension);
                break;
            }
            case Unix: {
                extension = ".sh";
                exeExtension = "";
                this.CreateExe_nonwinfamily(extension, exeExtension);
                this.CreateJCR_nonwinFamily(extension);
                break;
            }
            case VMS: {
                extension = ".sh";
                exeExtension = ".rexx";
                this.CreateExe_nonwinfamily(extension, exeExtension);
                this.CreateJCR_nonwinFamily(extension);
                break;
            }
            case MVS: {
                extension = ".sh";
                exeExtension = ".rexx";
                this.CreateExe_nonwinfamily(extension, exeExtension);
                this.CreateJCR_nonwinFamily(extension);
                break;
            }
            case ZOS: {
                extension = ".sh";
                exeExtension = ".rexx";
                this.CreateExe_nonwinfamily(extension, exeExtension);
                this.CreateJCR_nonwinFamily(extension);
                break;
            }
            default: {
                this.logger.info(RB.getStringResource("ConfigurationHelper.os.not.found.txt"));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void CreateJCR_nonwinFamily(String extension) throws BackupException {
        String path = this.cProperties.getProperty("backupserver.workspace.dir") + File.separator + "JCRCopyRepository" + extension;
        String jndiName = this.cProperties.getProperty(BackupServerConstants.BACKUP_CONFIG_SCS_JNDI_NAME);
        String jdbcUrl = this.cProperties.getProperty(BackupServerConstants.BACKUP_CONFIG_SCS_JDBC_URL);
        String jdbcDriver = this.cProperties.getProperty(BackupServerConstants.BACKUP_CONFIG_SCS_JDBC_DRIVER);
        if (jndiName == null || jdbcUrl == null || jdbcDriver == null) {
            this.logger.info(RB.getStringResource("ConfigurationHelper.os.bat.not.created.txt"));
            return;
        }
        File file = new File(path);
        FileWriter fstream = null;
        BufferedWriter out = null;
        try {
            fstream = new FileWriter(file);
            out = new BufferedWriter(fstream);
            out.write("#!/bin/sh");
            out.newLine();
            out.write("# JCRCopyRepository.sh");
            out.newLine();
            out.write(". `dirname $0`/../level_env.sh");
            out.newLine();
            out.write("LAUNCHERJAR=$SASVJR_HOME" + File.separator + "eclipse" + File.separator + "plugins" + File.separator + "sas.launcher.jar");
            out.newLine();
            out.write("UTILITIESDIR=$LEVEL_ROOT" + File.separator + "Backup");
            out.newLine();
            out.write("PICKLISTS=$SAS_HOME" + File.separator + "SASPlatformObjectFramework" + File.separator + "9.4" + File.separator + "picklists" + File.separator + "sas.svcs.admin.backup.batch.picklist");
            out.newLine();
            out.write("DRIVER=$LEVEL_ROOT" + File.separator + "Web" + File.separator + "Scripts" + File.separator + "AppServer" + File.separator + "jdbc" + File.separator + "postgresql-9.1-901.jdbc4.jar");
            out.newLine();
            out.write("CLASSPATH=$UTILITIESDIR:$LAUNCHERJAR");
            out.newLine();
            out.write("$JAVA_JRE_COMMAND ");
            out.write("-classpath $CLASSPATH ");
            out.write("-Djava.system.class.loader=com.sas.app.AppClassLoader ");
            out.write("-Dsas.app.launch.config=$PICKLISTS ");
            out.write("-Dsas.app.repository.path=$SASVJR_REPOSITORYPATH ");
            out.write("-Dsas.app.class.path=$UTILITIESDIR:$DRIVER ");
            out.write("-Dsas.ext.config=$SAS_HOME/sas.java.ext.config ");
            out.write("-Djava.security.auth.login.config=../Web" + File.separator + "Common" + File.separator + "login.config ");
            out.write("-Xmx256m ");
            out.write("-Dscs.jndi.jndiName=" + jndiName + " ");
            out.write("-Dscs.jndi.jdbcUrl=" + jdbcUrl + " ");
            out.write("-Dscs.jndi.driver=" + jdbcDriver + " ");
            out.write("-Dscs.jndi.user=$3 ");
            out.write("-Dscs.jndi.pwd=$4 ");
            out.write("-Djava.io.tmpdir=$5 ");
            out.write("com.sas.contentserver.core.JCRCopyRepository $1 $2 ");
            out.newLine();
            out.write("exit 0");
            out.newLine();
            if (fstream == null) return;
        }
        catch (IOException ioexception) {
            try {
                throw new BackupException(ioexception, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR.ordinal());
            }
            catch (Throwable throwable) {
                if (fstream == null) throw throwable;
                try {
                    out.close();
                    fstream.close();
                    if (file == null) throw throwable;
                    if (!file.exists()) throw throwable;
                    String[] command = new String[]{"/bin/chmod", "755", file.getAbsolutePath()};
                    Runtime.getRuntime().exec(command);
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            out.close();
            fstream.close();
            if (file == null) return;
            if (!file.exists()) return;
            String[] command = new String[]{"/bin/chmod", "755", file.getAbsolutePath()};
            Runtime.getRuntime().exec(command);
            return;
        }
        catch (IOException command) {
            return;
        }
    }

    private void CreateJCR_winFamily(String extension) throws BackupException {
        String path = this.cProperties.getProperty("backupserver.workspace.dir") + File.separator + "JCRCopyRepository" + extension;
        String jndiName = this.cProperties.getProperty(BackupServerConstants.BACKUP_CONFIG_SCS_JNDI_NAME);
        String jdbcUrl = this.cProperties.getProperty(BackupServerConstants.BACKUP_CONFIG_SCS_JDBC_URL);
        String jdbcDriver = this.cProperties.getProperty(BackupServerConstants.BACKUP_CONFIG_SCS_JDBC_DRIVER);
        String configDir = this.cProperties.getProperty(BackupServerConstants.SAS_CONFIG_BASE);
        if (jndiName == null || jdbcUrl == null || jdbcDriver == null) {
            this.logger.info(RB.getStringResource("ConfigurationHelper.os.bat.not.created.txt"));
            return;
        }
        File file = new File(path);
        FileWriter fstream = null;
        BufferedWriter out = null;
        try {
            fstream = new FileWriter(file);
            out = new BufferedWriter(fstream);
            out.write("@ECHO off");
            out.newLine();
            out.write("setlocal");
            out.newLine();
            out.write("call \"%~dp0.." + File.separator + "level_env.bat" + '\"');
            out.newLine();
            out.write("set LAUNCHERJAR=%SASVJR_HOME%" + File.separator + "eclipse" + File.separator + "plugins" + File.separator + "sas.launcher.jar");
            out.newLine();
            out.write("set UTILITIESDIR=%LEVEL_ROOT%" + File.separator + "Backup");
            out.newLine();
            out.write("set PICKLISTS=%SAS_HOME%" + File.separator + "SASPlatformObjectFramework" + File.separator + "9.4" + File.separator + "picklists" + File.separator + "sas.svcs.admin.backup.batch.picklist");
            out.newLine();
            out.write("set DRIVER=%LEVEL_ROOT%" + File.separator + "Web" + File.separator + "Scripts" + File.separator + "AppServer" + File.separator + "jdbc" + File.separator + "postgresql-9.1-901.jdbc4.jar");
            out.newLine();
            out.write("set CLASSPATH=%UTILITIESDIR%;%LAUNCHERJAR%");
            out.newLine();
            out.write("\"%JAVA_JRE_COMMAND%\"");
            out.write(" -classpath \"%CLASSPATH%\"");
            out.write(" -Djava.system.class.loader=com.sas.app.AppClassLoader");
            out.write(" -Dsas.app.launch.config=\"%PICKLISTS%\"");
            out.write(" -Dsas.app.repository.path=\"%SASVJR_REPOSITORYPATH%\"");
            out.write(" -Dsas.app.class.path=\"%UTILITIESDIR%;%DRIVER%\"");
            String logConfigPath = "%LEVEL_ROOT%" + File.separator + "Web" + File.separator + "Common" + File.separator + "login.config";
            if (configDir != null && configDir.contains(" ")) {
                out.write(" -Djava.security.auth.login.config=\"" + logConfigPath + "\"");
            } else {
                out.write(" -Djava.security.auth.login.config=" + logConfigPath);
            }
            out.write(" -Xmx256m");
            out.write(" -Dscs.jndi.jndiName=" + jndiName);
            out.write(" -Dscs.jndi.jdbcUrl=" + jdbcUrl);
            out.write(" -Dscs.jndi.driver=" + jdbcDriver);
            out.write(" -Dscs.jndi.user=%3");
            out.write(" -Dscs.jndi.pwd=%4");
            out.write(" -Djava.io.tmpdir=%5");
            out.write(" com.sas.contentserver.core.JCRCopyRepository %1 %2");
            out.newLine();
            out.write("endlocal");
            out.newLine();
            out.write("if [%2] EQU [exit] exit %ERRORLEVEL%");
        }
        catch (IOException ioexception) {
            throw new BackupException(ioexception, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR.ordinal());
        }
        finally {
            if (fstream != null) {
                try {
                    out.close();
                    fstream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void CreateExe_winfamily(String extension, String exeExtension) throws BackupException {
        String path = this.cProperties.getProperty("backupserver.workspace.dir") + File.separator + "BackupServer" + extension;
        File file = new File(path);
        FileWriter fstream = null;
        BufferedWriter out = null;
        try {
            fstream = new FileWriter(file);
            out = new BufferedWriter(fstream);
            out.write("@ECHO off");
            out.newLine();
            out.write("cd %~dp0");
            out.newLine();
            out.write("call \"" + this.cProperties.getProperty("backupserver.install.dir") + File.separator + "BackupServer" + exeExtension + "\" %*");
        }
        catch (IOException ioexception) {
            throw new BackupException(ioexception, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_CREATING_WINEXE.getErrorCode());
        }
        finally {
            if (fstream != null) {
                try {
                    out.close();
                    fstream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void CreateExe_nonwinfamily(String extension, String exeExtension) throws BackupException {
        String path = this.cProperties.getProperty("backupserver.workspace.dir") + File.separator + "BackupServer" + extension;
        File file = new File(path);
        FileWriter fstream = null;
        BufferedWriter out = null;
        try {
            fstream = new FileWriter(file);
            out = new BufferedWriter(fstream);
            out.write("#!/bin/sh -p");
            out.newLine();
            out.write("cd `dirname $0`");
            out.newLine();
            out.write(this.cProperties.getProperty("backupserver.install.dir") + File.separator + "BackupServer" + exeExtension + " \"$@\"");
            out.newLine();
            out.write("cd `dirname $0`");
            out.newLine();
            if (fstream == null) return;
        }
        catch (IOException ioexception) {
            try {
                throw new BackupException(ioexception, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_CREATING_NONWINEXE.getErrorCode());
            }
            catch (Throwable throwable) {
                if (fstream == null) throw throwable;
                try {
                    out.close();
                    fstream.close();
                    if (file == null) throw throwable;
                    if (!file.exists()) throw throwable;
                    String[] command = new String[]{"/bin/chmod", "755", file.getAbsolutePath()};
                    Runtime.getRuntime().exec(command);
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            out.close();
            fstream.close();
            if (file == null) return;
            if (!file.exists()) return;
            String[] command = new String[]{"/bin/chmod", "755", file.getAbsolutePath()};
            Runtime.getRuntime().exec(command);
            return;
        }
        catch (IOException command) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropertiesFile(String path) throws IOException {
        FileInputStream inStream = null;
        Properties iniProps = new Properties();
        try {
            inStream = new FileInputStream(new File(path));
            iniProps = new Properties();
            iniProps.load(inStream);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return iniProps;
    }

    private void CreateIniFile() throws IOException {
        String path = this.cProperties.getProperty("backupserver.workspace.dir") + "/" + BackupServerConstants.BACKUP_INI_FILE;
        FileOutputStream propsStream = new FileOutputStream(new File(path));
        this.cProperties.store(propsStream, "Backupserver initial configuration");
        propsStream.close();
    }

    public static enum OS_FAMILY {
        Undefined,
        Windows,
        Unix,
        MVS,
        ZOS,
        VMS;

    }
}

