/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server.handler;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.BackupSession;
import com.sas.svcs.backup.server.CommandHandler;
import com.sas.svcs.backup.server.CommandPostProcessor;
import com.sas.svcs.backup.server.DefaultCommandEnvironment;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UtilHandler
implements CommandHandler<DefaultCommandEnvironment>,
CommandPostProcessor<DefaultCommandEnvironment> {
    private static final Logger logger = LogManager.getLogger(UtilHandler.class);
    private static final String TASK = "task";
    private static final String ISCHILD = "ischild";
    private static final String CLEAN = "clean";
    private static final String PARENT = "parent";
    private static final String CHILD = "child";

    @Override
    public int execute(DefaultCommandEnvironment runEnv, BackupSession session) throws BackupException {
        String dir;
        int rc = 0;
        Command command = runEnv.getCommand();
        String task = command.getParameter(TASK);
        logger.info("Utility task is: " + task);
        boolean result = false;
        if (ISCHILD.equalsIgnoreCase(task)) {
            String parent = command.getParameter(PARENT);
            String child = command.getParameter(CHILD);
            result = UtilHandler.isChild(parent, child);
            logger.info(child + " is child of " + parent + "?: " + result);
            session.putSessionData(PARENT, parent);
            session.putSessionData(CHILD, child);
            session.putSessionData(ISCHILD, result);
        } else if (CLEAN.equalsIgnoreCase(task) && (dir = command.getParameter("dir")) != null) {
            if (FileUtils.deleteQuietly((File)new File(dir))) {
                logger.info("Removed the directory : " + dir);
            } else {
                logger.warn("Unable to remove the directory : " + dir);
            }
        }
        return rc;
    }

    public static boolean isChild(String parent, String child) throws BackupException {
        boolean isChild = false;
        if (parent != null && child != null) {
            File parentFile = new File(parent);
            File childFile = new File(child);
            try {
                parentFile = parentFile.getCanonicalFile();
            }
            catch (IOException e) {
                throw new BackupException(e, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_UTIL_ISCHILD.getErrorCode());
            }
            try {
                childFile = childFile.getCanonicalFile();
            }
            catch (IOException e) {
                throw new BackupException(e, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_UTIL_ISCHILD.getErrorCode());
            }
            for (File childParent = childFile.getParentFile(); childParent != null; childParent = childParent.getParentFile()) {
                if (!parentFile.equals(childParent)) continue;
                isChild = true;
                break;
            }
        }
        return isChild;
    }

    @Override
    public void doPostProcess(DefaultCommandEnvironment env, BackupSession session) throws BackupException {
        try {
            logger.debug("Writing result...");
            String task = env.getCommand().getParameter(TASK);
            if (ISCHILD.equalsIgnoreCase(task)) {
                String resultArea = env.getStatusAreaPath();
                Properties properties = new Properties();
                File resultProperties = new File(resultArea, "result.properties");
                if (!resultProperties.exists()) {
                    resultProperties.getParentFile().mkdirs();
                    resultProperties.createNewFile();
                }
                properties.setProperty(PARENT, session.getSessionData(PARENT, String.class));
                properties.setProperty(CHILD, session.getSessionData(CHILD, String.class));
                properties.setProperty(ISCHILD, session.getSessionData(ISCHILD, Boolean.class).toString());
                session.putSessionData("result.properties", properties);
                logger.debug("Written result.");
            }
        }
        catch (Exception exception) {
            throw new BackupException(BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_UTIL_ISCHILD.getErrorCode());
        }
    }
}

