/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server.handler;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.BackupSession;
import com.sas.svcs.backup.server.CommandHandler;
import com.sas.svcs.backup.server.DefaultCommandEnvironment;
import com.sas.svcs.backup.server.InitialConfigContext;
import com.sas.svcs.backup.server.util.BackupServerConstants;
import com.sas.svcs.backup.server.util.BackupServerUtil;
import com.sas.svcs.backup.server.util.ServiceSessionHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServiceSessionHandler
implements CommandHandler<DefaultCommandEnvironment> {
    Logger logger = LogManager.getLogger(ServiceSessionHandler.class);
    private static final String SAS_TIERS_XML = "SASTiers.xml";
    private static final List<String> FILES_TO_BE_SYNCHRONIZED = new ArrayList<String>();

    @Override
    public int execute(DefaultCommandEnvironment runEnv, BackupSession session) throws BackupException {
        Command command = runEnv.getCommand();
        InitialConfigContext context = InitialConfigContext.getInitialContext();
        String fileBase = null;
        String dropZone = context.getProperty(BackupServerConstants.BACKUP_DROP_ZONE);
        String dropzoneSessionPath = runEnv.getBackupConfigRootPath() + File.separator + "dropzone" + File.separator + (command.hasParameter("backupid") ? command.getParameter("backupid") : session.getSessionId());
        boolean copyDropZone = new File(dropzoneSessionPath).exists();
        String dropZoneConfigSubdir = context.getProperty(BackupServerConstants.BACKUP_DROP_ZONE_CONFIG_SUBDIR);
        if (dropZoneConfigSubdir == null && dropZone != null) {
            dropZoneConfigSubdir = dropZone + "/" + "config";
        }
        this.logger.info("Drop Zone : " + dropZone);
        fileBase = runEnv.getVaultBase();
        this.logger.info("History & config file base is " + fileBase);
        if (this.isStartSession(command)) {
            this.logger.info("Session is starting");
            if (this.isPrimaryNode(command)) {
                this.syncDown(dropZoneConfigSubdir, fileBase, runEnv, dropZone);
            }
        } else if (this.isEndSession(command)) {
            this.logger.info("Session is ending");
            if (this.isPrimaryNode(command)) {
                this.syncUp(dropZoneConfigSubdir, fileBase, runEnv, command, dropZone);
            }
            if (copyDropZone) {
                this.logger.info("Removing the content server backup copy from drop zone");
                File dropZoneStaging = new File(dropzoneSessionPath);
                if (FileUtils.deleteQuietly((File)dropZoneStaging)) {
                    this.logger.info("Content server backup is removed from staging area");
                } else {
                    this.logger.info("Unable to clean the content server backup from staging area " + dropzoneSessionPath);
                }
            }
        } else if (this.isSynchDown(command)) {
            this.logger.info("Synchronizing down..");
            if (this.isPrimaryNode(command)) {
                this.syncDown(dropZoneConfigSubdir, fileBase, runEnv, dropZone);
            }
        } else {
            this.logger.info("Synchronizing up..");
            if (this.isPrimaryNode(command)) {
                this.syncUp(dropZoneConfigSubdir, fileBase, runEnv, command, dropZone);
            }
        }
        this.logger.info("Session request completed successfully.");
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void syncUp(String dropZoneConfig, String fileBase, DefaultCommandEnvironment runEnv, Command command, String dropZone) throws BackupException {
        ServiceSessionHelper helper = new ServiceSessionHelper();
        this.logger.info("Node is primary. Ending the BackupHistory & Backup Configuration maintenance for the service session.");
        String sourcePath = null;
        String targetPath = null;
        for (String fileTobeMoved : FILES_TO_BE_SYNCHRONIZED) {
            targetPath = fileBase + File.separator + fileTobeMoved;
            sourcePath = dropZoneConfig + File.separator + fileTobeMoved;
            this.logger.info("Trying to copy file : " + sourcePath + " to " + targetPath);
            if (!this.isFilepresent(sourcePath)) continue;
            this.copyFile(sourcePath, targetPath);
            this.logger.info("Trying to delete configuration file : " + sourcePath);
            helper.deleteFile(sourcePath, command);
        }
        String sharedVault = runEnv.getSharedVault();
        if (sharedVault != null && !sharedVault.trim().equals("")) {
            boolean sharedVaultAccessible = BackupServerUtil.isPathAccessible(dropZone, new File(sharedVault));
            if (!sharedVaultAccessible) {
                this.logger.error("Shared vault is configured but 'not accessible'. Could not copy configuration files to sharedVault = " + sharedVault);
                throw new BackupException("Shared vault base is not accessible " + sharedVault, BackupServer.ReturnCode.ARCHIVE_SHARED_VAULT_NOT_ACCESSIBLE.getErrorCode());
            }
            this.logger.info("Trying to copy files to SharedVault");
            for (String fileTobeMoved : FILES_TO_BE_SYNCHRONIZED) {
                targetPath = sharedVault + File.separator + fileTobeMoved;
                sourcePath = fileBase + File.separator + fileTobeMoved;
                this.logger.info("Trying to copy file : " + sourcePath + " to " + targetPath);
                if (!this.isFilepresent(sourcePath)) continue;
                this.copyFile(sourcePath, targetPath);
            }
            return;
        } else {
            this.logger.debug("Shared Vault is not specified");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void syncDown(String dropZoneConfig, String fileBase, DefaultCommandEnvironment runEnv, String dropZone) throws BackupException {
        this.logger.info("Node is primary. Starting the BackupHistory & Backup Configuration maintanance for the service session.");
        String sourcePath = null;
        String targetPath = null;
        String sharedVault = runEnv.getSharedVault();
        if (sharedVault != null && !sharedVault.trim().equals("")) {
            boolean sharedVaultAccessible = BackupServerUtil.isPathAccessible(dropZone, new File(sharedVault));
            if (!sharedVaultAccessible) {
                this.logger.error("Shared vault is configured but 'not accessible'. Could not copy configuration files from sharedVault = " + sharedVault);
                throw new BackupException("Shared vault base is not accessible " + sharedVault, BackupServer.ReturnCode.ARCHIVE_SHARED_VAULT_NOT_ACCESSIBLE.getErrorCode());
            }
            for (String fileTobeMoved : FILES_TO_BE_SYNCHRONIZED) {
                targetPath = fileBase + File.separator + fileTobeMoved;
                sourcePath = sharedVault + File.separator + fileTobeMoved;
                this.logger.info("Trying to copy file SharedVault : " + sourcePath + " to " + targetPath);
                if (!this.isFilepresent(sourcePath)) continue;
                this.copyFile(sourcePath, targetPath);
            }
        } else {
            this.logger.debug("Shared Vault is not specified");
        }
        Iterator<String> iterator = FILES_TO_BE_SYNCHRONIZED.iterator();
        while (iterator.hasNext()) {
            String fileTobeMoved = iterator.next();
            targetPath = dropZoneConfig + File.separator + fileTobeMoved;
            sourcePath = fileBase + File.separator + fileTobeMoved;
            this.logger.info("Trying to copy file from vault to dropzone.  From : " + sourcePath + " to " + targetPath);
            if (!this.isFilepresent(sourcePath)) continue;
            this.copyFile(sourcePath, targetPath);
        }
        return;
    }

    private void copyFile(String sourcePath, String targetPath) throws BackupException {
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            this.logger.info("Copying history file from " + sourcePath + " to " + targetPath);
            inStream = new FileInputStream(new File(sourcePath));
            outStream = new FileOutputStream(new File(targetPath));
            IOUtils.copy((InputStream)inStream, (OutputStream)outStream);
        }
        catch (IOException exception) {
            try {
                exception.printStackTrace();
                this.logger.error("Unable to copy file " + sourcePath + " to " + targetPath);
                throw new BackupException("Unable to copy file " + sourcePath + " to " + targetPath, BackupErrorConstants.ErrorCodes.ERROR_CODE_GENERAL_IO_FAILURE.getErrorCode());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inStream);
                IOUtils.closeQuietly(outStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inStream);
        IOUtils.closeQuietly((OutputStream)outStream);
    }

    private boolean isStartSession(Command command) {
        this.logger.info("Is Start Session : " + command.hasParameter("start"));
        return command.hasParameter("start");
    }

    private boolean isPrimaryNode(Command command) {
        this.logger.info("Is primary node : " + command.hasParameter("isprimary"));
        return command.hasParameter("isprimary") ? Boolean.valueOf(command.getParameter("isprimary")) : false;
    }

    private boolean isFilepresent(String path) throws BackupException {
        File file = new File(path);
        if (!file.exists()) {
            this.logger.debug("isFilepresent() File is not present at " + path);
            return false;
        }
        this.logger.debug("isFilepresent() File is present at " + path);
        return true;
    }

    private boolean isEndSession(Command command) {
        return command.hasParameter("end");
    }

    private boolean isSynchUp(Command command) {
        return command.hasParameter("synchup");
    }

    private boolean isSynchDown(Command command) {
        return command.hasParameter("synchdown");
    }

    static {
        FILES_TO_BE_SYNCHRONIZED.add("BackupHistory.xml");
        FILES_TO_BE_SYNCHRONIZED.add("BackupConfiguration.xml");
        FILES_TO_BE_SYNCHRONIZED.add("METADATASERVER.xml");
        FILES_TO_BE_SYNCHRONIZED.add("CONTENTSERVER.xml");
        FILES_TO_BE_SYNCHRONIZED.add("CONFIGDIR.xml");
        FILES_TO_BE_SYNCHRONIZED.add("CUSTOMDIR.xml");
        FILES_TO_BE_SYNCHRONIZED.add("DATABASE.xml");
        FILES_TO_BE_SYNCHRONIZED.add(SAS_TIERS_XML);
    }
}

