/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server.handler;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.client.CommandContext;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.BackupSession;
import com.sas.svcs.backup.server.CommandHandler;
import com.sas.svcs.backup.server.CommandRequestContext;
import com.sas.svcs.backup.server.RecoverRunEnvironment;
import com.sas.svcs.backup.server.handler.RB;
import com.sas.svcs.backup.server.util.BackupServerUtil;
import com.sas.svcs.backup.server.util.OSUtils;
import com.sas.text.Message;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SCSRecoveryHandler
implements CommandHandler<RecoverRunEnvironment> {
    Logger logger = LogManager.getLogger(SCSRecoveryHandler.class);
    private static final String BackupRepositoryXML = "Backup_RepositoryXML";

    @Override
    public int execute(RecoverRunEnvironment recoveryRunEnv, BackupSession session) throws BackupException {
        Command command = recoveryRunEnv.getCommand();
        this.logger.info(RB.getStringResource("SCSCommonHandler.restore.initiated.txt"));
        int rc = BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_SCS.getErrorCode();
        try {
            String levDir = command.getParameter("configdir");
            CommandRequestContext requestContext = session.getRequestContext();
            String scsRepositoryRoot = this.getSCSRepositoryRoot(command);
            String configDir = command.getParameter("configbase");
            String vaultPath = null;
            vaultPath = recoveryRunEnv.getSourcePath();
            this.logger.info(Message.format((String)RB.getStringResource("SCSCommonHandler.SCS.repositpry.root.fmt"), (Object)scsRepositoryRoot));
            this.logger.info(Message.format((String)RB.getStringResource("SCSCommonHandler.SCS.vault.root.fmt"), (Object)vaultPath));
            String pg_user = null;
            String pg_pw = null;
            String pg_host = null;
            String pg_port = null;
            pg_user = command.getParameter("pguser");
            pg_pw = command.getParameter("pgpw");
            this.logger.info(RB.getStringResource("SCSCommonHandler.restore.credentials.extracted.txt"));
            pg_host = command.getParameter("pghost");
            pg_port = command.getParameter("pgport");
            this.logger.info("pgHost:" + pg_host + " pgPort: " + pg_port);
            String sourcePath = null;
            String targetPath = null;
            if (command.getCommandType().equals((Object)CommandContext.CommandType.BACKUP)) {
                sourcePath = scsRepositoryRoot;
                targetPath = vaultPath;
            } else {
                targetPath = scsRepositoryRoot;
                try {
                    File tempContentDir = this.createTempDir();
                    File sourceContentDirectory = new File(vaultPath);
                    FileUtils.copyDirectoryToDirectory((File)sourceContentDirectory, (File)tempContentDir);
                    String tempSourcePath = tempContentDir.getAbsolutePath();
                    sourcePath = tempSourcePath = tempSourcePath + File.separator + "content";
                }
                catch (Exception e) {
                    this.logger.warn("Error while creating temporary Folder for SCS restore", (Throwable)e);
                    sourcePath = vaultPath;
                }
            }
            this.logger.info(Message.format((String)RB.getStringResource("SCSCommonHandler.source.path.fmt"), (Object)sourcePath));
            this.logger.info(Message.format((String)RB.getStringResource("SCSCommonHandler.target.path.fmt"), (Object)targetPath));
            if (command.getCommandType().equals((Object)CommandContext.CommandType.RECOVER)) {
                String dbname = null;
                String dbtype = null;
                String webinfpltminstallconfig = null;
                String cfgwizardinstall = null;
                String cfgwizardutil = null;
                String webappUserId = null;
                String configBase = null;
                String deploywizinstall = null;
                String dbURL = null;
                boolean chkParam = this.chkOptionalParam(command);
                if (chkParam) {
                    dbname = command.getParameter("dbname");
                    dbtype = command.getParameter("dbtype");
                    webinfpltminstallconfig = requestContext.getSASHome() + File.separator + "SASWebInfrastructurePlatform" + File.separator + "9.4" + File.separator + "Config";
                    cfgwizardinstall = BackupServerUtil.getCfgwizardPath(requestContext.getSASHome());
                    cfgwizardutil = cfgwizardinstall + File.separator + "Utilities";
                    webappUserId = command.getParameter("webappuserid");
                    configBase = command.getParameter("configbase");
                    deploywizinstall = BackupServerUtil.getDeployWizardPath(requestContext.getSASHome());
                    dbURL = command.getParameter("jdbcurl");
                    this.logger.debug("Creating Grant script");
                    this.createGrantSQLScript(configBase, webappUserId, pg_host, pg_port, pg_user, pg_pw, dbname, dbURL);
                    this.logger.debug("Permission script created");
                    Properties dbProperties = null;
                    if (dbProperties == null) {
                        dbProperties = new Properties();
                    }
                    dbProperties.put("database.name", dbname);
                    dbProperties.put("database.type", dbtype);
                    dbProperties.put("database.host", pg_host);
                    dbProperties.put("database.port", pg_port);
                    dbProperties.put("database.admin.userid", pg_user);
                    dbProperties.put("database.encrypt.admin.passwd", pg_pw);
                    String file = webinfpltminstallconfig + File.separator + "Deployment" + File.separator + "Data" + File.separator + dbtype + File.separator + "drop-scs.sql";
                    String file1 = webinfpltminstallconfig + File.separator + "Deployment" + File.separator + "Data" + File.separator + dbtype + File.separator + "schema-scs.sql";
                    String file2 = configBase + File.separator + "GrantScript.sql";
                    dbProperties.put("file", file);
                    dbProperties.put("file1", file1);
                    dbProperties.put("file2", file2);
                    dbProperties.put("sqltype", "TSSQL");
                    dbProperties.put("database.client.jar.dir", "");
                    dbProperties.put("12byte.groovy.path", deploywizinstall + File.separator + "deploywiz" + File.separator + "groovy");
                    dbProperties.put("default.groovy.path", deploywizinstall + File.separator + "deploywiz" + File.separator + "groovy");
                    dbProperties.put("postgresjdbc.install.dir", levDir + File.separator + "Web" + File.separator + "Scripts" + File.separator + "AppServer" + File.separator + "jdbc" + File.separator);
                    String fileStorage = cfgwizardutil;
                    dbProperties.put("file.storage", fileStorage);
                    String path = configBase + File.separator + "db.properties";
                    FileOutputStream propsStream = null;
                    try {
                        File dbProps = new File(path);
                        dbProps.deleteOnExit();
                        propsStream = new FileOutputStream(dbProps);
                        dbProperties.store(propsStream, "database properties");
                        propsStream.close();
                    }
                    catch (FileNotFoundException fe) {
                        this.logger.error(RB.getStringResource("SCSCommonHandler.file.not.found.txt") + fe.toString());
                        rc = BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_SCS.getErrorCode();
                        throw new BackupException(RB.getStringResource("SCSCommonHandler.file.not.found.txt"), fe, rc);
                    }
                    catch (IOException io) {
                        this.logger.error(RB.getStringResource("SCSCommonHandler.io.exception.txt") + io.toString());
                        rc = BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_SCS.getErrorCode();
                        throw new BackupException(RB.getStringResource("SCSCommonHandler.io.exception.txt"), io, rc);
                    }
                    try {
                        this.logger.debug("Building and executing drop scs script");
                        String buildDropTable = this.createSqlExcutionScript(configDir, levDir, file, "$$");
                        BackupServerUtil.runANTProject(buildDropTable, command);
                        this.logger.debug("Building and executing create schema script");
                        String buildcreateSchema = this.createSqlExcutionScript(configDir, levDir, file1, "$$");
                        BackupServerUtil.runANTProject(buildcreateSchema, command);
                        this.logger.debug("Building and executing grant script");
                        String buildgrantRole = this.createSqlExcutionScript(configDir, levDir, file2, null);
                        BackupServerUtil.runANTProject(buildgrantRole, command);
                        this.logger.debug("Cleaning DB properties");
                        this.cleanDbProperites(configDir);
                        rc = this.restoreSCS(sourcePath, targetPath, configDir, pg_user, pg_pw);
                    }
                    catch (BackupException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        rc = BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_SCS.getErrorCode();
                        this.logger.error(RB.getStringResource("SCSCommonHandler.recovery.unsuccessfull.txt") + e.toString());
                        this.cleanDbProperites(configDir);
                        throw new BackupException(RB.getStringResource("SCSCommonHandler.recovery.unsuccessfull.txt"), e, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_SCS.getErrorCode());
                    }
                }
                this.logger.error(RB.getStringResource("SCSCommonHandler.SCS.optional.null.txt"));
                rc = BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_SCS.getErrorCode();
                throw new BackupException(RB.getStringResource("SCSCommonHandler.SCS.optional.null.txt"), BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_SCS.getErrorCode());
            }
            if (rc == 0 && command.getCommandType().equals((Object)CommandContext.CommandType.RECOVER)) {
                this.logger.info(RB.getStringResource("SCSCommonHandler.recovery.successfull.txt"));
            } else if (rc != 0 && command.getCommandType().equals((Object)CommandContext.CommandType.RECOVER)) {
                this.logger.error(RB.getStringResource("SCSCommonHandler.recovery.unsuccessfull.txt"));
            }
        }
        catch (BackupException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BackupException(e, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_SCS.getErrorCode());
        }
        if (rc != BackupServer.ReturnCode.OK.getErrorCode()) {
            throw new BackupException(rc);
        }
        return rc;
    }

    private void createGrantSQLScript(String configBase, String webappUserId, String pg_host, String pg_port, String pg_user, String pg_pw, String dbname, String jdbcURL) throws BackupException {
        Connection con = null;
        ResultSet rs = null;
        try {
            Class.forName("org.postgresql.Driver");
            String decryptPassword = null;
            try {
                decryptPassword = SasPasswordString.decode((String)pg_pw);
            }
            catch (SasPasswordEncodingException e) {
                this.logger.debug(RB.getStringResource("PostgresBackupHandler.error.decode.txt"), (Throwable)e);
                throw new BackupException(e, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_PGPASSWORDENCODING.getErrorCode());
            }
            con = DriverManager.getConnection(jdbcURL, pg_user, decryptPassword);
            Statement stmt = con.createStatement();
            rs = stmt.executeQuery("SELECT * FROM information_schema.tables where table_name like '%scs2%';");
        }
        catch (BackupException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error(RB.getStringResource("SCSCommonHandler.SCS.tool.error.txt") + e);
            throw new BackupException(RB.getStringResource("SCSCommonHandler.SCS.tool.error.txt"), e, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_SCS.getErrorCode());
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {
                this.logger.error(RB.getStringResource("SCSCommonHandler.SCS.sql.error.txt") + e);
                throw new BackupException(RB.getStringResource("SCSCommonHandler.SCS.sql.error.txt"), e, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_SCS.getErrorCode());
            }
        }
        File file = new File(configBase + File.separator + "GrantScript.sql");
        file.deleteOnExit();
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            if (rs != null) {
                try {
                    while (rs.next()) {
                        writer.write("ALTER TABLE " + rs.getString("table_name") + " OWNER TO " + '\"' + webappUserId + "\";");
                    }
                }
                catch (SQLException e) {
                    this.logger.error(RB.getStringResource("SCSCommonHandler.SCS.script.error.txt") + e);
                    throw new BackupException(e, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_SCS.getErrorCode());
                }
            }
            writer.close();
            writer = null;
        }
        catch (IOException e) {
            this.logger.debug("Error !! while creating the grant script file !!!!");
            throw new BackupException(e, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_SCS.getErrorCode());
        }
    }

    private void cleanDbProperites(String configDir) {
        File file;
        if (configDir != null && (file = new File(configDir + File.separator + "db.properties")).exists()) {
            this.logger.info("Deleting the properties file " + file.getPath());
            boolean success = file.delete();
            if (!success) {
                this.logger.debug(" Deletion failed.");
            } else {
                this.logger.debug(" File deleted.");
            }
        }
    }

    private boolean chkOptionalParam(Command command) {
        boolean rf = true;
        rf |= command.getParameter("dbname") != null;
        rf |= command.getParameter("dbtype") != null;
        return rf |= command.getParameter("webinfpltminstallconfig") != null;
    }

    private String createSqlExcutionScript(String configBase, String levDir, String inputfile, String delimiter) {
        StringBuilder projectFile = null;
        String propertyloca = configBase;
        File properitesFile = new File(propertyloca + File.separator + "db.properties");
        FileInputStream fis = null;
        Properties props = null;
        String dlm = null;
        try {
            projectFile = new StringBuilder();
            if (properitesFile.exists()) {
                props = new Properties();
                fis = new FileInputStream(properitesFile);
                props.load(fis);
                String startEncode = "<?xml version=\"1.0\"?>";
                String projectFilePrePart = "<project name=\"preSCSRecovery\" default=\"cleanncreate\">";
                String PropertyFile = "<property  file =\"" + propertyloca + "/db.properties\"/>";
                String taskdef = "<taskdef resource=\"net/sf/antcontrib/antlib.xml\" />";
                String projectImport = "<import file=\"" + props.getProperty("file.storage") + "${file.separator}cmu_import_config.xml\" /> ";
                String projectFileConfigTargetPart = "<target name=\"cleanncreate\"> ";
                String updatedataBase = "<updateDatabase ";
                String dbName = "dbname=\"${database.name}\" ";
                String dbType = "database.type=\"${database.type}\" ";
                String dbHost = "database.host=\"${database.host}\" ";
                String dbPort = "database.port=\"${database.port}\" ";
                String dbUser = "database.admin.userid=\"${database.admin.userid}\" ";
                String dbpwd = "database.encrypt.admin.passwd=\"${database.encrypt.admin.passwd}\" ";
                String file = "file=\"" + inputfile + "\" ";
                String sqlType = "sqltype=\"${sqltype}\" ";
                String clientDBJar = "database.client.jar.dir=\"${database.client.jar.dir}\" ";
                if (delimiter != null && delimiter.length() > 0) {
                    dlm = "delimiter=\"" + delimiter + "\" ";
                }
                String closeupdatBase = "/>";
                String projectFileTargetComplete = "</target>";
                String projectFilePostPart = "</project>";
                projectFile.append(startEncode);
                projectFile.append(projectFilePrePart);
                projectFile.append(PropertyFile);
                projectFile.append(taskdef);
                projectFile.append(projectImport);
                projectFile.append(projectFileConfigTargetPart);
                projectFile.append(updatedataBase);
                projectFile.append(dbName);
                projectFile.append(dbType);
                projectFile.append(dbHost);
                projectFile.append(dbPort);
                projectFile.append(dbUser);
                projectFile.append(dbpwd);
                projectFile.append(file);
                projectFile.append(sqlType);
                projectFile.append(clientDBJar);
                if (dlm != null && dlm.length() > 0) {
                    projectFile.append(dlm);
                }
                projectFile.append(closeupdatBase);
                projectFile.append(projectFileTargetComplete);
                projectFile.append(projectFilePostPart);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException();
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        return projectFile == null ? null : projectFile.toString();
    }

    public int restoreSCS(String sourcePath, String targetPath, String configDir, String pgUser, String pgPw) throws BackupException {
        File tempDir;
        this.logger.debug("Preparing to send to JCRCopyRepository");
        int rc = BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_SCS.getErrorCode();
        try {
            tempDir = this.createTempDir();
        }
        catch (IOException e2) {
            rc = BackupServer.ReturnCode.COMMAND_TOOL_ERROR_SCS.getErrorCode();
            throw new BackupException(e2, rc);
        }
        String targetString = targetPath;
        File targetDir = new File(targetString);
        targetDir.mkdirs();
        this.logger.debug("copying repository.xml");
        this.copyFile(sourcePath + File.separator + BackupRepositoryXML + File.separator + "repository.xml", targetPath + File.separator + "repository.xml");
        File batchFile = null;
        Process process = null;
        String configPath = configDir;
        if (OSUtils.getOS_Family() != "Windows") {
            this.logger.debug("I am in UNIX");
            batchFile = new File(configPath + File.separator + "JCRCopyRepository.sh");
        } else {
            this.logger.debug("I am in WX6");
            batchFile = new File(configPath + File.separator + "JCRCopyRepository.bat");
        }
        try {
            String line;
            this.logger.info(RB.getStringResource("SCSCommonHandler.restore.invoke.copy.repository.txt"));
            ProcessBuilder processBuilder = new ProcessBuilder(batchFile.getAbsolutePath(), sourcePath, targetPath, pgUser, pgPw, tempDir.getAbsolutePath());
            processBuilder.redirectErrorStream(true);
            process = processBuilder.start();
            InputStreamReader io = new InputStreamReader(process.getInputStream());
            BufferedReader r = new BufferedReader(io);
            while ((line = r.readLine()) != null) {
                this.logger.debug(line);
            }
            r.close();
        }
        catch (IOException e1) {
            this.logger.error(Message.format((String)RB.getStringResource("SCSCommonHandler.file.not.found.txt"), (Object)e1.toString()));
            rc = BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_SCS.getErrorCode();
            throw new BackupException(Message.format((String)RB.getStringResource("SCSCommonHandler.file.not.found.txt"), (Object)e1.toString()), e1, rc);
        }
        int exitStatus = -1;
        try {
            exitStatus = process.waitFor();
            if (exitStatus == 0) {
                this.logger.info("List of files Copied:");
                this.listFilesAndFilesSubDirectories(targetPath);
                this.logger.info("End of list of files");
                File folder = new File(targetPath);
                String[] files = folder.list();
                rc = files.length > 2 ? 0 : BackupServer.ReturnCode.COMMAND_TOOL_ERROR_SCS.getErrorCode();
            } else {
                rc = BackupServer.ReturnCode.COMMAND_TOOL_ERROR_SCS.getErrorCode();
            }
        }
        catch (InterruptedException e) {
            this.logger.error("Interrupted exception " + e);
            rc = BackupServer.ReturnCode.COMMAND_TOOL_ERROR_SCS.getErrorCode();
            throw new BackupException(e, rc);
        }
        finally {
            try {
                process.waitFor();
                process.getInputStream().close();
                process.getOutputStream().close();
                process.getErrorStream().close();
            }
            catch (Exception ioe) {
                this.logger.error("error closing streams:" + ioe.getLocalizedMessage());
            }
        }
        if (rc != BackupServer.ReturnCode.OK.getErrorCode()) {
            throw new BackupException(rc);
        }
        return rc;
    }

    private String getSCSRepositoryRoot(Command command) {
        String scsdefaultrepos;
        String scsRoot;
        if (command.getCommandType().equals((Object)CommandContext.CommandType.BACKUP)) {
            scsRoot = command.getParameter("scsroot");
            scsdefaultrepos = command.getParameter("defaultrepos");
        } else {
            scsRoot = command.getParameter("scsroot");
            scsdefaultrepos = "Copy_of_" + command.getParameter("defaultrepos");
        }
        return scsRoot + File.separator + scsdefaultrepos;
    }

    private File createTempDir() throws IOException {
        String baseTempPath = System.getProperty("java.io.tmpdir");
        Random random = new Random();
        int randomInt = 1 + random.nextInt();
        File tempDir = new File(baseTempPath, "RestoreTemp" + randomInt);
        try {
            if (tempDir.exists() && !tempDir.delete()) {
                throw new IOException("Could not delete temp folder: " + tempDir.getAbsolutePath());
            }
            File.createTempFile("test", "properties", tempDir).deleteOnExit();
        }
        catch (Exception e) {
            tempDir = new File(".", "Backuptemp" + File.separator + "Temp" + randomInt);
        }
        tempDir.mkdirs();
        this.logger.debug(tempDir.getAbsolutePath());
        tempDir.deleteOnExit();
        return tempDir;
    }

    public void copyFile(String fromFile, String toFile) throws BackupException {
        FileInputStream fin = null;
        FileOutputStream fout = null;
        try {
            int bytesRead;
            File file = new File(fromFile);
            if (!file.exists() || !file.isFile()) {
                this.logger.info(RB.getStringResource("SCSCommonHandler.repository.file.not.found.txt"));
                return;
            }
            fin = new FileInputStream(file);
            fout = new FileOutputStream(toFile);
            byte[] buffer = new byte[1024];
            while ((bytesRead = fin.read(buffer)) > 0) {
                fout.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException ioe) {
            this.logger.error(RB.getStringResource("SCSCommonHandler.io.exception.txt") + ioe);
            throw new BackupException(RB.getStringResource("SCSCommonHandler.io.exception.txt"), ioe, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_SCS.getErrorCode());
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException ioe) {
                this.logger.error("error closing file streams:" + ioe.getLocalizedMessage());
            }
        }
    }

    public void listFilesAndFilesSubDirectories(String directoryName) {
        File[] fList;
        File directory;
        if (directoryName != null && (directory = new File(directoryName)).exists() && (fList = directory.listFiles()) != null && !BackupServerUtil.isEmpty(fList)) {
            for (File file : fList) {
                if (file.isFile()) {
                    this.logger.info("FilePath@ " + file.getAbsolutePath());
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.listFilesAndFilesSubDirectories(file.getAbsolutePath());
            }
        }
    }
}

