/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server.handler;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.client.CommandContext;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupRunEnvironment;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.BackupSession;
import com.sas.svcs.backup.server.CommandHandler;
import com.sas.svcs.backup.server.InitialConfigContext;
import com.sas.svcs.backup.server.handler.RB;
import com.sas.svcs.backup.server.util.BackupServerUtil;
import com.sas.svcs.batch.rest.EnvironmentContextHolder;
import com.sas.svcs.batch.rest.ServiceExecutor;
import com.sas.svcs.batch.rest.model.BasicResponse;
import com.sas.svcs.batch.rest.model.EnvironmentContext;
import com.sas.svcs.batch.rest.model.Service;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SCSBackupHandler
implements CommandHandler<BackupRunEnvironment> {
    Logger logger = LogManager.getLogger(SCSBackupHandler.class);

    @Override
    public int execute(BackupRunEnvironment backupRunEnv, BackupSession session) throws BackupException {
        Command command = backupRunEnv.getCommand();
        int rc = BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_SCS.getErrorCode();
        try {
            block24: {
                String levDir = command.getParameter("configdir");
                String host = null;
                String port = null;
                String user = null;
                String password = null;
                host = command.getParameter("host");
                InitialConfigContext intCtx = InitialConfigContext.getInitialContext();
                if (!BackupServerUtil.isEmpty(intCtx.getProperty("backupserver.scs.host"))) {
                    host = intCtx.getProperty("backupserver.scs.host");
                }
                port = command.getParameter("port");
                if (!BackupServerUtil.isEmpty(intCtx.getProperty("backupserver.scs.port"))) {
                    port = intCtx.getProperty("backupserver.scs.port");
                }
                this.logger.debug("SCS host " + host + " SCS Port " + port);
                user = command.getParameter("user");
                if (!BackupServerUtil.isEmpty(intCtx.getProperty("backupserver.scs.user"))) {
                    user = intCtx.getProperty("backupserver.scs.user");
                }
                password = command.getParameter("pw");
                if (!BackupServerUtil.isEmpty(intCtx.getProperty("backupserver.scs.password"))) {
                    password = intCtx.getProperty("backupserver.scs.password");
                }
                try {
                    password = SasPasswordString.decode((String)password);
                }
                catch (SasPasswordEncodingException e) {
                    this.logger.debug(RB.getStringResource("PostgresBackupHandler.error.decode.txt"), (Throwable)e);
                    throw new BackupException(e, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_PGPASSWORDENCODING.getErrorCode());
                }
                if (command.getCommandType().equals((Object)CommandContext.CommandType.BACKUP)) {
                    String backupID = command.getParameter("sessionid");
                    Service service = null;
                    try {
                        service = new Service("POST", "SASContentServer/admin/copy?backup=" + URLEncoder.encode(backupID, "UTF-8"));
                        service.addHeader("accept", "application/xml");
                    }
                    catch (UnsupportedEncodingException e1) {
                        this.logger.info(RB.getStringResource("SCSCommonHandler.SCS.Error.copy.txt") + e1);
                    }
                    String protocolUsed = "http";
                    if (!command.getParameter("httpprotocol").isEmpty()) {
                        protocolUsed = command.getParameter("httpprotocol");
                    }
                    if (!BackupServerUtil.isEmpty(intCtx.getProperty("backupserver.scs.protocol"))) {
                        protocolUsed = intCtx.getProperty("backupserver.scs.protocol");
                    }
                    this.logger.debug("protocol used is " + protocolUsed);
                    EnvironmentContext context = new EnvironmentContext();
                    context.setHost(host);
                    context.setPort(port);
                    context.setUser(user);
                    context.setPassword(password);
                    context.setProtocol(protocolUsed);
                    EnvironmentContextHolder.set((EnvironmentContext)context);
                    ServiceExecutor executor = new ServiceExecutor();
                    try {
                        boolean dropZoneDirExists;
                        BasicResponse basicResponse = executor.execute(service);
                        int successCode = basicResponse.getStatusCode();
                        this.logger.info("Success Code " + successCode);
                        this.logger.debug("Response" + basicResponse.getRawResponse());
                        this.logger.debug("Response header" + basicResponse.getHeaders().toString());
                        Map<String, String> nodes = null;
                        if (successCode == 200) {
                            nodes = this.getNodeElements(basicResponse.getRawResponse().toString());
                            this.WriteToResultProperties(session, nodes);
                        }
                        File directory = nodes != null ? new File(nodes.get("path")) : null;
                        boolean bl = dropZoneDirExists = directory != null ? directory.exists() : false;
                        if (successCode == 200 && dropZoneDirExists) {
                            this.logger.debug("SCS Back up happened on the primary node");
                            rc = 0;
                            break block24;
                        }
                        if (successCode == 200 && !dropZoneDirExists) {
                            this.logger.debug("SCS Back up happened on the cluster node");
                            rc = 0;
                            break block24;
                        }
                        this.logger.error(RB.getStringResource("SCSCommonHandler.backup.Server.isup.txt"));
                        rc = BackupServer.ReturnCode.COMMAND_TOOL_ERROR_SCS.getErrorCode();
                        throw new BackupException(RB.getStringResource("SCSCommonHandler.backup.Server.isup.txt"), rc);
                    }
                    catch (BackupException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        this.logger.info(RB.getStringResource("SCSCommonHandler.backup.Server.isup.txt"));
                        this.logger.info(RB.getStringResource("SCSCommonHandler.backup.unsuccessfull.txt") + e);
                        rc = BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_SCS.getErrorCode();
                        throw new BackupException(RB.getStringResource("SCSCommonHandler.backup.unsuccessfull.txt"), e, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_SCS.getErrorCode());
                    }
                }
            }
            if (rc == 0 && command.getCommandType().equals((Object)CommandContext.CommandType.BACKUP)) {
                this.logger.info(RB.getStringResource("SCSCommonHandler.backup.successfull.txt"));
            } else if (rc != 0 && command.getCommandType().equals((Object)CommandContext.CommandType.BACKUP)) {
                this.logger.info(RB.getStringResource("SCSCommonHandler.backup.unsuccessfull.txt"));
            }
        }
        catch (BackupException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BackupException(e, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_SCS.getErrorCode());
        }
        if (rc != BackupServer.ReturnCode.OK.getErrorCode()) {
            throw new BackupException(rc);
        }
        return rc;
    }

    private void WriteToResultProperties(BackupSession session, Map<String, String> nodes) throws BackupException {
        Properties result = new Properties();
        if (nodes != null) {
            result.setProperty("scs.Backup.Path", nodes.get("path"));
            String instanceName = nodes.get("instanceid");
            String SCSHostName = instanceName.substring(instanceName.lastIndexOf("_") + 1);
            result.setProperty("scs.Backup.Host", SCSHostName);
            this.logger.info("Setting scs proeprties : " + SCSHostName + " " + nodes.get("path"));
            session.putSessionData("result.properties", result);
        }
    }

    public Map<String, String> getNodeElements(String xmlString) throws Exception {
        HashMap<String, String> mapNodes = new HashMap<String, String>();
        this.logger.info("SCS Returned result : " + xmlString);
        if (xmlString != null && !xmlString.isEmpty()) {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xmlString));
            Document doc = db.parse(is);
            NodeList nodes = doc.getElementsByTagName("backup");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element element = (Element)nodes.item(i);
                NodeList name = element.getElementsByTagName("path");
                Element line = (Element)name.item(0);
                mapNodes.put("path", SCSBackupHandler.getCharacterDataFromElement(line));
                NodeList title = element.getElementsByTagName("instanceid");
                line = (Element)title.item(0);
                mapNodes.put("instanceid", SCSBackupHandler.getCharacterDataFromElement(line));
            }
        }
        return mapNodes;
    }

    public static String getCharacterDataFromElement(Element e) {
        Node child = e.getFirstChild();
        if (child instanceof CharacterData) {
            CharacterData cd = (CharacterData)child;
            return cd.getData();
        }
        return "";
    }

    public void copyFile(String fromFile, String toFile) throws BackupException {
        FileInputStream fin = null;
        FileOutputStream fout = null;
        try {
            int bytesRead;
            File file = new File(fromFile);
            if (!file.exists() || !file.isFile()) {
                this.logger.info(RB.getStringResource("SCSCommonHandler.repository.file.not.found.txt"));
                return;
            }
            fin = new FileInputStream(file);
            fout = new FileOutputStream(toFile);
            byte[] buffer = new byte[1024];
            while ((bytesRead = fin.read(buffer)) > 0) {
                fout.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException ioe) {
            this.logger.error(RB.getStringResource("SCSCommonHandler.io.exception.txt") + ioe);
            throw new BackupException(RB.getStringResource("SCSCommonHandler.io.exception.txt"), ioe, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_SCS.getErrorCode());
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void listFilesAndFilesSubDirectories(String directoryName) {
        File[] fList;
        File directory;
        if (directoryName != null && (directory = new File(directoryName)).exists() && (fList = directory.listFiles()) != null && !BackupServerUtil.isEmpty(fList)) {
            for (File file : fList) {
                if (file.isFile()) {
                    this.logger.info("FilePath@ " + file.getAbsolutePath());
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.listFilesAndFilesSubDirectories(file.getAbsolutePath());
            }
        }
    }
}

