/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server.handler;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupJournal;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.BackupSession;
import com.sas.svcs.backup.server.CommandHandler;
import com.sas.svcs.backup.server.CommandPostProcessor;
import com.sas.svcs.backup.server.DefaultCommandEnvironment;
import com.sas.svcs.backup.server.handler.RB;
import com.sas.svcs.backup.server.util.BackupServerUtil;
import com.sas.svcs.backup.server.util.PurgeHelper;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PurgeHandler
implements CommandHandler<DefaultCommandEnvironment>,
CommandPostProcessor<DefaultCommandEnvironment> {
    private Logger logger = LogManager.getLogger(PurgeHandler.class);
    private final String DATE_FORMAT = "dd/MM/yyyy";
    private DefaultCommandEnvironment runEnvironment;

    @Override
    public int execute(DefaultCommandEnvironment runEnvironment, BackupSession session) throws BackupException {
        this.runEnvironment = runEnvironment;
        this.logger.info(RB.getStringResource("PurgeHandler.starting.purge.txt"));
        Command command = runEnvironment.getCommand();
        if (command.hasParameter("beforedate")) {
            String resultBase = runEnvironment.getStatusAreaBase();
            String logBase = runEnvironment.getLogBase();
            PurgeHelper helper = new PurgeHelper();
            ArrayList<String> dirsToPurge = new ArrayList<String>();
            dirsToPurge.add(resultBase);
            dirsToPurge.add(logBase);
            helper.addToPurge(dirsToPurge);
            String purgeBeforeDateFixDisabledProperty = null;
            try {
                purgeBeforeDateFixDisabledProperty = System.getProperty("backup.purge.beforedate.disable");
            }
            catch (Exception e) {
                this.logger.warn("Error while accessing system property 'backup.purge.beforedate.disable'" + e.getLocalizedMessage());
            }
            if (StringUtils.isBlank((String)purgeBeforeDateFixDisabledProperty) || !purgeBeforeDateFixDisabledProperty.equalsIgnoreCase("true")) {
                helper.purge(command);
            } else {
                this.logger.info("Skipping purging based on beforedate 'backup.purge.beforedate.disable' system property is set to true");
            }
        } else {
            ArrayList<String> sessionIds = null;
            String sessionId = command.getParameter("backupid");
            if (!"".equals(sessionId)) {
                this.logger.info(RB.getStringResource("PurgeHandler.found.session.backup.txt"));
                sessionIds = new ArrayList<String>(1);
                sessionIds.add(sessionId);
            }
            if (!sessionIds.isEmpty()) {
                String vaultBase = runEnvironment.getVaultBase();
                String resultBase = runEnvironment.getStatusAreaBase();
                String logBase = runEnvironment.getLogBase();
                PurgeHelper helper = new PurgeHelper();
                helper.addToPurge(vaultBase, sessionIds);
                List<String> sharedVaultBackups = this.findSharedVaultBaseDirs(session, sessionIds, runEnvironment);
                if (sharedVaultBackups != null) {
                    helper.addToPurge(sharedVaultBackups);
                }
                helper.addToPurge(resultBase, sessionIds);
                helper.addToPurge(logBase, sessionIds);
                this.logger.info(RB.getStringResource("PurgeHandler.executing.purge.txt"));
                helper.purge(command);
                this.logger.info(RB.getStringResource("PurgeHandler.executon.complete.txt"));
            } else {
                this.logger.info(RB.getStringResource("PurgeHandler.nothng.for.purge.txt"));
            }
        }
        this.logger.info(RB.getStringResource("PurgeHandler.purge.sucessfull.txt"));
        return 0;
    }

    private List<String> findSharedVaultBaseDirs(BackupSession session, List<String> sessionIds, DefaultCommandEnvironment runEnvironment) {
        String filePath = null;
        ArrayList<String> filePaths = null;
        if (sessionIds != null) {
            filePaths = new ArrayList<String>(sessionIds.size());
            String sharedVaultBase = session.getRequestContext().getCommand().getParameter("sharedvaultbase");
            String sharedVault = runEnvironment.getSharedVault();
            this.logger.info("findSharedVaultBaseDirs    sharedVault = " + sharedVault);
            String hostName = runEnvironment.getHostName();
            String tierName = session.getRequestContext().getCommand().getParameter("tier");
            String tierAndHostStr = BackupServerUtil.isEmpty(tierName) ? hostName : tierName + "@" + hostName;
            for (String sessionId : sessionIds) {
                if (sessionId == null || "".equals(sessionId)) continue;
                filePath = sharedVault + File.separator + sessionId;
                filePaths.add(filePath);
            }
        }
        return filePaths;
    }

    private List<String> processBeforeDatePurge(Command command, BackupSession session) throws BackupException {
        String beforeDate = command.getParameter("beforedate");
        String projectFile = "";
        List<String> sessionIds = Collections.emptyList();
        try {
            Date date = new SimpleDateFormat("dd/MM/yyyy").parse(beforeDate);
            List<BackupJournal.JournalEntry> entries = this.runEnvironment.getJournal().getBeforeDate(date, BackupJournal.EntryType.BACKUP);
            if (!entries.isEmpty()) {
                sessionIds = BackupServerUtil.getCollection(entries, "SessionId", String.class);
                session.putSessionData("purgedSession", sessionIds);
            }
        }
        catch (ParseException exception) {
            throw new BackupException(BackupServer.ReturnCode.PURGE_BEFOREDATE_PARSING_ERROR.getErrorCode());
        }
        catch (Exception exception) {
            throw new BackupException(BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR.getErrorCode());
        }
        return sessionIds;
    }

    @Override
    public void doPostProcess(DefaultCommandEnvironment env, BackupSession session) throws BackupException {
        try {
            List sessionIds = session.getSessionData("purgedSession", List.class);
            if (sessionIds != null) {
                String resultBase = session.getRequestContext().getConfigPath() + "/Results";
                String vaultBase = this.runEnvironment.getVaultBase();
                File rDir = null;
                File vDir = null;
                ArrayList<String> purged = new ArrayList<String>(sessionIds.size());
                for (String sessionId : sessionIds) {
                    rDir = new File(resultBase, sessionId);
                    vDir = new File(vaultBase, sessionId);
                    if (rDir.exists() || vDir.exists()) continue;
                    purged.add(sessionId);
                }
                if (purged.size() > 0) {
                    String purgedIds = BackupServerUtil.toString(purged);
                    Properties p = new Properties();
                    p.setProperty("purged.session.ids", purgedIds);
                    session.putSessionData("result.properties", p);
                    this.runEnvironment.getJournal().archive(purged);
                }
            }
        }
        catch (Exception exception) {
            throw new BackupException(BackupServer.ReturnCode.COMMAND_POST_PROCESS_ERROR.getErrorCode());
        }
    }
}

