/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server.handler;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.BackupSession;
import com.sas.svcs.backup.server.CommandHandler;
import com.sas.svcs.backup.server.CommandPostProcessor;
import com.sas.svcs.backup.server.CommandRequestContext;
import com.sas.svcs.backup.server.RecoverRunEnvironment;
import com.sas.svcs.backup.server.handler.ConnectionInfo;
import com.sas.svcs.backup.server.handler.PostgresBackupHandler;
import com.sas.svcs.backup.server.handler.PostgresLogParser;
import com.sas.svcs.backup.server.handler.RB;
import com.sas.svcs.backup.server.util.BackupServerUtil;
import com.sas.svcs.backup.server.util.OSUtils;
import com.sas.text.Message;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PostgresRecoveryHandler
implements CommandHandler<RecoverRunEnvironment>,
CommandPostProcessor<RecoverRunEnvironment> {
    private static final String PG_RESTORE = "pg_restore";
    Logger logger = LogManager.getLogger(PostgresRecoveryHandler.class);
    private static final String LD_LIB_PATH = "LD_LIBRARY_PATH";
    private static final String AIX_LD_LIB_PATH = "LIBPATH";
    private RecoverRunEnvironment recoverRunEnvironment;
    private PostgresLogParser logParser;

    private int recover(Properties props, BackupSession session) throws BackupException {
        File f;
        int returnCode = BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_PGRECOVERY.getErrorCode();
        List<Object> lstDbnames = new ArrayList();
        String user = null;
        String binpath = null;
        String backupid = null;
        String pw = null;
        String host = null;
        String port = null;
        String libpath = null;
        String pgdatabaseList = null;
        String serverInstanceName = null;
        String postgres_bkup_node = null;
        postgres_bkup_node = props.getProperty("postgres_node");
        user = props.getProperty("user");
        pw = props.getProperty("pw");
        host = props.getProperty("host");
        port = props.getProperty("port");
        binpath = props.getProperty("binpath");
        backupid = props.getProperty("backupid");
        libpath = props.getProperty("libpath");
        pgdatabaseList = props.getProperty("pgdatabaselist");
        serverInstanceName = props.getProperty("serverinstancename");
        if (OSUtils.getOS_Family().equals("Windows")) {
            f = new File(binpath + File.separator + PG_RESTORE + ".exe");
            if (!f.exists()) {
                this.logger.debug(binpath + File.separator + PG_RESTORE + " File doest not exists");
                returnCode = BackupServer.ReturnCode.FILE_NOT_PRESENT.getErrorCode();
                throw new BackupException(BackupServer.ReturnCode.FILE_NOT_PRESENT.getErrorCode());
            }
        } else {
            f = new File(binpath + File.separator + PG_RESTORE);
            if (!f.exists()) {
                this.logger.debug(binpath + File.separator + PG_RESTORE + " File doest not exists");
                returnCode = BackupServer.ReturnCode.FILE_NOT_PRESENT.getErrorCode();
                throw new BackupException(BackupServer.ReturnCode.FILE_NOT_PRESENT.getErrorCode());
            }
        }
        String decryptPassword = null;
        try {
            decryptPassword = SasPasswordString.decode((String)pw);
        }
        catch (SasPasswordEncodingException e) {
            this.logger.debug(RB.getStringResource("PostgresBackupHandler.error.decode.txt"), (Throwable)e);
            throw new BackupException(e, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_PGPASSWORDENCODING.getErrorCode());
        }
        if (!pgdatabaseList.equals("")) {
            lstDbnames = this.sepratedb_InstanceName(pgdatabaseList, serverInstanceName);
            Iterator<Object> itr = lstDbnames.iterator();
            while (itr.hasNext()) {
                this.logger.debug(((String)itr.next()).toString());
            }
        } else {
            throw new BackupException(BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_PGRECOVERY_EMPTY_DBLIST.getErrorCode());
        }
        String instanceDetails = serverInstanceName + "#" + host + "#" + port + "#" + postgres_bkup_node;
        HashMap dbnameList = session.getSessionData("dbsession", Map.class);
        if (dbnameList == null) {
            dbnameList = new HashMap();
        }
        if (lstDbnames.size() > 0) {
            instanceDetails = serverInstanceName + "#" + host + "#" + port + "#" + postgres_bkup_node;
            for (String string : lstDbnames) {
                HashMap<String, String> dbnameDetails = new HashMap<String, String>();
                this.logger.debug("Database Name :" + string);
                this.logger.debug(RB.getStringResource("PostgresRecoveryHandler.call.to.pgdump.recover.txt") + user + " Binpath " + binpath + "backupid " + backupid + " dbname" + string + "libpath" + libpath);
                String execString = binpath + File.separator + PG_RESTORE + '\"' + " -d " + string + " -U " + user + " -v  -c " + backupid + File.separator + "db" + File.separator + "Postgres_" + string + ".backup";
                this.logger.debug(Message.format((String)RB.getStringResource("PostgresRecoveryHandler.call.to.pgdump.exe.string.fmt"), (Object)execString));
                Process processNew = null;
                ProcessBuilder pbBuilder = null;
                try {
                    String string2;
                    String tempBinPath = binpath + File.separator + PG_RESTORE;
                    this.logger.debug("tempBinPath " + tempBinPath);
                    ArrayList<String> cmds = new ArrayList<String>();
                    cmds.add(tempBinPath);
                    cmds.add("-h");
                    cmds.add(host);
                    cmds.add("-p");
                    cmds.add(port);
                    cmds.add("-U");
                    cmds.add(user);
                    cmds.add("-d");
                    cmds.add(string);
                    cmds.add("-v");
                    cmds.add("-c");
                    cmds.add(backupid + File.separator + "Postgres_" + string + ".backup");
                    this.logger.debug("LD_PATH " + libpath);
                    pbBuilder = new ProcessBuilder(cmds);
                    Map<String, String> env = pbBuilder.environment();
                    env.put("PGPASSWORD", decryptPassword);
                    if (OSUtils.getOS_Family() != "Windows") {
                        StringBuffer ld_Path = new StringBuffer(props.getProperty("libpath"));
                        if (OSUtils.getOS() == 5) {
                            Object tempLibPath = ld_Path.toString();
                            if (env.containsKey(AIX_LD_LIB_PATH)) {
                                tempLibPath = env.get(AIX_LD_LIB_PATH) + ":" + ld_Path;
                            }
                            env.put(AIX_LD_LIB_PATH, (String)tempLibPath);
                        }
                        if (env.containsKey(LD_LIB_PATH)) {
                            ld_Path.append(":");
                            ld_Path.append(env.get(LD_LIB_PATH));
                        }
                        env.put(LD_LIB_PATH, ld_Path.toString());
                        for (Map.Entry entry : env.entrySet()) {
                            String key = (String)entry.getKey();
                            String string3 = (String)entry.getValue();
                        }
                    }
                    pbBuilder.redirectErrorStream(true);
                    processNew = pbBuilder.start();
                    InputStreamReader isr = new InputStreamReader(processNew.getInputStream());
                    BufferedReader br = new BufferedReader(isr);
                    boolean hasWarning = false;
                    boolean hasError = false;
                    this.logParser = new PostgresLogParser();
                    this.logger.info(RB.getStringResource("PostgresRecoveryHandler.recovery.pgrestore.utility.log.txt"));
                    while ((string2 = br.readLine()) != null) {
                        if (string2.toString().trim().equals("")) continue;
                        this.logger.info(string2);
                        if (this.logParser.hasError(string2)) {
                            this.logger.error(Message.format((String)RB.getStringResource("PostgresRecoveryHandler.recovery.error.in.pgrestore.fmt"), (Object)string2));
                            hasError = true;
                        }
                        if (this.logParser.hasWarning(string2)) {
                            this.logger.error(Message.format((String)RB.getStringResource("PostgresRecoveryHandler.recovery.warning.in.pgrestore.fmt"), (Object)string2));
                            hasWarning = true;
                        }
                        this.logger.debug("line return code : " + returnCode);
                    }
                    if (hasError) {
                        returnCode = BackupServer.ReturnCode.COMMAND_TOOL_ERROR_PGRECOVERY.getErrorCode();
                        this.logger.debug("ErrorCode: " + returnCode);
                    } else if (hasWarning) {
                        returnCode = BackupServer.ReturnCode.COMMAND_TOOL_WARNING_PGRECOVERY.getErrorCode();
                        this.logger.debug("warningCode: " + returnCode);
                    } else {
                        returnCode = 0;
                        this.logger.debug("successCode: " + returnCode);
                    }
                    this.logger.info("returnCode : " + returnCode);
                }
                catch (Exception ioe) {
                    this.logger.error(Message.format((String)RB.getStringResource("PostgresRecoveryHandler.recovery.error.fmt"), (Object)ioe.toString()));
                    returnCode = BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_PGRECOVERY.getErrorCode();
                    throw new BackupException(ioe, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_PGRECOVERY.getErrorCode());
                }
                finally {
                    try {
                        dbnameDetails.put("instancedetails", String.valueOf(instanceDetails));
                        dbnameDetails.put("status", String.valueOf(returnCode));
                        dbnameList.put(string + "@" + instanceDetails, dbnameDetails);
                        processNew.waitFor();
                        processNew.getInputStream().close();
                        processNew.getOutputStream().close();
                        processNew.getErrorStream().close();
                        Map<String, String> env = pbBuilder.environment();
                        env.put("PGPASSWORD", "");
                    }
                    catch (Exception ioe) {
                        this.logger.error(Message.format((String)RB.getStringResource("PostgresRecoveryHandler.recovery.error.fmt"), (Object)ioe.toString()));
                        returnCode = BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_PGRECOVERY.getErrorCode();
                        throw new BackupException(ioe, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_PGRECOVERY.getErrorCode());
                    }
                }
            }
            if (session.getSessionData("dbsession", Map.class) != null) {
                session.removeSessionData("dbsession");
            }
            session.putSessionData("dbsession", dbnameList);
        } else {
            String dbname = "";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("instancedetails", String.valueOf(instanceDetails));
            hashMap.put("status", String.valueOf(returnCode));
            dbnameList.put(dbname + "@" + instanceDetails, hashMap);
            if (session.getSessionData("dbsession", Map.class) != null) {
                session.removeSessionData("dbsession");
            }
            session.putSessionData("dbsession", dbnameList);
        }
        return returnCode;
    }

    private List<String> seprate_InstanceName(String pgdatabaseList) {
        ArrayList<String> instanceNames = new ArrayList<String>();
        if (!pgdatabaseList.equals("")) {
            String str = pgdatabaseList;
            StringTokenizer st = new StringTokenizer(str, ",", false);
            while (st.hasMoreTokens()) {
                String temp = st.nextToken(",");
                String instanceName = temp.split("@")[0];
                if (instanceNames.contains(instanceName)) continue;
                instanceNames.add(instanceName);
            }
            Iterator itr = instanceNames.iterator();
            while (itr.hasNext()) {
                this.logger.debug(itr.next().toString());
            }
        }
        return instanceNames;
    }

    private List<String> sepratedb_InstanceName(String pgdatabaseList, String serverInstance) {
        ArrayList<String> lstDbnames = new ArrayList<String>();
        if (!pgdatabaseList.equals("")) {
            String str = pgdatabaseList;
            StringTokenizer st = new StringTokenizer(str, ",", false);
            while (st.hasMoreTokens()) {
                String temp = st.nextToken(",");
                if (temp == null || !temp.split("@")[0].split("#")[0].equalsIgnoreCase(serverInstance)) continue;
                lstDbnames.add(temp.split("@")[1]);
            }
        }
        return lstDbnames;
    }

    private Properties createProperties(Command command, BackupSession session, ConnectionInfo connectInfo) {
        Properties props = new Properties();
        CommandRequestContext requestContext = session.getRequestContext();
        String serverInstanceNameHashCode = null;
        try {
            serverInstanceNameHashCode = BackupServerUtil.makeSHA1Hash(connectInfo.getName());
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error("Algorithm SHA1 is nota valid algowith for hascode.");
            e.printStackTrace();
        }
        String backupLoc = this.recoverRunEnvironment.getSourcePath() + File.separator + serverInstanceNameHashCode;
        this.logger.info(requestContext.getUser());
        String sasHome = requestContext.getSASHome();
        props.setProperty("postgres_node", command.getParameter("host"));
        props.setProperty("user", connectInfo.getUserName());
        props.setProperty("pw", connectInfo.getPassword());
        props.setProperty("host", connectInfo.getHost());
        props.setProperty("port", connectInfo.getPort());
        props.setProperty("serverinstancename", connectInfo.getName());
        props.setProperty("backupid", backupLoc);
        props.setProperty("binpath", sasHome + File.separator + PostgresBackupHandler.PG_DUMP_PATH);
        props.setProperty("libpath", sasHome + File.separator + PostgresBackupHandler.PG_LD_LIBRARY_PATH);
        String dbNamesList = "";
        if (command.getParameter("pgdatabaselist") != null) {
            dbNamesList = command.getParameter("pgdatabaselist");
        }
        props.setProperty("pgdatabaselist", dbNamesList);
        this.logger.info(props.getProperty("user") + " " + props.getProperty("binpath") + " " + props.getProperty("backupid") + " " + props.getProperty("dbname") + " " + props.getProperty("libpath"));
        return props;
    }

    @Override
    public int execute(RecoverRunEnvironment recoverRunEnvironment, BackupSession session) throws BackupException {
        this.recoverRunEnvironment = recoverRunEnvironment;
        Command command = recoverRunEnvironment.getCommand();
        int rc = 0;
        boolean retCodeSucc = false;
        int retCodeFail = BackupServer.ReturnCode.COMMAND_TOOL_ERROR_PGRECOVERY.getErrorCode();
        int retCodeWarn = BackupServer.ReturnCode.COMMAND_TOOL_WARNING_PGRECOVERY.getErrorCode();
        int internalError = BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_PGRECOVERY.getErrorCode();
        boolean consolidatedSucess = true;
        this.logger.debug("Staring command to run the data recover");
        List<String> connectStrings = this.getConnectionURLS(command.getParameter("dbconnecturl"));
        String pg_databaseList = command.getParameter("pgdatabaselist");
        ArrayList<ConnectionInfo> validConnects = new ArrayList<ConnectionInfo>();
        if (!pg_databaseList.equals("")) {
            List<String> instanceNames = this.seprate_InstanceName(pg_databaseList);
            for (String instName : instanceNames) {
                for (String connectURL : connectStrings) {
                    ConnectionInfo connectInfo = new ConnectionInfo(connectURL);
                    if (!connectInfo.getName().equals(instName)) continue;
                    validConnects.add(connectInfo);
                }
            }
        } else {
            for (String connectURL : connectStrings) {
                ConnectionInfo connectInfo = new ConnectionInfo(connectURL);
                validConnects.add(connectInfo);
            }
        }
        for (ConnectionInfo connectInfo : validConnects) {
            try {
                rc = this.recover(this.createProperties(command, session, connectInfo), session);
                boolean bl = consolidatedSucess = consolidatedSucess && (rc == 0 || rc == retCodeWarn);
                if (0 == rc) {
                    this.logger.info(RB.getStringResource("PostgresRecoveryHandler.recovery.sucessful.txt"));
                    continue;
                }
                if (retCodeWarn == rc) {
                    this.logger.info(RB.getStringResource("PostgresRecoveryHandler.recovery.with.warning.txt"));
                    continue;
                }
                if (retCodeFail != rc && internalError != rc) continue;
                this.logger.info(RB.getStringResource("PostgresRecoveryHandler.recovery.with.errors.txt"));
            }
            catch (BackupException e) {
                throw e;
            }
            catch (IllegalArgumentException exception) {
                this.logger.error(exception.getMessage());
                throw new BackupException(exception, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR.getErrorCode());
            }
            catch (Exception e) {
                this.logger.error(RB.getStringResource("PostgresRecoveryHandler.recovery.ended.with.exception.txt"));
                throw new BackupException(e, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_PGRECOVERY.getErrorCode());
            }
        }
        if (!consolidatedSucess) {
            throw new BackupException("One of the database failed to backup see log for details", BackupServer.ReturnCode.COMMAND_TOOL_ERROR_PGRECOVERY.getErrorCode());
        }
        return rc;
    }

    private List<String> getConnectionURLS(String urlOption) {
        String[] urls = urlOption.split(",");
        return Arrays.asList(urls);
    }

    @Override
    public void doPostProcess(RecoverRunEnvironment env, BackupSession session) throws BackupException {
        try {
            Map dbNamesMap = session.getSessionData("dbsession", Map.class);
            if (dbNamesMap != null) {
                Set dbNames = dbNamesMap.keySet();
                int append = 1;
                Properties properties = new Properties();
                for (String dbname : dbNames) {
                    Map dbDetials = (Map)dbNamesMap.get(dbname);
                    dbname = dbname.contains("@") ? dbname.split("@")[0] : dbname;
                    String dbStatusKey = "db.substatus." + append;
                    String dbStatusValue = (String)dbDetials.get("status");
                    String dbInstanceDetailsKey = "db.instancedetails." + append;
                    String dbInstanceDEtailaValue = (String)dbDetials.get("instancedetails");
                    String dbNamekey = "db.name." + append;
                    properties.setProperty(dbNamekey, dbname);
                    properties.setProperty(dbStatusKey, dbStatusValue);
                    properties.setProperty(dbInstanceDetailsKey, dbInstanceDEtailaValue);
                    ++append;
                }
                if (properties.size() > 0) {
                    session.putSessionData("result.properties", properties);
                }
            }
        }
        catch (Exception exception) {
            throw new BackupException(BackupServer.ReturnCode.COMMAND_POST_PROCESS_ERROR.getErrorCode());
        }
    }
}

