/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server.handler;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupRunEnvironment;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.BackupSession;
import com.sas.svcs.backup.server.CommandHandler;
import com.sas.svcs.backup.server.CommandPostProcessor;
import com.sas.svcs.backup.server.CommandRequestContext;
import com.sas.svcs.backup.server.InitialConfigContext;
import com.sas.svcs.backup.server.handler.ConnectionInfo;
import com.sas.svcs.backup.server.handler.PostgresLogParser;
import com.sas.svcs.backup.server.handler.RB;
import com.sas.svcs.backup.server.util.BackupServerUtil;
import com.sas.svcs.backup.server.util.OSUtils;
import com.sas.text.Message;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.postgresql.util.PSQLException;

public class PostgresBackupHandler
implements CommandHandler<BackupRunEnvironment>,
CommandPostProcessor<BackupRunEnvironment> {
    private static final String PG_DUMP = "pg_dump";
    Logger logger = LogManager.getLogger(PostgresBackupHandler.class);
    public static final String PG_DUMP_PATH = "SASWebInfrastructurePlatformDataServer" + File.separator + "9.4" + File.separator + "bin";
    public static final String PG_LD_LIBRARY_PATH = "SASWebInfrastructurePlatformDataServer" + File.separator + "9.4" + File.separator + "lib";
    private static final String LD_LIB_PATH = "LD_LIBRARY_PATH";
    private static final String AIX_LD_LIB_PATH = "LIBPATH";
    private static final int SHARELOCK_TIMEOUT = 300000;
    private PostgresLogParser logParser;
    private BackupRunEnvironment backupRunEnv;

    private String getTimeOutValue() {
        int dTimeout = 300000;
        try {
            String timeOut = InitialConfigContext.getInitialContext().getProperty("backupserver.db.lock.timeout");
            if (timeOut != null) {
                dTimeout = Integer.parseInt(timeOut.trim());
            }
        }
        catch (Exception e) {
            this.logger.warn("Error getting user specified lock timeout value from configuration using the default timeout value");
        }
        return String.valueOf(dTimeout);
    }

    private int backup(Properties props, BackupSession session) throws BackupException {
        File f;
        int returnCode = BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_PGBACKUP.getErrorCode();
        List<Object> lstDbnames = new ArrayList();
        String host = null;
        String port = null;
        String user = null;
        String password = null;
        String binpath = null;
        String backuploc = null;
        String pgdatabaseList = null;
        String serverInstanceName = null;
        String postgres_bkup_node = null;
        String excludes = props.getProperty("dbexcludes");
        List<String> excludeDatabaseNames = null;
        postgres_bkup_node = props.getProperty("postgres_node");
        host = props.getProperty("host");
        port = props.getProperty("port");
        user = props.getProperty("user");
        password = props.getProperty("pw");
        binpath = props.getProperty("binpath");
        backuploc = props.getProperty("backuploc");
        pgdatabaseList = props.getProperty("pgdatabaselist");
        serverInstanceName = props.getProperty("serverinstancename");
        String fileName = PG_DUMP;
        if ("Windows".equalsIgnoreCase(OSUtils.getOS_Family())) {
            fileName = fileName + ".exe";
        }
        if (!(f = new File(binpath + File.separator + fileName)).exists()) {
            returnCode = BackupServer.ReturnCode.FILE_NOT_PRESENT.getErrorCode();
            throw new BackupException(f.getAbsolutePath() + " doesn't exist.", BackupServer.ReturnCode.FILE_NOT_PRESENT.getErrorCode());
        }
        String decryptPassword = null;
        try {
            decryptPassword = SasPasswordString.decode((String)password);
        }
        catch (SasPasswordEncodingException e) {
            this.logger.debug(RB.getStringResource("PostgresBackupHandler.error.decode.txt"), (Throwable)e);
            throw new BackupException(e, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_PGPASSWORDENCODING.getErrorCode());
        }
        if (excludes != null && !excludes.isEmpty()) {
            excludeDatabaseNames = this.getDatabaseNames(excludes, serverInstanceName);
        }
        if (pgdatabaseList != null && !pgdatabaseList.equals("")) {
            lstDbnames = this.getDatabaseNames(pgdatabaseList, serverInstanceName);
            Iterator<Object> itr = lstDbnames.iterator();
            while (itr.hasNext()) {
                this.logger.debug(((String)itr.next()).toString());
            }
        } else {
            Connection con = null;
            ResultSet rs = null;
            try {
                Class.forName("org.postgresql.Driver");
                con = DriverManager.getConnection(this.CreateJdbcUrl(host, port, "postgres"), user, decryptPassword);
                Statement stmt = con.createStatement();
                rs = stmt.executeQuery("SELECT * FROM  pg_database WHERE datistemplate='FALSE';");
                while (rs.next()) {
                    lstDbnames.add(rs.getString("datname"));
                }
            }
            catch (PSQLException e) {
                this.logger.error("Error in backup for instance : " + serverInstanceName + " : " + (Object)((Object)e));
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                throw new BackupException("Error in backup for instance : " + serverInstanceName, e, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_PGBACKUP.getErrorCode());
            }
            finally {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException e) {
                    throw new BackupException(e, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_PGBACKUP.getErrorCode());
                }
            }
        }
        String instanceDetails = serverInstanceName + "#" + host + "#" + port + "#" + postgres_bkup_node;
        HashMap dbnameList = session.getSessionData("dbsession", Map.class);
        if (dbnameList == null) {
            dbnameList = new HashMap();
        }
        if (lstDbnames.size() > 0) {
            if (excludeDatabaseNames != null) {
                this.logger.info("Excluding databases: " + excludeDatabaseNames);
                lstDbnames.removeAll(excludeDatabaseNames);
            }
            for (String string : lstDbnames) {
                HashMap<String, String> dbnameDetails = new HashMap<String, String>();
                this.logger.debug("Database Name :" + string);
                boolean exclude_Tables = false;
                if (string.equals("SharedServices")) {
                    exclude_Tables = true;
                }
                String execString = exclude_Tables ? binpath + File.separator + PG_DUMP + " -h " + host + " -p " + port + " -U " + user + " -T *scs*-Fc -v -f " + backuploc + File.separator + "Postgres_" + string + ".backup " + string : binpath + File.separator + PG_DUMP + " -h " + host + " -p " + port + " -U " + user + " -Fc -v -f " + backuploc + File.separator + "Postgres_" + string + ".backup " + string;
                this.logger.debug(Message.format((String)RB.getStringResource("PostgresBackupHandler.call.to.pgdump.exe.string.fmt"), (Object)execString));
                Process processNew = null;
                ProcessBuilder pbBuilder = null;
                try {
                    String string2;
                    String timeOutValue = this.getTimeOutValue();
                    String tempBinPath = binpath + File.separator + PG_DUMP;
                    this.logger.debug("tempBinPath " + tempBinPath);
                    ArrayList<String> cmds = new ArrayList<String>();
                    cmds.add(tempBinPath);
                    cmds.add("-h");
                    cmds.add(host);
                    cmds.add("-p");
                    cmds.add(port);
                    cmds.add("-U");
                    cmds.add(user);
                    if (!"".equals(timeOutValue)) {
                        cmds.add("--lock-wait-timeout");
                        this.logger.info("Adding the lock wait timeout period : " + timeOutValue);
                        cmds.add(timeOutValue);
                    }
                    if (exclude_Tables) {
                        cmds.add("-T");
                        cmds.add("*scs*");
                    }
                    cmds.add("-w");
                    cmds.add("-F");
                    cmds.add("c");
                    cmds.add("-b");
                    cmds.add("-v");
                    cmds.add("-f");
                    cmds.add(backuploc + File.separator + "Postgres_" + string + ".backup");
                    cmds.add(string);
                    this.logger.debug("LD _PATH " + props.getProperty("libpath"));
                    pbBuilder = new ProcessBuilder(cmds);
                    Map<String, String> env = pbBuilder.environment();
                    env.put("PGPASSWORD", decryptPassword);
                    if (OSUtils.getOS_Family() != "Windows") {
                        StringBuffer ld_Path = new StringBuffer(props.getProperty("libpath"));
                        if (OSUtils.getOS() == 5) {
                            Object tempLibPath = ld_Path.toString();
                            if (env.containsKey(AIX_LD_LIB_PATH)) {
                                tempLibPath = env.get(AIX_LD_LIB_PATH) + ":" + ld_Path;
                            }
                            env.put(AIX_LD_LIB_PATH, (String)tempLibPath);
                        }
                        if (env.containsKey(LD_LIB_PATH)) {
                            ld_Path.append(":");
                            ld_Path.append(env.get(LD_LIB_PATH));
                        }
                        env.put(LD_LIB_PATH, ld_Path.toString());
                        for (Map.Entry entry : env.entrySet()) {
                            String key = (String)entry.getKey();
                            String string3 = (String)entry.getValue();
                        }
                    }
                    pbBuilder.redirectErrorStream(true);
                    processNew = pbBuilder.start();
                    InputStreamReader isr = new InputStreamReader(processNew.getInputStream());
                    BufferedReader br = new BufferedReader(isr);
                    boolean hasWarning = false;
                    boolean hasError = false;
                    this.logParser = new PostgresLogParser();
                    this.logger.info(RB.getStringResource("PostgresBackupHandler.backup.pgdump.utility.log.txt"));
                    while ((string2 = br.readLine()) != null) {
                        if (string2.toString().trim().equals("")) continue;
                        this.logger.info(string2);
                        if (this.logParser.hasError(string2)) {
                            this.logger.error(Message.format((String)RB.getStringResource("PostgresBackupHandler.backup.error.in.pgdump.fmt"), (Object)string2));
                            hasError = true;
                        }
                        if (this.logParser.hasWarning(string2)) {
                            this.logger.warn(Message.format((String)RB.getStringResource("PostgresBackupHandler.backup.warning.in.pgdump.fmt"), (Object)string2));
                            hasWarning = true;
                        }
                        this.logger.debug("line return code : " + returnCode);
                    }
                    if (hasError) {
                        returnCode = BackupServer.ReturnCode.COMMAND_TOOL_ERROR_PGBACKUP.getErrorCode();
                        this.logger.debug("ErrorCode: " + returnCode);
                    } else if (hasWarning) {
                        returnCode = BackupServer.ReturnCode.COMMAND_TOOL_WARNING_PGBACKUP.getErrorCode();
                        this.logger.debug("warningCode: " + returnCode);
                    } else {
                        returnCode = 0;
                        this.logger.debug("successCode: " + returnCode);
                    }
                    this.logger.debug("returnCode : " + returnCode);
                    dbnameDetails.put("instancedetails", String.valueOf(instanceDetails));
                    dbnameDetails.put("status", String.valueOf(returnCode));
                    dbnameDetails.put("size", String.valueOf(BackupServerUtil.getDirectorySize(new File(backuploc + File.separator + "Postgres_" + string + ".backup"))));
                    dbnameList.put(string + "@" + instanceDetails, dbnameDetails);
                }
                catch (Exception ioe) {
                    this.logger.error(Message.format((String)RB.getStringResource("PostgresBackupHandler.backup.error.fmt"), (Object)ioe));
                    returnCode = BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_PGBACKUP.getErrorCode();
                    throw new BackupException(ioe, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_PGBACKUP.getErrorCode());
                }
                finally {
                    try {
                        processNew.waitFor();
                        this.logger.info("Exit code : " + processNew.exitValue());
                        processNew.getInputStream().close();
                        processNew.getOutputStream().close();
                        processNew.getErrorStream().close();
                        Map<String, String> env = pbBuilder.environment();
                        env.put("PGPASSWORD", "");
                    }
                    catch (IOException ioe) {
                        this.logger.error(Message.format((String)RB.getStringResource("PostgresBackupHandler.backup.error.fmt"), (Object)ioe));
                        returnCode = BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_PGBACKUP.getErrorCode();
                        throw new BackupException(ioe, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_PGBACKUP.getErrorCode());
                    }
                    catch (InterruptedException e) {
                        returnCode = BackupServer.ReturnCode.COMMAND_TOOL_ERROR_PGBACKUP.getErrorCode();
                        throw new BackupException(e, BackupServer.ReturnCode.COMMAND_TOOL_ERROR_PGBACKUP.getErrorCode());
                    }
                }
            }
            if (session.getSessionData("dbsession", Map.class) != null) {
                session.removeSessionData("dbsession");
            }
            session.putSessionData("dbsession", dbnameList);
        } else {
            String dbname = "";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("instancedetails", String.valueOf(instanceDetails));
            hashMap.put("status", String.valueOf(returnCode));
            hashMap.put("size", String.valueOf(BackupServerUtil.getDirectorySize(new File(backuploc + File.separator + "Postgres_" + dbname + ".backup"))));
            dbnameList.put(dbname + "@" + instanceDetails, hashMap);
            if (session.getSessionData("dbsession", Map.class) != null) {
                session.removeSessionData("dbsession");
            }
            session.putSessionData("dbsession", dbnameList);
        }
        return returnCode;
    }

    private String CreateJdbcUrl(String hostName, String port, String dbname) {
        String jdbcUrl = "";
        if (hostName != null && port != null && dbname != null) {
            jdbcUrl = "jdbc:postgresql://" + hostName + ":" + port + "/" + dbname;
        }
        return jdbcUrl;
    }

    private List<String> getDatabaseNames(String pgdatabaseList, String serverInstance) {
        ArrayList<String> lstDbnames = new ArrayList<String>();
        if (pgdatabaseList != null && !pgdatabaseList.equals("")) {
            String str = pgdatabaseList;
            StringTokenizer st = new StringTokenizer(str, "|", false);
            while (st.hasMoreTokens()) {
                String temp = st.nextToken("|");
                if (temp == null || !temp.split("@")[0].split("#")[0].equalsIgnoreCase(serverInstance)) continue;
                lstDbnames.add(temp.split("@")[1]);
            }
        }
        return lstDbnames;
    }

    private Properties createProperties(Command command, BackupSession session, ConnectionInfo connectInfo) {
        String excludes;
        Properties props = new Properties();
        CommandRequestContext requestContext = session.getRequestContext();
        this.logger.debug(requestContext.getUser());
        String serverInstanceNameHashCode = null;
        try {
            serverInstanceNameHashCode = BackupServerUtil.makeSHA1Hash(connectInfo.getName());
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error("Algorithm SHA1 is nota valid algowith for hascode.", (Throwable)e);
            e.printStackTrace();
        }
        String backupLoc = this.backupRunEnv.getTargetPath() + File.separator + serverInstanceNameHashCode;
        File backupLocation = new File(backupLoc);
        if (backupLocation != null && !backupLocation.exists()) {
            backupLocation.mkdir();
        }
        String sasHome = requestContext.getSASHome();
        props.setProperty("postgres_node", command.getParameter("host"));
        props.setProperty("user", connectInfo.getUserName());
        props.setProperty("pw", connectInfo.getPassword());
        props.setProperty("host", connectInfo.getHost());
        props.setProperty("port", connectInfo.getPort());
        props.setProperty("serverinstancename", connectInfo.getName());
        props.setProperty("binpath", sasHome + File.separator + PG_DUMP_PATH);
        props.setProperty("backuploc", backupLoc);
        props.setProperty("libpath", sasHome + File.separator + PG_LD_LIBRARY_PATH);
        String dbInstanceIncludeList = connectInfo.getIncludes();
        if (dbInstanceIncludeList != null && !dbInstanceIncludeList.isEmpty()) {
            this.logger.info("dbInstanceIncludeList: " + dbInstanceIncludeList);
            props.remove("pgdatabaselist");
            props.setProperty("pgdatabaselist", dbInstanceIncludeList);
        }
        if ((excludes = connectInfo.getExcludes()) != null && !excludes.isEmpty()) {
            this.logger.info("dbexcludes: " + excludes);
            props.setProperty("dbexcludes", excludes);
        }
        this.logger.debug(props.getProperty("user") + " XXXXXXXXXXXXX " + props.getProperty("binpath") + " " + props.getProperty("backuploc") + " " + props.getProperty("pgdatabaselist") + " " + props.getProperty("libpath"));
        return props;
    }

    @Override
    public int execute(BackupRunEnvironment bakupRunEnv, BackupSession session) throws BackupException {
        int rc = 0;
        this.backupRunEnv = bakupRunEnv;
        boolean consolidatedSucess = true;
        Command command = bakupRunEnv.getCommand();
        boolean retCodeSucc = false;
        int retCodeFail = BackupServer.ReturnCode.COMMAND_TOOL_ERROR_PGBACKUP.getErrorCode();
        int retCodeWarn = BackupServer.ReturnCode.COMMAND_TOOL_WARNING_PGBACKUP.getErrorCode();
        int internalError = BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_PGBACKUP.getErrorCode();
        this.logger.debug("Staring command to run the data backup");
        List<String> connectStrings = this.getConnectionURLS(command.getParameter("dbconnecturl"));
        String pg_databaseList = command.getParameter("pgdatabaselist");
        ArrayList<ConnectionInfo> validConnects = new ArrayList<ConnectionInfo>();
        if (pg_databaseList != null && !pg_databaseList.equals("")) {
            List<String> instanceNames = this.getDBInstanceNames(pg_databaseList);
            for (String instName : instanceNames) {
                for (String connectURL : connectStrings) {
                    ConnectionInfo connectInfo = new ConnectionInfo(connectURL);
                    if (!connectInfo.getName().equals(instName)) continue;
                    validConnects.add(connectInfo);
                }
            }
        } else {
            for (String connectURL : connectStrings) {
                ConnectionInfo connectInfo = new ConnectionInfo(connectURL);
                validConnects.add(connectInfo);
            }
        }
        for (ConnectionInfo connectInfo : validConnects) {
            try {
                rc = this.backup(this.createProperties(command, session, connectInfo), session);
                boolean bl = consolidatedSucess = consolidatedSucess && (rc == 0 || rc == retCodeWarn);
                if (0 == rc) {
                    this.logger.info(RB.getStringResource("PostgresBackupHandler.backup.sucesfull.txt"));
                    continue;
                }
                if (retCodeWarn == rc) {
                    this.logger.info(RB.getStringResource("PostgresBackupHandler.backup.with.warnings.txt"));
                    continue;
                }
                if (retCodeFail != rc && internalError != rc) continue;
                this.logger.info(RB.getStringResource("PostgresBackupHandler.backup.with.errors.txt"));
            }
            catch (IllegalArgumentException exception) {
                this.logger.error(exception.getMessage(), (Throwable)exception);
                throw new BackupException(exception, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR.getErrorCode());
            }
        }
        if (!consolidatedSucess) {
            throw new BackupException("One of the database failed to backup see Database.log for details", BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_PGBACKUP.getErrorCode());
        }
        return rc;
    }

    private List<String> getDBInstanceNames(String pgdatabaseList) {
        ArrayList<String> instanceNames = new ArrayList<String>();
        if (pgdatabaseList != null && !pgdatabaseList.equals("")) {
            String str = pgdatabaseList;
            StringTokenizer st = new StringTokenizer(str, "|", false);
            while (st.hasMoreTokens()) {
                String temp = st.nextToken("|");
                String instanceName = temp.split("@")[0];
                if (instanceNames.contains(instanceName)) continue;
                instanceNames.add(instanceName);
            }
            Iterator itr = instanceNames.iterator();
            while (itr.hasNext()) {
                this.logger.debug(itr.next().toString());
            }
        }
        return instanceNames;
    }

    private List<String> getConnectionURLS(String urlOption) {
        String[] urls = urlOption.split(",");
        return Arrays.asList(urls);
    }

    @Override
    public void doPostProcess(BackupRunEnvironment env, BackupSession session) throws BackupException {
        try {
            Map dbNamesMap = session.getSessionData("dbsession", Map.class);
            if (dbNamesMap != null) {
                Set dbNames = dbNamesMap.keySet();
                int append = 1;
                Properties properties = new Properties();
                for (String dbname : dbNames) {
                    Map dbDetials = (Map)dbNamesMap.get(dbname);
                    dbname = dbname.contains("@") ? dbname.split("@")[0] : dbname;
                    String dbStatusKey = "db.substatus." + append;
                    String dbStatusValue = (String)dbDetials.get("status");
                    String dbInstanceDetailsKey = "db.instancedetails." + append;
                    String dbInstanceDEtailaValue = (String)dbDetials.get("instancedetails");
                    String dbSizeKey = "db.size." + append;
                    String dbSizeValue = (String)dbDetials.get("size");
                    String dbNamekey = "db.name." + append;
                    properties.setProperty(dbNamekey, dbname);
                    properties.setProperty(dbStatusKey, dbStatusValue);
                    properties.setProperty(dbSizeKey, dbSizeValue);
                    properties.setProperty(dbInstanceDetailsKey, dbInstanceDEtailaValue);
                    ++append;
                }
                if (properties.size() > 0) {
                    session.putSessionData("result.properties", properties);
                }
            }
        }
        catch (Exception exception) {
            throw new BackupException(BackupServer.ReturnCode.COMMAND_POST_PROCESS_ERROR.getErrorCode());
        }
    }
}

