/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server.handler;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.common.definitions.BackupErrorConstants;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.BackupSession;
import com.sas.svcs.backup.server.CommandHandler;
import com.sas.svcs.backup.server.CommandRequestContext;
import com.sas.svcs.backup.server.DefaultCommandEnvironment;
import com.sas.svcs.backup.server.InitialConfigContext;
import com.sas.svcs.backup.server.handler.RB;
import com.sas.svcs.backup.server.util.BackupServerUtil;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PostRecoverHandler
implements CommandHandler<DefaultCommandEnvironment> {
    Logger logger = LogManager.getLogger(PostRecoverHandler.class);
    int rc = 0;

    @Override
    public int execute(DefaultCommandEnvironment runEnv, BackupSession session) throws BackupException {
        CommandRequestContext requestContext = session.getRequestContext();
        Command command = runEnv.getCommand();
        this.rc = this.removeLocalBackup(command, runEnv);
        this.rc = this.runSCSTask(command);
        return this.rc;
    }

    private int runSCSTask(Command command) {
        try {
            if (this.isSCSPresent(command) && this.isRecoverySuccessful(command)) {
                this.rc = this.insertData(command);
                this.rc = this.renameRepositoryFolder(command);
            }
        }
        catch (Exception e) {
            this.rc = BackupErrorConstants.ErrorCodes.COMMAND_INTERNAL_WARN_POSTRECOVER.getErrorCode();
            this.logger.warn(RB.getStringResource("PostRecoverHandler.task.unsuccessfull.txt") + e.toString());
            throw new BackupException(RB.getStringResource("PostRecoverHandler.task.unsuccessfull.txt"), e, BackupErrorConstants.ErrorCodes.COMMAND_INTERNAL_WARN_POSTRECOVER.getErrorCode());
        }
        return this.rc;
    }

    private int renameRepositoryFolder(Command command) {
        String scsRoot = null;
        String scsoldrepos = null;
        String scscurrentrepos = null;
        scsRoot = command.getParameter("scsroot");
        scsoldrepos = command.getParameter("defaultrepos");
        scscurrentrepos = "Copy_of_" + command.getParameter("defaultrepos");
        boolean renamedoldRepFile = false;
        boolean renamedCopyofFile = false;
        File scsoldDir = new File(scsRoot + File.separator + scsoldrepos);
        File scsbckupDir = new File(scsRoot + File.separator + "Old_" + scsoldrepos);
        if (scsbckupDir.exists() && FileUtils.deleteQuietly((File)scsbckupDir)) {
            this.logger.info("Removed existing Old_Repository folder");
        }
        renamedoldRepFile = scsoldDir.renameTo(scsbckupDir);
        File scscurrentreposDir = new File(scsRoot + File.separator + scscurrentrepos);
        File scsreopsDir = new File(scsRoot + File.separator + scsoldrepos);
        renamedCopyofFile = scscurrentreposDir.renameTo(scsreopsDir);
        if (!renamedoldRepFile || !renamedCopyofFile) {
            this.rc = BackupErrorConstants.ErrorCodes.COMMAND_INTERNAL_WARN_POSTRECOVER.getErrorCode();
            this.logger.warn(RB.getStringResource("PostRecoverHandler.task.unsuccessfull.txt"));
        }
        return this.rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int insertData(Command command) throws SQLException {
        int index = 0;
        String pg_user = null;
        String pg_pw = null;
        pg_user = command.getParameter("pguser");
        pg_pw = command.getParameter("pgpw");
        InitialConfigContext intCtx = InitialConfigContext.getInitialContext();
        String jdbcDriver = null;
        String jdbcUrl = null;
        if (!BackupServerUtil.isEmpty(intCtx.getProperty("scs.jdbc.driver"))) {
            jdbcUrl = intCtx.getProperty("scs.jdbc.Url");
        }
        if (!BackupServerUtil.isEmpty(intCtx.getProperty("scs.jdbc.driver"))) {
            jdbcDriver = intCtx.getProperty("scs.jdbc.driver");
        }
        Connection dbConnection = null;
        Statement statement = null;
        String insertTableSQL = "insert into SAS_SCS2_GLOBAL_REVISION VALUES(0,-1)";
        try {
            dbConnection = this.getDBConnection(jdbcDriver, jdbcUrl, pg_user, pg_pw);
            statement = dbConnection.createStatement();
            index = statement.executeUpdate(insertTableSQL);
            this.logger.info("Record is inserted into SAS_SCS2_GLOBAL_REVISION table");
        }
        catch (Exception e) {
            this.rc = BackupErrorConstants.ErrorCodes.COMMAND_INTERNAL_WARN_POSTRECOVER.getErrorCode();
            this.logger.warn(RB.getStringResource("PostRecoverHandler.task.unsuccessfull.txt") + e.toString());
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (dbConnection != null) {
                dbConnection.close();
            }
        }
        if (index < 1) {
            this.rc = BackupErrorConstants.ErrorCodes.COMMAND_INTERNAL_WARN_POSTRECOVER.getErrorCode();
            this.logger.warn(RB.getStringResource("PostRecoverHandler.task.unsuccessfull.txt"));
        }
        return this.rc;
    }

    private int removeLocalBackup(Command command, DefaultCommandEnvironment runEnv) {
        try {
            if (command.hasParameter("sharedvaultpresent")) {
                this.logger.info("As shared vault is provided removing local contents");
                String localStaging = null;
                if (command.getParameter("backupid") != null) {
                    localStaging = runEnv.getVaultBase() + File.separator + command.getParameter("backupid");
                    this.cleanLocalVault(new File(localStaging));
                }
            }
        }
        catch (Exception e) {
            this.rc = BackupErrorConstants.ErrorCodes.COMMAND_INTERNAL_WARN_LOCALCONTENT_POSTRECOVERY.getErrorCode();
            this.logger.warn(RB.getStringResource("PostRecoverHandler.localcontent.remove.task.unsuccessfull.txt") + e.toString());
            throw new BackupException(RB.getStringResource("PostRecoverHandler.localcontent.remove.task.unsuccessfull.txt"), e, BackupErrorConstants.ErrorCodes.COMMAND_INTERNAL_WARN_LOCALCONTENT_POSTRECOVERY.getErrorCode());
        }
        return this.rc;
    }

    private Connection getDBConnection(String db_driver, String db_url, String db_user, String db_password) throws SQLException, ClassNotFoundException {
        Connection dbConnection = null;
        try {
            db_password = SasPasswordString.decode((String)db_password);
        }
        catch (SasPasswordEncodingException e) {
            this.logger.debug(RB.getStringResource("PostgresBackupHandler.error.decode.txt"), (Throwable)e);
            throw new BackupException(e, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_PGPASSWORDENCODING.getErrorCode());
        }
        Class.forName(db_driver);
        dbConnection = DriverManager.getConnection(db_url, db_user, db_password);
        return dbConnection;
    }

    public void cleanLocalVault(File localVault) throws IOException {
        if (localVault != null && localVault.exists()) {
            FileUtils.deleteDirectory((File)localVault);
        }
    }

    private boolean isSCSPresent(Command command) {
        return command.hasParameter("scspresent");
    }

    private boolean isRecoverySuccessful(Command command) {
        return command.hasParameter("recoverysuccessful");
    }
}

