/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server.handler;

import com.sas.apps.content.migration.core.ContentMigrationAdapter;
import com.sas.apps.content.migration.core.ContentMigrationException;
import com.sas.apps.content.migration.export.common.Directory;
import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupRunEnvironment;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.BackupSession;
import com.sas.svcs.backup.server.CommandHandler;
import com.sas.svcs.backup.server.CommandRequestContext;
import com.sas.svcs.backup.server.InitialConfigContext;
import com.sas.svcs.backup.server.handler.PhysicalDataBackupPostProcessor;
import com.sas.svcs.backup.server.util.BackupServerUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LevconfigBackupHandler
extends PhysicalDataBackupPostProcessor
implements CommandHandler<BackupRunEnvironment> {
    Logger logger = LogManager.getLogger(LevconfigBackupHandler.class);
    private String logDir = null;
    public static final String[] SERVER_CONTEXT_SEARCH = new String[]{"Data", "SASEnvironment"};
    private BackupRunEnvironment backupRunEnvironment;
    private static final String SOURCE_DIR_SEPERATOR = ",,";
    private static final List<String> foundationServersInsideContext = new ArrayList<String>();
    private static final List<String> foundationServersOutsideContext = new ArrayList<String>();

    private Properties createProperties(Command command, BackupSession session) throws BackupException {
        Properties props = new Properties();
        CommandRequestContext requestContext = session.getRequestContext();
        String configDir = command.getParameter("configdir");
        props.setProperty("cmu.base.dir", configDir);
        props.setProperty("cmu.sasroot", requestContext.getSASRoot());
        props.setProperty("cmu.sashome", requestContext.getSASHome());
        props.setProperty("cmu.migration.mode", "export");
        props.setProperty("cmu.package.dir", this.backupRunEnvironment.getTargetPath());
        props.setProperty("source.dir.permission.migration", "true");
        props.setProperty("source.dir.run.cporeport", "false");
        String includefilter = command.getParameter("includefilter");
        String extractedIncludeFilter = null;
        if (includefilter != null && !includefilter.isEmpty()) {
            extractedIncludeFilter = BackupServerUtil.extractFilter(includefilter, configDir);
        }
        Map<String, String> includeFilters = this.getFilterMap(extractedIncludeFilter);
        String excludefilter = command.getParameter("excludefilter");
        String extractedExcludeFilter = null;
        if (excludefilter != null && !excludefilter.isEmpty()) {
            extractedExcludeFilter = BackupServerUtil.extractFilter(excludefilter, configDir);
        }
        Map<String, String> excludeFilters = this.getFilterMap(extractedExcludeFilter);
        this.addDefaultExcludes(configDir, excludeFilters);
        String sourceDirs = command.getParameter("sourcedirs");
        extractedIncludeFilter = this.searchForConfigDirs(configDir, includeFilters);
        extractedIncludeFilter = this.addFoundationServerDirs(configDir, extractedIncludeFilter);
        if (extractedIncludeFilter != null && !extractedIncludeFilter.isEmpty()) {
            this.logger.debug("Passing include filter to cmu: " + extractedIncludeFilter);
            props.setProperty("cmu.include.filter", extractedIncludeFilter);
        }
        if (excludeFilters != null && !excludeFilters.isEmpty()) {
            String exclude = this.filterMapToString(excludeFilters);
            this.logger.debug("Passing exclude filter to cmu: " + exclude);
            props.setProperty("cmu.exclude.filter", exclude);
        }
        props.setProperty("cmu.source.dirs", sourceDirs);
        this.logger.info("List of directories to be backed up: " + sourceDirs);
        props.setProperty("config.xml.dir.path", "");
        return props;
    }

    private String addDefaultExcludes(String configDir, Map<String, String> excludeFilters) {
        String updatedExclude = null;
        String path = this.getCanonicalPathSafely(configDir);
        if (path != null) {
            String excludeFilterForConfigDir = excludeFilters.get(path);
            if (excludeFilterForConfigDir == null) {
                excludeFilterForConfigDir = "";
            }
            if (!(updatedExclude = excludeFilterForConfigDir).isEmpty()) {
                updatedExclude = updatedExclude + ":";
            }
            updatedExclude = updatedExclude + "Backup/**:**/*.MD5";
            if (excludeFilters.containsKey(path)) {
                excludeFilters.remove(path);
            }
            excludeFilters.put(path, updatedExclude);
        }
        return updatedExclude;
    }

    private String addFoundationServerDirs(String configDir, String extractedIncludeFilter) {
        Map<String, String> includeFilters = this.getFilterMap(extractedIncludeFilter);
        InitialConfigContext intCtx = InitialConfigContext.getInitialContext();
        String includeFoundationDirs = intCtx.getProperty("backupserver.include.foundation.server.dirs");
        boolean shouldIncludeFoundation = true;
        String path = this.getCanonicalPathSafely(configDir);
        String filterValue = null;
        if (path != null) {
            filterValue = includeFilters.get(path);
        }
        if (includeFoundationDirs != null) {
            shouldIncludeFoundation = Boolean.parseBoolean(includeFoundationDirs);
        }
        if (shouldIncludeFoundation) {
            this.logger.info("Scanning for server directories to be backed up.");
            if (path != null) {
                File[] outsideContextServers;
                StringBuffer serverDirs = new StringBuffer();
                File fConfigDir = new File(configDir);
                for (File dir : outsideContextServers = fConfigDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return LevconfigBackupHandler.this.isServerDirectory(dir, name, foundationServersOutsideContext);
                    }
                })) {
                    String relPath = Directory.getChildPath((String)configDir, (String)dir.getAbsolutePath());
                    this.appendToIncludeDirList(serverDirs, relPath + "/**");
                }
                List<File> contexts = this.getServerContexts(configDir);
                if (contexts != null) {
                    for (File fContext : contexts) {
                        File[] insideContextServers;
                        for (File dir : insideContextServers = fContext.listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                return LevconfigBackupHandler.this.isServerDirectory(dir, name, foundationServersInsideContext);
                            }
                        })) {
                            String relPath = Directory.getChildPath((String)configDir, (String)dir.getAbsolutePath());
                            this.appendToIncludeDirList(serverDirs, relPath + "/**");
                        }
                    }
                }
                if (filterValue == null || filterValue.length() == 0) {
                    filterValue = "";
                }
                if (serverDirs.length() > 0) {
                    if (filterValue.length() > 0) {
                        return path + "|" + filterValue + ":" + serverDirs.toString();
                    }
                    return path + "|" + serverDirs.toString();
                }
            }
            this.logger.info("Done with scanning");
        }
        return filterValue;
    }

    private String getCanonicalPathSafely(String configDir) {
        String path = null;
        if (configDir != null) {
            try {
                path = new File(configDir).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return path;
    }

    private boolean isServerDirectory(File dir, String name, List<String> matchCriteria) {
        File fileInQuestion = new File(dir, name);
        for (String serverDir : matchCriteria) {
            if (!fileInQuestion.isDirectory() || !name.startsWith(serverDir) || !name.equals(serverDir) && !this.isInteger(name.substring(serverDir.length()))) continue;
            this.logger.info("Folder added as Server directory : " + name + " ,  folder : " + dir.getAbsolutePath());
            return true;
        }
        return false;
    }

    private void appendToIncludeDirList(StringBuffer serverDirs, String dir) {
        if (serverDirs.length() > 0) {
            serverDirs.append(":");
        }
        if (dir != null) {
            serverDirs.append(dir);
        }
    }

    private boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public int execute(BackupRunEnvironment backupRunEnv, BackupSession session) throws BackupException {
        this.backupRunEnvironment = backupRunEnv;
        this.logger.info("Calling cmu to backup sas config directory");
        ContentMigrationAdapter cmu = new ContentMigrationAdapter();
        this.logger.debug("Staring command to run the data backup");
        Command command = backupRunEnv.getCommand();
        try {
            Properties props = this.createProperties(command, session);
            if (!BackupServerUtil.isEmpty(props.get("cmu.source.dirs"))) {
                cmu.migrateContents(props);
                this.logger.info("SAS configuration directory backed up successfully");
            } else {
                this.logger.info("Can't find anything to backup.");
            }
        }
        catch (ContentMigrationException e) {
            this.logger.error((Object)e.getStackTrace());
            throw new BackupException("SAS configuration directory backed failed.", e, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_RUNNING_CMU.getErrorCode());
        }
        return BackupServer.ReturnCode.OK.getErrorCode();
    }

    private String searchForConfigDirs(String configBase, Map<String, String> extractedIncludeFilter) throws BackupException {
        String finalIncludeFilterValue = null;
        String[] includeFiltersForConfigDir = null;
        HashSet<File> includeDirsSet = new HashSet<File>();
        try {
            if (extractedIncludeFilter != null) {
                for (Map.Entry<String, String> entry : extractedIncludeFilter.entrySet()) {
                    List<File> contextDirs;
                    String configDirPath = this.getCanonicalPathSafely(configBase);
                    if (configDirPath == null || !configDirPath.equals(entry.getKey())) continue;
                    if (entry.getValue() != null) {
                        includeFiltersForConfigDir = entry.getValue().split(":");
                    }
                    if (includeFiltersForConfigDir != null) {
                        for (String includeFilter : includeFiltersForConfigDir) {
                            if (includeFilter == null) continue;
                            if (!includeFilter.contains("*")) {
                                File srcDirectory = new File(includeFilter);
                                if (!srcDirectory.isAbsolute()) {
                                    srcDirectory = new File(configBase, includeFilter);
                                }
                                if (srcDirectory.isDirectory()) {
                                    this.updateIncludeDirSet(configBase, includeDirsSet, srcDirectory);
                                    continue;
                                }
                                finalIncludeFilterValue = finalIncludeFilterValue != null ? finalIncludeFilterValue + ":" + includeFilter : includeFilter;
                                continue;
                            }
                            finalIncludeFilterValue = finalIncludeFilterValue != null ? finalIncludeFilterValue + ":" + includeFilter : includeFilter;
                        }
                    }
                    if ((contextDirs = this.getServerContexts(configBase)) != null) {
                        for (File context : contextDirs) {
                            File tempF = new File(context.getCanonicalPath() + File.separator + "Data");
                            if (!this.lookIntoSetForFile(includeDirsSet, tempF)) {
                                includeDirsSet.add(tempF);
                            }
                            if (this.lookIntoSetForFile(includeDirsSet, tempF = new File(context.getCanonicalPath() + File.separator + "SASEnvironment"))) continue;
                            includeDirsSet.add(tempF);
                        }
                    }
                    for (File path : includeDirsSet) {
                        String relPath = Directory.getChildPath((String)configBase, (String)path.getAbsolutePath());
                        finalIncludeFilterValue = this.addIncludeDir(finalIncludeFilterValue, relPath);
                    }
                    entry.setValue(finalIncludeFilterValue);
                    finalIncludeFilterValue = entry.getKey() + "|" + finalIncludeFilterValue;
                }
            }
        }
        catch (IOException ex) {
            throw new BackupException(ex, BackupServer.ReturnCode.COMMAND_LEVCONFIG_CONTEXT_SCAN_FAILED.getErrorCode());
        }
        return finalIncludeFilterValue;
    }

    private void updateIncludeDirSet(String configBase, Set<File> sourceDirsSet, File srcDirectory) {
        String path = null;
        try {
            path = srcDirectory.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (path != null) {
            sourceDirsSet.add(srcDirectory);
        }
    }

    public static boolean isChild(String parent, String child) {
        boolean isChild = false;
        if (parent != null && child != null) {
            File parentFile = new File(parent);
            File childFile = new File(child);
            try {
                parentFile = parentFile.getCanonicalFile();
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
            try {
                childFile = childFile.getCanonicalFile();
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
            for (File childParent = childFile.getParentFile(); childParent != null; childParent = childParent.getParentFile()) {
                if (!parentFile.equals(childParent)) continue;
                isChild = true;
                break;
            }
        }
        return isChild;
    }

    private String addIncludeDir(String originalList, String newSrcDir) {
        originalList = originalList == null ? "" : originalList + ":";
        originalList = originalList + newSrcDir + "/**";
        return originalList;
    }

    private boolean lookIntoSetForFile(Set<File> sourceDirsSet, File file) {
        for (File srcDir : sourceDirsSet) {
            try {
                String child;
                String parent = file.getCanonicalPath();
                if (!parent.equalsIgnoreCase(child = srcDir.getCanonicalPath()) && !LevconfigBackupHandler.isChild(parent, child)) continue;
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public List<File> getServerContexts(String configBase) {
        ArrayList<File> contexts = new ArrayList<File>();
        File confB = new File(configBase);
        File[] files = confB.listFiles();
        if (files != null) {
            for (int index = 0; index < files.length; ++index) {
                if (!files[index].isDirectory() || !this.isContextDirectory(files[index])) continue;
                contexts.add(files[index]);
            }
        }
        return contexts != null && contexts.size() > 0 ? contexts : null;
    }

    private boolean isPresent(File directory, String fileName) {
        boolean isFound = false;
        if (directory != null && fileName != null) {
            isFound = this.isPresent(directory.getAbsolutePath(), fileName);
        }
        return isFound;
    }

    private boolean isPresent(String directory, String fileName) {
        boolean isFound = false;
        if (directory != null && fileName != null) {
            File searchFile = new File(directory, fileName);
            isFound = searchFile.exists();
        }
        return isFound;
    }

    private boolean isContextDirectory(File directory) {
        boolean isPresent = true;
        for (int index = 0; index < SERVER_CONTEXT_SEARCH.length; ++index) {
            isPresent = isPresent && this.isPresent(directory, SERVER_CONTEXT_SEARCH[index]);
        }
        return isPresent;
    }

    private String filterMapToString(Map<String, String> filters) {
        String filterString = null;
        if (filters != null && !filters.isEmpty()) {
            for (Map.Entry<String, String> filterEntry : filters.entrySet()) {
                filterString = filterString != null && !filterString.isEmpty() ? filterString + "," : "";
                filterString = filterString + filterEntry.getKey() + "|" + filterEntry.getValue();
            }
        }
        return filterString;
    }

    private Map<String, String> getFilterMap(String extractedFilter) {
        String[] filters;
        HashMap<String, String> userFilters = new HashMap<String, String>();
        if (extractedFilter != null && (filters = extractedFilter.split(",")) != null) {
            for (String filter : filters) {
                String[] pathToFilter = filter.split("\\|");
                if (pathToFilter.length != 2) continue;
                userFilters.put(pathToFilter[0], pathToFilter[1]);
            }
        }
        return userFilters;
    }

    static {
        foundationServersInsideContext.add("BatchServer");
        foundationServersInsideContext.add("ConnectServer");
        foundationServersInsideContext.add("OLAPServer");
        foundationServersInsideContext.add("PooledWorkspaceServer");
        foundationServersInsideContext.add("StoredProcessServer");
        foundationServersInsideContext.add("WorkspaceServer");
        foundationServersOutsideContext.add("Data");
        foundationServersOutsideContext.add("ObjectSpawner");
        foundationServersOutsideContext.add("SchedulingServer");
        foundationServersOutsideContext.add("ShareServer");
        foundationServersOutsideContext.add("ConnectSpawner");
    }
}

