/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server.handler;

import com.sas.apps.content.migration.core.ContentMigrationAdapter;
import com.sas.apps.content.migration.core.ContentMigrationException;
import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupRunEnvironment;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.BackupSession;
import com.sas.svcs.backup.server.CommandHandler;
import com.sas.svcs.backup.server.CommandRequestContext;
import com.sas.svcs.backup.server.handler.PhysicalDataBackupPostProcessor;
import com.sas.svcs.backup.server.util.BackupServerUtil;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomDataBackupHandler
extends PhysicalDataBackupPostProcessor
implements CommandHandler<BackupRunEnvironment> {
    Logger logger = LogManager.getLogger(CustomDataBackupHandler.class);
    private String logDir = null;
    private BackupRunEnvironment backupRunEnv;

    private Properties createProperties(Command command, BackupSession session) {
        String extractedFilter;
        String excludefilter;
        String extractedFilter2;
        Properties props = new Properties();
        CommandRequestContext requestContext = session.getRequestContext();
        String configDir = command.getParameter("configdir");
        props.setProperty("cmu.base.dir", configDir);
        props.setProperty("cmu.sasroot", requestContext.getSASRoot());
        props.setProperty("cmu.sashome", requestContext.getSASHome());
        props.setProperty("cmu.migration.mode", "export");
        props.setProperty("cmu.package.dir", this.backupRunEnv.getTargetPath());
        String includefilter = command.getParameter("includefilter");
        if (includefilter != null && !includefilter.isEmpty() && (extractedFilter2 = BackupServerUtil.extractFilter(includefilter, configDir)) != null && !extractedFilter2.isEmpty()) {
            this.logger.debug("Passing include filter to cmu: " + extractedFilter2);
            props.setProperty("cmu.include.filter", extractedFilter2);
        }
        if ((excludefilter = command.getParameter("excludefilter")) != null && !excludefilter.isEmpty() && (extractedFilter = BackupServerUtil.extractFilter(excludefilter, configDir)) != null && !extractedFilter.isEmpty()) {
            this.logger.debug("Passing exclude filter to cmu: " + extractedFilter);
            props.setProperty("cmu.exclude.filter", extractedFilter);
        }
        props.setProperty("source.dir.permission.migration", "true");
        props.setProperty("source.dir.run.cporeport", "false");
        String sourceDirs = command.getParameter("sourcedirs");
        props.setProperty("cmu.source.dirs", sourceDirs);
        this.logger.info("List of directories to be backed up: " + sourceDirs);
        props.setProperty("config.xml.dir.path", "config");
        return props;
    }

    @Override
    public int execute(BackupRunEnvironment backupRunEnv, BackupSession session) throws BackupException {
        this.backupRunEnv = backupRunEnv;
        this.logger.info("Calling cmu to backup user specified directories");
        ContentMigrationAdapter cmu = new ContentMigrationAdapter();
        this.logger.debug("Staring command to run the data backup");
        Command command = backupRunEnv.getCommand();
        try {
            cmu.migrateContents(this.createProperties(command, session));
            this.logger.info("User specified directories backed up successfully");
        }
        catch (ContentMigrationException e) {
            this.logger.error((Object)e.getStackTrace());
            throw new BackupException("User specified directories backup failed.", e, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_RUNNING_CMU.getErrorCode());
        }
        return BackupServer.ReturnCode.OK.getErrorCode();
    }
}

