/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server.handler;

import com.sas.svcs.backup.server.util.AntProjectRunner;
import java.io.File;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tools.ant.Project;

public class ArchiveValidationManager {
    private File backupVault;
    private static ArchiveValidationManager manager;
    private Logger logger = LogManager.getLogger(ArchiveValidationManager.class);

    private ArchiveValidationManager(File backupVault) {
        this.logger.debug("Initilizing ArchivevalidationManager for : " + backupVault.getPath());
        this.backupVault = backupVault;
    }

    public static ArchiveValidationManager getInstance(File backupVault) {
        return new ArchiveValidationManager(backupVault);
    }

    public String checkSum() throws Exception {
        String checkSum = null;
        this.removeMD5Files(this.backupVault);
        String antFile = this.createANTProject();
        this.logger.debug("Checksum calculation project");
        this.logger.debug(antFile);
        Properties p = new Properties();
        p.setProperty("backup.root", this.backupVault.getAbsolutePath());
        Project project = new AntProjectRunner(antFile).properties(p).run();
        checkSum = project.getProperty("backup.checksum");
        return checkSum;
    }

    public boolean validate(String checkSum) throws Exception {
        boolean validBackup = false;
        if (checkSum != null) {
            this.removeMD5Files(this.backupVault);
            String calculatedCheckSum = this.checkSum();
            validBackup = calculatedCheckSum.equals(checkSum);
            this.removeMD5Files(this.backupVault);
        }
        return validBackup;
    }

    private void removeMD5Files(File backupRoot) {
        File[] children;
        for (File child : children = backupRoot.listFiles()) {
            if (child.isDirectory()) {
                this.removeMD5Files(child);
                continue;
            }
            if (!child.getName().endsWith(".MD5") || child.delete()) continue;
            this.logger.debug("Unable to delete file " + child.getPath());
        }
    }

    private String createANTProject() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\"?>");
        sb.append("<project name=\"tarme\" default=\"calculate\">");
        sb.append("<taskdef resource=\"net/sf/antcontrib/antlib.xml\"/>");
        sb.append("<target name=\"calculate\">");
        sb.append("<checksum totalproperty=\"backup.checksum\">");
        sb.append("<fileset dir=\"${backup.root}\" excludes=\"metadataserver/**,*.checksum,*.renamed\"/>");
        sb.append("</checksum>");
        sb.append("<echo message=\"${backup.checksum}\"/>");
        sb.append("</target>");
        sb.append("</project>");
        return sb.toString();
    }
}

