/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server;

import com.sas.metadata.logical.batch.BatchDriver2;
import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.client.CommandContext;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.BackupSession;
import com.sas.svcs.backup.server.CommandRequestContext;
import com.sas.svcs.backup.server.DefaultBackupServer;
import com.sas.svcs.backup.server.RB;
import com.sas.text.Message;
import java.io.File;
import org.apache.commons.cli.HelpFormatter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackupDriver
extends BatchDriver2 {
    private static final Logger _logger = LogManager.getLogger(BackupDriver.class);
    public static final String OPTION_BACKUP = "backup";
    public static final String OPTION_RECOVER = "recover";
    public static final String OPTION_LIST = "list";
    public static final String OPTION_STATUS = "status";
    public static final String OPTION_COMMENT = "comment";
    public static final String OPTION_PURGE = "purge";
    public static final String OPTION_HELP = "?";
    public static final String OPTION_HELP_LONG = "help";
    public static final String OPTION_ADDITIONAL_PROPS = "Z";
    public static final String OPTION_CONTEXT_MAP = "C";
    public static final String OPTION_ID = "id";
    public static final String DATA = "Data";
    public static final String SASENVIRONMENT = "SASEnvironment";
    public static final String PIPE = "|";

    public BackupDriver() {
        this._logFilePrefix = "BackupServer";
        this._logContextName = "com.sas.svcs.backup.server";
        this._logTimestamps = true;
        this._logFileDisabled = false;
    }

    public BackupDriver(String host, String port, String user, String password) {
        this();
        this.setConnection(host, port);
        this.setCredential(user, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int result;
        boolean isBootStrapping;
        BackupDriver backupServer;
        Command command;
        block22: {
            _logger.info(RB.getStringResource("BackupDriver.backup.dirver.started.txt"));
            command = null;
            backupServer = new BackupDriver();
            DefaultBackupServer server = null;
            isBootStrapping = false;
            result = -1;
            try {
                server = new DefaultBackupServer();
                _logger.info(RB.getStringResource("BackupDriver.backupserver.initialized.txt"));
                command = server.getCommandContext().parseCommand(args);
                if (command != null) {
                    CommandRequestContext requestContext = CommandRequestContext.getRequestContext(command);
                    CommandContext ctxt = server.getCommandContext();
                    isBootStrapping = server.isBootStrapping(requestContext);
                    if (isBootStrapping) {
                        result = server.bootStrap(requestContext);
                    } else if (!server.alreadyRunning(command)) {
                        BackupSession session = server.getSession(requestContext);
                        result = session.execute(command);
                    } else {
                        _logger.info(RB.getStringResource("BackupDriver.already.running.txt"));
                    }
                    break block22;
                }
                throw new BackupException("Command value is NULL.", BackupServer.ReturnCode.ERROR_INVALID_COMMAND.getErrorCode());
            }
            catch (BackupException exception) {
                result = exception.getErrorCode();
                _logger.error(Message.format((String)RB.getStringResource("BackupDriver.exception.exiting.command.fmt"), (Object)exception.getMessage()), (Throwable)exception);
                _logger.error((Object)exception.getStackTrace());
            }
            catch (Exception excpetion) {
                _logger.error(Message.format((String)RB.getStringResource("BackupDriver.exception.exiting.command.fmt"), (Object)excpetion.getMessage()), (Throwable)excpetion);
                _logger.error(excpetion.getMessage());
                _logger.error((Object)excpetion.getStackTrace());
                result = BackupServer.ReturnCode.UNKNOWN.getErrorCode();
            }
            finally {
                try {
                    File f = new File(".", "temp.log");
                    if (f.exists()) {
                        f.delete();
                    }
                }
                catch (Exception f) {}
            }
        }
        if (result != 0 && !isBootStrapping) {
            backupServer.logErrorDetails(result, command);
        }
        _logger.info("Exiting with status code: " + result);
        System.exit(result);
    }

    private void logErrorDetails(int result, Command command) {
        if (command != null) {
            // empty if block
        }
    }

    private static String getUsage(HelpFormatter help) {
        StringBuffer usage = new StringBuffer();
        usage.append("Backup utility [options...]");
        return usage.toString();
    }
}

