/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.client;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackupDetailsDAO {
    private static Logger logger = LogManager.getLogger(BackupDetailsDAO.class);
    private File backupDetailsData;
    private static String DATA_FILE_NAME = "backupsourceDetails.checksum";
    private static BackupDetailsDAO dao;

    private BackupDetailsDAO(File dataPath) {
        if (dataPath != null) {
            this.backupDetailsData = new File(dataPath, DATA_FILE_NAME);
        }
    }

    public static BackupDetailsDAO getInstance(File dataStorePath) {
        if (dao == null) {
            dao = new BackupDetailsDAO(dataStorePath);
        }
        return dao;
    }

    public void save(String allcheckSum) throws IOException {
        StringReader reader = new StringReader(allcheckSum);
        FileWriter writer = new FileWriter(this.backupDetailsData);
        IOUtils.copy((Reader)reader, (Writer)writer);
        IOUtils.closeQuietly((Writer)writer);
        IOUtils.closeQuietly((Reader)reader);
    }

    public String loadChecksum() {
        StringWriter writer = new StringWriter();
        try {
            FileReader reader = new FileReader(this.backupDetailsData);
            IOUtils.copy((Reader)reader, (Writer)writer);
            IOUtils.closeQuietly((Writer)writer);
            IOUtils.closeQuietly((Reader)reader);
        }
        catch (FileNotFoundException exception) {
            exception.printStackTrace();
            logger.error("Unable to load checksm file " + exception.getMessage());
        }
        catch (IOException exception) {
            logger.error("Unable to load checksm file " + exception.getMessage());
        }
        catch (Exception e) {
            logger.error("Unable to load checksm file " + e.getMessage());
        }
        return writer.toString();
    }
}

