/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rpf.expr.parser;

import antlr.NoViableAltException;
import antlr.RecognitionException;
import antlr.TreeParser;
import antlr.collections.AST;
import com.sas.rpf.data.CharacterValue;
import com.sas.rpf.data.DataVectorInterface;
import com.sas.rpf.data.IncompatibleTypeException;
import com.sas.rpf.data.Level;
import com.sas.rpf.data.MissingValue;
import com.sas.rpf.data.NumericValue;
import com.sas.rpf.data.ValueInterface;
import com.sas.rpf.data.Variable;
import com.sas.rpf.data.VariableNotFoundException;
import com.sas.rpf.expr.parser.ExpressionEvaluatorTokenTypes;
import java.util.LinkedHashSet;
import java.util.Set;

public class ExpressionEvaluator
extends TreeParser
implements ExpressionEvaluatorTokenTypes {
    DataVectorInterface _data = null;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "EQ", "LT", "LE", "GT", "GE", "NE", "LPAREN", "RPAREN", "OR", "AND", "NOT", "NUMBER", "MISSING", "FORMAT", "VARIABLE", "LEVEL_NAME", "DOT", "STRING", "WS", "DASH", "SIMPLE_NUMBER", "EXPONENT", "ESC", "HEX_DIGIT", "SPACE", "LBRACKET", "RBRACKET", "DIGIT", "DOLLAR", "LETTER", "QUOTE"};

    public void setData(DataVectorInterface data) {
        this._data = data;
    }

    private ValueInterface resolveVariable(AST variableNode) throws VariableNotFoundException {
        String name = variableNode.getText();
        return this._data.getValue(name);
    }

    private ValueInterface resolveFormattedVariable(AST formattedVariableNode) throws VariableNotFoundException {
        AST variableNode = formattedVariableNode.getFirstChild();
        String name = variableNode.getText();
        return this._data.getFormattedValue(name);
    }

    private boolean checkFormattedVariableLevel(AST formattedVariableNode) {
        assert (this._data != null) : "Expression evaluator not initialized.";
        AST variableNode = formattedVariableNode.getFirstChild();
        return this.checkVariableLevel(variableNode);
    }

    private boolean checkVariableLevel(AST variableNode) {
        assert (this._data != null) : "Expression evaluator not initialized.";
        boolean result = true;
        int numberOfChildren = variableNode.getNumberOfChildren();
        if (numberOfChildren > 0) {
            AST currentChild = variableNode.getFirstChild();
            do {
                String level;
                String hierarchy;
                String dimension;
                if (this._data.isDrilledToLevel(new Level(dimension = currentChild.getFirstChild().getText(), hierarchy = currentChild.getFirstChild().getNextSibling().getText(), level = currentChild.getFirstChild().getNextSibling().getNextSibling().getText()))) continue;
                result = false;
                break;
            } while ((currentChild = currentChild.getNextSibling()) != null);
        }
        return result;
    }

    private Set extractVariable(AST variableNode, Set result) {
        Variable variable = new Variable(variableNode.getText());
        result.add(variable);
        return result;
    }

    private Set extractFormattedVariable(AST formatNode, Set result) {
        AST variableNode = formatNode.getFirstChild();
        Variable variable = new Variable(variableNode.getText(), true);
        result.add(variable);
        return result;
    }

    public ExpressionEvaluator() {
        this.tokenNames = _tokenNames;
    }

    public final boolean evaluate(AST _t) throws RecognitionException, VariableNotFoundException, IncompatibleTypeException {
        boolean result;
        block15: {
            result = false;
            AST evaluate_AST_in = _t == ASTNULL ? null : _t;
            AST nodeEQ = null;
            AST nodeLT = null;
            AST nodeLE = null;
            AST nodeGT = null;
            AST nodeGE = null;
            AST nodeNE = null;
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 14: {
                        AST __t2 = _t;
                        AST tmp1_AST_in = _t;
                        this.match(_t, 14);
                        _t = _t.getFirstChild();
                        boolean a = this.evaluate(_t);
                        _t = this._retTree;
                        _t = __t2;
                        _t = _t.getNextSibling();
                        result = !a;
                        break;
                    }
                    case 13: {
                        AST __t3 = _t;
                        AST tmp2_AST_in = _t;
                        this.match(_t, 13);
                        _t = _t.getFirstChild();
                        boolean a = this.evaluate(_t);
                        _t = this._retTree;
                        boolean b = this.evaluate(_t);
                        _t = this._retTree;
                        _t = __t3;
                        _t = _t.getNextSibling();
                        result = a && b;
                        break;
                    }
                    case 12: {
                        AST __t4 = _t;
                        AST tmp3_AST_in = _t;
                        this.match(_t, 12);
                        _t = _t.getFirstChild();
                        boolean a = this.evaluate(_t);
                        _t = this._retTree;
                        boolean b = this.evaluate(_t);
                        _t = this._retTree;
                        _t = __t4;
                        _t = _t.getNextSibling();
                        result = a || b;
                        break;
                    }
                    case 4: {
                        nodeEQ = _t;
                        this.match(_t, 4);
                        _t = _t.getNextSibling();
                        result = this.isCorrectLevelNumeric(nodeEQ) && this.evaluateNumeric(nodeEQ);
                        break;
                    }
                    case 5: {
                        nodeLT = _t;
                        this.match(_t, 5);
                        _t = _t.getNextSibling();
                        result = this.isCorrectLevelNumeric(nodeLT) && this.evaluateNumeric(nodeLT);
                        break;
                    }
                    case 6: {
                        nodeLE = _t;
                        this.match(_t, 6);
                        _t = _t.getNextSibling();
                        result = this.isCorrectLevelNumeric(nodeLE) && this.evaluateNumeric(nodeLE);
                        break;
                    }
                    case 7: {
                        nodeGT = _t;
                        this.match(_t, 7);
                        _t = _t.getNextSibling();
                        result = this.isCorrectLevelNumeric(nodeGT) && this.evaluateNumeric(nodeGT);
                        break;
                    }
                    case 8: {
                        nodeGE = _t;
                        this.match(_t, 8);
                        _t = _t.getNextSibling();
                        result = this.isCorrectLevelNumeric(nodeGE) && this.evaluateNumeric(nodeGE);
                        break;
                    }
                    case 9: {
                        nodeNE = _t;
                        this.match(_t, 9);
                        _t = _t.getNextSibling();
                        result = this.isCorrectLevelNumeric(nodeNE) && this.evaluateNumeric(nodeNE);
                        break;
                    }
                    case 10: {
                        AST __t5 = _t;
                        AST tmp4_AST_in = _t;
                        this.match(_t, 10);
                        _t = _t.getFirstChild();
                        boolean b = this.evaluate(_t);
                        _t = this._retTree;
                        _t = __t5;
                        _t = _t.getNextSibling();
                        result = b;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block15;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final boolean evaluateNumeric(AST _t) throws RecognitionException, VariableNotFoundException, IncompatibleTypeException {
        boolean result;
        block11: {
            result = false;
            AST evaluateNumeric_AST_in = _t == ASTNULL ? null : _t;
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 4: {
                        AST __t7 = _t;
                        AST tmp5_AST_in = _t;
                        this.match(_t, 4);
                        _t = _t.getFirstChild();
                        ValueInterface x = this.value(_t);
                        _t = this._retTree;
                        ValueInterface y = this.value(_t);
                        _t = this._retTree;
                        _t = __t7;
                        _t = _t.getNextSibling();
                        result = x.eq(y);
                        break;
                    }
                    case 5: {
                        AST __t8 = _t;
                        AST tmp6_AST_in = _t;
                        this.match(_t, 5);
                        _t = _t.getFirstChild();
                        ValueInterface x = this.value(_t);
                        _t = this._retTree;
                        ValueInterface y = this.value(_t);
                        _t = this._retTree;
                        _t = __t8;
                        _t = _t.getNextSibling();
                        result = x.lt(y);
                        break;
                    }
                    case 6: {
                        AST __t9 = _t;
                        AST tmp7_AST_in = _t;
                        this.match(_t, 6);
                        _t = _t.getFirstChild();
                        ValueInterface x = this.value(_t);
                        _t = this._retTree;
                        ValueInterface y = this.value(_t);
                        _t = this._retTree;
                        _t = __t9;
                        _t = _t.getNextSibling();
                        result = x.le(y);
                        break;
                    }
                    case 7: {
                        AST __t10 = _t;
                        AST tmp8_AST_in = _t;
                        this.match(_t, 7);
                        _t = _t.getFirstChild();
                        ValueInterface x = this.value(_t);
                        _t = this._retTree;
                        ValueInterface y = this.value(_t);
                        _t = this._retTree;
                        _t = __t10;
                        _t = _t.getNextSibling();
                        result = x.gt(y);
                        break;
                    }
                    case 8: {
                        AST __t11 = _t;
                        AST tmp9_AST_in = _t;
                        this.match(_t, 8);
                        _t = _t.getFirstChild();
                        ValueInterface x = this.value(_t);
                        _t = this._retTree;
                        ValueInterface y = this.value(_t);
                        _t = this._retTree;
                        _t = __t11;
                        _t = _t.getNextSibling();
                        result = x.ge(y);
                        break;
                    }
                    case 9: {
                        AST __t12 = _t;
                        AST tmp10_AST_in = _t;
                        this.match(_t, 9);
                        _t = _t.getFirstChild();
                        ValueInterface x = this.value(_t);
                        _t = this._retTree;
                        ValueInterface y = this.value(_t);
                        _t = this._retTree;
                        _t = __t12;
                        _t = _t.getNextSibling();
                        result = x.ne(y);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block11;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final ValueInterface value(AST _t) throws RecognitionException, VariableNotFoundException {
        ValueInterface result;
        block10: {
            result = null;
            AST value_AST_in = _t == ASTNULL ? null : _t;
            AST n = null;
            AST s = null;
            AST m = null;
            AST v = null;
            AST f = null;
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 15: {
                        n = _t;
                        this.match(_t, 15);
                        _t = _t.getNextSibling();
                        result = new NumericValue(Double.parseDouble(n.getText()));
                        break;
                    }
                    case 21: {
                        s = _t;
                        this.match(_t, 21);
                        _t = _t.getNextSibling();
                        result = new CharacterValue(s.getText());
                        break;
                    }
                    case 16: {
                        m = _t;
                        this.match(_t, 16);
                        _t = _t.getNextSibling();
                        result = new MissingValue();
                        break;
                    }
                    case 18: {
                        v = _t;
                        this.match(_t, 18);
                        _t = _t.getNextSibling();
                        result = this.resolveVariable(v);
                        break;
                    }
                    case 17: {
                        f = _t;
                        this.match(_t, 17);
                        _t = _t.getNextSibling();
                        result = this.resolveFormattedVariable(f);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block10;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final boolean isCorrectLevelNumeric(AST _t) throws RecognitionException {
        boolean result;
        block11: {
            result = true;
            AST isCorrectLevelNumeric_AST_in = _t == ASTNULL ? null : _t;
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 4: {
                        AST __t15 = _t;
                        AST tmp11_AST_in = _t;
                        this.match(_t, 4);
                        _t = _t.getFirstChild();
                        boolean x = this.isCorrectLevelVariable(_t);
                        _t = this._retTree;
                        boolean y = this.isCorrectLevelVariable(_t);
                        _t = this._retTree;
                        _t = __t15;
                        _t = _t.getNextSibling();
                        result &= x && y;
                        break;
                    }
                    case 5: {
                        AST __t16 = _t;
                        AST tmp12_AST_in = _t;
                        this.match(_t, 5);
                        _t = _t.getFirstChild();
                        boolean x = this.isCorrectLevelVariable(_t);
                        _t = this._retTree;
                        boolean y = this.isCorrectLevelVariable(_t);
                        _t = this._retTree;
                        _t = __t16;
                        _t = _t.getNextSibling();
                        result &= x && y;
                        break;
                    }
                    case 6: {
                        AST __t17 = _t;
                        AST tmp13_AST_in = _t;
                        this.match(_t, 6);
                        _t = _t.getFirstChild();
                        boolean x = this.isCorrectLevelVariable(_t);
                        _t = this._retTree;
                        boolean y = this.isCorrectLevelVariable(_t);
                        _t = this._retTree;
                        _t = __t17;
                        _t = _t.getNextSibling();
                        result &= x && y;
                        break;
                    }
                    case 7: {
                        AST __t18 = _t;
                        AST tmp14_AST_in = _t;
                        this.match(_t, 7);
                        _t = _t.getFirstChild();
                        boolean x = this.isCorrectLevelVariable(_t);
                        _t = this._retTree;
                        boolean y = this.isCorrectLevelVariable(_t);
                        _t = this._retTree;
                        _t = __t18;
                        _t = _t.getNextSibling();
                        result &= x && y;
                        break;
                    }
                    case 8: {
                        AST __t19 = _t;
                        AST tmp15_AST_in = _t;
                        this.match(_t, 8);
                        _t = _t.getFirstChild();
                        boolean x = this.isCorrectLevelVariable(_t);
                        _t = this._retTree;
                        boolean y = this.isCorrectLevelVariable(_t);
                        _t = this._retTree;
                        _t = __t19;
                        _t = _t.getNextSibling();
                        result &= x && y;
                        break;
                    }
                    case 9: {
                        AST __t20 = _t;
                        AST tmp16_AST_in = _t;
                        this.match(_t, 9);
                        _t = _t.getFirstChild();
                        boolean x = this.isCorrectLevelVariable(_t);
                        _t = this._retTree;
                        boolean y = this.isCorrectLevelVariable(_t);
                        _t = this._retTree;
                        _t = __t20;
                        _t = _t.getNextSibling();
                        result &= x && y;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block11;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final boolean isCorrectLevelVariable(AST _t) throws RecognitionException {
        boolean result;
        block10: {
            result = true;
            AST isCorrectLevelVariable_AST_in = _t == ASTNULL ? null : _t;
            AST n = null;
            AST s = null;
            AST m = null;
            AST v = null;
            AST f = null;
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 15: {
                        n = _t;
                        this.match(_t, 15);
                        _t = _t.getNextSibling();
                        result = true;
                        break;
                    }
                    case 21: {
                        s = _t;
                        this.match(_t, 21);
                        _t = _t.getNextSibling();
                        result = true;
                        break;
                    }
                    case 16: {
                        m = _t;
                        this.match(_t, 16);
                        _t = _t.getNextSibling();
                        result = true;
                        break;
                    }
                    case 18: {
                        v = _t;
                        this.match(_t, 18);
                        _t = _t.getNextSibling();
                        result = this.checkVariableLevel(v);
                        break;
                    }
                    case 17: {
                        f = _t;
                        this.match(_t, 17);
                        _t = _t.getNextSibling();
                        result = this.checkFormattedVariableLevel(f);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block10;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final Set extractVariables(AST _t) throws RecognitionException {
        LinkedHashSet result;
        block15: {
            result = new LinkedHashSet();
            AST extractVariables_AST_in = _t == ASTNULL ? null : _t;
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 14: {
                        AST __t22 = _t;
                        AST tmp17_AST_in = _t;
                        this.match(_t, 14);
                        _t = _t.getFirstChild();
                        Set a = this.extractVariables(_t);
                        _t = this._retTree;
                        _t = __t22;
                        _t = _t.getNextSibling();
                        result.addAll(a);
                        break;
                    }
                    case 13: {
                        AST __t23 = _t;
                        AST tmp18_AST_in = _t;
                        this.match(_t, 13);
                        _t = _t.getFirstChild();
                        Set a = this.extractVariables(_t);
                        _t = this._retTree;
                        Set b = this.extractVariables(_t);
                        _t = this._retTree;
                        _t = __t23;
                        _t = _t.getNextSibling();
                        result.addAll(a);
                        result.addAll(b);
                        break;
                    }
                    case 12: {
                        AST __t24 = _t;
                        AST tmp19_AST_in = _t;
                        this.match(_t, 12);
                        _t = _t.getFirstChild();
                        Set a = this.extractVariables(_t);
                        _t = this._retTree;
                        Set b = this.extractVariables(_t);
                        _t = this._retTree;
                        _t = __t24;
                        _t = _t.getNextSibling();
                        result.addAll(a);
                        result.addAll(b);
                        break;
                    }
                    case 4: {
                        AST __t25 = _t;
                        AST tmp20_AST_in = _t;
                        this.match(_t, 4);
                        _t = _t.getFirstChild();
                        Set x = this.extractVariable(_t);
                        _t = this._retTree;
                        Set y = this.extractVariable(_t);
                        _t = this._retTree;
                        _t = __t25;
                        _t = _t.getNextSibling();
                        result.addAll(x);
                        result.addAll(y);
                        break;
                    }
                    case 5: {
                        AST __t26 = _t;
                        AST tmp21_AST_in = _t;
                        this.match(_t, 5);
                        _t = _t.getFirstChild();
                        Set x = this.extractVariable(_t);
                        _t = this._retTree;
                        Set y = this.extractVariable(_t);
                        _t = this._retTree;
                        _t = __t26;
                        _t = _t.getNextSibling();
                        result.addAll(x);
                        result.addAll(y);
                        break;
                    }
                    case 6: {
                        AST __t27 = _t;
                        AST tmp22_AST_in = _t;
                        this.match(_t, 6);
                        _t = _t.getFirstChild();
                        Set x = this.extractVariable(_t);
                        _t = this._retTree;
                        Set y = this.extractVariable(_t);
                        _t = this._retTree;
                        _t = __t27;
                        _t = _t.getNextSibling();
                        result.addAll(x);
                        result.addAll(y);
                        break;
                    }
                    case 7: {
                        AST __t28 = _t;
                        AST tmp23_AST_in = _t;
                        this.match(_t, 7);
                        _t = _t.getFirstChild();
                        Set x = this.extractVariable(_t);
                        _t = this._retTree;
                        Set y = this.extractVariable(_t);
                        _t = this._retTree;
                        _t = __t28;
                        _t = _t.getNextSibling();
                        result.addAll(x);
                        result.addAll(y);
                        break;
                    }
                    case 8: {
                        AST __t29 = _t;
                        AST tmp24_AST_in = _t;
                        this.match(_t, 8);
                        _t = _t.getFirstChild();
                        Set x = this.extractVariable(_t);
                        _t = this._retTree;
                        Set y = this.extractVariable(_t);
                        _t = this._retTree;
                        _t = __t29;
                        _t = _t.getNextSibling();
                        result.addAll(x);
                        result.addAll(y);
                        break;
                    }
                    case 9: {
                        AST __t30 = _t;
                        AST tmp25_AST_in = _t;
                        this.match(_t, 9);
                        _t = _t.getFirstChild();
                        Set x = this.extractVariable(_t);
                        _t = this._retTree;
                        Set y = this.extractVariable(_t);
                        _t = this._retTree;
                        _t = __t30;
                        _t = _t.getNextSibling();
                        result.addAll(x);
                        result.addAll(y);
                        break;
                    }
                    case 10: {
                        AST __t31 = _t;
                        AST tmp26_AST_in = _t;
                        this.match(_t, 10);
                        _t = _t.getFirstChild();
                        Set b = this.extractVariables(_t);
                        _t = this._retTree;
                        _t = __t31;
                        _t = _t.getNextSibling();
                        result.addAll(b);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block15;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final Set extractVariable(AST _t) throws RecognitionException {
        Set result;
        block10: {
            result = new LinkedHashSet();
            AST extractVariable_AST_in = _t == ASTNULL ? null : _t;
            AST n = null;
            AST s = null;
            AST m = null;
            AST v = null;
            AST f = null;
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 15: {
                        n = _t;
                        this.match(_t, 15);
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 21: {
                        s = _t;
                        this.match(_t, 21);
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 16: {
                        m = _t;
                        this.match(_t, 16);
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 18: {
                        v = _t;
                        this.match(_t, 18);
                        _t = _t.getNextSibling();
                        result = this.extractVariable(v, result);
                        break;
                    }
                    case 17: {
                        f = _t;
                        this.match(_t, 17);
                        _t = _t.getNextSibling();
                        result = this.extractFormattedVariable(f, result);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block10;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return result;
    }
}

