/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rpf.expr;

import antlr.CommonAST;
import antlr.RecognitionException;
import antlr.collections.AST;
import com.sas.rpf.data.DataVectorInterface;
import com.sas.rpf.data.IncompatibleTypeException;
import com.sas.rpf.data.VariableNotFoundException;
import com.sas.rpf.exception.ParseException;
import com.sas.rpf.expr.EvaluateException;
import com.sas.rpf.expr.ExpressionElement;
import com.sas.rpf.expr.ExpressionElementInterface;
import com.sas.rpf.expr.ExpressionInterface;
import com.sas.rpf.expr.ExpressionTokens;
import com.sas.rpf.expr.Primitive;
import com.sas.rpf.expr.RB;
import com.sas.rpf.expr.SerializationException;
import com.sas.rpf.expr.parser.ExpressionEvaluator;
import com.sas.rpf.expr.parser.ExpressionLexer;
import com.sas.rpf.expr.parser.ExpressionParser;
import com.sas.rpf.expr.parser.ExpressionSerializer;
import com.sas.text.Message;
import java.io.StringReader;
import java.util.Set;

public class Expression
extends ExpressionElement
implements ExpressionInterface {
    private ExpressionEvaluator _evaluator = new ExpressionEvaluator();
    private ExpressionSerializer _serializer = new ExpressionSerializer();

    private Expression(AST ast) {
        super(ast);
    }

    Expression(Primitive left, Primitive right, int type) {
        this((AST)new CommonAST());
        this.getAST().setType(type);
        this.getAST().setText(ExpressionTokens.getTokenString(type));
        this.getAST().addChild(left.getAST());
        this.getAST().addChild(right.getAST());
    }

    Expression(Expression left, Expression right, int type) {
        this(left, right, ExpressionTokens.getTokenString(type), type);
    }

    Expression(Expression left, Expression right, String text, int type) {
        this((AST)new CommonAST());
        this.getAST().setType(type);
        this.getAST().setText(text);
        this.getAST().addChild(left.getAST());
        this.getAST().addChild(right.getAST());
    }

    Expression(Expression expression, int type) {
        this((AST)new CommonAST());
        this.getAST().setType(type);
        this.getAST().setText(ExpressionTokens.getTokenString(type));
        this.getAST().addChild(expression.getAST());
    }

    public static ExpressionInterface compile(String expressionString) throws ParseException {
        ExpressionLexer lexer = new ExpressionLexer(new StringReader(expressionString));
        ExpressionParser parser = new ExpressionParser(lexer);
        parser.setASTNodeClass("antlr.CommonAST");
        parser.parse();
        return new Expression(parser.getAST());
    }

    @Override
    public boolean evaluate(DataVectorInterface dataVector) throws VariableNotFoundException, IncompatibleTypeException, EvaluateException {
        this._evaluator.setData(dataVector);
        boolean result = false;
        try {
            result = this._evaluator.evaluate(this.getAST());
        }
        catch (RecognitionException e) {
            throw new EvaluateException(e, RB.getStringResource("Expression.evaluate.Recognition.txt"));
        }
        return result;
    }

    @Override
    public String getExpressionString() throws SerializationException {
        ExpressionSerializer serializer = new ExpressionSerializer();
        AST ast = this.getAST();
        String result = "";
        try {
            result = serializer.serializeExpression(ast);
        }
        catch (RecognitionException e) {
            throw new SerializationException(e, RB.getStringResource("Expression.getExpressionString.Recognition.txt"));
        }
        return result;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    private static ExpressionElementInterface createExpression(AST ast) {
        ExpressionElement result = null;
        int type = ast.getType();
        result = Expression.isPrimitive(type) ? new Primitive(ast) : new Expression(ast);
        return result;
    }

    @Override
    public ExpressionElementInterface getLeftExpression() {
        return Expression.createExpression(this.getLeftAST());
    }

    private AST getLeftAST() {
        return this.getAST().getFirstChild();
    }

    @Override
    public ExpressionElementInterface getRightExpression() {
        return Expression.createExpression(this.getRightAST());
    }

    private AST getRightAST() {
        return this.getAST().getFirstChild().getNextSibling();
    }

    @Override
    public String getOperator() {
        return ExpressionTokens.getTokenString(this.getAST().getType());
    }

    @Override
    public boolean hasRightExpression() {
        return this.getRightAST() != null;
    }

    public String toString() {
        String result;
        try {
            result = this._serializer.serializeExpression(this.getAST());
        }
        catch (RecognitionException e) {
            result = Message.format((String)RB.getStringResource("Expression.toString.Recognition.fmt.txt"), (Object)((Object)e));
        }
        return result;
    }

    @Override
    public int getType() {
        return this.getAST().getType();
    }

    @Override
    public Set extractVariables() throws EvaluateException {
        Set variables = null;
        try {
            variables = this._evaluator.extractVariables(this.getAST());
        }
        catch (RecognitionException e) {
            throw new EvaluateException(e, RB.getStringResource("Expression.extractVariable.Recognition.txt"));
        }
        return variables;
    }
}

