/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rpf.expr;

import com.sas.rpf.expr.Expression;
import com.sas.rpf.expr.ExpressionBuilderInterface;
import com.sas.rpf.expr.ExpressionInterface;
import com.sas.rpf.expr.IncompatibleExpressionElementsException;
import com.sas.rpf.expr.Primitive;
import com.sas.rpf.expr.PrimitiveInterface;
import com.sas.rpf.expr.RB;
import java.util.Collections;
import java.util.List;

public class ASTExpressionBuilder
implements ExpressionBuilderInterface {
    @Override
    public ExpressionInterface and(ExpressionInterface leftExpression, ExpressionInterface rightExpression) {
        if (!(leftExpression instanceof Expression) || !(rightExpression instanceof Expression)) {
            throw new IncompatibleExpressionElementsException(RB.getStringResource("ASTExpressionBuilder.WrongType.txt"));
        }
        return new Expression((Expression)leftExpression, (Expression)rightExpression, 13);
    }

    @Override
    public ExpressionInterface or(ExpressionInterface leftExpression, ExpressionInterface rightExpression) {
        if (!(leftExpression instanceof Expression) || !(rightExpression instanceof Expression)) {
            throw new IncompatibleExpressionElementsException(RB.getStringResource("ASTExpressionBuilder.WrongType.txt"));
        }
        return new Expression((Expression)leftExpression, (Expression)rightExpression, 12);
    }

    @Override
    public ExpressionInterface not(ExpressionInterface expression) {
        if (!(expression instanceof Expression)) {
            throw new IncompatibleExpressionElementsException(RB.getStringResource("ASTExpressionBuilder.WrongType.txt"));
        }
        return new Expression((Expression)expression, 14);
    }

    @Override
    public ExpressionInterface eq(PrimitiveInterface leftPrimitive, PrimitiveInterface rightPrimitive) {
        if (!(leftPrimitive instanceof Primitive) || !(rightPrimitive instanceof Primitive)) {
            throw new IncompatibleExpressionElementsException(RB.getStringResource("ASTExpressionBuilder.WrongType.txt"));
        }
        return new Expression((Primitive)leftPrimitive, (Primitive)rightPrimitive, 4);
    }

    @Override
    public ExpressionInterface lt(PrimitiveInterface leftExpression, PrimitiveInterface rightExpression) {
        return new Expression((Primitive)leftExpression, (Primitive)rightExpression, 5);
    }

    @Override
    public ExpressionInterface le(PrimitiveInterface leftPrimitive, PrimitiveInterface rightPrimitive) {
        if (!(leftPrimitive instanceof Primitive) || !(rightPrimitive instanceof Primitive)) {
            throw new IncompatibleExpressionElementsException(RB.getStringResource("ASTExpressionBuilder.WrongType.txt"));
        }
        return new Expression((Primitive)leftPrimitive, (Primitive)rightPrimitive, 6);
    }

    @Override
    public ExpressionInterface gt(PrimitiveInterface leftPrimitive, PrimitiveInterface rightPrimitive) {
        if (!(leftPrimitive instanceof Primitive) || !(rightPrimitive instanceof Primitive)) {
            throw new IncompatibleExpressionElementsException(RB.getStringResource("ASTExpressionBuilder.WrongType.txt"));
        }
        return new Expression((Primitive)leftPrimitive, (Primitive)rightPrimitive, 7);
    }

    @Override
    public ExpressionInterface ge(PrimitiveInterface leftPrimitive, PrimitiveInterface rightPrimitive) {
        if (!(leftPrimitive instanceof Primitive) || !(rightPrimitive instanceof Primitive)) {
            throw new IncompatibleExpressionElementsException(RB.getStringResource("ASTExpressionBuilder.WrongType.txt"));
        }
        return new Expression((Primitive)leftPrimitive, (Primitive)rightPrimitive, 8);
    }

    @Override
    public ExpressionInterface ne(PrimitiveInterface leftPrimitive, PrimitiveInterface rightPrimitive) {
        if (!(leftPrimitive instanceof Primitive) || !(rightPrimitive instanceof Primitive)) {
            throw new IncompatibleExpressionElementsException(RB.getStringResource("ASTExpressionBuilder.WrongType.txt"));
        }
        return new Expression((Primitive)leftPrimitive, (Primitive)rightPrimitive, 9);
    }

    @Override
    public ExpressionInterface paren(ExpressionInterface expression) {
        if (!(expression instanceof Expression)) {
            throw new IncompatibleExpressionElementsException(RB.getStringResource("ASTExpressionBuilder.WrongType.txt"));
        }
        return new Expression((Expression)expression, 10);
    }

    @Override
    public PrimitiveInterface newVariable(String variableName) {
        return Primitive.createVariable(variableName, Collections.EMPTY_LIST);
    }

    @Override
    public PrimitiveInterface newVariable(String variableName, List levels) {
        return Primitive.createVariable(variableName, levels);
    }

    @Override
    public PrimitiveInterface newFormattedVariable(String variableName, List levels) {
        return Primitive.createFormattedVariable(variableName, levels);
    }

    @Override
    public PrimitiveInterface newFormattedVariable(String variableName) {
        return Primitive.createFormattedVariable(variableName, Collections.EMPTY_LIST);
    }

    @Override
    public PrimitiveInterface newNumber(double value) {
        return Primitive.createNumber(value);
    }

    @Override
    public PrimitiveInterface newCharacter(String value) {
        return Primitive.createCharacterValue(value);
    }

    @Override
    public PrimitiveInterface newMissing() {
        return Primitive.createMissingValue();
    }
}

