/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rpf.data;

import com.sas.rpf.data.IncompatibleTypeException;
import com.sas.rpf.data.MissingValue;
import com.sas.rpf.data.RB;
import com.sas.rpf.data.ValueInterface;
import java.text.MessageFormat;

public final class CharacterValue
implements ValueInterface {
    private final String _value;

    public CharacterValue(String value) {
        this._value = value.trim();
    }

    @Override
    public boolean lt(ValueInterface other) throws IncompatibleTypeException {
        boolean returnValue;
        if (other instanceof MissingValue) {
            returnValue = other.ge(this);
        } else {
            CharacterValue that = this.getStringVariable(other);
            returnValue = this._value.compareTo(that._value) < 0;
        }
        return returnValue;
    }

    @Override
    public boolean le(ValueInterface other) throws IncompatibleTypeException {
        boolean returnValue;
        if (other instanceof MissingValue) {
            returnValue = other.gt(this);
        } else {
            CharacterValue that = this.getStringVariable(other);
            returnValue = this._value.compareTo(that._value) <= 0;
        }
        return returnValue;
    }

    @Override
    public boolean gt(ValueInterface other) throws IncompatibleTypeException {
        boolean returnValue;
        if (other instanceof MissingValue) {
            returnValue = other.le(this);
        } else {
            CharacterValue that = this.getStringVariable(other);
            returnValue = this._value.compareTo(that._value) > 0;
        }
        return returnValue;
    }

    @Override
    public boolean ge(ValueInterface other) throws IncompatibleTypeException {
        boolean returnValue;
        if (other instanceof MissingValue) {
            returnValue = other.lt(this);
        } else {
            CharacterValue that = this.getStringVariable(other);
            returnValue = this._value.compareTo(that._value) >= 0;
        }
        return returnValue;
    }

    @Override
    public boolean eq(ValueInterface other) throws IncompatibleTypeException {
        boolean returnValue;
        if (other instanceof MissingValue) {
            returnValue = other.eq(this);
        } else {
            CharacterValue that = this.getStringVariable(other);
            returnValue = this._value.equals(that._value);
        }
        return returnValue;
    }

    @Override
    public boolean ne(ValueInterface other) throws IncompatibleTypeException {
        boolean returnValue;
        if (other instanceof MissingValue) {
            returnValue = other.ne(this);
        } else {
            CharacterValue that = this.getStringVariable(other);
            returnValue = !this._value.equals(that._value);
        }
        return returnValue;
    }

    public boolean contains(ValueInterface other) throws IncompatibleTypeException {
        boolean returnValue;
        if (other instanceof MissingValue) {
            returnValue = false;
        } else {
            CharacterValue that = this.getStringVariable(other);
            returnValue = this._value.indexOf(that._value) > -1;
        }
        return returnValue;
    }

    public boolean startsWith(ValueInterface other) throws IncompatibleTypeException {
        boolean returnValue;
        if (other instanceof MissingValue) {
            returnValue = false;
        } else {
            CharacterValue that = this.getStringVariable(other);
            returnValue = this._value.startsWith(that._value);
        }
        return returnValue;
    }

    private CharacterValue getStringVariable(ValueInterface other) throws IncompatibleTypeException {
        if (!(other instanceof CharacterValue)) {
            Object[] args = new Object[]{this.getClass(), other.getClass()};
            String message = MessageFormat.format(RB.getStringResource("CharacterValue.getStringVariable.IncompatibleType.fmt.txt"), args);
            throw new IncompatibleTypeException(message);
        }
        return (CharacterValue)other;
    }

    public String toString() {
        return "\"" + this._value + "\"";
    }
}

