/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.tsmanager;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SASLibrary;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SASLibLoginsTab
extends WsDescriptionWizardTab {
    SASLibrary m_lib;
    protected ButtonGroup m_butGroup;
    protected JRadioButton m_datasrcButton;
    protected JRadioButton m_connectButton;
    protected WATextField m_datasrcText;
    protected WATextField m_connectText;
    protected Property m_property;
    protected Group m_group;
    protected boolean m_isUpdate;
    protected MdObjectStore m_store;
    private static final String DSN = "DSN";
    private static final String NOPROMPT = "NOPROMPT";
    private static final String CONCRED = "Connect Credentials";
    private static final WAdminResource bundle = WAdminResource.getBundle(SASLibLoginsTab.class);
    private static final long serialVersionUID = -830524542507057977L;

    public SASLibLoginsTab(SASLibrary lib) {
        this.m_lib = lib;
        this.m_isUpdate = true;
        try {
            if (this.m_lib.isNewObject()) {
                this.m_isUpdate = false;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        this.initialize();
        this.layoutWidgets();
    }

    public void populateStore() {
        if (this.isStorePopulated()) {
            return;
        }
        try {
            WAWizardDialog parent;
            this.m_store = (MdObjectStore)this.m_lib.getObjectStore();
            String ckCreate = null;
            if (!this.m_isUpdate && (ckCreate = (String)(parent = (WAWizardDialog)this.getTopLevelAncestor()).getWizardData("CREATEOBJECTS")) == null) {
                this.m_property = (Property)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, DSN, "Property", this.m_lib.getRepositoryID());
                this.m_property.setPropertyName(DSN);
                this.m_lib.getProperties().add((Object)this.m_property);
            }
            if (this.m_isUpdate || ckCreate != null) {
                AssociationList propList = new Vector(1);
                propList = this.m_lib.getProperties();
                for (int p = 0; p < propList.size(); ++p) {
                    if (((Property)propList.get(p)).getPropertyName().equals(DSN)) {
                        this.m_property = (Property)propList.get(p);
                        continue;
                    }
                    if (!((Property)propList.get(p)).getPropertyName().equals(NOPROMPT)) continue;
                    this.m_property = (Property)propList.get(p);
                    break;
                }
            }
            if (!this.m_isUpdate && ckCreate == null) {
                parent = (WAWizardDialog)this.getTopLevelAncestor();
                parent.replaceWizardData("CREATEOBJECTS", (Object)"YES");
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.setStorePopulated(true);
    }

    public void moveDataToView() {
        try {
            if (this.m_property.getPropertyName().equals(DSN)) {
                this.m_datasrcText.setText(this.m_property.getDefaultValue());
                this.m_datasrcButton.setSelected(true);
            } else {
                this.m_connectText.setText(this.m_property.getDefaultValue());
                this.m_connectButton.setSelected(true);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        this._onRadio();
    }

    public void moveDataToStore() {
        try {
            if (this.m_datasrcButton.isSelected()) {
                this.m_property.setDefaultValue(this.m_datasrcText.getText());
            } else {
                this.m_property.setDefaultValue(this.m_connectText.getText());
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean validateData() {
        boolean bValidated = true;
        if (this.m_connectButton.isSelected()) {
            String connectInfo = this.m_connectText.getText();
            if (connectInfo.length() == 0 || connectInfo.equals(" ")) {
                MessageUtil.displayMessage((String)bundle.getString("SASLibLogins.connMsg.txt"), (int)0);
                bValidated = false;
            }
        } else {
            String dsnInfo = this.m_datasrcText.getText();
            if (dsnInfo.length() == 0 || dsnInfo.equals(" ")) {
                MessageUtil.displayMessage((String)bundle.getString("SASLibLogins.dsnMsg.txt"), (int)0);
                bValidated = false;
            }
        }
        return bValidated;
    }

    public String createFinishString() {
        String strFinish = new String();
        strFinish = this.m_datasrcButton.isSelected() ? strFinish + bundle.getString("SASLibLogins.conInfo.txt") + "\n\t" + bundle.getString("SASLibLogins.conInfoDSN.txt") + " " + this.m_datasrcText.getText() + "\n" : strFinish + bundle.getString("SASLibLogins.conInfo.txt") + "\n\t" + bundle.getString("SASLibLogins.conInfoCon.txt") + " " + this.m_connectText.getText() + "\n";
        return strFinish;
    }

    public void initialize() {
        this.m_datasrcButton = new JRadioButton();
        this.m_datasrcButton.setText(bundle.getString("SASLibLogins.buttonDSN.txt"));
        this.m_datasrcButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SASLibLoginsTab.this._onRadio();
            }
        });
        this.m_connectButton = new JRadioButton();
        this.m_connectButton.setText(bundle.getString("SASLibLogins.buttonCon.txt"));
        this.m_connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SASLibLoginsTab.this._onRadio();
            }
        });
        this.m_datasrcText = new WATextField();
        this.m_datasrcText.setMaxCharacters(1024);
        this.m_datasrcText.setToolTipText(bundle.getString("SASLibLogins.dsnTooltip.txt"));
        this.m_butGroup = new ButtonGroup();
        this.m_butGroup.add(this.m_datasrcButton);
        this.m_butGroup.add(this.m_connectButton);
        this.m_connectText = new WATextField();
        this.m_connectText.setMaxCharacters(1024);
        this.m_connectText.setToolTipText(bundle.getString("SASLibLogins.conTooltip.txt"));
    }

    protected void _groupMetadata(boolean add) {
        try {
            if (add && this.m_group == null) {
                this.m_group = (Group)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, CONCRED, "Group", this.m_lib.getRepositoryID());
                this.m_lib.getGroups().add((Object)this.m_group);
            } else if (this.m_group != null) {
                Workspace.getMdFactory().deleteMetadataObject((CMetadata)this.m_group);
                this.m_group = null;
            }
        }
        catch (MdException e) {
            String message = e.getLocalizedMessage();
            String libName = "";
            try {
                libName = this.m_lib.getName();
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
            }
            if (message == null) {
                message = bundle.getString("Common.NullMdException.txt");
            }
            MessageUtil.displayMessage((String)message, (String)bundle.formatString("Common.Title.fmt.txt", (Object)libName), (int)0);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    protected void _onRadio() {
        if (this.m_datasrcButton.isSelected()) {
            try {
                this.m_property.setDelimiter("=");
                this.m_property.setPropertyName(DSN);
                this.m_property.setName(DSN);
                this.m_property.setDefaultValue(this.m_datasrcText.getText());
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            this.m_connectText.setText("");
            this.m_connectText.setEnabled(false);
            this.m_datasrcText.setEnabled(true);
        } else {
            try {
                this.m_property.setDelimiter("=");
                this.m_property.setPropertyName(NOPROMPT);
                this.m_property.setName(NOPROMPT);
                this.m_property.setDefaultValue(this.m_connectText.getText());
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            this.m_datasrcText.setText("");
            this.m_datasrcText.setEnabled(false);
            this.m_connectText.setEnabled(true);
        }
    }

    public void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        int row = 0;
        this.add(this.m_datasrcButton, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.m_datasrcText, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 40), 0, 0));
        this.add(this.m_connectButton, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.m_connectText, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 40), 0, 0));
        JPanel eaterPanel = new JPanel();
        this.add(eaterPanel, new GridBagConstraints(0, ++row, 0, 0, 1.0, 1.0, 18, 1, new Insets(0, 5, 5, 0), 0, 0));
        this.add(eaterPanel);
    }

    public void onBack() {
        this.setViewProperties();
    }

    public void onNext() {
        this.setViewProperties();
    }

    protected void setViewProperties() {
    }
}

