/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.scheduler;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServerComponent;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HostTypePanel
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource m_bundle = WAdminResource.getBundle(HostTypePanel.class);
    private ServerComponent m_javabatchserver = null;
    private JComboBox m_hostcombo = null;
    private String m_hosttype = null;
    private JLabel m_jclLabel = new JLabel(m_bundle.getString("BatchServer.Java.Property.JCLDir.xmlKey.txt"));
    private JTextField m_jcl = new JTextField();
    private String m_jcldir = null;
    private static final int NONE_INDEX = 0;
    private static final int WIN_INDEX = 1;
    private static final String WIN_STR = "win";
    private static final int UNX_INDEX = 2;
    private static final String UNX_STR = "unx";
    private static final int VMS_INDEX = 3;
    private static final String VMS_STR = "vms";
    private static final int MVS_INDEX = 4;
    private static final String MVS_STR = "mvs";
    private static final int MAX_INDEX = 5;
    public static final String PropHostType = "HostType";
    public static final String PropJCLDir = "JCLDir";

    public HostTypePanel(ServerComponent javabatchserver) {
        this.m_javabatchserver = javabatchserver;
        this.initialize();
        this.layoutWidgets();
    }

    public void saveSettingsAndCleanUp() {
        this.m_javabatchserver = null;
        this.m_hostcombo = null;
        this.m_hosttype = null;
        this.m_jcl = null;
        this.m_jcldir = null;
    }

    protected void initialize() {
        Object[] types = new Object[]{m_bundle.getString("BatchServer.Java.Property.HostType.SelectOne.xmlKey.txt"), m_bundle.getString("BatchServer.Java.Property.HostType.Windows.xmlKey.txt"), m_bundle.getString("BatchServer.Java.Property.HostType.UNIX.xmlKey.txt"), m_bundle.getString("BatchServer.Java.Property.HostType.VMS.xmlKey.txt"), m_bundle.getString("BatchServer.Java.Property.HostType.mvs.xmlKey.txt")};
        this.m_hostcombo = new JComboBox<Object>(types);
        this.m_hostcombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HostTypePanel.this.m_hostcombo.getSelectedIndex() == 4) {
                    HostTypePanel.this.m_jclLabel.setVisible(true);
                    HostTypePanel.this.m_jcl.setVisible(true);
                } else {
                    HostTypePanel.this.m_jclLabel.setVisible(false);
                    HostTypePanel.this.m_jcl.setVisible(false);
                }
            }
        });
        this.m_jclLabel.setLabelFor(this.m_jcl);
        this.m_hostcombo.setSelectedIndex(0);
    }

    protected void layoutWidgets() {
        JLabel hosttypeLabel = new JLabel(m_bundle.getString("BatchServer.Java.Property.HostType.xmlKey.txt"));
        hosttypeLabel.setLabelFor(this.m_hostcombo);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gbc_hostlabel = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints gbc_hostcombo = new GridBagConstraints(1, 0, 0, 1, 1.0, 1.0, 12, 2, new Insets(0, 12, 0, 0), 0, 0);
        GridBagConstraints gbc_jcllabel = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 0, 0, 0), 0, 0);
        GridBagConstraints gbc_jcldir = new GridBagConstraints(1, 1, 0, 1, 1.0, 1.0, 12, 2, new Insets(12, 12, 0, 0), 0, 0);
        GridBagConstraints gbc_eater = new GridBagConstraints(0, 2, 10, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
        this.setLayout(gridBagLayout);
        gridBagLayout.setConstraints(hosttypeLabel, gbc_hostlabel);
        gridBagLayout.setConstraints(this.m_hostcombo, gbc_hostcombo);
        gridBagLayout.setConstraints(this.m_jclLabel, gbc_jcllabel);
        gridBagLayout.setConstraints(this.m_jcl, gbc_jcldir);
        gridBagLayout.setConstraints(new JPanel(), gbc_eater);
        this.add(hosttypeLabel);
        this.add(this.m_hostcombo);
        this.add(this.m_jclLabel);
        this.add(this.m_jcl);
        this.add(new JPanel());
    }

    public String createFinishString() {
        String strFinish = Util.getDisplayLabel((String)m_bundle.getString("BatchServer.Java.Property.HostType.xmlKey.txt")) + "\n\t" + (String)this.m_hostcombo.getSelectedItem() + "\n";
        if (this.m_jcl.isVisible()) {
            strFinish = strFinish + Util.getDisplayLabel((String)m_bundle.getString("BatchServer.Java.Property.JCLDir.xmlKey.txt")) + "\n\t" + this.m_jcl.getText() + "\n";
        }
        return strFinish;
    }

    public Component getDefaultFocusComponent() {
        return this.m_hostcombo;
    }

    public void moveDataToStore() throws MdException, RemoteException {
        Property property;
        switch (this.m_hostcombo.getSelectedIndex()) {
            case 1: {
                this.m_hosttype = WIN_STR;
                this.m_jcldir = null;
                break;
            }
            case 2: {
                this.m_hosttype = UNX_STR;
                this.m_jcldir = null;
                break;
            }
            case 3: {
                this.m_hosttype = VMS_STR;
                this.m_jcldir = null;
                break;
            }
            case 4: {
                this.m_hosttype = MVS_STR;
                this.m_jcldir = this.m_jcl.getText();
                break;
            }
            default: {
                this.m_hosttype = "";
                this.m_jcldir = null;
            }
        }
        boolean setHostType = false;
        boolean setJCLDir = !this.m_jcl.isVisible();
        AssociationList properties = this.m_javabatchserver.getProperties();
        int propsize = properties.size();
        for (int j = 0; j < propsize; ++j) {
            Property property2 = (Property)properties.get(j);
            if (property2.getPropertyName().equalsIgnoreCase(PropHostType)) {
                property2.setDefaultValue(this.m_hosttype);
                setHostType = true;
            }
            if (setJCLDir || !property2.getPropertyName().equalsIgnoreCase(PropJCLDir)) continue;
            property2.setDefaultValue(this.m_jcldir);
            setJCLDir = true;
        }
        if (setHostType && setJCLDir) {
            return;
        }
        MdFactory factory = Workspace.getMdFactory();
        MdObjectStore store = (MdObjectStore)this.m_javabatchserver.getObjectStore();
        String repos = this.m_javabatchserver.getRepositoryID();
        if (!setHostType) {
            property = (Property)factory.createComplexMetadataObject(store, null, PropHostType, "Property", repos, null);
            property.setPropertyName(PropHostType);
            property.setDefaultValue(this.m_hosttype);
            property.setSQLType(12);
            properties.add((Object)property);
        }
        if (!setJCLDir) {
            property = (Property)factory.createComplexMetadataObject(store, null, PropJCLDir, "Property", repos, null);
            property.setPropertyName(PropJCLDir);
            property.setDefaultValue(this.m_jcldir);
            property.setSQLType(12);
            properties.add((Object)property);
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        AssociationList properties = this.m_javabatchserver.getProperties();
        int propsize = properties.size();
        for (int j = 0; j < propsize; ++j) {
            Property property = (Property)properties.get(j);
            if (property.getPropertyName().equalsIgnoreCase(PropHostType)) {
                this.m_hosttype = property.getDefaultValue();
                if (this.m_hosttype.compareTo(WIN_STR) == 0) {
                    this.m_hostcombo.setSelectedIndex(1);
                } else if (this.m_hosttype.compareTo(UNX_STR) == 0) {
                    this.m_hostcombo.setSelectedIndex(2);
                } else if (this.m_hosttype.compareTo(VMS_STR) == 0) {
                    this.m_hostcombo.setSelectedIndex(3);
                } else if (this.m_hosttype.compareTo(MVS_STR) == 0) {
                    this.m_hostcombo.setSelectedIndex(4);
                } else {
                    this.m_hostcombo.setSelectedIndex(0);
                }
            }
            if (!property.getPropertyName().equalsIgnoreCase(PropJCLDir)) continue;
            this.m_jcldir = property.getDefaultValue();
            this.m_jcl.setText(this.m_jcldir);
        }
    }

    public boolean validateData() {
        boolean rc = true;
        if (this.m_hostcombo.getSelectedIndex() == 0) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), m_bundle.getString("HostTypePanel.NoHostSelection.txt"), m_bundle.getString("Title.Error.txt"), 0);
            rc = false;
        } else if (this.m_hostcombo.getSelectedIndex() == 4 && this.m_jcl.getText().length() <= 0) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), m_bundle.getString("HostTypePanel.NoJCLDir.txt"), m_bundle.getString("Title.Error.txt"), 0);
            rc = false;
        }
        return rc;
    }
}

