/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.proxy;

import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.visuals.Resources;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMProperty;
import com.sas.workspace.mgmt.visuals.customizers.iom.ListProperty;
import com.sas.workspace.mgmt.visuals.customizers.iom.ListPropertyDialogImpl;
import com.sas.workspace.mgmt.visuals.customizers.proxy.InvalidProxyURIException;
import com.sas.workspace.mgmt.visuals.customizers.proxy.ProxyListItem;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;

public class ProxyListProperty
extends ListProperty {
    public static final int UP_BUTTON = 4;
    public static final int DOWN_BUTTON = 5;
    protected static final String UP_COMMAND = "Up";
    protected static final String DOWN_COMMAND = "Down";
    protected static final String PROXY_PATH_PROPNAME = "ProxyPath";
    protected static final String PROXY_APP_PROTOCOL = "Proxy";
    private ArrayList<ProxyListItem> m_currProxyItems;
    private ArrayList<TCPIPConnection> m_currProxyObjects;
    private int m_nextProxyID;
    private Prototype m_prototype;

    public ProxyListProperty(CMetadata object, AbstractProperty metaProp, int viewType) {
        super(object, metaProp, viewType);
    }

    @Override
    protected void initialize() {
        this.m_numButtons = 6;
        super.initialize();
        this.m_buttons[0].setText(IOMProperty.getDisplayString(0, "ProxyListProperty.Button.New.Name.xmlKey.txt"));
        ProxyListProperty.setMnemonic(this.m_buttons[0], 0, "ProxyListProperty.Button.New.Name.xmlKey.txt");
        JButton button = new JButton((String)null);
        button.setIcon(Resources.getImageIcon((String)"UpArrow"));
        button.setActionCommand(UP_COMMAND);
        int height = button.getMinimumSize().height;
        button.setMinimumSize(new Dimension(100, height));
        button.addActionListener(this);
        this.m_buttons[4] = button;
        this.m_useButton[4] = true;
        this.m_buttons[4].setEnabled(false);
        button = new JButton((String)null);
        button.setIcon(Resources.getImageIcon((String)"DownArrow"));
        button.setActionCommand(DOWN_COMMAND);
        height = button.getMinimumSize().height;
        button.setMinimumSize(new Dimension(100, height));
        button.addActionListener(this);
        this.m_buttons[5] = button;
        this.m_useButton[5] = true;
        this.m_buttons[5].setEnabled(false);
        this.setButtonDialog(0, new ProxyDialog(IOMProperty.getDisplayString(1, "Proxy.Dialog.New.Name.xmlKey.txt")));
        this.setButtonDialog(1, new ProxyDialog(IOMProperty.getDisplayString(1, "Proxy.Dialog.Edit.Name.xmlKey.txt")));
        this.addPersistedPropertyEventListener(new ProxyListPersistedPropertyListener());
        this.addPropertyValidationEventListener(new IOMProperty.PropertyValidationEventListener(){

            @Override
            public void validateProperty(IOMProperty.PersistedPropertyEvent evt) {
                if (ProxyListProperty.this.m_listMdl.size() == 0) {
                    JOptionPane.showMessageDialog(ProxyListProperty.this.m_list.getTopLevelAncestor(), IOMProperty.getDisplayString(0, "ProxyList.Error.NoList.Message.xmlKey.txt"), IOMProperty.getDisplayString(0, "ProxyList.Error.NoList.Title.xmlKey.txt"), 0);
                    ProxyListProperty.this.setValid(false);
                    return;
                }
                ProxyListProperty.this.setValid(true);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int newIndex;
        int selIndex;
        Object selected;
        if (e.getActionCommand().equals(UP_COMMAND)) {
            selected = this.m_list.getSelectedValue();
            selIndex = this.m_list.getSelectedIndex();
            if (selIndex != 0) {
                newIndex = selIndex - 1;
                Object prev = this.m_listMdl.get(newIndex);
                this.m_listMdl.set(selIndex, prev);
                this.m_listMdl.set(newIndex, selected);
                this.m_list.setSelectedIndex(newIndex);
            }
        }
        if (e.getActionCommand().equals(DOWN_COMMAND)) {
            selected = this.m_list.getSelectedValue();
            selIndex = this.m_list.getSelectedIndex();
            newIndex = selIndex + 1;
            if (newIndex != this.m_listMdl.getSize()) {
                Object next = this.m_listMdl.get(newIndex);
                this.m_listMdl.set(selIndex, next);
                this.m_listMdl.set(newIndex, selected);
                this.m_list.setSelectedIndex(selIndex + 1);
            }
        }
        super.actionPerformed(e);
    }

    @Override
    public Object getDataValue() {
        if (this.m_listMdl.size() == 0) {
            return null;
        }
        if (this.m_list.isSelectionEmpty()) {
            return null;
        }
        return this.m_list.getSelectedValue();
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        if (this.m_list.getSelectedIndices().length == 1) {
            if (this.m_listMdl.getSize() > 1) {
                this.m_buttons[4].setEnabled(this.m_list.getSelectedIndex() != 0);
                this.m_buttons[5].setEnabled(this.m_list.getSelectedIndex() != this.m_listMdl.getSize() - 1);
            } else {
                this.m_buttons[4].setEnabled(false);
                this.m_buttons[5].setEnabled(false);
            }
        } else {
            this.m_buttons[4].setEnabled(false);
            this.m_buttons[5].setEnabled(false);
        }
        super.valueChanged(arg0);
    }

    @Override
    public void addPropertyToPanel(JPanel panel) {
        GridBagConstraints gbc;
        int vertGap;
        if (!this.m_visible) {
            return;
        }
        if (this.m_viewType == 1) {
            this.m_scrPane.setMinimumSize(new Dimension(240, 100));
            vertGap = 12;
        } else {
            this.m_scrPane.setPreferredSize(new Dimension(160, 75));
            vertGap = 6;
        }
        int gridx = 0;
        int gridy = 0;
        int listWidth = 3;
        int listHeight = 2;
        GridBagLayout gbLayout = (GridBagLayout)panel.getLayout();
        if (this.m_sep != null) {
            gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.gridy = gridy++;
            gbc.gridx = gridx;
            gbc.gridwidth = 0;
            gbc.insets = new Insets(vertGap, 12, vertGap, 0);
            gbLayout.setConstraints(this.m_sep, gbc);
            panel.add(this.m_sep);
        } else if (this.m_useLabel) {
            try {
                ((JLabel)this.m_label).setLabelFor(this.m_list);
                ProxyListProperty.setMnemonic(this.m_label, 1, this.m_metaProp.getName());
                gbc = new GridBagConstraints();
                gbc.anchor = 17;
                gbc.fill = 1;
                gbc.insets = new Insets(0, 12, 0, 12);
                gbLayout.setConstraints(this.m_label, gbc);
                panel.add(this.m_label);
                ++gridx;
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridwidth = listWidth;
        gbc.gridheight = listHeight;
        gbc.insets = new Insets(0, 36, 0, 0);
        gbc.weightx = 1.0;
        gbLayout.setConstraints(this.m_scrPane, gbc);
        panel.add(this.m_scrPane);
        if (this.m_useButton[4]) {
            gbc = new GridBagConstraints();
            gbc.gridx = gridx + listWidth;
            gbc.gridy = gridy;
            gbLayout.setConstraints(this.m_buttons[4], gbc);
            panel.add(this.m_buttons[4]);
        }
        if (this.m_useButton[5]) {
            gbc = new GridBagConstraints();
            gbc.gridx = gridx + listWidth;
            gbc.gridy = gridy + 1;
            gbLayout.setConstraints(this.m_buttons[5], gbc);
            panel.add(this.m_buttons[5]);
        }
        JPanel genBtnPanel = new JPanel();
        int genBtnsUsed = 0;
        for (int i = 0; i < 4; ++i) {
            if (!this.m_useButton[i]) continue;
            ++genBtnsUsed;
        }
        GridLayout genBtnLayout = new GridLayout(1, genBtnsUsed, 12, 0);
        genBtnPanel.setLayout(genBtnLayout);
        for (int i = 0; i < 4; ++i) {
            if (!this.m_useButton[i]) continue;
            genBtnPanel.add(this.m_buttons[i]);
        }
        gbc = new GridBagConstraints();
        gbc.gridy = gridy + listHeight;
        gbc.gridx = gridx;
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(8, 12, 0, 12);
        gbLayout.setConstraints(genBtnPanel, gbc);
        panel.add(genBtnPanel);
    }

    private ProxyListItem createEntryFromTCPIPConnection(TCPIPConnection conn) throws RemoteException, MdException {
        AssociationList proxyConnProps = conn.getProperties(true);
        String path = null;
        for (int j = 0; j < proxyConnProps.size(); ++j) {
            Property pathProp = (Property)proxyConnProps.get(j);
            if (!pathProp.getPropertyName().equals(PROXY_PATH_PROPNAME)) continue;
            path = pathProp.getDefaultValue();
            break;
        }
        ProxyListItem item = new ProxyListItem(conn.getCommunicationProtocol(), conn.getHostName(), conn.getPort(), path);
        item.setEntryID(conn.getName());
        return item;
    }

    public void setConnectionPrototype(Prototype prototype) {
        this.m_prototype = prototype;
    }

    public class ProxyDialog
    extends ListPropertyDialogImpl {
        protected String m_name;
        protected JLabel m_label;
        protected WATextField m_text;
        protected ProxyListItem m_entry;

        public ProxyDialog(String name) {
            if (name == null || name.length() == 0) {
                this.m_name = IOMProperty.getDisplayString(1, "Proxy.Dialog.Default.Name.xmlKey.txt");
            }
            this.m_name = name;
            this.initialize();
        }

        public ProxyDialog() {
            this(null);
        }

        protected void initialize() {
            this.m_label = new JLabel(IOMProperty.getDisplayString(0, "ProxyDialog.URI.Name.xmlKey.txt"));
            this.m_text = new WATextField();
            this.m_text.setEditable(true);
            this.m_text.setEnabled(true);
            this.m_text.setPreferredSize(new Dimension(250, this.m_text.getPreferredSize().height));
            this.m_text.setToolTipText(IOMProperty.getDisplayString(0, "ProxyDialog.URI.Desc.xmlKey.txt"));
        }

        @Override
        public WAStandardDialog getDialog(Dialog owner, int button) {
            WAPanel panel = new WAPanel();
            panel.setHelpProduct("templateData");
            panel.setHelpTopic("proxy_uri");
            GridBagLayout gbLayout = new GridBagLayout();
            panel.setLayout((LayoutManager)gbLayout);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(0, 0, 10, 5);
            gbLayout.setConstraints(this.m_label, gbc);
            panel.add((Component)this.m_label);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.insets = new Insets(0, 0, 10, 5);
            gbLayout.setConstraints((Component)this.m_text, gbc);
            panel.add((Component)this.m_text);
            this.m_dialog = new WAStandardDialog(owner, this.m_name, true, panel){

                protected boolean onOK() {
                    URI uri = URI.create(ProxyDialog.this.m_text.getText());
                    if (ProxyListProperty.this.m_listMdl.contains(ProxyListItem.fromURI(uri))) {
                        JOptionPane.showMessageDialog(ProxyDialog.this.m_dialog.getOwner(), IOMProperty.getDisplayString(0, "Proxy.URI.Error.Duplicate.Message.xmlKey.txt"), IOMProperty.getDisplayString(0, "Proxy.URI.Error.Duplicate.Title.xmlKey.txt"), 0);
                        return false;
                    }
                    try {
                        ProxyListItem.validate(uri);
                    }
                    catch (InvalidProxyURIException ex) {
                        JOptionPane.showMessageDialog(ProxyDialog.this.m_dialog.getOwner(), ex.getMessage(), IOMProperty.getDisplayString(0, "Proxy.URI.Error.Title.xmlKey.txt"), 0);
                        return false;
                    }
                    if (ProxyDialog.this.m_entry != null) {
                        ProxyDialog.this.m_entry.setPreviousURI(ProxyDialog.this.m_entry.toString());
                        ProxyDialog.this.m_entry.setScheme(uri.getScheme());
                        ProxyDialog.this.m_entry.setHost(uri.getHost());
                        ProxyDialog.this.m_entry.setPort(uri.getPort());
                        ProxyDialog.this.m_entry.setPath(uri.getPath());
                    } else {
                        ProxyDialog.this.m_entry = ProxyListItem.fromURI(uri);
                    }
                    return super.onOK();
                }
            };
            return this.m_dialog;
        }

        @Override
        public Object getValue() {
            return this.m_entry;
        }

        @Override
        public void Reset() {
            this.m_text.setText("");
            this.m_entry = null;
        }

        @Override
        public void setInitialValue(Object value) {
            if (value instanceof ProxyListItem) {
                this.m_entry = (ProxyListItem)value;
            } else if (value instanceof URI) {
                this.m_entry = ProxyListItem.fromURI((URI)value);
            } else if (value instanceof String) {
                this.m_entry = ProxyListItem.fromURI(URI.create((String)value));
            }
            if (this.m_entry != null) {
                this.m_text.setText(this.m_entry.toString());
            }
        }
    }

    public class ProxyListPersistedPropertyListener
    implements IOMProperty.PersistedPropertyEventListener {
        @Override
        public void deleteProperty(IOMProperty.PersistedPropertyEvent evt) {
            try {
                ServerComponent proxyList = (ServerComponent)ProxyListProperty.this.m_object;
                AssociationList currProxies = proxyList.getSourceConnections();
                for (int i = 0; i < currProxies.size(); ++i) {
                    TCPIPConnection proxyConn = (TCPIPConnection)currProxies.get(i);
                    proxyList.getObjectStore().deleteObject((CMetadata)proxyConn);
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }

        @Override
        public void readProperty(IOMProperty.PersistedPropertyEvent evt) {
            try {
                this.buildEntryList();
                for (int i = 0; i < ProxyListProperty.this.m_currProxyItems.size(); ++i) {
                    ProxyListProperty.this.m_listMdl.addElement(ProxyListProperty.this.m_currProxyItems.get(i));
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
        }

        @Override
        public void writeProperty(IOMProperty.PersistedPropertyEvent evt) {
            TCPIPConnection proxyConn;
            int i;
            ServerComponent proxyList = (ServerComponent)ProxyListProperty.this.m_object;
            try {
                proxyList.getSourceConnections().removeAllElements();
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            for (i = 0; i < ProxyListProperty.this.m_listMdl.size(); ++i) {
                try {
                    ProxyListItem proxyListEntry = (ProxyListItem)ProxyListProperty.this.m_listMdl.get(i);
                    if (ProxyListProperty.this.m_currProxyItems.contains(proxyListEntry)) {
                        proxyConn = (TCPIPConnection)ProxyListProperty.this.m_currProxyObjects.get(ProxyListProperty.this.m_currProxyItems.indexOf(proxyListEntry));
                        ProxyListProperty.this.m_currProxyObjects.remove(proxyConn);
                        ProxyListProperty.this.m_currProxyItems.remove(proxyListEntry);
                    } else if (proxyListEntry.hasBeenUpdated() && ProxyListProperty.this.m_currProxyItems.contains(proxyListEntry.getPreviousURI())) {
                        proxyConn = (TCPIPConnection)ProxyListProperty.this.m_currProxyObjects.get(ProxyListProperty.this.m_currProxyItems.indexOf(proxyListEntry.getPreviousURI()));
                        ProxyListProperty.this.m_currProxyObjects.remove(proxyConn);
                        ProxyListProperty.this.m_currProxyItems.remove(proxyListEntry.getPreviousURI());
                    } else {
                        String proxyName = proxyList.getName() + "_Proxy_" + String.valueOf(ProxyListProperty.this.m_nextProxyID);
                        ProxyListProperty.this.m_nextProxyID++;
                        proxyConn = (TCPIPConnection)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)proxyList.getObjectStore(), null, proxyName, "TCPIPConnection", proxyList.getRepositoryID());
                        proxyConn.setApplicationProtocol(ProxyListProperty.PROXY_APP_PROTOCOL);
                        if (ProxyListProperty.this.m_prototype != null) {
                            proxyConn.setUsingPrototype((Root)ProxyListProperty.this.m_prototype);
                        }
                        int flags = 8604;
                        String strOpts = "<XMLSelect search=\"*[@Name='" + proxyListEntry.getHost() + "']\"/><TEMPLATES><Machine/></TEMPLATES>";
                        List machines = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(proxyList.getObjectStore(), "A0000001." + proxyList.getRepositoryID(), "Machine", flags, strOpts);
                        Machine machine = machines.size() == 0 ? (Machine)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)proxyList.getObjectStore(), null, proxyListEntry.getHost(), "Machine", proxyList.getRepositoryID()) : (Machine)machines.get(0);
                        if (i == 0) {
                            proxyList.setAssociatedMachine(machine);
                        }
                    }
                    proxyConn.setCommunicationProtocol(proxyListEntry.getScheme());
                    proxyConn.setHostName(proxyListEntry.getHost());
                    proxyConn.setPort(proxyListEntry.getPort());
                    AssociationList propList = proxyConn.getProperties();
                    Property pathProp = null;
                    boolean found = false;
                    for (int j = 0; j < propList.size() && !found; ++j) {
                        pathProp = (Property)propList.get(j);
                        found = pathProp.getPropertyName().equals(ProxyListProperty.PROXY_PATH_PROPNAME);
                    }
                    if (proxyListEntry.getPath() != null && proxyListEntry.getPath().length() != 0) {
                        if (!found) {
                            pathProp = (Property)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)proxyList.getObjectStore(), null, IOMProperty.getDisplayString(0, "Proxy.URI.PathProperty.Name.xmlKey.txt"), "Property", proxyList.getRepositoryID());
                            pathProp.setPropertyName(ProxyListProperty.PROXY_PATH_PROPNAME);
                            pathProp.setSQLType(12);
                            proxyConn.getProperties().add((Object)pathProp);
                        }
                        if (pathProp != null) {
                            pathProp.setDefaultValue(proxyListEntry.getPath());
                        }
                    } else if (found) {
                        proxyList.getObjectStore().deleteObject((CMetadata)pathProp);
                        pathProp = null;
                    }
                    proxyList.getSourceConnections().add((Object)proxyConn);
                    continue;
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException((RemoteException)e);
                    continue;
                }
                catch (ClassCastException e) {
                    continue;
                }
                catch (MdException e) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
                }
            }
            try {
                for (i = 0; i < ProxyListProperty.this.m_currProxyObjects.size(); ++i) {
                    proxyConn = (TCPIPConnection)ProxyListProperty.this.m_currProxyObjects.get(i);
                    proxyList.getObjectStore().deleteObject((CMetadata)proxyConn);
                }
                this.buildEntryList();
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
        }

        private void buildEntryList() throws RemoteException, MdException {
            ProxyListProperty.this.m_currProxyItems = new ArrayList();
            ProxyListProperty.this.m_currProxyObjects = new ArrayList();
            ProxyListProperty.this.m_nextProxyID = -1;
            ServerComponent proxyList = (ServerComponent)ProxyListProperty.this.m_object;
            AssociationList proxyConns = proxyList.getSourceConnections();
            for (int i = 0; i < proxyConns.size(); ++i) {
                TCPIPConnection proxyConn = (TCPIPConnection)proxyConns.get(i);
                ProxyListItem proxyListEntry = ProxyListProperty.this.createEntryFromTCPIPConnection(proxyConn);
                String[] tokens = proxyConn.getName().split("_");
                if (tokens.length == 3 && Integer.valueOf(tokens[2]) > ProxyListProperty.this.m_nextProxyID) {
                    ProxyListProperty.this.m_nextProxyID = Integer.valueOf(tokens[2]);
                }
                ProxyListProperty.this.m_currProxyItems.add(proxyListEntry);
                ProxyListProperty.this.m_currProxyObjects.add(proxyConn);
            }
            ProxyListProperty.this.m_nextProxyID++;
        }
    }
}

