/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.proxy;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.ServerComponent;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.customizers.iom.DefaultPropertyListener;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMProperty;
import com.sas.workspace.mgmt.visuals.customizers.iom.MachineList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ProxyListMachineList
extends MachineList {
    public ProxyListMachineList(ServerComponent comp, AssociationProperty metaProp, int viewType) {
        super(comp, metaProp, viewType);
    }

    protected List<Machine> getMachineObjects() {
        List machines = new Vector();
        Vector<Machine> objectsRet = new Vector<Machine>();
        int flags = 8476;
        String strTemplate = "<TEMPLATES><Machine><Implementors/></Machine><ServerComponent PublicType=\"\"/></TEMPLATES>";
        try {
            machines = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_object.getObjectStore(), "A0000001." + this.m_object.getRepositoryID(), "Machine", flags, strTemplate);
            for (int i = 0; i < machines.size(); ++i) {
                Machine machine = (Machine)machines.get(i);
                AssociationList implementors = machine.getImplementors();
                boolean plFound = false;
                int j = 0;
                while (j < implementors.size()) {
                    if (implementors.get(j) instanceof PrimaryType && ((PrimaryType)implementors.get(j)).getPublicType().equals("ProxyList")) {
                        plFound = true;
                        break;
                    }
                    ++i;
                }
                if (plFound) continue;
                objectsRet.add(machine);
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (Exception ex) {
            ex.getMessage();
        }
        return objectsRet;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.removeAllPersistedPropertyEventListeners();
        this.addPersistedPropertyEventListener(new ProxyListMachineListPersistedPropertyListener());
        this.m_dlMachines.setToolTipText(this.m_dlMachines.getSourceComponent(), ProxyListMachineList.getDisplayString(1, "ProxyList.MachineList.Source.Desc.xmlKey.txt"));
        this.m_dlMachines.setToolTipText(this.m_dlMachines.getTargetComponent(), ProxyListMachineList.getDisplayString(1, "ProxyList.MachineList.Target.Desc.xmlKey.txt"));
    }

    @Override
    public Object getDataValue() {
        return this.getMachines().toArray();
    }

    @Override
    public void addPropertyToPanel(JPanel panel) {
        try {
            GridBagConstraints gbc;
            if (!this.m_visible) {
                return;
            }
            int gridx = 0;
            int gridy = ProxyListMachineList.getNextComponentHorizontalGridValue(panel);
            GridBagLayout gbLayout = (GridBagLayout)panel.getLayout();
            int vertGap = 12;
            if (this.m_viewType == 0 || this.m_viewType == 2) {
                this.m_dlMachines.setPreferredSize(new Dimension(200, 70));
                vertGap = 6;
            }
            if (this.m_sep != null) {
                gbc = new GridBagConstraints();
                gbc.anchor = 17;
                gbc.gridx = gridx;
                gbc.gridy = gridy++;
                gbc.fill = 2;
                gbc.gridwidth = 0;
                gbc.insets = new Insets(vertGap, 12, vertGap, 0);
                gbLayout.setConstraints(this.m_sep, gbc);
                panel.add(this.m_sep);
            } else if (this.m_useLabel) {
                ((JLabel)this.m_label).setLabelFor((Component)((Object)this.m_dlMachines));
                ProxyListMachineList.setMnemonic(this.m_label, 1, this.m_metaProp.getName());
                gbc = new GridBagConstraints();
                gbc.anchor = 17;
                gbc.fill = 1;
                gbc.gridx = gridx++;
                gbc.gridy = gridy;
                gbc.insets = new Insets(0, 12, 0, 0);
                gbLayout.setConstraints(this.m_label, gbc);
                panel.add(this.m_label);
            }
            gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.gridx = gridx;
            gbc.gridy = gridy;
            gbc.weightx = 0.0;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            gbc.insets = this.m_sep != null ? new Insets(0, 36, 0, 12) : new Insets(0, 12, 0, 12);
            gbLayout.setConstraints((Component)((Object)this.m_dlMachines), gbc);
            panel.add((Component)((Object)this.m_dlMachines));
            ++gridy;
            JPanel btnPanel = new JPanel();
            GridLayout btnLayout = new GridLayout(1, 2, 12, 12);
            btnPanel.setLayout(btnLayout);
            btnPanel.add(this.m_btnNew);
            btnPanel.add(this.m_btnRemove);
            gbc = new GridBagConstraints();
            gbc.gridy = gridy;
            gbc.gridx = gridx;
            gbc.anchor = 11;
            gbc.gridwidth = 0;
            gbc.insets = new Insets(8, 12, 0, 12);
            gbLayout.setConstraints(btnPanel, gbc);
            panel.add(btnPanel);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    @Override
    public void setPropertyValue(Object value) {
        if (value instanceof Machine) {
            this.addTargetMachine((Machine)value);
        }
    }

    public class ProxyListMachineListPersistedPropertyListener
    extends DefaultPropertyListener {
        @Override
        public void readProperty(IOMProperty.PersistedPropertyEvent evt) {
            ServerComponent proxyList = (ServerComponent)ProxyListMachineList.this.m_object;
            try {
                AssociationList machines = proxyList.getImplementedObjects();
                for (int i = 0; i < machines.size(); ++i) {
                    ProxyListMachineList.this.setPropertyValue(machines.get(i));
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
        }

        @Override
        public void writeProperty(IOMProperty.PersistedPropertyEvent evt) {
            ServerComponent proxyList = (ServerComponent)ProxyListMachineList.this.m_object;
            try {
                Object[] machines = (Object[])ProxyListMachineList.this.getDataValue();
                AssociationList list = proxyList.getImplementedObjects();
                list.removeAllElements();
                for (int i = 0; i < machines.length; ++i) {
                    list.add(machines[i]);
                }
                proxyList.setImplementedObjects(list);
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
        }
    }
}

