/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.lasr;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class SignerPanel
extends WsDescriptionWizardTab {
    private SASClientConnection m_connection;
    private String m_strReposID;
    private List<Property> m_lstProperties;
    private JCheckBox m_chkSigner;
    private WATextField m_txtSigner;
    protected static final WAdminResource m_bundle = new WAdminResource(SignerPanel.class);
    protected static final WAdminResource templBundle = new WAdminResource("com.sas.workspace.visuals.res.PropertyBundle");
    private static final long serialVersionUID = 1L;

    public SignerPanel(SASClientConnection connection, String reposID, List<Property> propertyList) {
        this.m_connection = connection;
        this.m_strReposID = reposID;
        this.m_lstProperties = propertyList;
        this.initialize();
        this.layoutWidgets();
    }

    public void moveDataToStore() {
        try {
            AssociationList lstProperties;
            int index;
            WAWizardDialog parent;
            ServerComponent serverComponent;
            if (this.m_connection.getFQID().indexOf(36) != -1 && this.getTopLevelAncestor() instanceof WAWizardDialog && (serverComponent = (ServerComponent)(parent = (WAWizardDialog)this.getTopLevelAncestor()).getWizardData("DeployedComponent")).getClassIdentifier().equalsIgnoreCase("SASIOLA")) {
                for (index = 0; index < serverComponent.getExtensions().size(); ++index) {
                    Extension extension = (Extension)serverComponent.getExtensions().get(index);
                    Workspace.getMdFactory().deleteMetadataObject((CMetadata)extension);
                    --index;
                }
                boolean bIsSMP = false;
                lstProperties = serverComponent.getProperties();
                for (Property property : lstProperties) {
                    if (!property.getPropertyName().equalsIgnoreCase("SMPMODE")) continue;
                    bIsSMP = property.getDefaultValue().equalsIgnoreCase("1");
                    break;
                }
                List<String[]> lstExtensions = this.getExtendedAttributes();
                for (int extIndex = 0; extIndex < lstExtensions.size(); ++extIndex) {
                    Extension extension;
                    if (bIsSMP) {
                        if (!lstExtensions.get(extIndex)[0].equalsIgnoreCase("VA.TextAnalyticsSMPBinaryLocation")) continue;
                        extension = (Extension)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_connection.getObjectStore(), null, "Extension", "Extension", this.m_strReposID.substring(9));
                        extension.setName("VA.TextAnalyticsBinaryLocation", 1);
                        extension.setDesc(lstExtensions.get(extIndex)[1], 1);
                        extension.setValue(lstExtensions.get(extIndex)[2], 1);
                        serverComponent.getExtensions().add((Object)extension);
                        continue;
                    }
                    if (!lstExtensions.get(extIndex)[0].equalsIgnoreCase("VA.TextAnalyticsMPPBinaryLocation")) continue;
                    extension = (Extension)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_connection.getObjectStore(), null, "Extension", "Extension", this.m_strReposID.substring(9));
                    extension.setName("VA.TextAnalyticsBinaryLocation", 1);
                    extension.setDesc(lstExtensions.get(extIndex)[1], 1);
                    extension.setValue(lstExtensions.get(extIndex)[2], 1);
                    serverComponent.getExtensions().add((Object)extension);
                }
            }
            String strValue = this.m_txtSigner.getText();
            Property propPrototype = null;
            for (index = 0; index < this.m_lstProperties.size(); ++index) {
                Property property = this.m_lstProperties.get(index);
                if (!property.getPropertyName().equalsIgnoreCase("SIGNER")) continue;
                propPrototype = property;
                break;
            }
            if (!this.m_chkSigner.isSelected()) {
                AssociationList lstProperties2 = this.m_connection.getProperties();
                for (int index2 = 0; index2 < lstProperties2.size(); ++index2) {
                    Property property = (Property)lstProperties2.get(index2);
                    if (!property.getPropertyName().equalsIgnoreCase("SIGNER")) continue;
                    this.m_connection.getProperties().remove((Object)property);
                    PrototypeUtil.deleteProperty(property);
                    break;
                }
                return;
            }
            boolean bPropertyFound = false;
            lstProperties = this.m_connection.getProperties();
            for (int index3 = 0; index3 < lstProperties.size(); ++index3) {
                Property property = (Property)lstProperties.get(index3);
                if (!property.getPropertyName().equalsIgnoreCase("SIGNER")) continue;
                if (!strValue.equalsIgnoreCase(property.getDefaultValue())) {
                    property.setDefaultValue(strValue);
                }
                bPropertyFound = true;
                break;
            }
            if (!bPropertyFound) {
                Property property = PrototypeUtil.createProperty(propPrototype, (MdObjectStore)this.m_connection.getObjectStore(), this.m_strReposID);
                property.setDefaultValue(strValue);
                this.m_connection.getProperties().add((Object)property);
            }
        }
        catch (MdException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public void moveDataToView() {
        String strDefaultValue = new String();
        try {
            TCPIPConnection connection;
            String strTemplate = "<TEMPLATES><TCPIPConnection><Source/></TCPIPConnection></TEMPLATES>";
            String strSelect = "<XMLSELECT search=\"*[@Name='Connection URI'][Source/DeployedComponent[@ClassIdentifier='LASRKeyRegistrationService REST']]\"/>";
            String strOptions = strTemplate + strSelect;
            int flags = 8604;
            List lstConnections = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_connection.getObjectStore(), "A0000001." + this.m_connection.getRepositoryID(), "TCPIPConnection", flags, strOptions);
            int connIndex = 0;
            if (connIndex < lstConnections.size() && (strDefaultValue = (connection = (TCPIPConnection)lstConnections.get(connIndex)).getCommunicationProtocol() + "://" + connection.getHostName() + ":" + connection.getPort() + connection.getService()).endsWith("/register")) {
                strDefaultValue = strDefaultValue.substring(0, strDefaultValue.indexOf("/register"));
            }
            if (lstConnections.size() == 0) {
                this.m_chkSigner.setEnabled(false);
                this.m_chkSigner.setSelected(false);
            }
            boolean bPropertyFound = false;
            AssociationList lstProperties = this.m_connection.getProperties();
            for (int index = 0; index < lstProperties.size(); ++index) {
                Property property = (Property)lstProperties.get(index);
                if (!property.getPropertyName().equalsIgnoreCase("SIGNER")) continue;
                this.m_chkSigner.setSelected(true);
                bPropertyFound = true;
                break;
            }
            if (this.m_connection.getFQID().indexOf(36) == -1 && !bPropertyFound) {
                this.m_chkSigner.setSelected(false);
            }
        }
        catch (MdException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        this.m_txtSigner.setText(strDefaultValue);
        this.onEnableURI();
    }

    protected void onEnableURI() {
        this.m_txtSigner.setEnabled(this.m_chkSigner.isSelected());
    }

    public String createFinishString() {
        String strFinish = new String();
        if (this.m_chkSigner.isSelected()) {
            strFinish = m_bundle.getString("SignerPanel.Label.Signer.txt") + "\n\t" + this.m_txtSigner.getText().trim() + "\n";
        }
        return strFinish;
    }

    private List<String[]> getExtendedAttributes() throws RemoteException, MdException {
        ArrayList<String[]> lstExtensions = new ArrayList<String[]>();
        String strTemplate = "<TEMPLATES><SoftwareComponent><PropertySets/></SoftwareComponent><PropertySet><SetProperties/></PropertySet></TEMPLATES>";
        String strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='vacommon']\"/>";
        String strOptions = strTemplate + strSelect;
        int flags = 8604;
        List lstSoftwareComponents = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_connection.getObjectStore(), this.m_strReposID, "SoftwareComponent", flags, strOptions);
        if (lstSoftwareComponents.size() > 0) {
            SoftwareComponent sc = (SoftwareComponent)lstSoftwareComponents.get(0);
            AssociationList lstSet = sc.getPropertySets();
            for (PropertySet set : lstSet) {
                if (!set.getPropertySetName().equalsIgnoreCase("Application Configuration")) continue;
                AssociationList lstProperties = set.getSetProperties();
                for (Property property : lstProperties) {
                    if (!property.getPropertyName().equalsIgnoreCase("VA.TextAnalyticsSMPBinaryLocation") && !property.getPropertyName().equalsIgnoreCase("VA.TextAnalyticsMPPBinaryLocation")) continue;
                    String strName = property.getPropertyName();
                    String strDesc = property.getDesc();
                    String strValue = property.getDefaultValue();
                    lstExtensions.add(new String[]{strName, strDesc, strValue});
                }
            }
        }
        return lstExtensions;
    }

    protected void initialize() {
        this.m_chkSigner = new JCheckBox(m_bundle.getString("SignerPanel.Label.Signer.txt"));
        this.m_chkSigner.setSelected(true);
        this.m_chkSigner.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SignerPanel.this.onEnableURI();
            }
        });
        this.m_txtSigner = new WATextField(20);
        this.m_txtSigner.setEditable(false);
    }

    protected void layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_chkSigner, gbc);
        this.add(this.m_chkSigner);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 12, 0, 0);
        gridBagLayout.setConstraints((Component)this.m_txtSigner, gbc);
        this.add((Component)this.m_txtSigner);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }
}

