/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.iom;

import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMCustomizer;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMPortListCustomizer;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMProperty;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMPropertyList;
import com.sas.workspace.mgmt.visuals.customizers.iom.MachineList;
import java.awt.Dialog;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class MachineListCustomizer
extends IOMCustomizer {
    private static final long serialVersionUID = 1L;
    protected MachineList m_machineList;

    public MachineListCustomizer(Root root, List groupPropertiesList, int viewType) {
        super(root, groupPropertiesList, viewType);
    }

    public static Machine findMachine(Root object, String hostName) {
        int flags = 384;
        String strTemplate = "<XMLSelect search=\"*[@Name='" + hostName + "']\"/>";
        List machines = new Vector();
        try {
            machines = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(object.getObjectStore(), "A0000001." + object.getRepositoryID(), "Machine", flags, strTemplate);
            return (Machine)machines.get(0);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return null;
    }

    @Override
    protected void initialize() {
        try {
            if (this.m_root instanceof ServerComponent) {
                this.m_iomProps = new IOMPropertyList();
                for (int i = 0; i < this.m_propList.size(); ++i) {
                    try {
                        IOMProperty iomProp;
                        if (this.m_propList.get(i) instanceof AssociationProperty && ((AssociationProperty)this.m_propList.get(i)).getMetadataType().equals("Tree")) {
                            this.m_machineList = new MachineList((ServerComponent)this.m_root, (AssociationProperty)this.m_propList.get(i), this.m_viewType);
                            this.setName(((AssociationProperty)this.m_propList.get(i)).getAssociatedPropertyGroup().getName());
                            iomProp = this.m_machineList;
                        } else {
                            iomProp = new IOMProperty((CMetadata)this.m_root, (AbstractProperty)this.m_propList.get(i), this.m_viewType);
                        }
                        this.m_iomProps.add(iomProp);
                        continue;
                    }
                    catch (IOMProperty.IllegalPropertyTypeException ex) {
                        if (this.m_propList.get(i) instanceof Property && ((Property)this.m_propList.get(i)).getPropertyName().equals("DummyProperty")) continue;
                        MessageUtil.displayDetailsMessage((String)IOMProperty.getDisplayString(0, "MachineList.Error.PropertyError.Message.xmlKey.txt"), (int)0, (int)2, (JComponent)null);
                        continue;
                    }
                    catch (MdException ex) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                        continue;
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                }
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    @Override
    public void moveDataToView() throws MdException, RemoteException {
        if (this.m_machineList != null) {
            this.removePPVFormatting();
            this.m_machineList.setOwningDialog((Dialog)this.getTopLevelAncestor());
            super.moveDataToView();
        }
    }

    @Override
    public boolean validateData() {
        if (this.m_machineList != null && this.m_machineList.getMachines().size() == 0) {
            JOptionPane.showMessageDialog(((Dialog)this.getTopLevelAncestor()).getOwner(), IOMProperty.getDisplayString(1, "MachineList.NeedMachine.Message.xmlKey.txt"), IOMProperty.getDisplayString(1, "MachineList.NeedMachine.Title.xmlKey.txt"), 0);
            return false;
        }
        return super.validateData();
    }

    @Override
    public String createFinishString() {
        if (this.m_viewType == 0) {
            try {
                ServerComponent server = (ServerComponent)this.m_root;
                if (server.getPublicType().equals("Spawner.IOM")) {
                    IOMPortListCustomizer.setRootConnectionHostName("Operator", server);
                } else {
                    IOMPortListCustomizer.setRootConnectionHostName("Bridge", server);
                    IOMPortListCustomizer.setRootConnectionHostName("MultiBridge", server);
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return super.createFinishString();
    }
}

