/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.iom;

import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AttributeProperty;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMCustomizer;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMProperty;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;

public class IOMServerPropertiesCustomizer
extends IOMCustomizer {
    private static final long serialVersionUID = 1L;
    protected JPanel m_propPanel;
    protected String m_propGroupName;

    public IOMServerPropertiesCustomizer(Root root, List groupPropertiesList, int viewType) {
        super(root, groupPropertiesList, viewType);
    }

    private static Root _getLogicalServerTypeObject(IOMCustomizer object, ServerComponent comp, int viewType) {
        try {
            AssociationList comps = comp.getUsedByComponents();
            LogicalServer ls = null;
            if (comps.size() == 1) {
                ls = (LogicalServer)comp.getUsedByComponents().get(0);
            } else if (viewType == 0) {
                Container cont;
                for (cont = object.getTopLevelAncestor(); cont != null && !(cont instanceof WAWizardDialog); cont = cont.getParent()) {
                }
                if (cont == null) {
                    return null;
                }
                WAWizardDialog wizard = (WAWizardDialog)cont;
                ls = (LogicalServer)wizard.getWizardData("LogicalServer");
            }
            if (ls == null) {
                return null;
            }
            for (int i = 0; i < ls.getInitProcesses().size(); ++i) {
                if (!((Transformation)ls.getInitProcesses().get(i)).getTransformRole().equals("Load Balancing")) continue;
                return (Transformation)ls.getInitProcesses().get(i);
            }
            for (int j = 0; j < ls.getSoftwareTrees().size(); ++j) {
                if (!((Tree)ls.getSoftwareTrees().get(j)).getTreeType().equals("Pooling")) continue;
                return (Tree)ls.getSoftwareTrees().get(j);
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        return null;
    }

    protected Root getLogicalServerTypeObject() {
        if (this.m_root instanceof ServerComponent) {
            return IOMServerPropertiesCustomizer._getLogicalServerTypeObject(this, (ServerComponent)this.m_root, this.m_viewType);
        }
        return null;
    }

    protected static Root getLogicalServerTypeObject(IOMCustomizer object, ServerComponent comp, int viewType) {
        return IOMServerPropertiesCustomizer._getLogicalServerTypeObject(object, comp, viewType);
    }

    @Override
    protected void initialize() {
        try {
            this.m_propGroupName = IOMProperty.getDisplayString(1, ((AbstractProperty)this.m_propList.get(0)).getAssociatedPropertyGroup().getName());
            this.setName(this.m_propGroupName);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        super.initialize();
    }

    @Override
    protected void layoutWidgets() {
        try {
            super.layoutWidgets();
            Component[] comps = this.getComponents();
            this.m_propPanel = (JPanel)comps[comps.length - 1];
            GridBagConstraints gbc = ((GridBagLayout)this.getLayout()).getConstraints(this.m_propPanel);
            gbc.insets = new Insets(12, 0, 0, 0);
            ((GridBagLayout)this.getLayout()).setConstraints(this.m_propPanel, gbc);
            Root lsobj = this.getLogicalServerTypeObject();
            for (int i = 0; i < this.m_iomProps.size(); ++i) {
                String role;
                IOMProperty iomProp = this.m_iomProps.get(i);
                AbstractProperty metaProp = iomProp.getMetadataProperty();
                if (metaProp instanceof Property) {
                    role = ((Property)metaProp).getPropertyRole();
                } else {
                    if (!(metaProp instanceof AttributeProperty)) continue;
                    role = ((AttributeProperty)metaProp).getPropertyRole();
                }
                if (role.length() == 0 || this.showProperty(lsobj, role)) continue;
                iomProp.setEnabled(false);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected List parseRoleAttribute(String role) {
        Vector<String> pairs = new Vector<String>();
        int pos = role.indexOf(":");
        if (pos == -1) {
            pairs.add(role);
        } else {
            pairs.add(role.substring(0, pos));
            role = role.substring(pos + 1, role.length());
            pos = 0;
            while (pos != -1) {
                pos = role.indexOf(":");
                String pair = pos != -1 ? role.substring(0, pos) : role;
                int pos2 = pair.indexOf("(");
                pairs.add(pair.substring(0, pos2));
                pairs.add(pair.substring(pos2 + 1, pair.length() - 1));
                role = role.substring(pos + 1, role.length());
            }
        }
        return pairs;
    }

    protected boolean showProperty(Root lsobj, String role) {
        try {
            if (role.length() == 0) {
                return true;
            }
            List pairs = this.parseRoleAttribute(role);
            String type = (String)pairs.get(0);
            if (lsobj == null) {
                return false;
            }
            if (!(lsobj instanceof Transformation) && !(lsobj instanceof Tree)) {
                return false;
            }
            if (lsobj instanceof Transformation && !((Transformation)lsobj).getTransformRole().equals(type)) {
                return false;
            }
            if (lsobj instanceof Tree && !((Tree)lsobj).getTreeType().equals(type)) {
                return false;
            }
            if (pairs.size() > 1) {
                if (lsobj instanceof Tree) {
                    return false;
                }
                try {
                    AssociationList properties = lsobj.getProperties();
                    block5: for (int j = 1; j < pairs.size(); j += 2) {
                        String name = (String)pairs.get(j);
                        String value = (String)pairs.get(j + 1);
                        for (int i = 0; i < properties.size(); ++i) {
                            Property prop = (Property)properties.get(i);
                            if (!prop.getPropertyName().equals(name)) continue;
                            if (prop.getDefaultValue().equals(value)) continue block5;
                            return false;
                        }
                    }
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                    return false;
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                }
            }
            return true;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }
}

