/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.iom;

import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextField;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.TitledSeparator;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMCustomizer;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMProperty;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMPropertyList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class IOMSecurityCustomizer
extends IOMCustomizer {
    private static final long serialVersionUID = 1L;
    private IOMProperty m_enableSACS;
    private String m_authSrvName;
    private JRadioButton m_radHost;
    private IOMProperty m_package;
    private IOMProperty m_SPN;
    private JRadioButton m_radMeta;
    private boolean m_isCSP;
    private IOMProperty m_packList;
    private String m_defAuthServ;
    private boolean m_isMUser;
    private boolean m_isWKSP;
    private JRadioButton m_radPrompt;

    public IOMSecurityCustomizer(Root root, List groupPropertiesList, int viewType) {
        super(root, groupPropertiesList, viewType);
    }

    @Override
    protected void initialize() {
        try {
            this.m_iomProps = new IOMPropertyList();
            boolean isLB = false;
            this.m_isCSP = false;
            this.m_isWKSP = false;
            if (this.m_root instanceof LogicalServer) {
                LogicalServer ls = (LogicalServer)this.m_root;
                String classID = ls.getClassIdentifier();
                if (classID.equalsIgnoreCase("15931E31-667F-11D5-8804-00C04F35AC8C") || classID.equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb") || classID.equalsIgnoreCase("e803e04b-aaf0-4c74-86a6-f7008aa702dc") || classID.equalsIgnoreCase("f3f46472-1e31-11d5-87c2-00c04f38f9f6")) {
                    if (classID.equals("15931E31-667F-11D5-8804-00C04F35AC8C") || classID.equals("620963ee-32bf-4128-bf5f-4b0df8ff90eb")) {
                        isLB = true;
                    }
                    this.m_isMUser = true;
                } else if (classID.equals("440196D4-90F0-11D0-9F41-00A024BB830C")) {
                    this.m_isWKSP = true;
                    try {
                        int i;
                        AssociationList assocs = ls.getInitProcesses();
                        for (i = 0; i < assocs.size() && !isLB; ++i) {
                            if (!(assocs.get(i) instanceof Transformation) || !((Transformation)assocs.get(i)).getTransformRole().equals("Load Balancing")) continue;
                            isLB = true;
                        }
                        if (!isLB) {
                            assocs = ls.getSoftwareTrees();
                            for (i = 0; i < assocs.size() && !this.m_isCSP; ++i) {
                                if (!(assocs.get(i) instanceof Tree) || !((Tree)assocs.get(i)).getTreeType().equals("Pooling")) continue;
                                this.m_isCSP = true;
                            }
                        }
                    }
                    catch (MdException ex) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                    }
                    catch (RemoteException re) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                    }
                }
            }
            for (int i = 0; i < this.m_propList.size(); ++i) {
                try {
                    if (!(this.m_propList.get(i) instanceof Property)) continue;
                    AbstractProperty prop = (AbstractProperty)this.m_propList.get(i);
                    String propName = ((Property)prop).getPropertyName();
                    if (propName.equalsIgnoreCase("AuthService") && prop.getIsVisible() == 1) {
                        this.m_defAuthServ = ((Property)prop).getDefaultValue();
                        this.m_authSrvName = IOMProperty.getDisplayString(1, prop.getName());
                        this.m_radHost = new JRadioButton(IOMProperty.getDisplayString(1, "LogicalServer.AuthService.Host.Value.xmlKey.txt"));
                        this.m_radHost.setToolTipText(IOMProperty.getDisplayString(1, "LogicalServer.AuthService.Host.Desc.xmlKey.txt"));
                        IOMProperty.setMnemonic(this.m_radHost, 1, "LogicalServer.AuthService.Host.Value.xmlKey.txt");
                        this.m_radMeta = new JRadioButton(IOMProperty.getDisplayString(1, "LogicalServer.AuthService.Metadata.Value.xmlKey.txt"));
                        this.m_radMeta.setToolTipText(IOMProperty.getDisplayString(1, "LogicalServer.AuthService.Metadata.Desc.xmlKey.txt"));
                        IOMProperty.setMnemonic(this.m_radMeta, 1, "LogicalServer.AuthService.Metadata.Value.xmlKey.txt");
                        this.m_radPrompt = new JRadioButton(IOMProperty.getDisplayString(1, "LogicalServer.AuthService.Prompt.Value.xmlKey.txt"));
                        this.m_radPrompt.setToolTipText(IOMProperty.getDisplayString(1, "LogicalServer.AuthService.Prompt.Desc.xmlKey.txt"));
                        IOMProperty.setMnemonic(this.m_radPrompt, 1, "LogicalServer.AuthService.Prompt.Value.xmlKey.txt");
                        ButtonGroup btnGroup = new ButtonGroup();
                        btnGroup.add(this.m_radHost);
                        btnGroup.add(this.m_radMeta);
                        btnGroup.add(this.m_radPrompt);
                        this.m_radHost.addItemListener(new ItemListener(){

                            @Override
                            public void itemStateChanged(ItemEvent e) {
                                if (e.getStateChange() == 1) {
                                    if (IOMSecurityCustomizer.this.m_isMUser && IOMSecurityCustomizer.this.m_enableSACS != null && IOMSecurityCustomizer.this.m_enableSACS.getDataValue().equals("True")) {
                                        JOptionPane.showMessageDialog(IOMSecurityCustomizer.this.m_radHost.getTopLevelAncestor(), IOMProperty.getDisplayString(0, "SecurityDialog.TrustedUser.Warning.Message.xmlKey.txt"), IOMProperty.getDisplayString(0, "SecurityDialog.TrustedUser.Warning.Title.xmlKey.txt"), 2);
                                    }
                                    if (IOMSecurityCustomizer.this.m_package != null) {
                                        IOMSecurityCustomizer.this.m_package.setEnabled(true);
                                        if (e.getStateChange() == 1) {
                                            boolean useSPN = IOMSecurityCustomizer.this.m_package.getDataValue().equals("Kerberos") || IOMSecurityCustomizer.this.m_package.getDataValue().equals("Negotiate");
                                            boolean usePack = IOMSecurityCustomizer.this.m_package.getDataValue().equals("Negotiate");
                                            if (IOMSecurityCustomizer.this.m_SPN != null) {
                                                IOMSecurityCustomizer.this.m_SPN.setEnabled(useSPN);
                                            }
                                            if (IOMSecurityCustomizer.this.m_packList != null) {
                                                IOMSecurityCustomizer.this.m_packList.setEnabled(usePack);
                                            }
                                        }
                                    }
                                }
                            }
                        });
                        this.m_radMeta.addItemListener(new ItemListener(){

                            @Override
                            public void itemStateChanged(ItemEvent e) {
                                if (e.getStateChange() == 1) {
                                    if (IOMSecurityCustomizer.this.m_package != null) {
                                        IOMSecurityCustomizer.this.m_package.setEnabled(false);
                                    }
                                    if (IOMSecurityCustomizer.this.m_SPN != null) {
                                        IOMSecurityCustomizer.this.m_SPN.setEnabled(false);
                                    }
                                    if (IOMSecurityCustomizer.this.m_packList != null) {
                                        IOMSecurityCustomizer.this.m_packList.setEnabled(false);
                                    }
                                }
                            }
                        });
                        this.m_radPrompt.addItemListener(new ItemListener(){

                            @Override
                            public void itemStateChanged(ItemEvent e) {
                                if (IOMSecurityCustomizer.this.m_isMUser && IOMSecurityCustomizer.this.m_enableSACS != null && IOMSecurityCustomizer.this.m_enableSACS.getDataValue().equals("True")) {
                                    JOptionPane.showMessageDialog(IOMSecurityCustomizer.this.m_radPrompt.getTopLevelAncestor(), IOMProperty.getDisplayString(0, "SecurityDialog.TrustedUser.Warning.Message.xmlKey.txt"), IOMProperty.getDisplayString(0, "SecurityDialog.TrustedUser.Warning.Title.xmlKey.txt"), 2);
                                }
                                if (e.getStateChange() == 1) {
                                    if (IOMSecurityCustomizer.this.m_package != null) {
                                        IOMSecurityCustomizer.this.m_package.setEnabled(false);
                                    }
                                    if (IOMSecurityCustomizer.this.m_SPN != null) {
                                        IOMSecurityCustomizer.this.m_SPN.setEnabled(false);
                                    }
                                    if (IOMSecurityCustomizer.this.m_packList != null) {
                                        IOMSecurityCustomizer.this.m_packList.setEnabled(false);
                                    }
                                }
                            }
                        });
                        continue;
                    }
                    if (propName.equalsIgnoreCase("EnableSACS") && prop.getIsVisible() == 1) {
                        this.m_enableSACS = new SACSProperty((CMetadata)this.m_root, prop, this.m_viewType);
                        this.m_enableSACS.addDivider(IOMProperty.getDisplayString(1, "LogicalServer.Security.Property.SACS.Name2.xmlKey.txt"));
                        if (this.m_isCSP) {
                            this.m_enableSACS.setPropertyValue("False");
                            this.m_enableSACS.setEnabled(false);
                        }
                        this.m_enableSACS.addItemListener(new ItemListener(){

                            @Override
                            public void itemStateChanged(ItemEvent e) {
                                if (e.getStateChange() == 1 && IOMSecurityCustomizer.this.m_isMUser && IOMSecurityCustomizer.this.m_radMeta != null && !IOMSecurityCustomizer.this.m_radMeta.isSelected()) {
                                    JOptionPane.showMessageDialog(IOMSecurityCustomizer.this.m_radMeta.getTopLevelAncestor(), IOMProperty.getDisplayString(0, "SecurityDialog.TrustedUser.Warning.Message.xmlKey.txt"), IOMProperty.getDisplayString(0, "SecurityDialog.TrustedUser.Warning.Title.xmlKey.txt"), 2);
                                }
                            }
                        });
                        continue;
                    }
                    if (propName.equalsIgnoreCase("SecurityPackage") && prop.getIsVisible() == 1) {
                        this.m_package = new AuthorizationTypeProperty((CMetadata)this.m_root, prop, this.m_viewType);
                        this.m_package.addItemListener(new ItemListener(){

                            @Override
                            public void itemStateChanged(ItemEvent e) {
                                if (e.getStateChange() == 1) {
                                    boolean useSPN = IOMSecurityCustomizer.this.m_package.getDataValue().equals("Kerberos") || IOMSecurityCustomizer.this.m_package.getDataValue().equals("Negotiate");
                                    boolean usePack = IOMSecurityCustomizer.this.m_package.getDataValue().equals("Negotiate");
                                    if (IOMSecurityCustomizer.this.m_SPN != null) {
                                        IOMSecurityCustomizer.this.m_SPN.setEnabled(useSPN);
                                    }
                                    if (IOMSecurityCustomizer.this.m_packList != null) {
                                        IOMSecurityCustomizer.this.m_packList.setEnabled(usePack);
                                    }
                                }
                            }
                        });
                        this.m_package.setEnabled(!this.m_isCSP);
                        continue;
                    }
                    if (propName.equalsIgnoreCase("SPN") && prop.getIsVisible() == 1) {
                        this.m_SPN = new AuthorizationTypeProperty((CMetadata)this.m_root, prop, this.m_viewType);
                        this.m_SPN.setEnabled(!this.m_isCSP && this.m_package != null && (this.m_package.getDataValue().equals("Negotiate") || this.m_package.getDataValue().equals("Kerberos")));
                        continue;
                    }
                    if (!propName.equalsIgnoreCase("SecurityPackageList") || prop.getIsVisible() != 1) continue;
                    this.m_packList = new AuthorizationTypeProperty((CMetadata)this.m_root, prop, this.m_viewType);
                    this.m_packList.setEnabled(this.m_package != null && this.m_package.getDataValue().equals("Negotiate"));
                    continue;
                }
                catch (IOMProperty.IllegalPropertyTypeException illegalPropertyTypeException) {
                    // empty catch block
                }
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    @Override
    protected void layoutWidgets() {
        GridBagConstraints gbc;
        int gridx = 0;
        int gridy = 0;
        JPanel panel = new JPanel();
        GridBagLayout gbLayout = new GridBagLayout();
        panel.setLayout(gbLayout);
        if (this.m_enableSACS != null) {
            this.m_enableSACS.addPropertyToPanel(panel);
        }
        if (this.m_radHost != null && this.m_radMeta != null && this.m_radPrompt != null) {
            gridy = IOMProperty.getNextComponentHorizontalGridValue(panel);
            gbc = new GridBagConstraints();
            gbc.gridwidth = 0;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.gridx = gridx;
            gbc.gridy = gridy++;
            TitledSeparator sep = new TitledSeparator(this.m_authSrvName);
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 12, 6, 0);
            gbLayout.setConstraints(sep, gbc);
            panel.add(sep);
            gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.gridx = gridx;
            gbc.gridy = gridy++;
            gbc.insets = new Insets(0, 24, 0, 0);
            gbLayout.setConstraints(this.m_radHost, gbc);
            panel.add(this.m_radHost);
            if (this.m_package != null) {
                this.m_package.addPropertyToPanel(panel);
                ++gridy;
            }
            if (this.m_SPN != null) {
                this.m_SPN.addPropertyToPanel(panel);
                ++gridy;
            }
            if (this.m_packList != null) {
                this.m_packList.addPropertyToPanel(panel);
                ++gridy;
            }
            gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.gridx = gridx;
            gbc.gridy = gridy++;
            gbc.insets = new Insets(0, 24, 0, 0);
            gbLayout.setConstraints(this.m_radMeta, gbc);
            panel.add(this.m_radMeta);
            gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.gridx = gridx;
            gbc.gridy = gridy++;
            gbc.insets = new Insets(0, 24, 0, 0);
            gbLayout.setConstraints(this.m_radPrompt, gbc);
            panel.add(this.m_radPrompt);
        } else {
            gridy = IOMProperty.getNextComponentHorizontalGridValue(panel);
            gbc = new GridBagConstraints();
            gbc.gridwidth = 0;
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.gridx = gridx;
            gbc.gridy = gridy;
            JPanel blank = new JPanel();
            blank.setPreferredSize(new Dimension(475, 10));
            ((GridBagLayout)panel.getLayout()).setConstraints(blank, gbc);
            panel.add(blank);
        }
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        ((GridBagLayout)panel.getLayout()).setConstraints(eaterPanel, gbc);
        panel.add(eaterPanel);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbLayout.setConstraints(panel, gbc);
        this.add(panel);
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        if (this.m_enableSACS != null) {
            this.m_enableSACS.writeProperty();
        }
        if (this.m_radHost != null && this.m_radMeta != null && this.m_radPrompt != null) {
            Property prop;
            String value = "";
            if (this.m_radHost.isSelected()) {
                value = "Host";
                if (this.m_isWKSP) {
                    this.removeWorkspaceCredentials();
                }
            } else if (this.m_radMeta.isSelected()) {
                value = "Metadata";
            } else if (this.m_radPrompt.isSelected()) {
                value = "Prompt";
            }
            AssociationList propList = this.m_root.getProperties(false);
            boolean found = false;
            for (int i = 0; i < propList.size() && !found; ++i) {
                prop = (Property)propList.get(i);
                if (prop == null || !prop.getPropertyName().equals("AuthService")) continue;
                found = true;
                if (prop.getDefaultValue().equalsIgnoreCase(value)) continue;
                prop.setDefaultValue(value);
                propList.set(i, (Object)prop);
            }
            if (!found) {
                prop = (Property)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_root.getObjectStore(), null, this.m_authSrvName, "Property", this.m_root.getRepositoryID(), null);
                prop.setPropertyName("AuthService");
                prop.setDefaultValue(value);
                prop.setOwningType(IOMProperty.createStringPropertyType((CMetadata)this.m_root));
                propList.add((Object)prop);
            }
            if (this.m_radMeta.isSelected() || this.m_radPrompt.isSelected()) {
                if (this.m_package != null) {
                    this.m_package.deleteProperty();
                }
                if (this.m_SPN != null) {
                    this.m_SPN.deleteProperty();
                }
                if (this.m_packList != null) {
                    this.m_packList.deleteProperty();
                }
            } else if (this.m_radHost.isSelected() && this.m_package != null) {
                if (this.m_package.getDataValue().equals("")) {
                    this.m_package.deleteProperty();
                } else {
                    this.m_package.writeProperty();
                }
                boolean useSPN = this.m_package.getDataValue().equals("Kerberos") || this.m_package.getDataValue().equals("Negotiate");
                boolean usePack = this.m_package.getDataValue().equals("Negotiate");
                if (this.m_SPN != null) {
                    if (!this.m_SPN.getDataValue().equals("") && useSPN) {
                        this.m_SPN.writeProperty();
                    } else {
                        this.m_SPN.deleteProperty();
                    }
                }
                if (this.m_packList != null) {
                    if (!this.m_packList.getDataValue().equals("") && usePack) {
                        this.m_packList.writeProperty();
                    } else {
                        this.m_packList.deleteProperty();
                    }
                }
            }
        }
    }

    @Override
    public void moveDataToView() throws MdException, RemoteException {
        this.removePPVFormatting();
        if (this.m_enableSACS != null) {
            this.m_enableSACS.readProperty();
        }
        if (this.m_radHost != null && this.m_radMeta != null && this.m_radPrompt != null) {
            if (this.m_isCSP) {
                this.m_radHost.setSelected(true);
                this.m_radMeta.setEnabled(false);
                this.m_radPrompt.setEnabled(false);
                if (this.m_package != null) {
                    this.m_package.setPropertyValue("Password");
                    this.m_package.setEnabled(false);
                }
                if (this.m_SPN != null) {
                    this.m_SPN.setEnabled(false);
                }
                if (this.m_packList != null) {
                    this.m_packList.setEnabled(false);
                }
            } else {
                Property prop;
                AssociationList propList = this.m_root.getProperties(false);
                boolean found = false;
                for (int i = 0; i < propList.size() && !found; ++i) {
                    prop = (Property)propList.get(i);
                    if (!prop.getPropertyName().equals("AuthService")) continue;
                    found = true;
                    String value = prop.getDefaultValue();
                    if (value.equals("Metadata")) {
                        this.m_radMeta.setSelected(true);
                        continue;
                    }
                    if (value.equals("Prompt")) {
                        this.m_radPrompt.setSelected(true);
                        continue;
                    }
                    this.m_radHost.setSelected(true);
                }
                if (!found) {
                    prop = (Property)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_root.getObjectStore(), null, this.m_authSrvName, "Property", this.m_root.getRepositoryID(), null);
                    prop.setPropertyName("AuthService");
                    if (this.m_defAuthServ.equalsIgnoreCase("Metadata")) {
                        prop.setDefaultValue("Metadata");
                        this.m_radMeta.setSelected(true);
                    } else if (this.m_defAuthServ.equalsIgnoreCase("Prompt")) {
                        prop.setDefaultValue("Prompt");
                        this.m_radPrompt.setSelected(true);
                    } else {
                        prop.setDefaultValue("Host");
                        this.m_radHost.setSelected(true);
                    }
                    prop.setSQLType(12);
                    propList.add((Object)prop);
                }
                if (this.m_package != null) {
                    this.m_package.readProperty();
                }
                if (this.m_SPN != null) {
                    this.m_SPN.readProperty();
                }
                if (this.m_packList != null) {
                    this.m_packList.readProperty();
                }
            }
        }
    }

    @Override
    protected void removePPVFormatting() {
        Container parent = this.getParent();
        Component[] comps = parent.getComponents();
        if (comps.length == 0) {
            return;
        }
        if (parent.getLayout() instanceof GridBagLayout) {
            GridBagLayout layout = (GridBagLayout)parent.getLayout();
            comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                GridBagConstraints gbc = layout.getConstraints(comps[i]);
                gbc.insets.top = 0;
                layout.setConstraints(comps[i], gbc);
            }
        }
    }

    private void removeWorkspaceCredentials() throws MdException, RemoteException {
        AssociationList comps = ((LogicalServer)this.m_root).getUsingComponents();
        block0: for (int i = 0; i < comps.size(); ++i) {
            int j;
            ServerComponent sc = (ServerComponent)comps.get(i);
            AssociationList ips = sc.getInitProcesses();
            AssociationList props = sc.getProperties();
            block1: for (j = 0; j < ips.size(); ++j) {
                if (!(ips.get(j) instanceof Transformation) || !((Transformation)ips.get(j)).getTransformRole().equals("Initialization")) continue;
                Transformation trans = (Transformation)ips.get(j);
                AssociationList tSources = trans.getTransformationSources();
                for (int k = 0; k < tSources.size(); ++k) {
                    if (!(tSources.get(k) instanceof Login)) continue;
                    tSources.remove(k);
                    continue block1;
                }
            }
            for (j = 0; j < props.size(); ++j) {
                if (!((Property)props.get(j)).getPropertyName().equals("UseSpawnerID")) continue;
                props.remove(j);
                continue block0;
            }
        }
    }

    public class SACSProperty
    extends IOMProperty {
        public SACSProperty(CMetadata object, AbstractProperty metaProp, int viewType) {
            super(object, metaProp, viewType);
        }

        @Override
        public void addPropertyToPanel(JPanel panel) {
            GridBagConstraints gbc;
            if (!this.m_visible) {
                return;
            }
            int gridx = 0;
            int gridy = SACSProperty.getNextComponentHorizontalGridValue(panel);
            GridBagLayout gbLayout = (GridBagLayout)panel.getLayout();
            if (this.m_sep != null) {
                gbc = new GridBagConstraints();
                gbc.gridx = gridx;
                gbc.gridy = gridy++;
                gbc.weightx = 1.0;
                gbc.anchor = 17;
                gbc.fill = 2;
                gbc.gridwidth = 0;
                gbc.insets = new Insets(6, 12, 0, 0);
                gbLayout.setConstraints(this.m_sep, gbc);
                panel.add(this.m_sep);
            }
            try {
                SACSProperty.setMnemonic(this.m_data, 1, this.m_metaProp.getName());
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            gbc = new GridBagConstraints();
            gbc.gridx = gridx;
            gbc.gridy = gridy;
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            int indent = this.m_sep != null ? 24 : 12;
            gbc.insets = new Insets(6, indent, 6, 12);
            gbLayout.setConstraints(this.m_data, gbc);
            panel.add(this.m_data);
        }
    }

    public class AuthorizationTypeProperty
    extends IOMProperty {
        public AuthorizationTypeProperty(CMetadata object, AbstractProperty metaProp, int viewType) {
            super(object, metaProp, viewType);
            if (this.m_data instanceof WATextField) {
                ((WATextField)this.m_data).setColumns(30);
            }
        }

        @Override
        public void addPropertyToPanel(JPanel panel) {
            try {
                int gridx = 0;
                int gridy = AuthorizationTypeProperty.getNextComponentHorizontalGridValue(panel);
                GridBagLayout gbLayout = (GridBagLayout)panel.getLayout();
                ((JLabel)this.m_label).setLabelFor(this.m_data);
                AuthorizationTypeProperty.setMnemonic(this.m_label, 1, this.m_metaProp.getName());
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = gridx++;
                gbc.gridy = gridy;
                gbc.anchor = 17;
                gbc.insets = new Insets(6, 48, 6, 0);
                gbLayout.setConstraints(this.m_label, gbc);
                panel.add(this.m_label);
                gbc = new GridBagConstraints();
                gbc.gridx = gridx++;
                gbc.gridy = gridy;
                gbc.anchor = 17;
                gbc.weightx = 1.0;
                gbc.fill = 2;
                gbc.gridwidth = 0;
                gbc.insets = new Insets(6, 12, 6, 12);
                gbLayout.setConstraints(this.m_data, gbc);
                panel.add(this.m_data);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }
}

