/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.iom;

import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.visuals.TitledSeparator;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMProperty;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMPropertyList;
import com.sas.workspace.mgmt.visuals.customizers.iom.LoginProperty;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JPanel;

public class IOMCustomizer
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected Root m_root;
    protected List m_propList;
    protected IOMPropertyList m_iomProps;
    protected int m_viewType;
    public static final String IOM_OLAP_CLSID = "f3f46472-1e31-11d5-87c2-00c04f38f9f6";
    public static final String IOM_SPAWNER_CLSID = "IOM Spawner";
    public static final String IOM_STOREDPROCESS_CLSID = "15931E31-667F-11D5-8804-00C04F35AC8C";
    public static final String IOM_WORKSPACE_CLSID = "440196D4-90F0-11D0-9F41-00A024BB830C";
    public static final String IOM_POOLEDWORKSPACE_CLSID = "620963ee-32bf-4128-bf5f-4b0df8ff90eb";
    public static final String IOM_TKTS_CLSID = "e803e04b-aaf0-4c74-86a6-f7008aa702dc";
    protected static final String HELP_SET = "HelpSet";
    protected static final String HELP_TOPIC_SIMPLE = "HelpTopicSimple";
    protected static final String HELP_TOPIC_ADVANCED = "HelpTopicAdvanced";

    public IOMCustomizer(Root root, List groupPropertiesList, int viewType) {
        this.m_root = root;
        this.m_propList = groupPropertiesList;
        this.m_viewType = viewType;
        this.initialize();
        this.layoutWidgets();
    }

    public String createFinishString() {
        StringBuffer strFinish = new StringBuffer();
        for (int i = 0; i < this.m_iomProps.size(); ++i) {
            IOMProperty iomProp = this.m_iomProps.get(i);
            strFinish.append(iomProp);
        }
        return strFinish.toString();
    }

    protected void initialize() {
        this.m_iomProps = new IOMPropertyList();
        for (int i = 0; i < this.m_propList.size(); ++i) {
            try {
                AbstractProperty absProp = (AbstractProperty)this.m_propList.get(i);
                IOMProperty iomProp = absProp instanceof AssociationProperty && ((AssociationProperty)absProp).getMetadataType().equals("Login") ? new LoginProperty((CMetadata)this.m_root, (AssociationProperty)absProp, this.m_viewType) : new IOMProperty((CMetadata)this.m_root, (AbstractProperty)this.m_propList.get(i), this.m_viewType);
                this.m_iomProps.add(iomProp);
                continue;
            }
            catch (IOMProperty.IllegalPropertyTypeException illegalPropertyTypeException) {
                continue;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    protected void layoutWidgets() {
        GridBagLayout gbLayout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbLayout);
        JPanel propPanel = this.m_iomProps.getPropertiesPanel();
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = IOMProperty.getNextComponentHorizontalGridValue(propPanel);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        ((GridBagLayout)propPanel.getLayout()).setConstraints(eaterPanel, gbc);
        propPanel.add(eaterPanel);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbLayout.setConstraints(propPanel, gbc);
        this.add(propPanel);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        super.moveDataToStore();
        for (int i = 0; i < this.m_iomProps.size(); ++i) {
            IOMProperty iomProp = this.m_iomProps.get(i);
            iomProp.writeProperty();
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        super.moveDataToView();
        for (int i = 0; i < this.m_iomProps.size(); ++i) {
            IOMProperty iomProp = this.m_iomProps.get(i);
            iomProp.readProperty();
        }
    }

    protected void removePPVFormatting() {
        Container parent = this.getParent();
        Component[] comps = parent.getComponents();
        if (comps.length == 0) {
            return;
        }
        if (comps[0] instanceof TitledSeparator) {
            parent.remove(0);
        }
        if (parent.getLayout() instanceof GridBagLayout) {
            GridBagLayout layout = (GridBagLayout)parent.getLayout();
            comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!comps[i].getClass().equals(((Object)((Object)this)).getClass())) continue;
                GridBagConstraints gbc = layout.getConstraints(comps[i]);
                gbc.insets.left = 0;
                gbc.insets.top = 0;
                layout.setConstraints(comps[i], gbc);
                break;
            }
        }
    }

    public boolean validateData() {
        for (int i = 0; i < this.m_iomProps.size(); ++i) {
            this.m_iomProps.get(i).validateProperty();
            if (this.m_iomProps.get(i).isValid()) continue;
            return false;
        }
        return super.validateData();
    }
}

