/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.iom;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.COMConnection;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.Transformation;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMCustomizer;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMProperty;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMPropertyList;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMServerPropertiesCustomizer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JCheckBox;

public class COMConnectionCustomizer
extends IOMCustomizer {
    private static final long serialVersionUID = 1L;
    private JCheckBox m_checkBox;

    public COMConnectionCustomizer(Root root, List groupPropertiesList, int viewType) {
        super(root, groupPropertiesList, viewType);
    }

    private COMConnection getConnection() {
        COMConnection comConn = null;
        try {
            AssociationList conns = ((ServerComponent)this.m_root).getSourceConnections();
            for (int i = 0; i < conns.size(); ++i) {
                if (!(conns.get(i) instanceof COMConnection)) continue;
                comConn = (COMConnection)conns.get(i);
                break;
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        return comConn;
    }

    @Override
    protected void initialize() {
        try {
            if (!(this.m_root instanceof ServerComponent)) {
                return;
            }
            this.m_iomProps = new IOMPropertyList();
            AssociationProperty prop = null;
            for (int i = 0; i < this.m_propList.size(); ++i) {
                if (!(this.m_propList.get(i) instanceof AssociationProperty)) continue;
                prop = (AssociationProperty)this.m_propList.get(i);
                if (prop.getMetadataType().equals("COMConnection")) break;
                prop = null;
            }
            if (prop == null) {
                return;
            }
            this.m_checkBox = new JCheckBox(IOMProperty.getDisplayString(1, prop.getName()));
            this.m_checkBox.setToolTipText(IOMProperty.getDisplayString(1, prop.getDesc()));
            IOMProperty.setMnemonic(this.m_checkBox, 1, prop.getName());
            Root lsobj = IOMServerPropertiesCustomizer.getLogicalServerTypeObject(this, (ServerComponent)this.m_root, this.m_viewType);
            if (lsobj != null && lsobj instanceof Transformation && ((Transformation)lsobj).getTransformRole().equals("Load Balancing")) {
                this.m_checkBox.setEnabled(false);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    @Override
    protected void layoutWidgets() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 10, 0, 0);
        layout.setConstraints(this.m_checkBox, gbc);
        this.add(this.m_checkBox);
        WAPanel eater = new WAPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        layout.setConstraints((Component)eater, gbc);
        this.add((Component)eater);
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        COMConnection comConn = this.getConnection();
        if (this.m_checkBox.isSelected()) {
            if (comConn == null) {
                String name = this.m_root.getName() + " " + IOMProperty.getDisplayString(1, "Connection.COM.Name.xmlKey.txt");
                comConn = (COMConnection)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_root.getObjectStore(), null, name, "COMConnection", this.m_root.getRepositoryID(), null);
                comConn.setCommunicationProtocol("COM");
                comConn.setApplicationProtocol("COM");
                ((ServerComponent)this.m_root).getSourceConnections().add((Object)comConn);
            }
        } else if (comConn != null) {
            this.m_root.getObjectStore().deleteObject((CMetadata)comConn);
        }
    }

    @Override
    public void moveDataToView() throws MdException, RemoteException {
        this.removePPVFormatting();
        this.m_checkBox.setSelected(this.getConnection() != null);
    }
}

