/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.iom;

import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMProperty;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMPropertyList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;

public abstract class AbstractServerCustomizer
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    private Hashtable<String, IOMPropertyList> m_hashProps;
    private JButton m_advBtn;
    private List<String> m_roles;
    protected int m_viewType;

    public AbstractServerCustomizer(Root root, List groupPropertiesList, int viewType) {
        try {
            this.m_viewType = viewType;
            this.m_hashProps = new Hashtable();
            this.m_roles = new Vector<String>();
            String genRole = IOMProperty.getDisplayString(1, "LogicalServer.PropertyRole.General.xmlKey.txt");
            for (int i = 0; i < groupPropertiesList.size(); ++i) {
                IOMPropertyList propList;
                Property prop = (Property)groupPropertiesList.get(i);
                String role = prop.getPropertyRole();
                if (role.trim().equals("")) {
                    role = genRole;
                }
                if (this.m_hashProps.containsKey(role)) {
                    propList = this.m_hashProps.get(role);
                } else {
                    propList = new IOMPropertyList();
                    if (!this.m_roles.contains(role)) {
                        this.m_roles.add(role);
                    }
                }
                IOMProperty iomProp = new IOMProperty((CMetadata)root, (AbstractProperty)prop, this.m_viewType);
                iomProp.setDataColumns(15);
                iomProp.readProperty();
                propList.add(iomProp);
                if (this.m_hashProps.contains(role)) continue;
                this.m_hashProps.put(role, propList);
            }
            this.m_advBtn = new JButton(this.getButtonText());
            this.setButtonMnemonic(this.m_advBtn);
            this.m_advBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int i;
                    WAPropertyTab[] propTabs = new WAPropertyTab[AbstractServerCustomizer.this.m_roles.size()];
                    Object[][] propValues = new Object[AbstractServerCustomizer.this.m_roles.size()][];
                    WAPropertyDialog dialog = new WAPropertyDialog((Dialog)AbstractServerCustomizer.this.m_advBtn.getTopLevelAncestor(), AbstractServerCustomizer.this.getDialogTitle(), true);
                    for (i = 0; i < AbstractServerCustomizer.this.m_roles.size(); ++i) {
                        propTabs[i] = new WAPropertyTab();
                        propTabs[i].setName((String)AbstractServerCustomizer.this.m_roles.get(i));
                        IOMPropertyList actList = (IOMPropertyList)AbstractServerCustomizer.this.m_hashProps.get(AbstractServerCustomizer.this.m_roles.get(i));
                        if (actList == null) continue;
                        propValues[i] = new Object[actList.size()];
                        for (int j = 0; j < actList.size(); ++j) {
                            propValues[i][j] = actList.get(j).getDataValue();
                        }
                        JPanel propPanel = actList.getPropertiesPanel();
                        JPanel eaterPanel = new JPanel();
                        GridBagConstraints gbc = new GridBagConstraints();
                        gbc.gridx = 0;
                        gbc.gridy = IOMProperty.getNextComponentHorizontalGridValue(propPanel);
                        gbc.weightx = 1.0;
                        gbc.weighty = 1.0;
                        gbc.fill = 1;
                        gbc.gridwidth = 0;
                        gbc.gridheight = 0;
                        ((GridBagLayout)propPanel.getLayout()).setConstraints(eaterPanel, gbc);
                        propPanel.add(eaterPanel);
                        GridBagLayout gbLayout = new GridBagLayout();
                        gbc = new GridBagConstraints();
                        gbc.anchor = 17;
                        gbc.gridx = 0;
                        gbc.gridy = 0;
                        gbc.gridwidth = 0;
                        gbc.gridheight = 0;
                        gbc.weightx = 1.0;
                        gbc.weighty = 1.0;
                        gbc.fill = 1;
                        propTabs[i].setLayout((LayoutManager)gbLayout);
                        gbLayout.setConstraints(propPanel, gbc);
                        propTabs[i].add((Component)propPanel);
                        propTabs[i].setHelpProduct("templatedata");
                        String lctabName = IOMProperty.getDisplayString(1, propTabs[i].getName()).toLowerCase().trim();
                        propTabs[i].setHelpTopic("logservopt_" + lctabName + "_tab");
                    }
                    if (propTabs.length == 1) {
                        dialog.setMainPanel((WAPanel)propTabs[0]);
                    } else {
                        for (i = 0; i < propTabs.length; ++i) {
                            dialog.addTab(IOMProperty.getDisplayString(1, (String)AbstractServerCustomizer.this.m_roles.get(i)), propTabs[i]);
                        }
                    }
                    dialog.pack();
                    dialog.show();
                    if (dialog.getReturnValue() == 2) {
                        for (int k = 0; k < propValues.length; ++k) {
                            IOMPropertyList propList = (IOMPropertyList)AbstractServerCustomizer.this.m_hashProps.get(AbstractServerCustomizer.this.m_roles.get(k));
                            for (int l = 0; l < propList.size(); ++l) {
                                propList.get(l).setPropertyValue(propValues[k][l]);
                            }
                        }
                    }
                }
            });
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridLayout(1, 3, 12, 0));
            buttonPanel.add(this.m_advBtn);
            this.setLayout(new BorderLayout());
            this.add(this.m_advBtn, "East");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        super.moveDataToStore();
        for (int j = 0; j < this.m_roles.size(); ++j) {
            IOMPropertyList propList = this.m_hashProps.get(this.m_roles.get(j));
            for (int i = 0; i < propList.size(); ++i) {
                IOMProperty iomProp = propList.get(i);
                iomProp.writeProperty();
            }
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.removePPVFormatting();
        super.moveDataToView();
    }

    protected void removePPVFormatting() {
        Container parent = this.getParent();
        Component[] comps = parent.getComponents();
        if (comps.length == 0) {
            return;
        }
        if (parent.getLayout() instanceof GridBagLayout) {
            GridBagLayout layout = (GridBagLayout)parent.getLayout();
            comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                GridBagConstraints gbc = layout.getConstraints(comps[i]);
                gbc.insets.top = 0;
                layout.setConstraints(comps[i], gbc);
            }
        }
    }

    protected abstract String getButtonText();

    protected abstract void setButtonMnemonic(JButton var1);

    protected abstract String getDialogTitle();
}

