/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.grid;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.LocalDiscoveryServiceInterface;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.ApplicationFilter;
import com.sas.services.information.metadata.ApplicationInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.GridApplicationInterface;
import com.sas.services.information.metadata.GridServerInterface;
import com.sas.services.information.metadata.OMRGridApplication;
import com.sas.services.information.metadata.OMRGridServer;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.user.UserContextInterface;
import com.sas.util.UsageVersion;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.WsTable;
import com.sas.workspace.mgmt.visuals.customizers.grid.AdvancedPropertiesPanel;
import com.sas.workspace.mgmt.visuals.customizers.grid.BasicMetadataUser;
import com.sas.workspace.mgmt.visuals.customizers.grid.DeleteAction;
import com.sas.workspace.mgmt.visuals.customizers.grid.GAOTemplate;
import com.sas.workspace.mgmt.visuals.customizers.grid.GaoMappingTableModel;
import com.sas.workspace.mgmt.visuals.customizers.grid.GridApplicationWizard;
import com.sas.workspace.mgmt.visuals.customizers.grid.ModifyAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GridServerPropertyPanel
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    private final WAdminResource bundle = WAdminResource.getBundle(GridServerPropertyPanel.class);
    private ServerComponent m_gridServer = null;
    private OMRGridServer m_OMRGridServer = null;
    private ServerInterface m_server = null;
    private JLabel m_providerLabel;
    private WATextField m_providerText;
    private JLabel m_gridCommandLabel;
    private WATextField m_gridCommandText;
    private JLabel m_sasOptions;
    private WATextField m_sasOptionsText;
    private JLabel m_optionalStringLine;
    private JLabel m_requiredStringLine;
    private JLabel m_reqdResLabel;
    private WATextField m_reqdResText;
    private JLabel m_gridOptionLabel;
    private WATextField m_gridOptionText;
    private JButton m_applicationButton;
    private JCheckBox m_GAPageCheckBox;
    private WsTable m_gridMappingsTable;
    private JLabel m_gaoTableLabel;
    private JButton m_newGAOButton;
    private JButton m_editGAOButton;
    private JButton m_deleteGAOButton;
    private JButton m_advancedButton;
    private UserContextInterface m_user = null;
    private MdFactory m_factory = null;
    private MdObjectStore m_store = null;
    private String m_repos = null;
    public FolderInterface m_gaoFolder = null;
    private List<GAOTemplate> m_availableGAOs;
    private List<BasicMetadataUser> m_availableUsers;
    private List<BasicMetadataUser> m_totalUserGroups;
    private List<BasicMetadataUser> m_totalUsers = null;
    private List<String> m_availablePropertySets;
    protected List<String> m_availableSASApplications;
    HashMap<GAOTemplate, List<HashMap<String, List<BasicMetadataUser>>>> m_dataMap;
    private boolean m_currentClient = true;
    protected static final String MODULENAME = "ModuleName";
    protected static final String WORKLOADNAME = "Workload";
    protected static final String OPTIONSTRING = "OptionString";
    protected static final String NOAPPSRVREQ = "noAppSvrRes";
    protected static final String GRIDREQUIREDRESOURCESNAME = "Server.Grid.CheckBox.Name.xmlKey.txt";
    protected static final String GRIDCLASSIDENTIFIER = "D7E796B4-654C-4ab3-B690-657EE79309FB";
    protected static final String SOFTWAREVENDOR = "SAS Institute";
    protected static final int SOFTWAREMAJOR = 9;
    protected static final int SOFTWAREMINOR = 4;
    protected static final String SOFTWAREVERSION = "9.4";
    protected static final String SASCMDCOMMAND = "SASCMD";
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(2, 0);
    protected String m_AppServerName = null;
    protected String m_strSettingPrefix = "GridServerProperty.MappingTable";
    private Workspace m_workspace = Workspace.getWorkspace();
    private WorkspaceFile m_workspaceFile = null;
    protected static final String GRIDCAPABLE = "isGridCapable";
    protected static final String GRIDCAPABLE2 = "IsGridCapable";
    private String m_workload = null;
    private String m_module = null;
    int flags = 412;
    String strTemplate = "<TEMPLATES><Transformation><Properties/></Transformation></TEMPLATES>";
    protected final String GOSPUBLICTYPE = "GridOptionsSet";
    protected final String SASADMINGROUP = "SASAdministrators";
    protected boolean m_isAuthorized = false;
    protected final String USERTYPE = "user";
    private static final Logger LOGGER = LogManager.getLogger(GridServerPropertyPanel.class);

    public GridServerPropertyPanel(ServerComponent gridServer) {
        this.m_gridServer = gridServer;
        if (this.m_workspace != null) {
            this.m_workspaceFile = this.m_workspace.getAppDefaultsFile();
        }
        this.initialize();
        this.layoutWidgets();
    }

    public GridServerPropertyPanel(ServerComponent gridServer, ServerInterface server) {
        this.m_gridServer = gridServer;
        this.m_server = server;
    }

    public ServerComponent getGridServerComponent() {
        return this.m_gridServer;
    }

    private double getUsageVersion() throws RemoteException {
        return this.m_OMRGridServer.getUsageVersion().encode();
    }

    public boolean isCurrentClient() {
        return this.m_currentClient;
    }

    public void populateStore() throws MdException {
    }

    public void moveDataToView() throws RemoteException, MdException {
        try {
            if (this.m_currentClient) {
                this.moveDataToView4CurrentClient();
            } else {
                this.moveDataToView4previousClient();
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private String getServerContextName() throws RemoteException, MdException {
        LogicalServer ls = (LogicalServer)this.m_gridServer.getUsedByComponents().get(0);
        ServerContext sc = (ServerContext)ls.getUsedByComponents().get(0);
        return sc.getName();
    }

    private void moveDataToView4previousClient() throws RemoteException, MdException {
        boolean noAppReq = false;
        if (this.m_gridServer.getProductName() != null && this.m_gridServer.getProductName() != "") {
            this.m_providerText.setText(this.m_gridServer.getProductName());
        } else {
            this.m_providerText.setText("Platform");
        }
        AssociationList properties = this.m_gridServer.getProperties();
        for (Property p : properties) {
            if (p.getPropertyName().equalsIgnoreCase(SASCMDCOMMAND)) {
                String sascmd;
                String command = p.getDefaultValue();
                if (command == null) continue;
                if (command.startsWith("\"")) {
                    sascmd = StringUtils.substringBetween((String)command, (String)"\"", (String)"\"");
                    if (sascmd != null) {
                        this.setCommandInQuote(command, sascmd, "\"");
                    }
                } else if (command.startsWith("'")) {
                    sascmd = StringUtils.substringBetween((String)command, (String)"'", (String)"'");
                    if (sascmd != null) {
                        this.setCommandInQuote(command, sascmd, "'");
                    }
                } else {
                    String[] cmdValues = command.split(" ", 2);
                    if (cmdValues.length == 2) {
                        this.m_gridCommandText.setText(cmdValues[0]);
                        this.m_sasOptionsText.setText(cmdValues[1]);
                    } else if (cmdValues.length == 1) {
                        this.m_gridCommandText.setText(cmdValues[0]);
                    }
                }
            }
            if (p.getPropertyName().equalsIgnoreCase(OPTIONSTRING)) {
                this.m_gridOptionText.setText(p.getDefaultValue());
            }
            if (!p.getPropertyName().equalsIgnoreCase(NOAPPSRVREQ)) continue;
            noAppReq = true;
        }
        if (!noAppReq) {
            this.m_reqdResText.setText(this.m_AppServerName);
        }
    }

    private void setCommandInQuote(String origS, String command, String c) {
        this.m_gridCommandText.setText(c + command + c);
        String sasoption = StringUtils.substring((String)origS, (int)(command.length() + 3));
        if (sasoption.length() != 0) {
            this.m_sasOptionsText.setText(sasoption.trim());
        }
    }

    protected void moveDataToView4CurrentClient() throws RemoteException, MdException {
        try {
            String requiredResource;
            List reqdResList = new ArrayList();
            List gridOptList = new ArrayList();
            String requiredAppServer = "";
            if (this.m_OMRGridServer != null) {
                String sascmd;
                reqdResList = this.m_OMRGridServer.getRequiredResources();
                gridOptList = this.m_OMRGridServer.getGridOptions();
                requiredAppServer = this.m_OMRGridServer.getRequiredResource();
                String gridProps = this.m_OMRGridServer.getGridCommand();
                if (gridProps == null) {
                    gridProps = "";
                }
                if (gridProps.startsWith("\"")) {
                    sascmd = StringUtils.substringBetween((String)gridProps, (String)"\"", (String)"\"");
                    if (sascmd != null) {
                        this.setCommandInQuote(gridProps, sascmd, "\"");
                    } else {
                        this.m_gridCommandText.setText(gridProps);
                    }
                } else if (gridProps.startsWith("'")) {
                    sascmd = StringUtils.substringBetween((String)gridProps, (String)"'", (String)"'");
                    if (sascmd != null) {
                        this.setCommandInQuote(gridProps, sascmd, "'");
                    } else {
                        this.m_gridCommandText.setText(gridProps);
                    }
                } else {
                    String[] cmdValue = gridProps.split(" ", 2);
                    if (cmdValue.length == 2) {
                        String sascmd2 = cmdValue[0];
                        String sasoption = cmdValue[1].trim();
                        if (sascmd2.length() != 0) {
                            this.m_gridCommandText.setText(sascmd2);
                        }
                        if (sasoption.length() != 0) {
                            this.m_sasOptionsText.setText(sasoption);
                        }
                    } else {
                        this.m_gridCommandText.setText(cmdValue[0]);
                    }
                }
            }
            String reqdResources = "";
            if (reqdResList != null) {
                for (Object s : reqdResList) {
                    reqdResources = reqdResources + ((String)s).trim() + " ";
                }
            }
            String gridOptions = "";
            if (gridOptList != null) {
                for (String s : gridOptList) {
                    gridOptions = gridOptions + s.trim() + " ";
                }
            }
            if ((requiredResource = this.m_OMRGridServer.getRequiredResource()) != null && Integer.parseInt(requiredResource) != 1 && reqdResources == null) {
                this.m_reqdResText.setText(this.m_AppServerName);
            } else {
                this.m_reqdResText.setText(reqdResources);
            }
            this.m_gridOptionText.setText(gridOptions);
            if (this.m_OMRGridServer.getProvider() != null && this.m_OMRGridServer.getProvider() != "") {
                this.m_providerText.setText(this.m_OMRGridServer.getProvider());
            } else {
                this.m_providerText.setText("Platform");
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    public void moveDataToStore() throws RemoteException, MdException {
    }

    public void onOK() {
        block6: {
            this.saveSettings();
            try {
                this.m_OMRGridServer.update();
                this.m_gridServer.updateMetadataAll();
            }
            catch (ServiceException e) {
                if (Workspace.isDebug()) {
                    System.out.println("Save failure: + e.printStackTrace()");
                }
            }
            catch (RemoteException e) {
                if (Workspace.isDebug()) {
                    System.out.println("Save failure: + e.printStackTrace()");
                }
            }
            catch (MdException e) {
                if (!Workspace.isDebug()) break block6;
                System.out.println("Save failure: + e.printStackTrace()");
            }
        }
    }

    public void onNext() {
        this.saveSettings();
    }

    public void onCancel() {
    }

    public void saveSettingsAndCleanUp() {
        WAPropertyDialog parent = (WAPropertyDialog)this.getTopLevelAncestor();
        if (parent.getReturnValue() == 1) {
            this.onOK();
        }
    }

    public void saveSettings() {
        if (this.m_currentClient) {
            this.saveSettingsAndCleanUp4currentClient();
        } else {
            this.saveSettingsAndCleanUp4PreClient();
        }
        this.saveAdvancedOptions();
        try {
            this.saveTableMapping();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MdException e) {
            e.printStackTrace();
        }
        this.m_gridMappingsTable.saveSortSettings(Workspace.getWorkspace().getAppDefaultsFile(), this.m_strSettingPrefix);
        if (this.m_workspaceFile != null) {
            this.m_workspaceFile.saveExisting();
        }
    }

    private void saveAdvancedOptions() {
        if (this.m_workload != null) {
            this.setWorkloadOption(this.m_workload, this.m_server);
        }
        if (this.m_module != null) {
            this.setModuleOption(this.m_module, this.m_server);
        }
    }

    private void saveSettingsAndCleanUp4PreClient() {
        ArrayList<String> reqdResList;
        String sascmd = "";
        boolean requireNoApp = true;
        boolean hasSASCMDValue = false;
        if (this.m_gridCommandText.getText().length() != 0) {
            hasSASCMDValue = true;
            String oldCmd = this.m_gridCommandText.getText();
            sascmd = !this.m_sasOptionsText.getText().isEmpty() ? oldCmd.concat(" ").concat(this.m_sasOptionsText.getText()) : oldCmd;
        }
        if ((reqdResList = new ArrayList<String>(Arrays.asList(this.m_reqdResText.getText().split(" ")))).contains(this.m_AppServerName)) {
            requireNoApp = false;
        }
        ArrayList<String> gridOptList = new ArrayList<String>(Arrays.asList(this.m_gridOptionText.getText().split(" ")));
        try {
            this.m_OMRGridServer.setProductName(this.m_providerText.getText());
            this.m_OMRGridServer.setUsageVersion(CURRENT_VERSION.encode());
            AssociationList gridProps = this.m_gridServer.getProperties();
            for (Property p : gridProps) {
                if (!p.getPropertyName().equalsIgnoreCase(NOAPPSRVREQ)) continue;
                if (!requireNoApp) {
                    gridProps.remove(p);
                }
                this.m_OMRGridServer.setRequiredResources(reqdResList);
            }
            if (hasSASCMDValue) {
                this.m_OMRGridServer.setGridCommand(sascmd);
            }
            if (reqdResList.size() != 0) {
                this.m_OMRGridServer.setRequiredResources(reqdResList);
            }
            if (gridOptList.size() != 0) {
                this.m_OMRGridServer.setGridOptions(gridOptList);
            }
            if (requireNoApp) {
                this.m_OMRGridServer.setRequiredResource("1");
            } else {
                this.m_OMRGridServer.setRequiredResources(reqdResList);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MdException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    public void saveSettingsAndCleanUp4currentClient() {
        try {
            ArrayList<String> reqdResList;
            this.m_OMRGridServer.setProvider(this.m_providerText.getText());
            this.m_OMRGridServer.setUsageVersion(CURRENT_VERSION.encode());
            if (this.m_gridCommandText.getText().length() != 0) {
                String oldCmd = this.m_gridCommandText.getText();
                if (!this.m_sasOptionsText.getText().isEmpty()) {
                    String newCmd = oldCmd.concat(" ").concat(this.m_sasOptionsText.getText());
                    this.m_OMRGridServer.setGridCommand(newCmd);
                } else {
                    this.m_OMRGridServer.setGridCommand(oldCmd);
                }
            }
            if ((reqdResList = new ArrayList<String>(Arrays.asList(this.m_reqdResText.getText().split(" ")))).contains(this.m_AppServerName)) {
                String noAppServer = this.m_OMRGridServer.getRequiredResource();
                if (noAppServer != null && Integer.parseInt(noAppServer) == 1) {
                    this.m_OMRGridServer.setRequiredResource("0");
                }
            } else {
                this.m_OMRGridServer.setRequiredResource("1");
            }
            this.m_OMRGridServer.setRequiredResources(reqdResList);
            ArrayList<String> gridOptList = new ArrayList<String>(Arrays.asList(this.m_gridOptionText.getText().split(" ")));
            this.m_OMRGridServer.setGridOptions(gridOptList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initialize() {
        try {
            this.getMetadataServer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.m_user = this.getUserContext();
            if (this.m_user != null) {
                this.m_server = this.m_user.getAuthServer();
                this.m_OMRGridServer = (OMRGridServer)this.getGridServerObject(this.m_server);
                this.m_OMRGridServer.setUsageVersion(CURRENT_VERSION.encode());
                this.m_OMRGridServer.setPublicType("Server.Grid");
                this.m_OMRGridServer.setClassIdentifier(GRIDCLASSIDENTIFIER);
                this.m_OMRGridServer.setVendor(SOFTWAREVENDOR);
                this.m_OMRGridServer.setMajor(9);
                this.m_OMRGridServer.setMinor(4);
                this.m_OMRGridServer.setSoftwareVersion(SOFTWAREVERSION);
                if (this.getUsageVersion() < CURRENT_VERSION.encode()) {
                    this.m_currentClient = false;
                }
                this.m_AppServerName = this.getServerContextName();
                if (this.m_gaoFolder == null) {
                    this.m_gaoFolder = this.setUpGAOFolder(this.m_server);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn(" Could not get user context from workspace. Assume non-GUI testing in effect.", (Object)"GridServerPropertyPanel.java:initialize()");
        }
        this.m_requiredStringLine = new JLabel(this.bundle.getString("GridServerPropertyPanel.requiredString.line.txt"));
        this.m_providerLabel = new JLabel(this.bundle.getString("GridServerPropertyPanel.provider.label.txt"));
        this.m_providerText = new WATextField();
        this.m_providerText.setText("Platform");
        this.m_providerText.setToolTipText(this.bundle.getString("GridServerPropertyPanel.provider.label.desc.txt"));
        this.m_gridCommandLabel = new JLabel(this.bundle.getString("GridServerPropertyPanel.SASCMD.label.txt"));
        this.m_gridCommandText = new WATextField();
        this.m_gridCommandText.setToolTipText(this.bundle.getString("GridServerPropertyPanel.SASCMD.label.desc.txt"));
        this.m_sasOptions = new JLabel(this.bundle.getString("Grid.Application.SAS.Options.xmlKey.txt"));
        this.m_sasOptionsText = new WATextField();
        this.m_sasOptionsText.setToolTipText(this.bundle.getString("Grid.Application.SAS.Options.desc.xmlKey.txt"));
        this.m_optionalStringLine = new JLabel(this.bundle.getString("GridServerPropertyPanel.optionString.line.txt"));
        this.m_GAPageCheckBox = new JCheckBox(this.bundle.getString("GridServerPropertyPanel.showGApage.button.txt"));
        this.m_reqdResLabel = new JLabel(this.bundle.getString("GridServerPropertyPanel.reqd.res.label.txt"));
        this.m_reqdResText = new WATextField();
        this.m_gridOptionLabel = new JLabel(this.bundle.getString("Grid.Application.Grid.Options.xmlKey.txt"));
        this.m_gridOptionText = new WATextField();
        this.m_gridOptionText.setToolTipText(this.bundle.getString("Grid.Application.Grid.Options.desc.xmlKey.txt"));
        this.m_applicationButton = new JButton(this.bundle.getString("GridServerPropertyPanel.application.button.txt"));
        this.m_applicationButton.setToolTipText(this.bundle.getString("GridServerPropertyPanel.application.button.desc.txt"));
        this.m_advancedButton = new JButton(this.bundle.getString("GridServerPropertyPanel.application.button.txt"));
        this.m_advancedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridServerPropertyPanel.this.createAdvancedPanel();
            }
        });
        this.m_applicationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridServerPropertyPanel.this.createNewApplicationObjectWizard();
            }
        });
        this.m_gaoTableLabel = new JLabel(this.bundle.getString("GridServerPropertyPanel.tabledesc.label.txt"));
        this.m_newGAOButton = new JButton(this.bundle.getString("GridApplicationWizard.new.button.txt"));
        this.m_isAuthorized = this.isAuthorized();
        if (this.m_isAuthorized) {
            this.m_newGAOButton.setEnabled(true);
        } else {
            this.m_newGAOButton.setEnabled(false);
        }
        this.m_newGAOButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridServerPropertyPanel.this.createNewApplicationObjectWizard();
            }
        });
        this.m_deleteGAOButton = new JButton(this.bundle.getString("GridServerPropertyPanel.contextMenu.deleteGAO.txt"));
        this.m_deleteGAOButton.setEnabled(false);
        this.m_deleteGAOButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GridServerPropertyPanel.this.confirmDeleteMapping()) {
                    int selectedRowCount = GridServerPropertyPanel.this.m_gridMappingsTable.getSelectedRowCount();
                    if (selectedRowCount > 1) {
                        int[] selectedRows = GridServerPropertyPanel.this.m_gridMappingsTable.getSelectedRows();
                        int[] newRowList = new int[selectedRowCount];
                        for (int index = 0; index < selectedRows.length; ++index) {
                            newRowList[index] = GridServerPropertyPanel.this.m_gridMappingsTable.convertRowIndexToModel(selectedRows[index]);
                        }
                        ((GaoMappingTableModel)((Object)GridServerPropertyPanel.this.m_gridMappingsTable.getModel())).deleteSelectedRows(newRowList);
                    } else {
                        int selectedRow = GridServerPropertyPanel.this.m_gridMappingsTable.convertRowIndexToModel(GridServerPropertyPanel.this.m_gridMappingsTable.getSelectedRow());
                        if (selectedRow >= 0) {
                            int[] selectedRows = new int[]{selectedRow};
                            ((GaoMappingTableModel)((Object)GridServerPropertyPanel.this.m_gridMappingsTable.getModel())).deleteSelectedRows(selectedRows);
                        }
                    }
                }
                GridServerPropertyPanel.this.isSelectedRowAvailable();
            }
        });
        this.m_editGAOButton = new JButton(this.bundle.getString("GridServerPropertyPanel.contextMenu.modifyGAO.txt"));
        this.m_editGAOButton.setEnabled(false);
        this.m_editGAOButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rowSelected = GridServerPropertyPanel.this.m_gridMappingsTable.convertRowIndexToModel(GridServerPropertyPanel.this.m_gridMappingsTable.getSelectedRow());
                if (rowSelected >= 0) {
                    String metaId = (String)GridServerPropertyPanel.this.m_gridMappingsTable.getModel().getValueAt(rowSelected, 3);
                    String sasAppName = (String)GridServerPropertyPanel.this.m_gridMappingsTable.getModel().getValueAt(rowSelected, 0);
                    if (GridServerPropertyPanel.this.isSASAppGridCapable(sasAppName)) {
                        GridServerPropertyPanel.this.createNewApplicationObjectWizard(metaId, sasAppName);
                    } else {
                        GridServerPropertyPanel.this.popupSASAppNotGridCapable();
                    }
                    GridServerPropertyPanel.this.isSelectedRowAvailable();
                }
            }
        });
        try {
            this.createTableDataMap();
            this.m_availableSASApplications = this.getApplicationNames(this.m_server);
        }
        catch (ServiceException e1) {
            this.popError();
        }
        catch (RemoteException e1) {
            this.popError();
        }
        catch (MdException e1) {
            this.popError();
        }
        this.m_gridMappingsTable = new WsTable((WsAbstractTableModel)new GaoMappingTableModel(this.m_dataMap, this.m_server, this));
        this.sortMappingTable();
        this.m_gridMappingsTable.setCellSelectionEnabled(false);
        this.m_gridMappingsTable.setRowSelectionAllowed(true);
        if (this.m_workspaceFile != null) {
            this.m_gridMappingsTable.restoreSortSettings(this.m_workspaceFile, this.m_strSettingPrefix);
        }
        this.m_gridMappingsTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                block19: {
                    int rowSelectedCount = GridServerPropertyPanel.this.m_gridMappingsTable.getSelectedRowCount();
                    if (e.getButton() == 1 && e.getClickCount() == 1) {
                        if (!GridServerPropertyPanel.this.m_isAuthorized) {
                            return;
                        }
                        if (rowSelectedCount <= 0) {
                            GridServerPropertyPanel.this.m_editGAOButton.setEnabled(false);
                            GridServerPropertyPanel.this.m_deleteGAOButton.setEnabled(false);
                        } else if (rowSelectedCount > 1) {
                            GridServerPropertyPanel.this.m_editGAOButton.setEnabled(false);
                            GridServerPropertyPanel.this.m_deleteGAOButton.setEnabled(true);
                        } else {
                            GridServerPropertyPanel.this.m_editGAOButton.setEnabled(true);
                            GridServerPropertyPanel.this.m_deleteGAOButton.setEnabled(true);
                        }
                    } else if (e.getButton() == 3) {
                        if (!GridServerPropertyPanel.this.m_isAuthorized) {
                            return;
                        }
                        try {
                            int selectedRowCount = GridServerPropertyPanel.this.m_gridMappingsTable.getSelectedRowCount();
                            if (GridServerPropertyPanel.this.m_gridMappingsTable.getSelectedRowCount() > 1) {
                                int[] newRowList = new int[selectedRowCount];
                                int[] selectedRows = GridServerPropertyPanel.this.m_gridMappingsTable.getSelectedRows();
                                for (int index = 0; index < selectedRows.length; ++index) {
                                    newRowList[index] = GridServerPropertyPanel.this.m_gridMappingsTable.convertRowIndexToModel(selectedRows[index]);
                                }
                                GridServerPropertyPanel.this.createPopupMenu(newRowList).show(e.getComponent(), e.getX(), e.getY());
                                break block19;
                            }
                            int rowSelected = GridServerPropertyPanel.this.m_gridMappingsTable.convertRowIndexToModel(GridServerPropertyPanel.this.m_gridMappingsTable.getSelectedRow());
                            GridServerPropertyPanel.this.createPopupMenu(rowSelected).show(e.getComponent(), e.getX(), e.getY());
                        }
                        catch (ArrayIndexOutOfBoundsException selectedRowCount) {}
                    } else if (e.getClickCount() == 2) {
                        if (!GridServerPropertyPanel.this.m_isAuthorized) {
                            return;
                        }
                        int rowSelected = GridServerPropertyPanel.this.m_gridMappingsTable.convertRowIndexToModel(GridServerPropertyPanel.this.m_gridMappingsTable.getSelectedRow());
                        if (rowSelected >= 0) {
                            String metaId = (String)GridServerPropertyPanel.this.m_gridMappingsTable.getModel().getValueAt(rowSelected, 3);
                            String sasAppName = (String)GridServerPropertyPanel.this.m_gridMappingsTable.getModel().getValueAt(rowSelected, 0);
                            if (GridServerPropertyPanel.this.isSASAppGridCapable(sasAppName)) {
                                GridServerPropertyPanel.this.createNewApplicationObjectWizard(metaId, sasAppName);
                            } else {
                                GridServerPropertyPanel.this.popupSASAppNotGridCapable();
                            }
                        }
                    }
                }
            }
        });
    }

    public JPopupMenu createPopupMenu(int rowIndex) {
        JPopupMenu contextMenu = new JPopupMenu();
        contextMenu.add(new DeleteAction(rowIndex, this, (GaoMappingTableModel)((Object)this.m_gridMappingsTable.getModel())));
        contextMenu.add(new ModifyAction(rowIndex, this));
        return contextMenu;
    }

    public JPopupMenu createPopupMenu(int[] rowIndexes) {
        JPopupMenu contextMenu = new JPopupMenu();
        contextMenu.add(new DeleteAction(rowIndexes, this, (GaoMappingTableModel)((Object)this.m_gridMappingsTable.getModel())));
        return contextMenu;
    }

    public void isSelectedRowAvailable() {
        if (this.m_gridMappingsTable.getSelectedRowCount() <= 0 || !this.m_isAuthorized) {
            this.m_deleteGAOButton.setEnabled(false);
            this.m_editGAOButton.setEnabled(false);
        } else {
            this.m_deleteGAOButton.setEnabled(true);
            this.m_editGAOButton.setEnabled(true);
        }
    }

    public boolean confirmDelete() {
        return JOptionPane.showConfirmDialog((Component)((Object)this), this.bundle.getString("GridServerPropertyPanel.ConfirmDeleteMapping.txt"), this.bundle.getString("GridServerPropertyPanel.ConfirmDelete.WindowTitle.txt"), 2, 2) == 0;
    }

    private boolean popError() {
        return JOptionPane.showConfirmDialog((Component)((Object)this), this.bundle.getString("GridServerPropertyPanel.CreateTable.error.txt"), this.bundle.getString("GridServerPropertyPanel.ConfirmDelete.WindowTitle.txt"), 2, 2) == 0;
    }

    private FolderInterface setUpGAOFolder(ServerInterface server) throws ServiceException, RemoteException {
        FolderInterface folder = null;
        PathUrl path = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)"Shared Data");
        FolderInterface appFolder = (FolderInterface)server.getObjectByPath(path);
        if (appFolder != null) {
            FolderInterface folder1 = appFolder.getSubfolder("SAS Grid Manager");
            if (folder1 == null) {
                folder1 = appFolder.makeSubfolder("SAS Grid Manager");
            }
            if ((folder = folder1.getSubfolder("Grid Options Set")) == null) {
                folder = folder1.makeSubfolder("Grid Options Set");
            }
            folder.update();
            return folder;
        }
        return folder;
    }

    public void layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.insets = new Insets(12, 12, 0, 0);
        gbc.anchor = 21;
        gridBagLayout.setConstraints(this.m_requiredStringLine, gbc);
        this.add(this.m_requiredStringLine);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.insets = new Insets(12, 12, 0, 0);
        gbc.anchor = 21;
        gridBagLayout.setConstraints(this.m_providerLabel, gbc);
        this.add(this.m_providerLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.gridwidth = -1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_providerText, gbc);
        this.add((Component)this.m_providerText);
        gbc = new GridBagConstraints();
        gbc.anchor = 21;
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_gridCommandLabel, gbc);
        this.add(this.m_gridCommandLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.gridwidth = -1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_gridCommandText, gbc);
        this.add((Component)this.m_gridCommandText);
        gbc = new GridBagConstraints();
        gbc.anchor = 21;
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_optionalStringLine, gbc);
        this.add(this.m_optionalStringLine);
        gbc = new GridBagConstraints();
        gbc.anchor = 21;
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_sasOptions, gbc);
        this.add(this.m_sasOptions);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.gridwidth = -1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_sasOptionsText, gbc);
        this.add((Component)this.m_sasOptionsText);
        gbc = new GridBagConstraints();
        gbc.anchor = 21;
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_reqdResLabel, gbc);
        this.add(this.m_reqdResLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_reqdResText, gbc);
        this.add((Component)this.m_reqdResText);
        gbc = new GridBagConstraints();
        gbc.anchor = 21;
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_gridOptionLabel, gbc);
        this.add(this.m_gridOptionLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 21;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_gridOptionText, gbc);
        this.add((Component)this.m_gridOptionText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.anchor = 23;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_gaoTableLabel, gbc);
        this.add(this.m_gaoTableLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.gridy = gridy++;
        gbc.insets = new Insets(12, 12, 0, 12);
        gbc.anchor = 21;
        gbc.fill = 2;
        JScrollPane mScrollPane = new JScrollPane((Component)this.m_gridMappingsTable);
        mScrollPane.setHorizontalScrollBarPolicy(30);
        mScrollPane.setPreferredSize(new Dimension(500, 150));
        gridBagLayout.setConstraints(mScrollPane, gbc);
        this.add(mScrollPane);
        JPanel tableButtonPanel = new JPanel();
        this.m_newGAOButton.setMargin(new Insets(0, 10, 0, 10));
        this.m_editGAOButton.setMargin(new Insets(0, 10, 0, 10));
        this.m_deleteGAOButton.setMargin(new Insets(0, 10, 0, 10));
        tableButtonPanel.add(this.m_newGAOButton);
        tableButtonPanel.add(this.m_editGAOButton);
        tableButtonPanel.add(this.m_deleteGAOButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.anchor = 23;
        gridBagLayout.setConstraints(tableButtonPanel, gbc);
        this.add(tableButtonPanel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.gridy = gridy++;
        gbc.insets = new Insets(12, 12, 0, 0);
        gbc.anchor = 23;
        gridBagLayout.setConstraints(this.m_advancedButton, gbc);
        this.add(this.m_advancedButton);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }

    private void createAdvancedPanel() {
        AdvancedPropertiesPanel advp = new AdvancedPropertiesPanel(this);
        advp.setModal(true);
        advp.setVisible(true);
    }

    public boolean validateData() {
        boolean bValidated = true;
        String providerField = this.m_providerText.getText();
        if (providerField.length() == 0) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), this.bundle.getString("GridServerPropertyPanel.provider.Required.txt"), this.bundle.getString("Common.RequiredError.txt"), 0);
            bValidated = false;
            return bValidated;
        }
        String gridCommand = this.m_gridCommandText.getText();
        if (gridCommand.length() == 0) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), this.bundle.getString("GridServerPropertyPanel.GridCommand.Required.txt"), this.bundle.getString("Common.RequiredError.txt"), 0);
            bValidated = false;
            return bValidated;
        }
        return bValidated;
    }

    public boolean confirmDelete(Component root) {
        return JOptionPane.showConfirmDialog(root, this.bundle.getString("GridServerPropertyPanel.ConfirmDelete.txt"), this.bundle.getString("GridServerPropertyPanel.ConfirmDelete.WindowTitle.txt"), 2, 2) == 0;
    }

    public boolean confirmDeleteMapping() {
        return JOptionPane.showConfirmDialog((Component)((Object)this), this.bundle.getString("GridServerPropertyPanel.ConfirmDeleteMapping.txt"), this.bundle.getString("GridServerPropertyPanel.ConfirmDelete.WindowTitle.txt"), 2, 2) == 0;
    }

    public WsTable getGridMappingTable() {
        return this.m_gridMappingsTable;
    }

    public void createNewApplicationObjectWizard() {
        GridApplicationWizard wizard = new GridApplicationWizard(this);
        if (wizard != null) {
            wizard.setModal(true);
            wizard.setVisible(true);
        }
    }

    public void createNewApplicationObjectWizard(String metaID, String sasApp) {
        GridApplicationWizard wizard = new GridApplicationWizard(this, sasApp, metaID, this.m_availableUsers);
        if (wizard != null) {
            wizard.setModal(true);
            wizard.setVisible(true);
        }
    }

    public void refreshMappingTable(String sasApp, GAOTemplate t, List<BasicMetadataUser> users, boolean isDeleted) {
        ((GaoMappingTableModel)((Object)this.m_gridMappingsTable.getModel())).updateGAO(sasApp, t, users, isDeleted);
    }

    protected void getMetadataServer() throws MdException, RemoteException {
        this.m_factory = Workspace.getMdFactory();
        this.m_store = (MdObjectStore)this.m_gridServer.getObjectStore();
        this.m_repos = this.m_gridServer.getRepositoryID();
    }

    protected UserContextInterface getUserContext() {
        if (this.m_user != null) {
            return this.m_user;
        }
        return Workspace.getWorkspace().getUserContext();
    }

    public List<String> getExistingPropertySets() throws ServiceException, RemoteException, MdException {
        ArrayList<String> sasAppList = new ArrayList<String>();
        List gridProperties = this.m_OMRGridServer.getPropertySetNames();
        for (PropertySet appNameMappingSet : gridProperties) {
            String appName = appNameMappingSet.getName();
            sasAppList.add(appName);
        }
        return sasAppList;
    }

    public GridApplicationInterface getExistingGOS(ServerInterface authServer, String gaoName) throws ServiceException, RemoteException, MdException {
        List gList = null;
        gList = this.m_OMRGridServer.getExistingGridOptionsSetList(authServer);
        for (OMRGridApplication gos : gList) {
            if (!gos.getName().equalsIgnoreCase(gaoName)) continue;
            return gos;
        }
        return null;
    }

    public List<GAOTemplate> getExistingGAOs(ServerInterface authServer) throws ServiceException, RemoteException, MdException {
        ArrayList<GAOTemplate> gaoList = new ArrayList<GAOTemplate>();
        List gList = null;
        if (this.m_OMRGridServer == null) {
            this.m_OMRGridServer = (OMRGridServer)this.getGridServerObject(this.m_server);
        }
        gList = this.m_OMRGridServer.getExistingGridOptionsSetList(authServer);
        for (OMRGridApplication gao : gList) {
            GAOTemplate newGao = this.createGAO(gao);
            gaoList.add(newGao);
        }
        return gaoList;
    }

    private GAOTemplate createGAO(OMRGridApplication gao) throws ServiceException, RemoteException {
        String reqdString = "";
        for (Object resource : gao.getRequiredResources()) {
            reqdString = reqdString + (String)resource + " ";
        }
        String gridOptStr = "";
        for (Object option : gao.getGridOptions()) {
            gridOptStr = gridOptStr + (String)option + " ";
        }
        String sasOptStr = "";
        for (String option : gao.getSASOptions()) {
            sasOptStr = sasOptStr + option + " ";
        }
        GAOTemplate newGao = new GAOTemplate(gao.getName(), gridOptStr.trim(), reqdString.trim(), sasOptStr.trim(), "", null, gao.getIdentifier());
        return newGao;
    }

    public List<BasicMetadataUser> getTotalUsers(ServerInterface server) throws ServiceException, MdException, RemoteException {
        List identitiesList = new ArrayList();
        this.m_totalUsers = new ArrayList<BasicMetadataUser>();
        ArrayList<BasicMetadataUser> users = new ArrayList<BasicMetadataUser>();
        String searchString = "<XMLSelect search=\"*[@PublicType='User' or @PublicType='UserGroup']\"/>";
        int flags = 26780;
        Filter filter = new Filter();
        filter.setOMRFlags(flags);
        filter.setType("Identity");
        filter.setExplicitSearchString("omi", searchString);
        identitiesList = server.browseSearch((FilterInterface)filter);
        for (BrowseMetadataInterface e : identitiesList) {
            BasicMetadataUser u;
            if (e.getName().equalsIgnoreCase("PUBLIC")) continue;
            if ((String)e.getRawData().get("DisplayName") != null && (String)e.getRawData().get("Id") != null) {
                u = new BasicMetadataUser(e.getName(), (String)e.getRawData().get("Id"), (String)e.getRawData().get("DisplayName"));
                users.add(u);
                if (!e.getSmartType().equalsIgnoreCase("user")) continue;
                this.m_totalUsers.add(u);
                continue;
            }
            u = new BasicMetadataUser(e.getName(), e.getReposId());
            users.add(u);
            if (!e.getSmartType().equalsIgnoreCase("user")) continue;
            this.m_totalUsers.add(u);
        }
        Collections.sort(users);
        return users;
    }

    public List<String> getApplicationNames(ServerInterface authServer) throws ServiceException, RemoteException, MdException {
        ArrayList<String> applicationList = new ArrayList<String>();
        ApplicationFilter filter = new ApplicationFilter();
        filter.setOnlyGridCapable(true);
        List appList = authServer.search((FilterInterface)filter);
        for (ApplicationInterface app : appList) {
            String name;
            FolderInterface parentFolder;
            FolderInterface folder = app.getParent();
            if (folder == null || (parentFolder = folder.getParent()) == null || applicationList.contains(name = parentFolder.getName())) continue;
            applicationList.add(name);
        }
        String path = "/System/Applications";
        PathUrl pathURL = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)authServer, (String)path);
        FolderInterface appFolder = (FolderInterface)authServer.getObjectByPath(pathURL);
        List allItems = appFolder.getSubfolders();
        for (FolderInterface folder : allItems) {
            List keywordList = folder.getKeywords();
            for (Object obj : keywordList) {
                String[] words;
                String appName;
                if (obj.toString().equalsIgnoreCase(GRIDCAPABLE)) {
                    if (applicationList.contains(folder.getName())) continue;
                    applicationList.add(folder.getName());
                    continue;
                }
                if (!obj.toString().startsWith(GRIDCAPABLE) && !obj.toString().startsWith(GRIDCAPABLE2) || (appName = (words = obj.toString().split(":"))[1].trim()) == null || applicationList.contains(folder.getName())) continue;
                applicationList.add(folder.getName());
            }
        }
        Collections.sort(applicationList);
        applicationList.add(0, this.bundle.getString("GridApplicationWizard.selectapp.label.txt"));
        return applicationList;
    }

    public List<String> getExistingSASApplications() {
        return this.m_availableSASApplications;
    }

    public void updateRemoteGAO(GAOTemplate t, ServerInterface authServer) throws RemoteException, MdException, ServiceException {
        GridApplicationInterface remoteGAO;
        if (this.m_OMRGridServer == null) {
            this.m_OMRGridServer = (OMRGridServer)this.getGridServerObject(this.m_server);
        }
        if ((remoteGAO = this.m_OMRGridServer.getGridOptionsSet(t.getMetaId(), t.getName(), authServer)) != null) {
            remoteGAO.setName(t.getName());
            this.updateRemoteGAO(remoteGAO, t.getSASOptions(), t.getGridOptions(), t.getRequiredResources());
        }
    }

    public void deleteMetadataGAO(GAOTemplate t, ServerInterface server, boolean toDelete) throws RemoteException, ServiceException, MdException {
        GridApplicationInterface gridApp;
        if (this.m_OMRGridServer == null) {
            this.m_OMRGridServer = (OMRGridServer)this.getGridServerObject(this.m_server);
        }
        if ((gridApp = this.m_OMRGridServer.getGridOptionsSet(t.getMetaId(), t.getName(), server)) != null) {
            PathUrl gridPath = gridApp.getPathUrl();
            GridApplicationInterface gridByPath = (GridApplicationInterface)server.getObjectByPath(gridPath);
            try {
                this.removeUserMappings(gridByPath, server);
                if (Workspace.isDebug()) {
                    System.out.println("Delete grid options set: " + gridApp.getName());
                }
                gridByPath.delete();
                gridApp.delete();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        } else {
            throw new RemoteException("Can't find grid application \"" + t.getName() + "\", \"" + t.getMetaId() + "\" to delete.");
        }
    }

    public GridApplicationInterface getNewRemoteGAO(String name, String sasOption, String gridOption, String requiredResource, FolderInterface folder, ServerInterface server) throws ServiceException, RemoteException, MdException {
        LocalDiscoveryServiceInterface dsi = DiscoveryService.defaultInstance();
        Class[] desiredServiceCapabilities = new Class[]{InformationServiceInterface.class};
        ServiceTemplate serviceTemplate = new ServiceTemplate(desiredServiceCapabilities, null);
        InformationServiceInterface _informationService = (InformationServiceInterface)dsi.findService(serviceTemplate);
        GridApplicationInterface gridApp = null;
        if (folder != null) {
            gridApp = (GridApplicationInterface)_informationService.newMetadataInFolder(folder, folder.getRepository(), "GridOptionsSet", name);
            gridApp.update();
            gridApp = this.updateRemoteGAO(gridApp, sasOption, gridOption, requiredResource);
        } else {
            MessageUtil.displayMessage((String)this.bundle.getString("GridServerPropertyPanel.noGAOfolder.error.txt"));
        }
        return gridApp;
    }

    public GridApplicationInterface updateRemoteGAO(GridApplicationInterface gridGao, String sasOption, String gridOption, String requiredSource) throws ServiceException, RemoteException {
        GridApplicationInterface gridApp = gridGao;
        String delims = " ";
        String[] gridOptionTokens = gridOption.split(delims);
        ArrayList<String> gridOptions = new ArrayList<String>();
        for (String token : gridOptionTokens) {
            gridOptions.add(token);
        }
        gridApp.setGridOptions(gridOptions);
        String[] sasOptionTokens = sasOption.split(delims);
        ArrayList<String> sasOptions = new ArrayList<String>();
        for (String token : sasOptionTokens) {
            sasOptions.add(token);
        }
        gridApp.setSASOptions(sasOptions);
        String[] requiredSourceTokens = requiredSource.split(delims);
        ArrayList<String> requiredResources = new ArrayList<String>();
        for (String token : requiredSourceTokens) {
            requiredResources.add(token);
        }
        gridApp.setRequiredResources(requiredResources);
        return gridApp;
    }

    public BasicMetadataUser findUserByName(String uName, ServerInterface s) {
        try {
            if (this.m_totalUserGroups == null) {
                this.m_totalUserGroups = this.getTotalUsers(s);
            }
            for (BasicMetadataUser u : this.m_totalUserGroups) {
                if (!u.userName.equalsIgnoreCase(uName) && (u.userDisplayName == null || !u.userDisplayName.equalsIgnoreCase(uName))) continue;
                return u;
            }
            return new BasicMetadataUser(uName, "");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void removeUserMappings(GridApplicationInterface gao, ServerInterface s) throws MdException, RemoteException, ServiceException {
        if (this.m_OMRGridServer == null) {
            this.m_OMRGridServer = (OMRGridServer)this.getGridServerObject(this.m_server);
        }
        List gridProperties = this.m_OMRGridServer.getPropertySetNames();
        for (PropertySet appNameMappingSet : gridProperties) {
            AssociationList propList = appNameMappingSet.getSetProperties();
            String thisAppName = appNameMappingSet.getName();
            try {
                for (int i = propList.size() - 1; i >= 0; --i) {
                    Property property;
                    if (!(propList.get(i) instanceof Property) || (property = (Property)propList.get(i)) == null || property.getSourceTransformations().size() == 0) continue;
                    AssociationList assocGAOList = property.getSourceTransformations();
                    for (CMetadata transformObject : assocGAOList) {
                        try {
                            if (!transformObject.getId().equals(gao.getIdentifier())) continue;
                            List users = gao.getUserMappings();
                            for (String u : users) {
                                ArrayList<String> thisUser = new ArrayList<String>();
                                thisUser.add(u);
                                try {
                                    this.m_OMRGridServer.deleteUserMapping(thisAppName, gao.getName(), thisUser);
                                    this.m_OMRGridServer.update();
                                }
                                catch (Exception e) {
                                    System.err.println("Unable to delete user mapping: " + thisAppName + ": " + thisUser);
                                    e.printStackTrace();
                                }
                            }
                        }
                        catch (NoSuchElementException noSuchElementException) {
                        }
                    }
                }
            }
            catch (Exception exception) {
            }
        }
    }

    public GridServerInterface getGridServerObject(ServerInterface authServer) {
        try {
            FilterComponent fc1 = new FilterComponent("PublicType", 0, "Server.Grid");
            Filter filter = new Filter();
            filter.setFilterComponent(fc1);
            filter.setType("ServerComponent");
            filter.setName(this.m_gridServer.getName());
            List serverList = authServer.search((FilterInterface)filter);
            if (serverList.size() > 0) {
                return (GridServerInterface)serverList.get(0);
            }
            OMRGridServer gridServer = new OMRGridServer(this.m_gridServer);
            return gridServer;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void createNewMetadataGAO(GAOTemplate t, ServerInterface s) throws MdException, RemoteException, ServiceException {
        GridApplicationInterface newGao;
        if (this.m_gaoFolder == null) {
            this.m_gaoFolder = this.setUpGAOFolder(s);
        }
        if ((newGao = this.getNewRemoteGAO(t.getName(), t.getSASOptions(), t.getGridOptions(), t.getRequiredResources(), this.m_gaoFolder, s)) == null) {
            return;
        }
        t.setIsNew(false);
        newGao.update();
    }

    public void cleanUserMetadata(List<String> allApps) throws RemoteException, MdException {
        AssociationList apps = this.m_gridServer.getPropertySets();
        for (int i = apps.size() - 1; i >= 0; --i) {
            if (!allApps.contains(((PropertySet)apps.get(i)).getName())) {
                this.m_gridServer.getPropertySets().remove(i);
                continue;
            }
            AssociationList userNames = ((PropertySet)apps.get(i)).getSetProperties();
            for (int z = userNames.size() - 1; z >= 0; --z) {
                Property user = (Property)userNames.get(z);
                if (user.getSourceTransformations().size() != 0) continue;
                ((PropertySet)apps.get(i)).getSetProperties().remove(z);
            }
        }
    }

    public String getWorkloadOption() {
        String workload = "";
        if (this.m_currentClient) {
            try {
                List workloadlst = this.m_OMRGridServer.getGridWorkLoad();
                for (String item : workloadlst) {
                    workload = workload + item + " ";
                }
            }
            catch (NullPointerException workloadlst) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                AssociationList gridProps = this.m_gridServer.getProperties();
                for (Property p : gridProps) {
                    if (!p.getPropertyName().equals(WORKLOADNAME)) continue;
                    workload = p.getDefaultValue();
                    break;
                }
            }
            catch (RemoteException remoteException) {
            }
            catch (MdException mdException) {
                // empty catch block
            }
        }
        if (workload == "" || workload == null) {
            return "";
        }
        return workload.trim();
    }

    public void setWorkloadOption(String workload, ServerInterface s) {
        block6: {
            ArrayList<String> workloadList = new ArrayList<String>(Arrays.asList(workload.split(" ")));
            for (int i = workloadList.size() - 1; i >= 0; --i) {
                if (((String)workloadList.get(i)).trim().length() != 0) continue;
                workloadList.remove(i);
            }
            try {
                if (this.m_currentClient) {
                    if (this.m_OMRGridServer == null) {
                        this.m_OMRGridServer = (OMRGridServer)this.getGridServerObject(this.m_server);
                    }
                    this.m_OMRGridServer.setGridWorkLoad(workloadList);
                    break block6;
                }
                AssociationList gridProps = this.m_gridServer.getProperties();
                for (Property p : gridProps) {
                    if (!p.getPropertyName().equals(WORKLOADNAME)) continue;
                    p.setDefaultValue(workload);
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getModuleOption() throws MdException, ServiceException, RemoteException {
        String moduleName = "";
        if (this.m_currentClient) {
            moduleName = this.m_OMRGridServer.getGridModuleName();
        } else {
            try {
                AssociationList gridProps = this.m_gridServer.getProperties();
                for (Property p : gridProps) {
                    if (!p.getPropertyName().equals(MODULENAME)) continue;
                    moduleName = p.getDefaultValue();
                }
            }
            catch (RemoteException remoteException) {
            }
            catch (MdException mdException) {
                // empty catch block
            }
        }
        if (moduleName == "" || moduleName == null) {
            return "";
        }
        return moduleName.trim();
    }

    public void setModuleOption(String module, ServerInterface s) {
        if (this.m_currentClient) {
            if (this.m_OMRGridServer == null) {
                this.m_OMRGridServer = (OMRGridServer)this.getGridServerObject(this.m_server);
            }
            try {
                this.m_OMRGridServer.setGridModuleName(module);
            }
            catch (ServiceException serviceException) {
            }
            catch (RemoteException remoteException) {
            }
            catch (MdException mdException) {}
        } else {
            try {
                AssociationList gridProps = this.m_gridServer.getProperties();
                for (Property p : gridProps) {
                    if (!p.getPropertyName().equals(MODULENAME)) continue;
                    p.setDefaultValue(module);
                    break;
                }
            }
            catch (RemoteException remoteException) {
            }
            catch (MdException mdException) {
                // empty catch block
            }
        }
    }

    public OMRGridServer getOMRGridServer() {
        return this.m_OMRGridServer;
    }

    private boolean isAuthorized() {
        boolean authorized;
        try {
            authorized = this.m_user.isInGroup("SASAdministrators");
        }
        catch (ServiceException e) {
            return false;
        }
        catch (RemoteException e) {
            return false;
        }
        return authorized;
    }

    public void sortMappingTable() {
        this.m_gridMappingsTable.sort(0, 1);
    }

    public void createTableDataMap() {
        this.m_dataMap = new HashMap();
        try {
            this.m_availableGAOs = this.getExistingGAOs(this.m_server);
            this.m_availablePropertySets = this.getExistingPropertySets();
        }
        catch (ServiceException e1) {
            e1.printStackTrace();
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
        }
        catch (MdException e1) {
            e1.printStackTrace();
        }
        for (GAOTemplate t : this.m_availableGAOs) {
            HashMap sasAppIdentityMap = new HashMap();
            for (String sasApp : this.m_availablePropertySets) {
                ArrayList<BasicMetadataUser> identityList = new ArrayList<BasicMetadataUser>();
                try {
                    List userList = this.m_OMRGridServer.getUserMappings(sasApp, t.getName());
                    for (String u : userList) {
                        BasicMetadataUser thisUser = this.findUserByName(u, this.m_server);
                        identityList.add(thisUser);
                    }
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                catch (MdException e) {
                    e.printStackTrace();
                }
                if (identityList.size() == 0) continue;
                sasAppIdentityMap.put(sasApp, identityList);
            }
            if (sasAppIdentityMap.isEmpty()) continue;
            List<HashMap<String, List<BasicMetadataUser>>> values = this.m_dataMap.get(t);
            if (values == null) {
                values = new ArrayList<HashMap<String, List<BasicMetadataUser>>>();
            }
            values.add(sasAppIdentityMap);
            this.m_dataMap.put(t, values);
        }
    }

    public void saveTableMapping() throws ServiceException, RemoteException, MdException {
        List<BasicMetadataUser> localUserList;
        if (this.m_OMRGridServer == null) {
            this.m_OMRGridServer = (OMRGridServer)this.getGridServerObject(this.m_server);
        }
        List propertySetList = this.m_OMRGridServer.getPropertySetNames();
        List gaoList = this.m_OMRGridServer.getExistingGridOptionsSetList(this.m_server);
        GaoMappingTableModel model = (GaoMappingTableModel)((Object)this.m_gridMappingsTable.getModel());
        HashMap<GAOTemplate, List<HashMap<String, List<BasicMetadataUser>>>> dataMap = model.getDataMap();
        List<String> newPropertySetList = this.getNewPSListFromDataMap(dataMap, propertySetList);
        for (PropertySet ps : propertySetList) {
            for (OMRGridApplication gao : gaoList) {
                String userString;
                localUserList = model.getUserListFromLocalTemplate(gao.getName(), ps.getName(), dataMap);
                List<BasicMetadataUser> remoteUserList = this.getUserListFromMetadata(gao.getName(), ps);
                ArrayList deleteList = new ArrayList();
                ArrayList<String> addList = new ArrayList<String>();
                for (BasicMetadataUser user : remoteUserList) {
                    if (localUserList == null || localUserList.contains(user)) continue;
                    deleteList.add(user.userName);
                }
                for (BasicMetadataUser addUser : localUserList) {
                    if (remoteUserList == null || remoteUserList.contains(addUser)) continue;
                    addList.add(addUser.userName);
                }
                if (deleteList.size() > 0) {
                    this.m_OMRGridServer.deleteUserMapping(ps.getName(), gao.getName(), (List)deleteList);
                    if (Workspace.isDebug()) {
                        userString = "";
                        Iterator iterator = deleteList.iterator();
                        while (iterator.hasNext()) {
                            String user = (String)iterator.next();
                            userString = userString + user + ";";
                        }
                        if (userString.length() > 0) {
                            System.out.println("Delete user mapping in metadata:propertySetName=" + ps.getName() + " gao=" + gao.getName() + " userList=" + userString);
                        }
                    }
                }
                if (addList.size() <= 0) continue;
                this.m_OMRGridServer.setUserMappings(ps.getName(), addList, (GridApplicationInterface)gao);
                if (!Workspace.isDebug()) continue;
                userString = "";
                for (String user : addList) {
                    userString = userString + user + ";";
                }
                if (userString.length() <= 0) continue;
                System.out.println("Set user mapping in metadata:propertySetName=" + ps.getName() + " gao=" + gao.getName() + " userList=" + userString);
            }
            if (!this.isUserListFromLocalEmpty(ps.getName(), dataMap)) continue;
            this.m_OMRGridServer.removePropertySetFromServer(ps);
            if (!Workspace.isDebug()) continue;
            System.out.println("Remove propertySet in metadata: " + ps.getName());
        }
        for (String app : newPropertySetList) {
            for (OMRGridApplication gao : gaoList) {
                localUserList = model.getUserListFromLocalTemplate(gao.getName(), app, dataMap);
                ArrayList<String> addList = new ArrayList<String>();
                for (BasicMetadataUser addUser : localUserList) {
                    addList.add(addUser.userName);
                }
                if (addList.size() > 0) {
                    this.m_OMRGridServer.setUserMappings(app, addList, (GridApplicationInterface)gao);
                }
                if (!Workspace.isDebug()) continue;
                String userString = "";
                for (String user : addList) {
                    userString = userString + user + ";";
                }
                if (userString.length() <= 0) continue;
                System.out.println("Set user mapping in new PropertySet in metadata: propertySetName=" + app + " gao=" + gao.getName() + " userList=" + userString);
            }
        }
    }

    private List<BasicMetadataUser> getUserListFromMetadata(String gaoName, PropertySet ps) throws RemoteException, MdException, ServiceException {
        ArrayList<BasicMetadataUser> remoteUsers = new ArrayList<BasicMetadataUser>();
        List userStrings = this.m_OMRGridServer.getUserMappings(ps.getName(), gaoName);
        for (String user : userStrings) {
            BasicMetadataUser bUser = this.findUserByName(user, this.m_server);
            remoteUsers.add(bUser);
        }
        return remoteUsers;
    }

    private boolean isUserListFromLocalEmpty(String app, HashMap<GAOTemplate, List<HashMap<String, List<BasicMetadataUser>>>> dataMap) {
        for (Map.Entry<GAOTemplate, List<HashMap<String, List<BasicMetadataUser>>>> pairs : dataMap.entrySet()) {
            List<HashMap<String, List<BasicMetadataUser>>> mapList = pairs.getValue();
            for (HashMap<String, List<BasicMetadataUser>> map : mapList) {
                for (Map.Entry<String, List<BasicMetadataUser>> entry : map.entrySet()) {
                    String sasAppName = entry.getKey().toString();
                    if (!sasAppName.equalsIgnoreCase(app)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private List<String> getNewPSListFromDataMap(HashMap<GAOTemplate, List<HashMap<String, List<BasicMetadataUser>>>> dataMap, List<PropertySet> propertySetList) throws RemoteException {
        ArrayList<String> appListInMap = new ArrayList<String>();
        ArrayList<String> newPropertySetList = new ArrayList<String>();
        for (Map.Entry<GAOTemplate, List<HashMap<String, List<BasicMetadataUser>>>> pairs : dataMap.entrySet()) {
            List<HashMap<String, List<BasicMetadataUser>>> mapList = pairs.getValue();
            for (HashMap<String, List<BasicMetadataUser>> map : mapList) {
                for (Map.Entry<String, List<BasicMetadataUser>> entry : map.entrySet()) {
                    if (appListInMap.contains(entry.getKey())) continue;
                    appListInMap.add(entry.getKey());
                }
            }
        }
        for (String app : appListInMap) {
            boolean found = false;
            for (PropertySet ps : propertySetList) {
                if (!ps.getName().equalsIgnoreCase(app)) continue;
                found = true;
            }
            if (found) continue;
            newPropertySetList.add(app);
        }
        return newPropertySetList;
    }

    public boolean isSASAppGridCapable(String sasAppName) {
        List<String> appList = this.getExistingSASApplications();
        for (String app : appList) {
            if (!sasAppName.equalsIgnoreCase(app)) continue;
            return true;
        }
        return false;
    }

    public boolean popupSASAppNotGridCapable() {
        return JOptionPane.showConfirmDialog((Component)((Object)this), this.bundle.getString("GridServerPropertyPanel.Warning.SASAPPnotGridCapable.txt"), this.bundle.getString("GridServerPropertyPanel.ConfirmDelete.WindowTitle.txt"), 2, 2) == 0;
    }

    public WsTable getMappingTable() {
        return this.m_gridMappingsTable;
    }

    public List<BasicMetadataUser> getTotalUsers() {
        if (this.m_totalUserGroups == null) {
            try {
                this.m_totalUserGroups = this.getTotalUsers(this.m_server);
            }
            catch (ServiceException e) {
                e.printStackTrace();
                return null;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                return null;
            }
            catch (MdException e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.m_totalUsers;
    }

    public List<GAOTemplate> getTotalGaoTemplate() {
        return this.m_availableGAOs;
    }

    public void setTotalGaoTemplate(List<GAOTemplate> gaoList) {
        this.m_availableGAOs = gaoList;
    }

    public ServerInterface getServer() {
        return this.m_server;
    }

    public void setWorkload(String workload) {
        this.m_workload = workload;
    }

    public void setModule(String module) {
        this.m_module = module;
    }

    public String createFinishString() {
        return "";
    }
}

