/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.grid;

import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.customizers.grid.BasicMetadataUser;
import com.sas.workspace.mgmt.visuals.customizers.grid.GAOTemplate;
import com.sas.workspace.mgmt.visuals.customizers.grid.GaoMappingTableModel;
import com.sas.workspace.mgmt.visuals.customizers.grid.GridApplicationEditor;
import com.sas.workspace.mgmt.visuals.customizers.grid.GridServerPropertyPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class GridApplicationWizard
extends WAStandardDialog
implements ActionListener,
ListDataListener {
    private static final long serialVersionUID = 1L;
    private WAPanel mainPanel;
    private WAPanel mainContainerPanel;
    private GridServerPropertyPanel m_propPanel;
    private JLabel m_selectAppInfo;
    private JLabel m_selectUserInfo;
    private JButton m_btnApply;
    private JButton m_btnClose;
    private JButton m_btnNew;
    private JButton m_btnDelete;
    private JButton m_btnEdit;
    private JButton m_btnHelp;
    private JLabel m_gaoNameLabel;
    private JComboBox m_gaoBox;
    private JLabel m_appNameLabel;
    private JComboBox m_applicationBox;
    private DualListSelector m_userSelector = null;
    private GAOTemplate m_selectedGAO = null;
    private List<BasicMetadataUser> m_availableUsers = null;
    private List<GAOTemplate> m_availableGAOs = null;
    private JCheckBox m_showUsers = null;
    private JCheckBox m_showGroups = null;
    private JLabel m_searchLabel;
    private JTextField m_userSearchBox = null;
    private static String m_searchString = null;
    private String m_selectedSASApp = null;
    private boolean m_editWizard = false;
    private String m_selectedGAOID = null;
    private HashMap<GAOTemplate, List<HashMap<String, List<BasicMetadataUser>>>> m_dataMap = null;
    private List<BasicMetadataUser> m_totalUsers = null;
    private static final WAdminResource bundle = WAdminResource.getBundle(GridApplicationWizard.class);

    public GridApplicationWizard(GridServerPropertyPanel owner) {
        super((Frame)Workspace.getWorkspace(), bundle.getString("GridApplicationWizard.window.title.txt"));
        this.setLocation(owner.getLocationOnScreen());
        this.m_propPanel = owner;
        this.setHelpProduct("templatedata");
        this.setHelpTopic("grid_app_map");
    }

    public GridApplicationWizard(GridServerPropertyPanel owner, String sasApp, String gaoID, List<BasicMetadataUser> availableUsers) {
        super((Frame)((JFrame)SwingUtilities.getRoot((Component)((Object)owner)).getParent()), bundle.getString("GridApplicationWizard.window.title.txt"));
        this.setLocation(owner.getLocationOnScreen());
        this.m_propPanel = owner;
        this.m_availableUsers = availableUsers;
        this.m_selectedSASApp = sasApp;
        this.m_editWizard = true;
        this.m_selectedGAOID = gaoID;
        this.setHelpProduct("templatedata");
        this.setHelpTopic("grid_app_map");
    }

    public void initialize() {
        this.setResizable(true);
        this.m_totalUsers = new ArrayList<BasicMetadataUser>();
        this.m_availableGAOs = new ArrayList<GAOTemplate>();
        this.m_dataMap = ((GaoMappingTableModel)((Object)this.m_propPanel.getGridMappingTable().getModel())).getDataMap();
        this.mainContainerPanel = new WAPanel();
        this.mainContainerPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.mainPanel = new WAPanel();
        this.m_selectAppInfo = new JLabel(bundle.getString("GridApplicationWizard.appselect.instructions.label.txt"));
        this.m_selectUserInfo = new JLabel(bundle.getString("GridApplicationWizard.userselect.instructions.label.txt"));
        this.m_btnApply = new JButton(bundle.getString("GridApplicationWizard.apply.button.txt"));
        this.m_btnApply.setActionCommand("Apply");
        this.m_btnApply.addActionListener(this);
        this.m_btnClose = new JButton(bundle.getString("GridApplicationWizard.cancel.button.txt"));
        this.m_btnClose.setActionCommand("Cancel");
        this.m_btnClose.addActionListener(this);
        this.m_btnNew = new JButton(bundle.getString("GridApplicationWizard.new.button.txt"));
        this.m_btnNew.setActionCommand("CreateGAO");
        this.m_btnNew.addActionListener(this);
        this.m_btnDelete = new JButton(bundle.getString("GridApplicationWizard.delete.button.txt"));
        this.m_btnDelete.setActionCommand("DeleteGAO");
        this.m_btnDelete.addActionListener(this);
        this.m_btnEdit = new JButton(bundle.getString("GridApplicationWizard.modify.button.txt"));
        this.m_btnEdit.setActionCommand("EditGAO");
        this.m_btnEdit.addActionListener(this);
        this.m_applicationBox = new JComboBox();
        this.m_appNameLabel = new JLabel(bundle.getString("GridApplicationWizard.appname.label.txt"));
        this.m_showUsers = new JCheckBox(bundle.getString("GridApplicationWizard.showusers.label.txt"), true);
        this.m_showUsers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                m_searchString = GridApplicationWizard.this.m_userSearchBox.getText();
                GridApplicationWizard.this.updateSearch();
            }
        });
        this.m_showGroups = new JCheckBox(bundle.getString("GridApplicationWizard.showgroups.label.txt"), true);
        this.m_showGroups.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                m_searchString = GridApplicationWizard.this.m_userSearchBox.getText();
                GridApplicationWizard.this.updateSearch();
            }
        });
        this.m_searchLabel = new JLabel(bundle.getString("GridApplicationWizard.search.label.txt"));
        this.m_userSearchBox = new JTextField(5);
        this.m_userSearchBox.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                GridApplicationWizard.this.m_userSearchBox.setText("");
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() != null && !e.getOppositeComponent().equals(GridApplicationWizard.this.m_userSelector.getSourceComponent())) {
                    GridApplicationWizard.this.m_userSearchBox.setText("");
                }
            }
        });
        this.m_userSearchBox.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                try {
                    m_searchString = e.getDocument().getText(0, e.getDocument().getLength());
                    GridApplicationWizard.this.updateSearch();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                try {
                    m_searchString = e.getDocument().getText(0, e.getDocument().getLength());
                    GridApplicationWizard.this.updateSearch();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.m_userSelector = new DualListSelector();
        this.m_showUsers.setEnabled(false);
        this.m_showGroups.setEnabled(false);
        this.m_userSearchBox.setEnabled(false);
        this.m_gaoBox = new JComboBox();
        this.m_gaoNameLabel = new JLabel(bundle.getString("GridApplicationWizard.appobjectname.label.txt"));
        try {
            List<String> appList = this.m_propPanel.getExistingSASApplications();
            for (String s : appList) {
                this.m_applicationBox.addItem(s);
            }
            this.m_applicationBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (GridApplicationWizard.this.m_gaoBox.getSelectedItem() instanceof GAOTemplate && GridApplicationWizard.this.m_applicationBox.getSelectedIndex() != 0) {
                        GridApplicationWizard.this.m_selectedSASApp = ((JComboBox)evt.getSource()).getSelectedItem().toString();
                        GridApplicationWizard.this.m_selectedGAO = null;
                        GridApplicationWizard.this.resetSelectedModel();
                        GridApplicationWizard.this.m_selectedGAO = (GAOTemplate)GridApplicationWizard.this.m_gaoBox.getSelectedItem();
                        GridApplicationWizard.this.updateSelectedUsers(GridApplicationWizard.this.m_selectedGAO, GridApplicationWizard.this.m_selectedSASApp);
                        GridApplicationWizard.this.m_selectedGAO.setIsEdited(true);
                        GridApplicationWizard.this.enablePanel();
                    } else {
                        GridApplicationWizard.this.m_selectedSASApp = ((JComboBox)evt.getSource()).getSelectedItem().toString();
                        GridApplicationWizard.this.disablePanel();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.m_availableGAOs = this.m_propPanel.getTotalGaoTemplate();
        }
        catch (Exception e) {
            System.err.println("Could not get existing GAOs: ");
            e.printStackTrace();
        }
        this.m_gaoBox.addItem(bundle.getString("GridApplicationWizard.selectGAO.label.txt"));
        for (GAOTemplate g : this.m_availableGAOs) {
            if (g.isDeleted()) continue;
            this.m_gaoBox.addItem(g);
        }
        this.m_gaoBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Object o = GridApplicationWizard.this.m_gaoBox.getSelectedItem();
                int index = GridApplicationWizard.this.m_gaoBox.getSelectedIndex();
                Object evtSource = evt.getSource();
                if (GridApplicationWizard.this.m_gaoBox.getSelectedItem() instanceof GAOTemplate) {
                    GridApplicationWizard.this.m_selectedGAO = null;
                    GridApplicationWizard.this.resetSelectedModel();
                    GridApplicationWizard.this.m_selectedGAO = (GAOTemplate)GridApplicationWizard.this.m_gaoBox.getSelectedItem();
                    if (GridApplicationWizard.this.m_applicationBox.getSelectedIndex() != 0) {
                        GridApplicationWizard.this.updateSelectedUsers(GridApplicationWizard.this.m_selectedGAO, GridApplicationWizard.this.m_applicationBox.getSelectedItem().toString());
                        GridApplicationWizard.this.enablePanel();
                    } else {
                        GridApplicationWizard.this.disablePanel();
                    }
                } else if (evt.getSource() instanceof JComboBox && GridApplicationWizard.this.m_gaoBox.getSelectedItem() instanceof String) {
                    GridApplicationWizard.this.m_selectedGAO = null;
                    GridApplicationWizard.this.resetSelectedModel();
                    GridApplicationWizard.this.disablePanel();
                }
            }
        });
        try {
            this.m_availableUsers = this.getUsers(this.m_showUsers.isSelected(), this.m_showGroups.isSelected(), null, this.m_propPanel.getServer());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.m_userSelector.setSourceLabel(bundle.getString("GridApplicationWizard.availableidentities.label.txt"));
        this.m_userSelector.setTargetLabel(bundle.getString("GridApplicationWizard.selectedidentities.label.txt"));
        DefaultListModel<BasicMetadataUser> myModel = new DefaultListModel<BasicMetadataUser>();
        if (this.m_availableUsers == null) {
            try {
                this.m_availableUsers = this.getUsers(true, true, "", this.m_propPanel.getServer());
            }
            catch (Exception e) {
                System.err.println("Could not get users in initalization.");
                e.printStackTrace();
            }
        }
        for (BasicMetadataUser u : this.m_availableUsers) {
            myModel.addElement(u);
        }
        this.m_userSelector.setModel(myModel);
        this.m_userSelector.setTargetModel(new DefaultListModel());
        this.m_userSelector.getTargetModel().addListDataListener(this);
        this.m_userSelector.setEnabled(false);
        this.m_btnHelp = new JButton(bundle.getString("GridApplicationWizard.help.button.txt"));
        this.m_btnHelp.setAction(this.createHelpAction());
        if (this.m_editWizard) {
            for (GAOTemplate t : this.m_availableGAOs) {
                if (!t.getMetaId().equals(this.m_selectedGAOID)) continue;
                this.m_gaoBox.setSelectedItem(t);
            }
            this.m_applicationBox.setSelectedItem(this.m_selectedSASApp);
        }
    }

    public void layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.mainPanel.setLayout((LayoutManager)gridBagLayout);
        GridBagLayout contGridBagLayout = new GridBagLayout();
        this.mainContainerPanel.setLayout((LayoutManager)contGridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.anchor = 23;
        gbc.gridheight = 1;
        gbc.gridwidth = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gridBagLayout.setConstraints(this.m_selectAppInfo, gbc);
        this.mainPanel.add((Component)this.m_selectAppInfo);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(13, 10, 0, 10);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.anchor = 23;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gridBagLayout.setConstraints(this.m_appNameLabel, gbc);
        this.mainPanel.add((Component)this.m_appNameLabel);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.gridx = 3;
        gbc.gridy = gridy++;
        gbc.gridwidth = 6;
        gbc.anchor = 23;
        gbc.ipadx = 95;
        gbc.weighty = 0.0;
        gridBagLayout.setConstraints(this.m_applicationBox, gbc);
        this.mainPanel.add((Component)this.m_applicationBox);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(13, 10, 0, 10);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.anchor = 23;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gridBagLayout.setConstraints(this.m_gaoNameLabel, gbc);
        this.mainPanel.add((Component)this.m_gaoNameLabel);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.gridx = 3;
        gbc.gridy = gridy++;
        gbc.gridwidth = 20;
        gbc.anchor = 23;
        gbc.ipadx = 95;
        gbc.weighty = 0.0;
        gridBagLayout.setConstraints(this.m_gaoBox, gbc);
        this.mainPanel.add((Component)this.m_gaoBox);
        JPanel tableButtonPanel = new JPanel();
        this.m_btnNew.setMargin(new Insets(0, 10, 0, 10));
        this.m_btnEdit.setMargin(new Insets(0, 10, 0, 10));
        this.m_btnDelete.setMargin(new Insets(0, 10, 0, 10));
        tableButtonPanel.add(this.m_btnNew);
        tableButtonPanel.add(this.m_btnEdit);
        tableButtonPanel.add(this.m_btnDelete);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = gridy++;
        gbc.anchor = 23;
        gridBagLayout.setConstraints(tableButtonPanel, gbc);
        this.mainPanel.add((Component)tableButtonPanel);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(12, 0, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.gridwidth = 6;
        gbc.anchor = 11;
        gbc.weighty = 0.0;
        JSeparator sep = new JSeparator(0);
        sep.setPreferredSize(new Dimension(470, 1));
        gridBagLayout.setConstraints(sep, gbc);
        this.mainPanel.add((Component)sep);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(12, 0, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.anchor = 23;
        gbc.gridheight = 1;
        gbc.gridwidth = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gridBagLayout.setConstraints(this.m_selectUserInfo, gbc);
        this.mainPanel.add((Component)this.m_selectUserInfo);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 0, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.gridwidth = 1;
        gbc.anchor = 23;
        gbc.weighty = 0.0;
        gridBagLayout.setConstraints(this.m_showUsers, gbc);
        this.mainPanel.add((Component)this.m_showUsers);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 12, 0, 0);
        gbc.gridx = 2;
        gbc.gridy = gridy++;
        gbc.gridwidth = 2;
        gbc.anchor = 23;
        gbc.weighty = 0.0;
        gridBagLayout.setConstraints(this.m_showGroups, gbc);
        this.mainPanel.add((Component)this.m_showGroups);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(1, 3, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.gridwidth = 4;
        gbc.anchor = 23;
        gbc.weighty = 0.0;
        gbc.ipadx = 98;
        gridBagLayout.setConstraints(this.m_searchLabel, gbc);
        this.mainPanel.add((Component)this.m_searchLabel);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(1, 3, 0, 0);
        gbc.gridx = 3;
        gbc.gridy = gridy++;
        gbc.gridwidth = 20;
        gbc.anchor = 23;
        gbc.ipadx = 95;
        gbc.weighty = 0.0;
        gridBagLayout.setConstraints(this.m_userSearchBox, gbc);
        this.mainPanel.add((Component)this.m_userSearchBox);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 0, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.gridwidth = 10;
        gbc.gridheight = 1;
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.ipady = 3;
        gridBagLayout.setConstraints((Component)this.m_userSelector, gbc);
        this.mainPanel.add((Component)this.m_userSelector);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.anchor = 23;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        contGridBagLayout.setConstraints((Component)this.mainPanel, gbc);
        this.mainContainerPanel.add((Component)this.mainPanel);
        JPanel p = new JPanel();
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(17, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 25;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.ipadx = 350;
        contGridBagLayout.setConstraints(p, gbc);
        this.mainContainerPanel.add((Component)p);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(17, 0, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 26;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        contGridBagLayout.setConstraints(this.m_btnApply, gbc);
        this.mainContainerPanel.add((Component)this.m_btnApply);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(17, 0, 0, 0);
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 26;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        contGridBagLayout.setConstraints(this.m_btnClose, gbc);
        this.mainContainerPanel.add((Component)this.m_btnClose);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(17, 0, 0, 0);
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.anchor = 26;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        contGridBagLayout.setConstraints(this.m_btnHelp, gbc);
        this.mainContainerPanel.add((Component)this.m_btnHelp);
        this.add((Component)this.mainContainerPanel);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("Apply".equals(e.getActionCommand())) {
            try {
                this.validateAndSaveData();
                this.dispose();
            }
            catch (Exception ex) {
                System.err.println(ex.getLocalizedMessage());
                ex.printStackTrace();
            }
        } else if ("Cancel".equals(e.getActionCommand())) {
            this.dispose();
        } else if ("CreateGAO".equals(e.getActionCommand())) {
            this.makeNewGAO();
        } else if ("EditGAO".equals(e.getActionCommand())) {
            if (this.m_gaoBox.getSelectedItem() instanceof GAOTemplate) {
                this.editExistingGAO((GAOTemplate)this.m_gaoBox.getSelectedItem());
            }
        } else if ("DeleteGAO".equals(e.getActionCommand())) {
            if (this.m_gaoBox.getSelectedItem() instanceof GAOTemplate && this.m_propPanel.confirmDelete((Component)((Object)this))) {
                this.deleteExistingGAO((GAOTemplate)this.m_gaoBox.getSelectedItem());
            }
        } else if ("showUsersChanged".equals(e.getActionCommand())) {
            this.updateSearch();
        } else if ("showGroupsChanged".equals(e.getActionCommand())) {
            this.updateSearch();
        }
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
    }

    private void makeNewGAO() {
        GAOTemplate newGAO = new GAOTemplate(true);
        GridApplicationEditor mappingWizard = new GridApplicationEditor((JDialog)((Object)this), newGAO, bundle.getString("GridApplicationWizard.newGAO.window.title.txt"), this.m_availableGAOs);
        if (mappingWizard != null) {
            mappingWizard.setModal(true);
            mappingWizard.setVisible(true);
        }
        if (mappingWizard.getReturnValue() == 0 || mappingWizard.getReturnValue() == 1) {
            this.m_availableGAOs.add(newGAO);
        }
        this.refreshGaoBox();
        this.m_gaoBox.setSelectedItem(newGAO);
    }

    private void editExistingGAO(GAOTemplate toEdit) {
        GridApplicationEditor mappingWizard = new GridApplicationEditor((JDialog)((Object)this), toEdit, bundle.getString("GridApplicationWizard.editGAO.window.title.txt"), this.m_availableGAOs);
        if (mappingWizard != null) {
            mappingWizard.setModal(true);
            mappingWizard.setVisible(true);
        }
        this.refreshGaoBox();
        this.m_gaoBox.setSelectedItem(toEdit);
    }

    private void deleteExistingGAO(GAOTemplate toDelete) {
        if (!toDelete.isNew()) {
            this.m_propPanel.refreshMappingTable(this.m_selectedSASApp, toDelete, null, true);
            try {
                this.m_propPanel.deleteMetadataGAO(toDelete, this.m_propPanel.getServer(), true);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
            catch (MdException e) {
                e.printStackTrace();
            }
        }
        this.m_availableGAOs.remove(toDelete);
        this.refreshGaoBox();
    }

    private void refreshGaoBox() {
        int selectedIndex = this.m_gaoBox.getSelectedIndex();
        this.m_gaoBox.removeAllItems();
        this.m_gaoBox.addItem(bundle.getString("GridApplicationWizard.selectGAO.label.txt"));
        int count = 0;
        for (GAOTemplate g : this.m_availableGAOs) {
            this.m_gaoBox.addItem(g);
            ++count;
        }
        if (selectedIndex > 0 && selectedIndex < count) {
            this.m_gaoBox.setSelectedIndex(selectedIndex);
        }
    }

    private void updateSelectedUsers(GAOTemplate t, String appName) {
        DefaultListModel baseModel = (DefaultListModel)this.m_userSelector.getModel();
        DefaultListModel targetModel = (DefaultListModel)this.m_userSelector.getTargetModel();
        List<Object> userList = new ArrayList();
        this.resetSelectedModel();
        GaoMappingTableModel model = (GaoMappingTableModel)((Object)this.m_propPanel.getMappingTable().getModel());
        HashMap<GAOTemplate, List<HashMap<String, List<BasicMetadataUser>>>> dataMap = model.getDataMap();
        userList = model.getUserListFromLocalTemplate(t.getName(), appName, dataMap);
        if (userList.size() > 0) {
            Collections.sort(userList);
            for (BasicMetadataUser basicMetadataUser : userList) {
                baseModel.removeElement(basicMetadataUser);
                targetModel.addElement(basicMetadataUser);
            }
        }
        this.m_userSelector.repaint();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
            BasicMetadataUser addedUser = new BasicMetadataUser((BasicMetadataUser)this.m_userSelector.getTargetModel().getElementAt(i));
            if (!(this.m_selectedGAO instanceof GAOTemplate) || this.m_selectedGAO.getSelectedUsers().contains(addedUser)) continue;
            this.m_selectedGAO.addUser(addedUser);
            this.m_selectedGAO.setIsEdited(true);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        if (this.m_selectedGAO instanceof GAOTemplate && this.m_applicationBox.getSelectedIndex() != 0) {
            ArrayList<BasicMetadataUser> usersInThisApp = new ArrayList<BasicMetadataUser>();
            for (BasicMetadataUser u : this.m_selectedGAO.getSelectedUsers()) {
                usersInThisApp.add(u);
            }
            DefaultListModel baseM = (DefaultListModel)this.m_userSelector.getModel();
            for (int i = 0; i < baseM.size(); ++i) {
                try {
                    BasicMetadataUser removed = (BasicMetadataUser)baseM.get(i);
                    if (!usersInThisApp.contains(removed)) continue;
                    this.m_selectedGAO.removeUser(removed);
                    this.m_selectedGAO.setIsEdited(true);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void resetSelectedModel() {
        DefaultListModel targetM = (DefaultListModel)this.m_userSelector.getTargetModel();
        for (int i = 0; i < targetM.getSize(); ++i) {
            ((DefaultListModel)this.m_userSelector.getModel()).addElement((BasicMetadataUser)targetM.get(i));
        }
        targetM.clear();
        this.m_userSelector.repaint();
    }

    private List<BasicMetadataUser> getSelectedUsers() {
        DefaultListModel targetM = (DefaultListModel)this.m_userSelector.getTargetModel();
        ArrayList<BasicMetadataUser> userList = new ArrayList<BasicMetadataUser>();
        for (int i = 0; i < targetM.getSize(); ++i) {
            userList.add((BasicMetadataUser)targetM.get(i));
        }
        return userList;
    }

    public List<BasicMetadataUser> getUsers(boolean usersChecked, boolean groupsChecked, String searchqry, ServerInterface server) throws ServiceException, MdException, RemoteException {
        int flags = 26780;
        Filter filter = new Filter();
        filter.setOMRFlags(flags);
        filter.setType("Identity");
        String bothSearchString = "<XMLSelect search=\"*[@PublicType='User' or @PublicType='UserGroup']\"/>";
        String userSearchString = "<XMLSelect search=\"*[@PublicType='User']\"/>";
        String groupSearchString = "<XMLSelect search=\"*[@PublicType='UserGroup']\"/>";
        if (usersChecked && groupsChecked) {
            filter.setExplicitSearchString("omi", bothSearchString);
        } else if (usersChecked) {
            filter.setExplicitSearchString("omi", userSearchString);
        } else if (groupsChecked) {
            filter.setExplicitSearchString("omi", groupSearchString);
        } else {
            return new ArrayList<BasicMetadataUser>();
        }
        List identitiesList = new ArrayList();
        ArrayList<BasicMetadataUser> users = new ArrayList<BasicMetadataUser>();
        identitiesList = server.browseSearch((FilterInterface)filter);
        for (BrowseMetadataInterface e : identitiesList) {
            if (e.getName().equalsIgnoreCase("PUBLIC")) continue;
            if ((String)e.getRawData().get("DisplayName") != null && (String)e.getRawData().get("Id") != null) {
                users.add(new BasicMetadataUser(e.getName(), (String)e.getRawData().get("Id"), (String)e.getRawData().get("DisplayName")));
                continue;
            }
            users.add(new BasicMetadataUser(e.getName(), e.getReposId()));
        }
        Collections.sort(users);
        if (searchqry != null && searchqry.length() >= 1) {
            ArrayList<BasicMetadataUser> newUsers = new ArrayList<BasicMetadataUser>();
            for (BasicMetadataUser user : users) {
                if (!user.userName.toUpperCase().contains(searchqry.toUpperCase()) && (user.userDisplayName == null || !user.userDisplayName.toUpperCase().contains(searchqry.toUpperCase()))) continue;
                newUsers.add(user);
            }
            return newUsers;
        }
        return users;
    }

    public void validateAndSaveData() throws MdException, RemoteException, ServiceException {
        for (GAOTemplate t : this.m_availableGAOs) {
            if (t.isNew()) {
                this.m_propPanel.createNewMetadataGAO(t, this.m_propPanel.getServer());
                if (!Workspace.isDebug()) continue;
                System.out.println("Create new GAO:" + t.getName());
                System.out.println("Grid Options: " + t.getGridOptions());
                System.out.println("Reqd Resources: " + t.getRequiredResources());
                System.out.println("SAS Options: " + t.getSASOptions());
                continue;
            }
            if (!t.isEdited()) continue;
            this.m_propPanel.updateRemoteGAO(t, this.m_propPanel.getServer());
            if (!Workspace.isDebug()) continue;
            System.out.println("Edit GAO:" + t.getName());
            System.out.println("Grid Options: " + t.getGridOptions());
            System.out.println("Reqd Resources: " + t.getRequiredResources());
            System.out.println("SAS Options: " + t.getSASOptions());
        }
        if (this.m_selectedSASApp != null && this.m_selectedGAO != null && this.m_selectedGAO.getName().trim().length() > 0) {
            List<BasicMetadataUser> selectedUserGroups = this.getSelectedUsers();
            if (selectedUserGroups != null && selectedUserGroups.size() == 0) {
                if (Workspace.isDebug()) {
                    System.out.println("Not saving selected mapping since the selected user is zero: selectedSASApp=" + this.m_selectedSASApp + ";Selected gao=" + this.m_selectedGAO.getName());
                }
            } else if (selectedUserGroups != null && selectedUserGroups.size() > 0) {
                this.m_propPanel.refreshMappingTable(this.m_selectedSASApp, this.m_selectedGAO, selectedUserGroups, false);
                if (Workspace.isDebug()) {
                    System.out.println("Save selected mapping: selectedSASApp=" + this.m_selectedSASApp + ";Selected gao=" + this.m_selectedGAO.getName());
                }
            }
        }
        this.m_propPanel.setTotalGaoTemplate(this.m_availableGAOs);
        this.m_propPanel.sortMappingTable();
        this.m_propPanel.isSelectedRowAvailable();
    }

    private void enablePanel() {
        this.m_selectUserInfo.setEnabled(true);
        this.m_showUsers.setEnabled(true);
        this.m_showGroups.setEnabled(true);
        this.m_userSearchBox.setEnabled(true);
        this.m_userSelector.setEnabled(true);
    }

    private void disablePanel() {
        this.m_selectUserInfo.setEnabled(false);
        this.m_showUsers.setEnabled(false);
        this.m_showGroups.setEnabled(false);
        this.m_userSearchBox.setEnabled(false);
        this.m_userSelector.setEnabled(false);
    }

    protected void updateSearch() {
        if (m_searchString == "" || m_searchString == null) {
            try {
                this.m_availableUsers = this.getUsers(this.m_showUsers.isSelected(), this.m_showGroups.isSelected(), "", this.m_propPanel.getServer());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            try {
                this.m_availableUsers = this.getUsers(this.m_showUsers.isSelected(), this.m_showGroups.isSelected(), m_searchString, this.m_propPanel.getServer());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        DefaultListModel usermodel = (DefaultListModel)this.m_userSelector.getModel();
        DefaultListModel targetmodel = (DefaultListModel)this.m_userSelector.getTargetModel();
        usermodel.removeAllElements();
        for (BasicMetadataUser u : this.m_availableUsers) {
            if (targetmodel.contains(u)) continue;
            usermodel.addElement(u);
        }
        for (int i = usermodel.getSize() - 1; i >= 0; --i) {
            if (!targetmodel.contains(usermodel.get(i))) continue;
            usermodel.remove(i);
        }
        for (BasicMetadataUser u : this.m_availableUsers) {
            if (!this.m_selectedGAO.getSelectedUsers().contains(u) || targetmodel.contains(u)) continue;
            targetmodel.addElement(u);
        }
        this.m_userSelector.repaint();
    }

    private int getSelectedUsers(List<BasicMetadataUser> users) {
        int userCount = 0;
        if (this.m_totalUsers != null && this.m_totalUsers.size() == 0) {
            this.m_totalUsers = this.m_propPanel.getTotalUsers();
        }
        for (BasicMetadataUser user : users) {
            if (!this.m_totalUsers.contains(user)) continue;
            ++userCount;
        }
        return userCount;
    }
}

