/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.grid;

import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.mgmt.visuals.customizers.grid.GAOTemplate;
import com.sas.workspace.mgmt.visuals.customizers.grid.GridApplicationWizard;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GridApplicationEditor
extends WAStandardDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JTextField m_gaoName = null;
    private JTextField m_gaoGridOption = null;
    private JTextField m_gaoReqdResources = null;
    private JTextField m_gaoSASOption = null;
    private JLabel m_nameLabel = null;
    private JLabel m_gridOptionLabel = null;
    private JLabel m_gridReqdResourcesLabel = null;
    private JLabel m_gaoSASOptionLabel = null;
    private WAPanel mainPanel;
    private WAPanel mainContainerPanel;
    private String m_gaoNameResult;
    private String m_gaoGridOptionResult;
    private String m_gaoReqdResourcesResult;
    private String m_gaoSASOptionResult;
    private static final WAdminResource bundle = WAdminResource.getBundle(GridApplicationWizard.class);
    private GAOTemplate m_gao = null;
    private boolean nameChanged = false;
    private boolean gridOptionsChanged = false;
    private boolean reqdResourcesChanged = false;
    private boolean SASOptionsChanged = false;
    private List<GAOTemplate> allGAOs = null;

    public GridApplicationEditor(JDialog owner, GAOTemplate toEdit, String windowTitle, List<GAOTemplate> allgridapps) {
        super((Dialog)owner, windowTitle, false);
        this.m_gao = toEdit;
        this.allGAOs = allgridapps;
        this.setHelpProduct("templatedata");
        this.setHelpTopic("grid_app_edit");
    }

    public void initialize() {
        this.setModalExclusionType(Dialog.ModalExclusionType.TOOLKIT_EXCLUDE);
        this.setOKButtonVisible(true);
        this.setCancelButtonVisible(true);
        this.setHelpButtonVisible(true);
        this.mainContainerPanel = new WAPanel();
        this.mainContainerPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 6, 11));
        this.mainPanel = new WAPanel();
        this.m_btnApply = new JButton(bundle.getString("GridApplicationEditor.apply.button.txt"));
        this.m_btnApply.addActionListener(this);
        this.m_btnApply.setAction(this.createOKAction());
        this.m_btnClose = new JButton(bundle.getString("GridApplicationEditor.cancel.button.txt"));
        this.m_btnClose.setAction(this.createCancelAction());
        this.m_btnHelp = new JButton(bundle.getString("GridApplicationWizard.help.button.txt"));
        this.m_btnHelp.setAction(this.createHelpAction());
        this.m_nameLabel = new JLabel(bundle.getString("GridApplicationEditor.gaoname.label.txt"));
        this.m_gridOptionLabel = new JLabel(bundle.getString("GridApplicationEditor.gridoption.label.txt"));
        this.m_gridReqdResourcesLabel = new JLabel(bundle.getString("GridApplicationEditor.reqdresources.label.txt"));
        this.m_gaoSASOptionLabel = new JLabel(bundle.getString("GridApplicationEditor.sasoption.label.txt"));
        this.m_gaoName = new JTextField(20);
        this.m_gaoGridOption = new JTextField(20);
        this.m_gaoReqdResources = new JTextField(20);
        this.m_gaoSASOption = new JTextField(20);
        this.m_gaoName.setText(this.m_gao.getName());
        this.m_gaoGridOption.setText(this.m_gao.getGridOptions());
        this.m_gaoGridOption.setToolTipText(bundle.getString("Grid.Application.Grid.Options.desc.xmlKey.txt"));
        this.m_gaoReqdResources.setText(this.m_gao.getRequiredResources());
        this.m_gaoSASOption.setText(this.m_gao.getSASOptions());
        this.m_gaoSASOption.setToolTipText(bundle.getString("Grid.Application.SAS.Options.desc.xmlKey.txt"));
        this.m_gaoName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                try {
                    GridApplicationEditor.this.m_gaoNameResult = e.getDocument().getText(0, e.getDocument().getLength());
                    GridApplicationEditor.this.nameChanged = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                try {
                    GridApplicationEditor.this.m_gaoNameResult = e.getDocument().getText(0, e.getDocument().getLength());
                    GridApplicationEditor.this.nameChanged = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.m_gaoGridOption.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                try {
                    GridApplicationEditor.this.m_gaoGridOptionResult = e.getDocument().getText(0, e.getDocument().getLength());
                    GridApplicationEditor.this.gridOptionsChanged = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                try {
                    GridApplicationEditor.this.m_gaoGridOptionResult = e.getDocument().getText(0, e.getDocument().getLength());
                    GridApplicationEditor.this.gridOptionsChanged = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.m_gaoReqdResources.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                try {
                    GridApplicationEditor.this.m_gaoReqdResourcesResult = e.getDocument().getText(0, e.getDocument().getLength());
                    GridApplicationEditor.this.reqdResourcesChanged = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                try {
                    GridApplicationEditor.this.m_gaoReqdResourcesResult = e.getDocument().getText(0, e.getDocument().getLength());
                    GridApplicationEditor.this.reqdResourcesChanged = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.m_gaoSASOption.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                try {
                    GridApplicationEditor.this.m_gaoSASOptionResult = e.getDocument().getText(0, e.getDocument().getLength());
                    GridApplicationEditor.this.SASOptionsChanged = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                try {
                    GridApplicationEditor.this.m_gaoSASOptionResult = e.getDocument().getText(0, e.getDocument().getLength());
                    GridApplicationEditor.this.SASOptionsChanged = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public void layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.mainPanel.setLayout((LayoutManager)gridBagLayout);
        GridBagLayout contGridBagLayout = new GridBagLayout();
        this.mainContainerPanel.setLayout((LayoutManager)contGridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(1, 0, 0, 10);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.anchor = 21;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gridBagLayout.setConstraints(this.m_nameLabel, gbc);
        this.mainPanel.add((Component)this.m_nameLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = gridy++;
        gbc.anchor = 22;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.ipadx = 100;
        gridBagLayout.setConstraints(this.m_gaoName, gbc);
        this.mainPanel.add((Component)this.m_gaoName);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 0, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.anchor = 21;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gridBagLayout.setConstraints(this.m_gaoSASOptionLabel, gbc);
        this.mainPanel.add((Component)this.m_gaoSASOptionLabel);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 0, 0, 0);
        gbc.gridx = 2;
        gbc.gridy = gridy++;
        gbc.anchor = 22;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.ipadx = 100;
        gridBagLayout.setConstraints(this.m_gaoSASOption, gbc);
        this.mainPanel.add((Component)this.m_gaoSASOption);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 0, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.anchor = 21;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gridBagLayout.setConstraints(this.m_gridReqdResourcesLabel, gbc);
        this.mainPanel.add((Component)this.m_gridReqdResourcesLabel);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 0, 0, 0);
        gbc.gridx = 2;
        gbc.gridy = gridy++;
        gbc.anchor = 22;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.ipadx = 100;
        gridBagLayout.setConstraints(this.m_gaoReqdResources, gbc);
        this.mainPanel.add((Component)this.m_gaoReqdResources);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 0, 0, 10);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.anchor = 21;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gridBagLayout.setConstraints(this.m_gridOptionLabel, gbc);
        this.mainPanel.add((Component)this.m_gridOptionLabel);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 0, 0, 0);
        gbc.gridx = 2;
        gbc.gridy = gridy;
        gbc.anchor = 22;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.ipadx = 100;
        gridBagLayout.setConstraints(this.m_gaoGridOption, gbc);
        this.mainPanel.add((Component)this.m_gaoGridOption);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.anchor = 20;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        contGridBagLayout.setConstraints((Component)this.mainPanel, gbc);
        this.mainContainerPanel.add((Component)this.mainPanel);
        JPanel p = new JPanel();
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(17, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 25;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.ipadx = 100;
        contGridBagLayout.setConstraints(p, gbc);
        this.mainContainerPanel.add((Component)p);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(17, 0, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 26;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        contGridBagLayout.setConstraints(this.m_btnApply, gbc);
        this.mainContainerPanel.add((Component)this.m_btnApply);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(17, 0, 0, 0);
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 26;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        contGridBagLayout.setConstraints(this.m_btnClose, gbc);
        this.mainContainerPanel.add((Component)this.m_btnClose);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(17, 0, 0, 0);
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.anchor = 26;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        contGridBagLayout.setConstraints(this.m_btnHelp, gbc);
        this.mainContainerPanel.add((Component)this.m_btnHelp);
        this.add((Component)this.mainContainerPanel);
        this.pack();
        this.m_gaoName.requestFocusInWindow();
    }

    public boolean onOK() {
        if (("".equals(this.m_gaoNameResult) || this.m_gaoNameResult == null) && "".equals(this.m_gao.getName()) || this.nameChanged && "".equals(this.m_gaoNameResult)) {
            MessageUtil.displayMessage((String)bundle.getString("GridApplicationEditor.namenotgivenerror.label.txt"));
            return false;
        }
        for (GAOTemplate t : this.allGAOs) {
            if (!t.getName().equals(this.m_gaoNameResult)) continue;
            MessageUtil.displayMessage((String)bundle.getString("GridApplicationEditor.duplicatenameerror.label.txt"));
            return false;
        }
        if (this.nameChanged) {
            this.m_gao.setName(this.m_gaoNameResult);
            this.m_gao.setIsEdited(true);
        }
        if (this.gridOptionsChanged) {
            this.m_gao.setGridOptions(this.m_gaoGridOptionResult);
            this.m_gao.setIsEdited(true);
        }
        if (this.reqdResourcesChanged) {
            this.m_gao.setRequiredResources(this.m_gaoReqdResourcesResult);
            this.m_gao.setIsEdited(true);
        }
        if (this.SASOptionsChanged) {
            this.m_gao.setSASOptions(this.m_gaoSASOptionResult);
            this.m_gao.setIsEdited(true);
        }
        return true;
    }
}

