/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.dbms;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.visuals.PropertiesPropertyView;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import com.sas.workspace.mgmt.visuals.customizers.dbms.SAPHANAServerPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SAPHANAConnectionPanel
extends WsDescriptionWizardTab {
    private SASClientConnection m_connection;
    private String m_strReposID;
    private List<Property> m_lstProperties;
    private JRadioButton m_rdoServer;
    private JButton m_btnServer;
    private JRadioButton m_rdoODBC;
    private WATextField m_txtODBC;
    private JRadioButton m_rdoConnection;
    private WATextField m_txtConnection;
    private SAPHANAServerPanel m_pnlServer;
    protected static final WAdminResource templBundle = new WAdminResource("com.sas.svcs.metadata.mgmt.impl.repository.data.ResourceTemplates.Resources");
    protected static final WAdminResource uigenBundle = new WAdminResource(PropertiesPropertyView.class);
    private static final long serialVersionUID = 1L;

    public SAPHANAConnectionPanel(SASClientConnection connection, String reposID, List<Property> propertyList) {
        this.m_connection = connection;
        this.m_strReposID = reposID;
        this.m_lstProperties = propertyList;
        this.initialize();
        this.layoutWidgets();
    }

    public void moveDataToStore() throws MdException, RemoteException {
        Property property2;
        int index;
        AssociationList lstProperties = this.m_connection.getProperties();
        if (!this.m_rdoServer.isSelected()) {
            for (index = 0; index < lstProperties.size(); ++index) {
                property2 = (Property)lstProperties.get(index);
                if (property2.getPropertyName().equalsIgnoreCase("DSN") || property2.getPropertyName().equalsIgnoreCase("NOPROMPT")) continue;
                lstProperties.remove(property2);
                PrototypeUtil.deleteProperty(property2);
                --index;
            }
        }
        if (this.m_rdoODBC.isSelected()) {
            for (Property property2 : lstProperties) {
                if (!property2.getPropertyName().equalsIgnoreCase("DSN")) continue;
                if (property2.getDefaultValue().equalsIgnoreCase(this.m_txtODBC.getText().trim())) {
                    return;
                }
                property2.setDefaultValue(this.m_txtODBC.getText().trim());
                return;
            }
            for (int index2 = 0; index2 < lstProperties.size(); ++index2) {
                property2 = (Property)lstProperties.get(index2);
                lstProperties.remove(property2);
                PrototypeUtil.deleteProperty(property2);
                --index2;
            }
            lstProperties.clear();
            Property propPrototype = null;
            for (int index3 = 0; index3 < this.m_lstProperties.size(); ++index3) {
                Property property3 = this.m_lstProperties.get(index3);
                if (!property3.getPropertyName().equalsIgnoreCase("DSN")) continue;
                propPrototype = property3;
                break;
            }
            Property property4 = PrototypeUtil.createProperty(propPrototype, (MdObjectStore)this.m_connection.getObjectStore(), this.m_strReposID);
            property4.setDefaultValue(this.m_txtODBC.getText().trim());
            lstProperties.add(property4);
        } else if (this.m_rdoConnection.isSelected()) {
            for (Property property2 : lstProperties) {
                if (!property2.getPropertyName().equalsIgnoreCase("NOPROMPT")) continue;
                if (property2.getDefaultValue().equalsIgnoreCase(this.m_txtConnection.getText().trim())) {
                    return;
                }
                property2.setDefaultValue(this.m_txtConnection.getText().trim());
                return;
            }
            for (int index4 = 0; index4 < lstProperties.size(); ++index4) {
                property2 = (Property)lstProperties.get(index4);
                lstProperties.remove(property2);
                PrototypeUtil.deleteProperty(property2);
                --index4;
            }
            lstProperties.clear();
            Property propPrototype = null;
            for (int index5 = 0; index5 < this.m_lstProperties.size(); ++index5) {
                Property property5 = this.m_lstProperties.get(index5);
                if (!property5.getPropertyName().equalsIgnoreCase("NOPROMPT")) continue;
                propPrototype = property5;
                break;
            }
            Property property6 = PrototypeUtil.createProperty(propPrototype, (MdObjectStore)this.m_connection.getObjectStore(), this.m_strReposID);
            property6.setDefaultValue(this.m_txtConnection.getText().trim());
            lstProperties.add(property6);
        } else {
            for (index = 0; index < lstProperties.size(); ++index) {
                property2 = (Property)lstProperties.get(index);
                if (!property2.getPropertyName().equalsIgnoreCase("DSN") && !property2.getPropertyName().equalsIgnoreCase("NOPROMPT")) continue;
                this.m_connection.getProperties().remove((Object)property2);
                PrototypeUtil.deleteProperty(property2);
                --index;
            }
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        AssociationList lstProperties = this.m_connection.getProperties();
        for (Property property : lstProperties) {
            if (property.getPropertyName().equalsIgnoreCase("DSN")) {
                this.m_txtODBC.setText(property.getDefaultValue());
                this.m_rdoODBC.setSelected(true);
                break;
            }
            if (!property.getPropertyName().equalsIgnoreCase("NOPROMPT")) continue;
            this.m_txtConnection.setText(property.getDefaultValue());
            this.m_rdoConnection.setSelected(true);
            break;
        }
        this.enableComponent(this.m_rdoServer, this.m_btnServer);
        this.enableComponent(this.m_rdoODBC, (JComponent)this.m_txtODBC);
        this.enableComponent(this.m_rdoConnection, (JComponent)this.m_txtConnection);
    }

    public boolean validateData() {
        if (this.m_rdoODBC.isSelected()) {
            if (this.m_txtODBC.getText().trim().length() == 0) {
                String strMessage = uigenBundle.formatString("PropertiesPropertyView.FieldIsRequired.fmt.txt", (Object)templBundle.getString("Connection.DBMS.Property.DSN.Name.xmlKey.txt"));
                String strTitle = uigenBundle.getString("Common.RequiredField.txt");
                MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
                return false;
            }
        } else if (this.m_rdoConnection.isSelected()) {
            if (this.m_txtConnection.getText().trim().length() == 0) {
                String strMessage = uigenBundle.formatString("PropertiesPropertyView.FieldIsRequired.fmt.txt", (Object)templBundle.getString("Connection.DBMS.Property.NOPROMPT.Name.xmlKey.txt"));
                String strTitle = uigenBundle.getString("Common.RequiredField.txt");
                MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
                return false;
            }
        } else {
            try {
                boolean bServerPropFound = false;
                AssociationList lstProperties = this.m_connection.getProperties();
                for (Property property : lstProperties) {
                    if (!property.getPropertyName().equalsIgnoreCase("SERVER")) continue;
                    bServerPropFound = true;
                }
                if (!bServerPropFound) {
                    String strMessage = uigenBundle.formatString("PropertiesPropertyView.SelectOneFieldInGroup.fmt.txt", (Object)templBundle.getString("Connection.DBMS.PropertyGroup.SRV.Name.xmlKey.txt"));
                    String strTitle = uigenBundle.getString("Common.RequiredField.txt");
                    MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
                    return false;
                }
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
            catch (MdException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }
        return true;
    }

    public String createFinishString() {
        String strFinish = "";
        if (this.m_pnlServer != null) {
            strFinish = strFinish + this.m_pnlServer.createFinishString();
        }
        try {
            AssociationList lstProperties = this.m_connection.getProperties();
            for (Property property : lstProperties) {
                if (!property.getPropertyName().equalsIgnoreCase("DSN") && !property.getPropertyName().equalsIgnoreCase("NOPROMPT")) continue;
                strFinish = strFinish + uigenBundle.formatString("PropertiesPropertyView.LabelColon.fmt", (Object)templBundle.getString(property.getName())) + "\n\t" + property.getDefaultValue() + "\n";
            }
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        catch (MdException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        return strFinish;
    }

    private void onOptions() {
        Container parent = this.getTopLevelAncestor();
        WAPropertyDialog dialog = null;
        if (parent instanceof Frame) {
            dialog = new WAPropertyDialog((Frame)parent, uigenBundle.formatString("PropertiesPropertyView.GroupOptionsTitle.fmt.txt", (Object)templBundle.getString("Connection.DBMS.PropertyGroup.SRV.Name.xmlKey.txt")), true);
        } else if (parent instanceof Dialog) {
            dialog = new WAPropertyDialog((Dialog)parent, uigenBundle.formatString("PropertiesPropertyView.GroupOptionsTitle.fmt.txt", (Object)templBundle.getString("Connection.DBMS.PropertyGroup.SRV.Name.xmlKey.txt")), true);
        }
        this.m_pnlServer = new SAPHANAServerPanel(this.m_connection, this.m_strReposID);
        dialog.setMainPanel((WAPanel)this.m_pnlServer);
        dialog.pack();
        dialog.show();
    }

    protected void initialize() {
        this.m_rdoServer = new JRadioButton(uigenBundle.formatString("PropertiesPropertyView.LabelColon.fmt", (Object)templBundle.getString("Connection.DBMS.PropertyGroup.SRV.Name.xmlKey.txt")));
        this.m_rdoServer.setSelected(true);
        this.m_btnServer = new JButton(uigenBundle.getString("Common.Options....txt"));
        this.m_rdoServer.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SAPHANAConnectionPanel.this.enableComponent(SAPHANAConnectionPanel.this.m_rdoServer, SAPHANAConnectionPanel.this.m_btnServer);
            }
        });
        this.m_btnServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SAPHANAConnectionPanel.this.onOptions();
            }
        });
        this.m_rdoODBC = new JRadioButton(uigenBundle.formatString("PropertiesPropertyView.LabelColon.fmt", (Object)templBundle.getString("Connection.DBMS.Property.DSN.Name.xmlKey.txt")));
        this.m_txtODBC = new WATextField();
        this.m_txtODBC.setToolTipText(templBundle.getString("Connection.DBMS.Property.DSN.Desc.xmlKey.txt"));
        this.m_rdoODBC.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SAPHANAConnectionPanel.this.enableComponent(SAPHANAConnectionPanel.this.m_rdoODBC, (JComponent)SAPHANAConnectionPanel.this.m_txtODBC);
            }
        });
        this.m_rdoConnection = new JRadioButton(uigenBundle.formatString("PropertiesPropertyView.LabelColon.fmt", (Object)templBundle.getString("Connection.DBMS.Property.NOPROMPT.Name.xmlKey.txt")));
        this.m_txtConnection = new WATextField();
        this.m_txtConnection.setToolTipText(templBundle.getString("Connection.DBMS.Property.NOPROMPT.Desc.xmlKey.txt"));
        this.m_rdoConnection.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SAPHANAConnectionPanel.this.enableComponent(SAPHANAConnectionPanel.this.m_rdoConnection, (JComponent)SAPHANAConnectionPanel.this.m_txtConnection);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_rdoServer);
        buttonGroup.add(this.m_rdoODBC);
        buttonGroup.add(this.m_rdoConnection);
    }

    protected void layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_rdoServer, gbc);
        this.add(this.m_rdoServer);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_btnServer, gbc);
        this.add(this.m_btnServer);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_rdoODBC, gbc);
        this.add(this.m_rdoODBC);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints((Component)this.m_txtODBC, gbc);
        this.add((Component)this.m_txtODBC);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_rdoConnection, gbc);
        this.add(this.m_rdoConnection);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints((Component)this.m_txtConnection, gbc);
        this.add((Component)this.m_txtConnection);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }

    private void enableComponent(JToggleButton source, JComponent target) {
        target.setEnabled(source.isSelected());
    }
}

