/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.dbms;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.visuals.PropertiesPropertyView;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import com.sas.workspace.mgmt.visuals.customizers.dbms.DirectSQLPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JPanel;

public class OptimizationPanel
extends WsDescriptionWizardTab {
    private SASLibrary m_library;
    private String m_strReposID;
    private List<Property> m_lstProperties;
    private int m_iViewType;
    private MdObjectStore m_stoTemp;
    private PropertiesPropertyView m_pnlProp;
    private DirectSQLPanel m_pnlDirSQL;
    private static final long serialVersionUID = 1L;

    public OptimizationPanel(SASLibrary library, String reposID, List<Property> propertyList, int viewType) {
        this.m_library = library;
        this.m_strReposID = reposID;
        this.m_lstProperties = propertyList;
        this.m_iViewType = viewType;
        this.initialize();
        this.layoutWidgets();
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_pnlProp.moveDataToStore();
        this.m_pnlDirSQL.moveDataToStore();
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_pnlProp.populateStore();
        this.m_pnlDirSQL.populateStore();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.m_pnlProp.moveDataToView();
        this.m_pnlDirSQL.moveDataToView();
    }

    public boolean validateData() {
        boolean bValidated = this.m_pnlProp.validateData();
        if (bValidated) {
            bValidated = this.m_pnlDirSQL.validateData();
        }
        return bValidated;
    }

    public String createFinishString() {
        String strFinish = this.m_pnlProp.createFinishString();
        strFinish = strFinish + this.m_pnlDirSQL.createFinishString();
        return strFinish;
    }

    public void saveSettingsAndCleanUp() {
        try {
            if (this.m_stoTemp != null && this.m_library.getFQID().indexOf(36) == -1) {
                this.m_stoTemp.dispose();
            }
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        this.m_pnlProp.saveSettingsAndCleanUp();
        this.m_pnlDirSQL.saveSettingsAndCleanUp();
    }

    protected void initialize() {
        try {
            PropertyGroup group = this.m_lstProperties.get(0).getAssociatedPropertyGroup();
            this.setName(group.getName());
            this.m_stoTemp = Workspace.getMdFactory().createObjectStore(group.getObjectStore(), "OptimizationPanel - Temp Store");
            PropertyGroup grpTemp = (PropertyGroup)Workspace.getMdFactory().createComplexMetadataObject(this.m_stoTemp, null, "PropertyGroup", "PropertyGroup", this.m_strReposID.substring(9));
            grpTemp.setName(group.getName());
            grpTemp.setDesc(group.getDesc());
            AssociationList lstProperties = group.getGroupedProperties();
            for (int index = 0; index < lstProperties.size(); ++index) {
                Property property = (Property)lstProperties.get(index);
                Property proTemp = PrototypeUtil.createProperty(property, this.m_stoTemp, this.m_strReposID);
                proTemp.setIsVisible(property.getIsVisible());
                proTemp.setIsUpdateable(property.getIsUpdateable());
                proTemp.setIsRequired(property.getIsRequired());
                proTemp.setIsExpert(property.getIsExpert());
                proTemp.setPropertyRole(property.getPropertyRole());
                proTemp.setDesc(property.getDesc());
                grpTemp.getGroupedProperties().add((Object)proTemp);
            }
            PropertyGroup subgrpTemp = (PropertyGroup)Workspace.getMdFactory().createComplexMetadataObject(this.m_stoTemp, null, "PropertyGroup", "PropertyGroup", this.m_strReposID.substring(9));
            subgrpTemp.setName(((PropertyGroup)group.getSubpropertyGroups().get(0)).getName());
            Property proTemp = (Property)Workspace.getMdFactory().createComplexMetadataObject(this.m_stoTemp, null, "Property", "Property", this.m_strReposID.substring(9));
            proTemp.setIsExpert(1);
            proTemp.setIsVisible(0);
            PropertyType typTemp = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject(this.m_stoTemp, null, "PropertyType", "PropertyType", this.m_strReposID.substring(9));
            typTemp.setSQLType(12);
            proTemp.setOwningType(typTemp);
            subgrpTemp.getGroupedProperties().add((Object)proTemp);
            grpTemp.getSubpropertyGroups().add((Object)subgrpTemp);
            PropertyGroup grpPrimary = group;
            while (grpPrimary.getParentGroup() != null) {
                grpPrimary = grpPrimary.getParentGroup();
            }
            Prototype prototype = (Prototype)grpPrimary.getAssociatedObject();
            this.m_pnlProp = new PropertiesPropertyView((Root)this.m_library, grpTemp, this.m_iViewType, 1, prototype);
            this.m_pnlProp.setMinimumViewHeight(300);
            AssociationList lstSubProperties = ((PropertyGroup)group.getSubpropertyGroups().get(0)).getGroupedProperties();
            this.m_pnlDirSQL = new DirectSQLPanel(this.m_library, this.m_strReposID, (List<Property>)lstSubProperties);
        }
        catch (MdException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    protected void layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints((Component)((Object)this.m_pnlProp), gbc);
        this.add((Component)((Object)this.m_pnlProp));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 24, 0, 12);
        gridBagLayout.setConstraints((Component)((Object)this.m_pnlDirSQL), gbc);
        this.add((Component)((Object)this.m_pnlDirSQL));
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }
}

