/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers;

import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectFactoryListener;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.MnemonicModel;
import com.sas.workspace.mgmt.visuals.AuthenticationDomainDialog;
import com.sas.workspace.mgmt.visuals.MetadataObjectCellRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class DataFluxSASConnectionPanel
extends WsDescriptionWizardTab {
    SASClientConnection m_connection;
    private List m_domainList;
    private JLabel m_lblPort;
    private WATextField m_txtPort;
    private JLabel m_lblHost;
    private WATextField m_txtHost;
    private JSeparator m_line;
    private JLabel m_titleAuthType;
    private JLabel m_titleComm;
    private JLabel m_lblAuthType;
    private JComboBox m_cbxAuthType;
    private JLabel m_lblAuthDomain;
    private JComboBox m_cbxAuthDomain;
    private JButton m_btnAuthDomain;
    private static final String DEFAULT_PORT = "24141";
    private static final String SAS_TOKEN_AUTH = "SAS token authentication";
    private static final String ITEM_NONE = "(None)";
    private static final String METADATA = "Metadata";
    private static final String PROMPT = "Prompt";
    private static final String USERPASSWORD = "User/Password";
    private static final WAdminResource bundle = WAdminResource.getBundle(DataFluxSASConnectionPanel.class);
    private static final long serialVersionUID = -830524542507057977L;

    public DataFluxSASConnectionPanel(SASClientConnection connection) {
        this.m_connection = connection;
        this.initialize();
        this.layoutWidgets();
    }

    public void populateStore() {
        int flags = 8456;
        try {
            this.m_domainList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_connection.getObjectStore(), this.getReposID(), "AuthenticationDomain", flags, "");
        }
        catch (MdException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    public void moveDataToView() {
        block11: {
            try {
                this.m_txtHost.setText(this.m_connection.getRemoteAddress());
                String strCurrentValue = String.valueOf(this.m_connection.getPort());
                int valueState = this.m_connection.getPortState();
                if (valueState != 2 && strCurrentValue.equals("") || valueState == 0 && strCurrentValue.equals("0")) {
                    this.m_txtPort.setText(DEFAULT_PORT);
                } else {
                    this.m_txtPort.setText(strCurrentValue);
                }
                this.m_cbxAuthType.removeAllItems();
                this.m_cbxAuthType.addItem(USERPASSWORD);
                this.m_cbxAuthType.addItem(PROMPT);
                this.m_cbxAuthType.addItem(SAS_TOKEN_AUTH);
                if (!this.m_connection.getAuthenticationType().equals(METADATA)) {
                    this.m_cbxAuthType.setSelectedItem(this.m_connection.getAuthenticationType());
                    for (int domainIndex = 0; this.m_domainList != null && domainIndex < this.m_domainList.size(); ++domainIndex) {
                        AuthenticationDomain domain = (AuthenticationDomain)this.m_domainList.get(domainIndex);
                        this.m_cbxAuthDomain.addItem(domain);
                    }
                    if (this.m_domainList.size() > 0) {
                        this.m_cbxAuthDomain.setSelectedIndex(0);
                    }
                    try {
                        if (this.m_connection.getDomain() != null) {
                            this.m_cbxAuthDomain.setSelectedItem(this.m_connection.getDomain());
                        }
                        break block11;
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                    catch (RemoteException re) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                    }
                    break block11;
                }
                this.m_cbxAuthType.setSelectedItem(SAS_TOKEN_AUTH);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    public void moveDataToStore() {
        this.setViewProperties();
    }

    public boolean validateData() {
        boolean bValidated = true;
        if (this.m_txtHost.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), bundle.getString("DFluxSASConnectionPanel.Host.Required.txt"), bundle.getString("Common.Error.txt"), 0);
            bValidated = false;
            return bValidated;
        }
        if (this.m_txtPort.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), bundle.getString("DFluxSASConnectionPanel.Port.Required.txt"), bundle.getString("Common.Error.txt"), 0);
            bValidated = false;
            return bValidated;
        }
        try {
            int port = Integer.valueOf(this.m_txtPort.getText().trim());
            if (port < 0 || port > 65535) {
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), bundle.getString("DFluxSASConnectionPanel.Port.Integer.txt"), bundle.getString("Common.Error.txt"), 0);
                bValidated = false;
                return bValidated;
            }
        }
        catch (NumberFormatException exc) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), bundle.getString("DFluxSASConnectionPanel.Port.Integer.txt"), bundle.getString("Common.Error.txt"), 0);
            bValidated = false;
            return bValidated;
        }
        return bValidated;
    }

    public String createFinishString() {
        String strFinish = Util.getDisplayLabel((String)bundle.getString("DFluxSASConnectionPanel.AuthenticationType.Label.txt")) + "\n\t" + (String)this.m_cbxAuthType.getSelectedItem() + "\n";
        if (this.m_cbxAuthDomain.getSelectedItem() != null) {
            strFinish = !this.m_cbxAuthType.getSelectedItem().equals(SAS_TOKEN_AUTH) ? strFinish + Util.getDisplayLabel((String)bundle.getString("DFluxSASConnectionPanel.AuthenticationDomain.Label.txt")) + "\n\t" + MetadataObjectCellRenderer.getDisplayName((Root)((AuthenticationDomain)this.m_cbxAuthDomain.getSelectedItem())) + "\n" : strFinish + Util.getDisplayLabel((String)bundle.getString("DFluxSASConnectionPanel.AuthenticationDomain.Label.txt")) + "\n\t" + ITEM_NONE + "\n";
        }
        strFinish = strFinish + Util.getDisplayLabel((String)bundle.getString("DFluxSASConnectionPanel.Host.Label.txt")) + "\n\t" + this.m_txtHost.getText() + "\n";
        strFinish = strFinish + Util.getDisplayLabel((String)bundle.getString("DFluxSASConnectionPanel.Port.Label.txt")) + "\n\t" + this.m_txtPort.getText() + "\n";
        return strFinish;
    }

    public void onNext() {
        this.setViewProperties();
    }

    public void onBack() {
        this.setViewProperties();
    }

    private void setViewProperties() {
        try {
            this.m_connection.setApplicationProtocol("TKTS", 1);
            this.m_connection.setCommunicationProtocol("TCP", 1);
            if (this.m_cbxAuthType.getSelectedItem().toString().equals(SAS_TOKEN_AUTH)) {
                this.m_connection.setAuthenticationType(METADATA, 1);
            } else {
                this.m_connection.setAuthenticationType(this.m_cbxAuthType.getSelectedItem().toString());
            }
            if (!this.m_cbxAuthType.getSelectedItem().equals(SAS_TOKEN_AUTH)) {
                this.m_connection.setDomain((AuthenticationDomain)this.m_cbxAuthDomain.getSelectedItem());
            }
            this.m_connection.setRemoteAddress(this.m_txtHost.getText().trim(), 1);
            try {
                if (this.m_txtPort.getText().trim().length() > 0) {
                    this.m_connection.setPort(this.m_txtPort.getText().trim(), 1);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected void onAuthTypeChanged() {
        if (this.m_cbxAuthType.getSelectedItem().toString().equals(SAS_TOKEN_AUTH)) {
            this.m_cbxAuthDomain.removeAllItems();
            this.m_cbxAuthDomain.addItem(ITEM_NONE);
            this.m_cbxAuthDomain.setSelectedIndex(0);
            this.m_btnAuthDomain.setEnabled(false);
        } else if (this.m_cbxAuthDomain.getItemCount() == 1 && this.m_cbxAuthDomain.getSelectedItem().equals(ITEM_NONE)) {
            this.m_cbxAuthDomain.removeAllItems();
            for (int domainIndex = 0; this.m_domainList != null && domainIndex < this.m_domainList.size(); ++domainIndex) {
                AuthenticationDomain domain = (AuthenticationDomain)this.m_domainList.get(domainIndex);
                this.m_cbxAuthDomain.addItem(domain);
            }
            this.m_btnAuthDomain.setEnabled(true);
        }
    }

    protected void onNewAuthDomain() {
        try {
            ViewListener viewListener = new ViewListener(this.m_cbxAuthDomain);
            Workspace.getMdFactory().addMdObjectFactoryListener((MdObjectFactoryListener)viewListener);
            AuthenticationDomainDialog dialog = null;
            Container parent = this.getTopLevelAncestor();
            if (parent instanceof Dialog) {
                dialog = new AuthenticationDomainDialog((Dialog)parent, Workspace.getMdFactory().createObjectStore(), this.getReposID());
            } else if (parent instanceof Frame) {
                dialog = new AuthenticationDomainDialog((Frame)parent, Workspace.getMdFactory().createObjectStore(), this.getReposID());
            }
            if (dialog != null) {
                dialog.show();
                if (dialog.getReturnValue() == 2) {
                    Workspace.getMdFactory().removeMdObjectFactoryListener((MdObjectFactoryListener)viewListener);
                }
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    String getReposID() {
        try {
            return "A0000001." + this.m_connection.getFQID().substring(0, 8);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public void initialize() {
        this.m_titleAuthType = new JLabel();
        this.m_titleAuthType.setText(bundle.getString("DFluxSASConnectionPanel.AuthenticationType.Title.txt"));
        this.m_titleComm = new JLabel();
        this.m_titleComm.setText(bundle.getString("DFluxSASConnectionPanel.Communication.Title.txt"));
        this.m_lblAuthType = new JLabel();
        MnemonicModel.setLabelTextAndMnemonic(this.m_lblAuthType, bundle.getString("DFluxSASConnectionPanel.AuthenticationType.Label.txt"));
        this.m_cbxAuthType = new JComboBox();
        this.m_lblAuthType.setLabelFor(this.m_cbxAuthType);
        this.m_cbxAuthType.setRenderer(new MetadataObjectCellRenderer());
        this.m_cbxAuthType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataFluxSASConnectionPanel.this.onAuthTypeChanged();
            }
        });
        this.m_lblAuthDomain = new JLabel();
        MnemonicModel.setLabelTextAndMnemonic(this.m_lblAuthDomain, bundle.getString("DFluxSASConnectionPanel.AuthenticationDomain.Label.txt"));
        this.m_cbxAuthDomain = new JComboBox();
        this.m_lblAuthDomain.setLabelFor(this.m_cbxAuthDomain);
        this.m_cbxAuthDomain.setRenderer(new MetadataObjectCellRenderer());
        this.m_btnAuthDomain = new JButton();
        MnemonicModel.setButtonTextAndMnemonic(this.m_btnAuthDomain, bundle.getString("Common.New....txt"));
        this.m_btnAuthDomain.setMargin(new Insets(0, 4, 0, 4));
        this.m_btnAuthDomain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataFluxSASConnectionPanel.this.onNewAuthDomain();
            }
        });
        this.m_lblHost = new JLabel();
        MnemonicModel.setLabelTextAndMnemonic(this.m_lblHost, bundle.getString("DFluxSASConnectionPanel.Host.Label.txt"));
        this.m_txtHost = new WATextField();
        this.m_lblHost.setLabelFor((Component)this.m_txtHost);
        this.m_lblPort = new JLabel();
        MnemonicModel.setLabelTextAndMnemonic(this.m_lblPort, bundle.getString("DFluxSASConnectionPanel.Port.Label.txt"));
        this.m_txtPort = new WATextField();
        this.m_lblPort.setLabelFor(this.m_lblPort);
        this.m_line = new JSeparator();
    }

    public void layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        this.m_lblPort = new JLabel();
        MnemonicModel.setLabelTextAndMnemonic(this.m_lblPort, bundle.getString("DFluxSASConnectionPanel.Port.Label.txt"));
        this.m_lblPort.setLabelFor((Component)this.m_txtPort);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_titleComm, gbc);
        this.add(this.m_titleComm);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 19, 0, 0);
        gridBagLayout.setConstraints(this.m_lblPort, gbc);
        this.add(this.m_lblPort);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_txtPort, gbc);
        this.add((Component)this.m_txtPort);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 19, 0, 0);
        gridBagLayout.setConstraints(this.m_lblHost, gbc);
        this.add(this.m_lblHost);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_txtHost, gbc);
        this.add((Component)this.m_txtHost);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_titleAuthType, gbc);
        this.add(this.m_titleAuthType);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 19, 0, 0);
        gridBagLayout.setConstraints(this.m_lblAuthType, gbc);
        this.add(this.m_lblAuthType);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_cbxAuthType, gbc);
        this.add(this.m_cbxAuthType);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 19, 0, 0);
        gridBagLayout.setConstraints(this.m_lblAuthDomain, gbc);
        this.add(this.m_lblAuthDomain);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.gridwidth = -1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_cbxAuthDomain, gbc);
        this.add(this.m_cbxAuthDomain);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = gridy++;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_btnAuthDomain, gbc);
        this.add(this.m_btnAuthDomain);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }

    protected class ViewListener
    implements MdObjectFactoryListener {
        protected JComboBox m_choice;

        public ViewListener(JComboBox choice) {
            this.m_choice = choice;
        }

        public void MdObjectCreated(MdEvent event, String strID) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(strID);
            this._onCreate(list);
        }

        public void MdObjectsCreated(MdEvent event, List idList) {
            this._onCreate(idList);
        }

        public void MdObjectDeleted(MdEvent event, String strID) {
        }

        protected void _onCreate(List idList) {
            try {
                boolean bProcessed = false;
                for (int i = 0; i < idList.size(); ++i) {
                    String strID = (String)idList.get(i);
                    CMetadata meta = Workspace.getMdFactory().getObject(strID);
                    if (!meta.getCMetadataType().equals("AuthenticationDomain")) continue;
                    Root root = (Root)meta;
                    this.m_choice.removeAllItems();
                    List itemsList = null;
                    int flags = 8456;
                    try {
                        itemsList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(DataFluxSASConnectionPanel.this.m_connection.getObjectStore(), DataFluxSASConnectionPanel.this.getReposID(), "AuthenticationDomain", flags, "");
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                        return;
                    }
                    catch (RemoteException re) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                    }
                    for (int j = 0; itemsList != null && j < itemsList.size(); ++j) {
                        Root itemRoot = (Root)itemsList.get(j);
                        this.m_choice.addItem(itemRoot);
                        if (!itemRoot.getFQID().equals(root.getFQID())) continue;
                        this.m_choice.setSelectedItem(itemRoot);
                        bProcessed = true;
                    }
                }
                if (bProcessed) {
                    Workspace.getMdFactory().removeMdObjectFactoryListener((MdObjectFactoryListener)this);
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }
}

