/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.AttributeProperty;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.ServiceType;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Transformation;
import com.sas.svcs.metadata.mgmt.impl.repository.ResourceTemplateHelper;
import com.sas.visuals.util.XMLUtility;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATransitionWizardModel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAWizardModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.AuthorizationView;
import com.sas.workspace.mgmt.visuals.ConnectSpawnerServersView;
import com.sas.workspace.mgmt.visuals.ConnectionPropertyView;
import com.sas.workspace.mgmt.visuals.ConnectionTypeView;
import com.sas.workspace.mgmt.visuals.GeneralPropertyView;
import com.sas.workspace.mgmt.visuals.LibraryWizard;
import com.sas.workspace.mgmt.visuals.OLAPSchemaView;
import com.sas.workspace.mgmt.visuals.PrototypeNotAddedException;
import com.sas.workspace.mgmt.visuals.PrototypeNotFoundException;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import com.sas.workspace.mgmt.visuals.SASAppServerTypeView;
import com.sas.workspace.mgmt.visuals.SchemaWizard;
import com.sas.workspace.mgmt.visuals.Server;
import com.sas.workspace.mgmt.visuals.ServerConfigView;
import com.sas.workspace.mgmt.visuals.ServerPropertyView;
import com.sas.workspace.mgmt.visuals.ServerTypePropertyView;
import com.sas.workspace.mgmt.visuals.SpawnerServersView;
import com.sas.workspace.mgmt.visuals.TransformPropertyView;
import com.sas.workspace.visuals.WizardFinishTab;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServerWizard
extends WAWizardDialog {
    protected Server m_server;
    protected Server m_childServer;
    protected JFrame m_frame;
    protected Dialog m_dialog;
    protected Component m_component;
    protected String m_strContext;
    protected String m_strTitle;
    protected MdObjectStore m_objectStore = null;
    protected boolean m_bShowWizard = true;
    private AuthorizationView m_authTab = null;
    protected static final WAdminResource bundle = new WAdminResource(ServerWizard.class);
    private static final long serialVersionUID = -4285252683776537825L;

    public ServerWizard(JFrame frame, String strContext) {
        this(frame, strContext, bundle.getString("ServerWizard.Title.txt"), new String[0]);
    }

    public ServerWizard(JFrame frame, String strContext, String strTitle) {
        this(frame, strContext, strTitle, new String[0]);
    }

    public ServerWizard(JFrame frame, String strContext, String strTitle, String strClassID) {
        this(frame, strContext, strTitle, new String[]{strClassID}, null);
    }

    public ServerWizard(JFrame frame, String strContext, String strTitle, String[] classIDArray) {
        this(frame, strContext, strTitle, classIDArray, null);
    }

    public ServerWizard(JFrame frame, String strContext, String strTitle, MdObjectStore objectStore) {
        this(frame, strContext, strTitle, new String[0], objectStore);
    }

    public ServerWizard(JFrame frame, String strContext, String strTitle, String strClassID, MdObjectStore objectStore) {
        this(frame, strContext, strTitle, new String[]{strClassID}, objectStore);
    }

    public ServerWizard(JFrame frame, String strContext, String strTitle, String[] classIDArray, MdObjectStore objectStore) {
        this(frame, strContext, strTitle, classIDArray, objectStore, null);
    }

    public ServerWizard(JFrame frame, String strContext, String strTitle, String[] classIDArray, MdObjectStore objectStore, Hashtable propertiesTable) {
        super((Frame)frame, true, objectStore);
        this._init(frame, strContext, strTitle, classIDArray, propertiesTable);
    }

    public ServerWizard(Dialog dialog, String strContext) {
        this(dialog, (MdObjectStore)null, strContext, bundle.getString("ServerWizard.Title.txt"));
    }

    public ServerWizard(Dialog dialog, String strContext, String strTitle) {
        this(dialog, (MdObjectStore)null, strContext, strTitle);
    }

    public ServerWizard(Dialog dialog, String strContext, String strTitle, String strClassID) {
        this(dialog, null, strContext, strTitle, new String[]{strClassID});
    }

    public ServerWizard(Dialog dialog, String strContext, String strTitle, String[] classIDArray) {
        this(dialog, null, strContext, strTitle, classIDArray);
    }

    public ServerWizard(Dialog dialog, MdObjectStore objectStore, String strContext, String strTitle) {
        this(dialog, objectStore, strContext, strTitle, new String[0]);
    }

    public ServerWizard(Dialog dialog, MdObjectStore objectStore, String strContext, String strTitle, String strClassID) {
        this(dialog, objectStore, strContext, strTitle, new String[]{strClassID});
    }

    public ServerWizard(Dialog dialog, MdObjectStore objectStore, String strContext, String strTitle, String[] classIDArray) {
        this(dialog, objectStore, strContext, strTitle, classIDArray, null);
    }

    public ServerWizard(Dialog dialog, MdObjectStore objectStore, String strContext, String strTitle, String[] classIDArray, Hashtable propertiesTable) {
        super(dialog, true, objectStore);
        this._init(dialog, strContext, strTitle, classIDArray, propertiesTable);
    }

    protected void _init(Component component, String strContext, String strTitle, String[] classIDArray, Hashtable propertiesTable) {
        try {
            this.setHelpProduct("newserver");
            this.m_objectStore = (MdObjectStore)this.getWizardData("OBJECTSTORE");
            this.m_objectStore.setIsObjectCopiedFromParentOnCreation(false);
            Boolean bDisposeStore = new Boolean(false);
            this.replaceWizardData("DisposeStore", bDisposeStore);
            ServerComponent sc = null;
            if (propertiesTable != null) {
                Enumeration e = propertiesTable.keys();
                while (e.hasMoreElements()) {
                    Root elementRoot = (Root)e.nextElement();
                    if (elementRoot.getCMetadataType().equalsIgnoreCase("ServerComponent")) {
                        sc = (ServerComponent)elementRoot;
                    }
                    if (!elementRoot.getCMetadataType().equalsIgnoreCase("SASClientConnection") && !elementRoot.getCMetadataType().equalsIgnoreCase("TCPIPConnection") && !elementRoot.getCMetadataType().equalsIgnoreCase("COMConnection") && !elementRoot.getCMetadataType().equalsIgnoreCase("OpenClientConnection") && !elementRoot.getCMetadataType().equalsIgnoreCase("Connection")) continue;
                    Connection conn = (Connection)elementRoot;
                    this.replaceWizardData("Connection", conn);
                }
            }
            this.m_server = sc != null ? new Server(this.m_objectStore, strContext, (DeployedComponent)sc) : new Server(this.m_objectStore, strContext);
            this.m_server.setParentComponent(component);
            this.m_childServer = new Server(this.m_objectStore, strContext);
            this.m_childServer.setParentComponent(component);
            this.m_component = component;
            this.m_strContext = strContext;
            this.m_strTitle = strTitle;
            WATransitionWizardModel model = new WATransitionWizardModel();
            this.setWizardModel((WAWizardModel)model);
            if (propertiesTable != null) {
                this.replaceWizardData("Properties", propertiesTable);
            }
            boolean bShowAllPrototypes = false;
            String[] refinedClassIDArray = this.refineClassIDs(classIDArray);
            if (refinedClassIDArray.length == 1) {
                Prototype prototype;
                String strPrototypeKey = "DeployedComponentPrototype";
                if (refinedClassIDArray[0].equals("SAS Application Server")) {
                    strPrototypeKey = "ServerContextPrototype";
                }
                boolean bl = this.m_bShowWizard = (prototype = ServerWizard.getPrototype("PrototypeProperties", "ClassIdentifier", refinedClassIDArray[0], this.m_strContext, this.m_objectStore, this.m_component, this, strPrototypeKey)) != null;
                if (prototype != null) {
                    String strMetadataType = prototype.getMetadataType();
                    Root root = (Root)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, "Server", strMetadataType, strContext.substring(9));
                    DeployedComponent dc = this.m_server.getDeployedComponent();
                    try {
                        Vector<Object> objectsToRemoveList = new Vector<Object>();
                        objectsToRemoveList.add(dc);
                        AssociationList propList = dc.getProperties();
                        for (int propIndex = 0; propIndex < propList.size(); ++propIndex) {
                            Property prop = (Property)propList.get(propIndex);
                            objectsToRemoveList.add(prop);
                            PropertyType propType = prop.getOwningType();
                            if (propType == null) continue;
                            objectsToRemoveList.add(propType);
                            TextStore propTypeText = (TextStore)propType.getStoredConfiguration();
                            if (propTypeText == null) continue;
                            objectsToRemoveList.add(propTypeText);
                        }
                        AssociationList dcConnList = dc.getSourceConnections();
                        for (int connIndex = 0; connIndex < dcConnList.size(); ++connIndex) {
                            Connection dcConn = (Connection)dcConnList.get(connIndex);
                            objectsToRemoveList.add(dcConn);
                            AssociationList connPropList = dcConn.getProperties();
                            for (int propIndex = 0; propIndex < connPropList.size(); ++propIndex) {
                                Property prop = (Property)connPropList.get(propIndex);
                                objectsToRemoveList.add(prop);
                                PropertyType propType = prop.getOwningType();
                                if (propType == null) continue;
                                objectsToRemoveList.add(propType);
                                TextStore propTypeText = (TextStore)propType.getStoredConfiguration();
                                if (propTypeText == null) continue;
                                objectsToRemoveList.add(propTypeText);
                            }
                        }
                        AssociationList dcInitList = dc.getInitProcesses();
                        for (int initIndex = 0; initIndex < dcInitList.size(); ++initIndex) {
                            Transformation dcTransform = (Transformation)dcInitList.get(initIndex);
                            objectsToRemoveList.add(dcTransform);
                            AssociationList tranPropList = dcTransform.getProperties();
                            for (int propIndex = 0; propIndex < tranPropList.size(); ++propIndex) {
                                Property prop = (Property)tranPropList.get(propIndex);
                                objectsToRemoveList.add(prop);
                                PropertyType propType = prop.getOwningType();
                                if (propType == null) continue;
                                objectsToRemoveList.add(propType);
                                TextStore propTypeText = (TextStore)propType.getStoredConfiguration();
                                if (propTypeText == null) continue;
                                objectsToRemoveList.add(propTypeText);
                            }
                        }
                        AssociationList dcServiceTypesList = dc.getServiceTypes();
                        for (int sTypeIndex = 0; sTypeIndex < dcServiceTypesList.size(); ++sTypeIndex) {
                            ServiceType sType = (ServiceType)dcServiceTypesList.get(sTypeIndex);
                            objectsToRemoveList.add(sType);
                        }
                        AssociationList dataPackagesList = dc.getDataPackages();
                        for (int dpIndex = 0; dpIndex < dataPackagesList.size(); ++dpIndex) {
                            DeployedDataPackage ddp = (DeployedDataPackage)dataPackagesList.get(dpIndex);
                            if (ddp.getFQID().indexOf(36) == -1) continue;
                            objectsToRemoveList.add(ddp);
                            AssociationList ddpPropList = ddp.getProperties();
                            for (int propIndex = 0; propIndex < ddpPropList.size(); ++propIndex) {
                                Property prop = (Property)ddpPropList.get(propIndex);
                                objectsToRemoveList.add(prop);
                                PropertyType propType = prop.getOwningType();
                                if (propType == null) continue;
                                objectsToRemoveList.add(propType);
                                TextStore propTypeText = (TextStore)propType.getStoredConfiguration();
                                if (propTypeText == null) continue;
                                objectsToRemoveList.add(propTypeText);
                            }
                        }
                        ((MdObjectStore)dc.getObjectStore()).removeObjectsFromStore(objectsToRemoveList);
                        if (propertiesTable != null) {
                            Hashtable[] pTableArray = (Hashtable[])propertiesTable.remove(dc);
                            if (pTableArray != null) {
                                propertiesTable.put(root, pTableArray);
                            }
                            this.replaceWizardData("Properties", propertiesTable);
                        }
                        PropertyGroup primaryGroup = prototype.getPrimaryPropertyGroup();
                        AssociationList propertyList = primaryGroup.getGroupedProperties();
                        int iPropertyListSize = propertyList.size();
                        for (int propIndex = 0; propIndex < iPropertyListSize; ++propIndex) {
                            AttributeProperty attrProperty;
                            AbstractProperty ap = (AbstractProperty)propertyList.get(propIndex);
                            if (!(ap instanceof AttributeProperty) || !(attrProperty = (AttributeProperty)ap).getPropertyName().equalsIgnoreCase("ClassIdentifier") || !attrProperty.getDefaultValue().equalsIgnoreCase("b379c9c1-89e0-4e72-ba43-6a416899b5dd") && !attrProperty.getDefaultValue().equalsIgnoreCase("e803e04b-aaf0-4c74-86a6-f7008aa702dc")) continue;
                            LogicalServer logicalServer = (LogicalServer)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, root.getName(), "LogicalServer", strContext.substring(9), null);
                            if (attrProperty.getDefaultValue().equalsIgnoreCase("b379c9c1-89e0-4e72-ba43-6a416899b5dd")) {
                                logicalServer.setName(bundle.formatString("SASAppServerTypeView.LogicalServerIdentifierName.Logical.fmt.txt", (Object)root.getName()));
                                logicalServer.setClassIdentifier("b379c9c1-89e0-4e72-ba43-6a416899b5dd");
                            }
                            if (attrProperty.getDefaultValue().equalsIgnoreCase("e803e04b-aaf0-4c74-86a6-f7008aa702dc")) {
                                logicalServer.setName(bundle.formatString("ServerWizard.LogicalFederationName.fmt.txt", (Object)root.getName()));
                                logicalServer.setClassIdentifier("e803e04b-aaf0-4c74-86a6-f7008aa702dc");
                                root.setName(bundle.formatString("ServerWizard.FederationServerName.fmt.txt", (Object)root.getName()));
                            }
                            ServiceType serviceType = (ServiceType)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, "Logical IOM Server", "ServiceType", strContext.substring(9), null);
                            Server logServer = new Server((MdObjectStore)logicalServer.getObjectStore(), strContext, (DeployedComponent)logicalServer);
                            Prototype logPrototype = logServer.getDeployedComponentPrototype((Component)((Object)this));
                            if (logPrototype != null) {
                                logicalServer.setUsingPrototype((Root)logPrototype);
                                ServerWizard.setDefaultLogicalServerProperties(logicalServer, logPrototype, strContext);
                            }
                            logicalServer.getServiceTypes().add((Object)serviceType);
                            logicalServer.getUsingComponents().add((Object)root);
                            this.replaceWizardData("LogicalServer", logicalServer);
                            break;
                        }
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                    catch (RemoteException exc) {
                        Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    }
                    this.m_server.setDeployedComponent((DeployedComponent)root);
                } else {
                    bShowAllPrototypes = true;
                }
            } else {
                bShowAllPrototypes = true;
            }
            if (bShowAllPrototypes) {
                try {
                    if (refinedClassIDArray.length == 0) {
                        refinedClassIDArray = null;
                    }
                    ServerTypePropertyView typeTab = new ServerTypePropertyView(this.m_server, this.m_objectStore, refinedClassIDArray);
                    this.addTab(strTitle, "ServerType", (WAPropertyTab)typeTab, bundle.getString("ServerWizard.ServerTypeImage.image"), bundle.getImageIcon("ServerWizard.ServerTypeImage.image"));
                    String[][] transition = new String[][]{{"ServerType", "NEXT", "General"}};
                    model.addTransitions(transition);
                }
                catch (PrototypeNotFoundException exc) {
                    this.m_bShowWizard = false;
                }
            }
            this.addWizardTabs(model, strTitle);
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public Root getMetadataObject() {
        Root root = (Root)this.getWizardData("ServerContext");
        if (root == null) {
            root = (Root)this.getWizardData("DeployedComponent");
        }
        return root;
    }

    public String getTitle() {
        return this.m_strTitle;
    }

    public void setPreferredSize(Dimension dimension) {
        this.getMainPanel().setPreferredSize(dimension);
    }

    public void show() {
        if (this.m_bShowWizard) {
            super.show();
        }
    }

    protected void addWizardTabs(WATransitionWizardModel model, String strTitle) {
        this.setTitle(strTitle);
        GeneralPropertyView generalTab = new GeneralPropertyView(this.m_server, 0);
        this.addTab(strTitle, "General", (WAPropertyTab)generalTab, bundle.getString("Common.NameDescriptionTab.image"), bundle.getImageIcon("Common.NameDescriptionTab.image"));
        ServerPropertyView propertyTab = new ServerPropertyView(this.m_server, 0);
        this.addTab(strTitle, "Server", (WAPropertyTab)propertyTab, bundle.getString("Common.PropertiesTab.image"), bundle.getImageIcon("Common.PropertiesTab.image"));
        TransformPropertyView spawnInitTab = new TransformPropertyView(this.m_server, 0);
        this.addTab(strTitle, "SpawnerInit", (WAPropertyTab)spawnInitTab, bundle.getString("Common.PropertiesTab.image"), bundle.getImageIcon("Common.PropertiesTab.image"));
        SpawnerServersView spawnServersTab = new SpawnerServersView(this.m_server, 0);
        this.addTab(strTitle, "SpawnerServers", (WAPropertyTab)spawnServersTab, bundle.getString("Common.PropertiesTab.image"), bundle.getImageIcon("Common.PropertiesTab.image"));
        ConnectSpawnerServersView connSpawnServersTab = new ConnectSpawnerServersView(this.m_server, 0);
        this.addTab(strTitle, "ConnectSpawnerServers", (WAPropertyTab)connSpawnServersTab, bundle.getString("Common.PropertiesTab.image"), bundle.getImageIcon("Common.PropertiesTab.image"));
        SASAppServerTypeView appTab = new SASAppServerTypeView(this.m_server, 0, this.m_objectStore);
        this.addTab(strTitle, "SASAppServer", (WAPropertyTab)appTab, bundle.getString("ServerWizard.ServerTypeImage.image"), bundle.getImageIcon("ServerWizard.ServerTypeImage.image"));
        ConnectionTypeView connTypeTab = new ConnectionTypeView();
        this.addTab(strTitle, "ConnectionType", (WAPropertyTab)connTypeTab, bundle.getString("ServerWizard.ConnectionInfoImage.image"), bundle.getImageIcon("ServerWizard.ConnectionInfoImage.image"));
        ServerConfigView configTab = new ServerConfigView(this.m_server);
        this.addTab(strTitle, "ServerConfig", (WAPropertyTab)configTab, bundle.getString("Common.NameDescriptionTab.image"), bundle.getImageIcon("Common.NameDescriptionTab.image"));
        GeneralPropertyView childGeneralTab = new GeneralPropertyView(this.m_childServer, 0);
        this.addTab(strTitle, "ChildGeneral", (WAPropertyTab)childGeneralTab, bundle.getString("Common.NameDescriptionTab.image"), bundle.getImageIcon("Common.NameDescriptionTab.image"));
        ServerPropertyView childPropertyTab = new ServerPropertyView(this.m_childServer, 0);
        this.addTab(strTitle, "ChildServer", (WAPropertyTab)childPropertyTab, bundle.getString("Common.PropertiesTab.image"), bundle.getImageIcon("Common.PropertiesTab.image"));
        ConnectionTypeView childConnTypeTab = new ConnectionTypeView();
        this.addTab(strTitle, "ChildConnectionType", (WAPropertyTab)childConnTypeTab, bundle.getString("ServerWizard.ConnectionInfoImage.image"), bundle.getImageIcon("ServerWizard.ConnectionInfoImage.image"));
        ConnectionPropertyView childConnectionTab = new ConnectionPropertyView(0);
        this.addTab(strTitle, "ChildConnection", (WAPropertyTab)childConnectionTab, bundle.getString("ServerWizard.ConnectionInfoImage.image"), bundle.getImageIcon("ServerWizard.ConnectionInfoImage.image"));
        OLAPSchemaView olapTab = new OLAPSchemaView(this.m_server, 0);
        this.addTab(strTitle, "OLAPSchema", (WAPropertyTab)olapTab, bundle.getString("Common.PropertiesTab.image"), bundle.getImageIcon("Common.PropertiesTab.image"));
        this.m_authTab = new AuthorizationView(this.m_server);
        this.addTab(strTitle, "Authorization", (WAPropertyTab)this.m_authTab, bundle.getString("Common.PropertiesTab.image"), bundle.getImageIcon("Common.PropertiesTab.image"));
        WizardFinishTab finishTab = new WizardFinishTab(bundle.getString("ServerWizard.DefinitionSuccess.txt"));
        finishTab.setHelpProduct("newserver");
        finishTab.setHelpTopic("servwiz_6");
        this.addTab(strTitle, "Completion", (WAPropertyTab)finishTab, bundle.getString("Common.FinishTab.image"), bundle.getImageIcon("Common.FinishTab.image"));
        String[][] transitions = new String[][]{{"General", "NEXT", "ChildConnection"}, {"General", "SERVER", "Server"}, {"Server", "APPSERVER", "SASAppServer"}, {"SASAppServer", "NEXT", "ServerConfig"}, {"SASAppServer", "BATCH", "ChildServer"}, {"Server", "NEXT", "Completion"}, {"ServerConfig", "NEXT", "Completion"}, {"ServerConfig", "CUSTOM", "ChildServer"}, {"Server", "SPAWNERINIT", "SpawnerInit"}, {"Server", "CONNECTIONTYPE", "ChildConnectionType"}, {"Server", "CONNECTION", "ChildConnection"}, {"Server", "ConnectSpawnerServers", "ConnectSpawnerServers"}, {"SpawnerInit", "NEXT", "SpawnerServers"}, {"SpawnerServers", "NEXT", "ChildConnectionType"}, {"ConnectSpawnerServers", "NEXT", "ChildConnection"}, {"ChildGeneral", "NEXT", "ChildConnection"}, {"ChildGeneral", "SERVER", "ChildServer"}, {"ChildServer", "NEXT", "Completion"}, {"ChildServer", "CONNECTIONTYPE", "ChildConnectionType"}, {"ChildServer", "CONNECTION", "ChildConnection"}, {"ChildConnectionType", "NEXT", "ChildConnection"}, {"ChildConnection", "NEXT", "Completion"}, {"ChildConnection", "OLAPSCHEMA", "OLAPSchema"}, {"ChildConnection", "AUTHORIZATION", "Authorization"}, {"OLAPSchema", "NEXT", "Completion"}, {"Authorization", "NEXT", "Completion"}};
        model.addTransitions(transitions);
        this.addWizardData("Server", this.m_server);
        this.addWizardData("ChildServer", this.m_childServer);
    }

    public boolean onCompletion() {
        try {
            DeployedComponent deployedComponent;
            this.setCursor(Cursor.getPredefinedCursor(3));
            Prototype prototype = (Prototype)this.getWizardData("ServerContextPrototype");
            if (prototype == null) {
                prototype = (Prototype)this.getWizardData("DeployedComponentPrototype");
            }
            if ((deployedComponent = (DeployedComponent)this.getWizardData("ServerContext")) == null) {
                deployedComponent = (DeployedComponent)this.getWizardData("DeployedComponent");
            }
            if (deployedComponent instanceof ServerContext) {
                List requestList = (List)this.getWizardData("MetadataRequestList");
                List logicalServerList = (List)this.getWizardData("LogicalServersList");
                if (requestList != null) {
                    for (int i = 0; i < requestList.size(); ++i) {
                        LogicalServer logicalServer;
                        block24: {
                            String strRequest = (String)requestList.get(i);
                            logicalServer = (LogicalServer)logicalServerList.get(i);
                            try {
                                String strStart = "<Metadata>";
                                String strEnd = "</Metadata>";
                                String strXML = strRequest.substring(strRequest.indexOf(strStart), strRequest.indexOf(strEnd) + strEnd.length());
                                Workspace.getMdFactory().getOMIUtil().populateStoreFromString(deployedComponent.getObjectStore(), strXML, 1, true);
                            }
                            catch (Exception exc) {
                                String strMessage = exc.getMessage();
                                if (!(exc instanceof MdException)) break block24;
                                MessageUtil.displayMessage((String)strMessage, (int)0);
                            }
                        }
                        List changeList = deployedComponent.getObjectStore().getChangedObjects();
                        for (int changeIndex = 0; changeIndex < changeList.size(); ++changeIndex) {
                            Root changeRoot = (Root)changeList.get(changeIndex);
                            if (!changeRoot.getCMetadataType().equals("ServerComponent") || !((ServerComponent)changeRoot).getClassIdentifier().equals(logicalServer.getClassIdentifier())) continue;
                            try {
                                if (logicalServer.getUsingComponents().contains((Object)changeRoot)) continue;
                                logicalServer.getUsingComponents().add((Object)changeRoot);
                                continue;
                            }
                            catch (MdException exc) {
                                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                                continue;
                            }
                            catch (RemoteException exc) {
                                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                            }
                        }
                    }
                }
                try {
                    this.m_server.persist();
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
                }
                catch (RemoteException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                return super.onFinish();
            }
            Prototype deployedComponentPrototype = (Prototype)this.getWizardData("DeployedComponentPrototype");
            deployedComponent.setUsingPrototype((Root)deployedComponentPrototype);
            this.m_server.setDeployedComponent(deployedComponent);
            if (deployedComponent.getClassIdentifier().equalsIgnoreCase("b379c9c1-89e0-4e72-ba43-6a416899b5dd") || deployedComponent.getClassIdentifier().equalsIgnoreCase("e803e04b-aaf0-4c74-86a6-f7008aa702dc")) {
                LogicalServer logicalServer = (LogicalServer)this.getWizardData("LogicalServer");
                if (deployedComponent.getClassIdentifier().equalsIgnoreCase("b379c9c1-89e0-4e72-ba43-6a416899b5dd")) {
                    logicalServer.setName(bundle.formatString("SASAppServerTypeView.LogicalServerIdentifierName.Logical.fmt.txt", (Object)deployedComponent.getName()));
                }
                if (deployedComponent.getClassIdentifier().equalsIgnoreCase("e803e04b-aaf0-4c74-86a6-f7008aa702dc")) {
                    logicalServer.setName(bundle.formatString("ServerWizard.LogicalFederationName.fmt.txt", (Object)deployedComponent.getName()));
                    deployedComponent.setName(bundle.formatString("ServerWizard.FederationServerName.fmt.txt", (Object)deployedComponent.getName()));
                }
                this.m_server.setDeployedComponent((DeployedComponent)logicalServer);
            }
            try {
                this.m_server.persist();
                if (deployedComponent.getClassIdentifier().equalsIgnoreCase("SASIOLA")) {
                    MdStore store = deployedComponent.getObjectStore();
                    String strReposID = this.m_server.getContext();
                    String strSelect = "<XMLSELECT search=\"*[@Name='" + deployedComponent.getName() + "']\" />";
                    int flags = 8600;
                    int index = 0;
                    List lstServers = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(store, strReposID, "ServerComponent", flags, strSelect);
                    if (index < lstServers.size()) {
                        ServerComponent server = (ServerComponent)lstServers.get(index);
                        this.m_authTab.setAdministerPermission(server.getFQID());
                    }
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            return super.onFinish();
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            return false;
        }
    }

    protected boolean onFinish() {
        this.dispose();
        OpRequestUI request = new OpRequestUI((JDialog)((Object)this), bundle.getString("WriteMetadataProgressIndicator.Msg.Message.txt"), bundle.getString("WriteMetadataProgressIndicator.Msg.Title"));
        request.setProgressShownOnStatusBar(false);
        return (Boolean)request.exec((Object)this, "onCompletion");
    }

    public static void setDefaultLogicalServerProperties(LogicalServer logicalServer, Prototype prototype, String reposID) {
        block14: {
            try {
                PropertyGroup group = prototype.getPrimaryPropertyGroup();
                List requiredPropertiesList = PrototypeUtil.getAllRequiredPropertiesRecursive(group);
                for (int propIndex = 0; propIndex < requiredPropertiesList.size(); ++propIndex) {
                    AbstractProperty reqProperty = (AbstractProperty)requiredPropertiesList.get(propIndex);
                    if (reqProperty instanceof AttributeProperty) {
                        AttributeProperty attrProp = (AttributeProperty)reqProperty;
                        try {
                            String strMethod = "set" + attrProp.getPropertyName();
                            Object[] args = new Object[]{attrProp.getDefaultValue(), new Integer(1)};
                            Class[] classes = new Class[]{String.class, Integer.TYPE};
                            Method method = logicalServer.getClass().getMethod(strMethod, classes);
                            try {
                                method.invoke((Object)logicalServer, args);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                            }
                            catch (IllegalAccessException illegalAccessException) {
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                        }
                        catch (NoSuchMethodException strMethod) {
                            // empty catch block
                        }
                    }
                    if (!(reqProperty instanceof Property)) continue;
                    Property property = PrototypeUtil.createProperty((Property)reqProperty, (MdObjectStore)logicalServer.getObjectStore(), reposID);
                    logicalServer.getProperties().add((Object)property);
                }
                if (!logicalServer.getClassIdentifier().equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c") && !logicalServer.getClassIdentifier().equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb") && !logicalServer.getClassIdentifier().equalsIgnoreCase("510A5F10-8E07-44AC-942B-EFB5A4782A39") && !logicalServer.getClassIdentifier().equalsIgnoreCase("94D98CD0-56C5-40A3-A140-49D21D17BDCE")) break block14;
                Transformation transformation = (Transformation)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)logicalServer.getObjectStore(), null, logicalServer.getName(), "Transformation", reposID.substring(9), null);
                transformation.setTransformRole("Load Balancing", 1);
                AssociationList propertiesList = group.getGroupedProperties();
                for (int propIndex = 0; propIndex < propertiesList.size(); ++propIndex) {
                    AssociationProperty assocProperty;
                    AbstractProperty property = (AbstractProperty)propertiesList.get(propIndex);
                    if (!(property instanceof AssociationProperty) || !(assocProperty = (AssociationProperty)property).getMetadataType().equalsIgnoreCase("Transformation") || !assocProperty.getAssociationName().equalsIgnoreCase("InitProcesses")) continue;
                    AssociationList prototypeList = assocProperty.getAssociatedPrototypes();
                    for (int protIndex = 0; protIndex < prototypeList.size(); ++protIndex) {
                        Prototype prot = (Prototype)prototypeList.get(protIndex);
                        if (prot == prototype) continue;
                        transformation.setUsingPrototype((Root)prot);
                        group = prot.getPrimaryPropertyGroup();
                        requiredPropertiesList = PrototypeUtil.getAllRequiredPropertiesRecursive(group);
                        for (propIndex = 0; propIndex < requiredPropertiesList.size(); ++propIndex) {
                            AbstractProperty reqProperty = (AbstractProperty)requiredPropertiesList.get(propIndex);
                            if (!(reqProperty instanceof Property)) continue;
                            Property p = PrototypeUtil.createProperty((Property)reqProperty, (MdObjectStore)logicalServer.getObjectStore(), reposID);
                            transformation.getProperties().add((Object)p);
                        }
                    }
                    break;
                }
                logicalServer.getInitProcesses().add((Object)transformation);
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }
    }

    protected static Prototype getPrototype(String strAssociation, String strAttribute, String strValue, String strContext, MdObjectStore objectStore, Component component, String strMetadataType) {
        return ServerWizard.getPrototype(strAssociation, strAttribute, strValue, strContext, objectStore, component, strMetadataType, false);
    }

    protected static Prototype getPrototype(String strAssociation, String strAttribute, String strValue, String strContext, MdObjectStore objectStore, Component component, String strMetadataType, boolean bDisplayError) {
        Prototype prototype = null;
        Locale locale = Locale.getDefault();
        String strNameAttribute = "Name";
        String strValueAttribute = "Value";
        String strStringentClause = "[@MetadataType='" + strMetadataType + "']";
        if (strAssociation != null && strAssociation.equalsIgnoreCase("PrototypeProperties")) {
            strNameAttribute = "Property" + strNameAttribute;
            strValueAttribute = "Default" + strValueAttribute;
        }
        String strType = bundle.getString("Prototype.Type.notrans");
        String strTemplate = "<TEMPLATES><Prototype><Extensions/></Prototype></TEMPLATES>";
        String strSelect = "<XMLSELECT search=\"*" + strStringentClause + "[" + strAssociation + "/*[@" + strNameAttribute + "='" + strAttribute + "' AND @" + strValueAttribute + "='" + strValue + "']]\"/>";
        if (strAssociation == null) {
            strSelect = "<XMLSELECT search=\"@" + strAttribute + "='" + strValue + "'\"/>";
        }
        String strOptions = strTemplate + strSelect;
        int flags = 8588;
        try {
            Vector boolList;
            List prototypeList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)objectStore, strContext, strType, flags, strOptions);
            if (!prototypeList.isEmpty()) {
                Extension extension;
                int extIndex;
                AssociationList extensionList;
                Prototype prot;
                int protIndex;
                for (protIndex = 0; protIndex < prototypeList.size(); ++protIndex) {
                    prot = (Prototype)prototypeList.get(protIndex);
                    extensionList = prot.getExtensions();
                    for (extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                        extension = (Extension)extensionList.get(extIndex);
                        if (!extension.getName().equals("Locale")) continue;
                        String localeValue = extension.getValue();
                        if (localeValue.equalsIgnoreCase("Generic")) {
                            prototype = prot;
                            break;
                        }
                        if (PrototypeUtil.getLocale(localeValue).equals(locale)) {
                            prototype = prot;
                            break;
                        }
                        if (!PrototypeUtil.getLocale(localeValue).equals(PrototypeUtil.getLocale("en_US"))) continue;
                        prototype = prot;
                        break;
                    }
                    if (prototype != null) break;
                }
                if (prototype == null) {
                    for (protIndex = 0; protIndex < prototypeList.size(); ++protIndex) {
                        prot = (Prototype)prototypeList.get(protIndex);
                        extensionList = prot.getExtensions();
                        for (extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                            extension = (Extension)extensionList.get(extIndex);
                            if (!extension.getName().equals("Locale")) continue;
                            if (!PrototypeUtil.getLocale(extension.getValue()).getLanguage().equals(locale.getLanguage())) break;
                            prototype = prot;
                            break;
                        }
                        if (prototype != null) break;
                    }
                    if (PrototypeUtil.getLocale("en").getLanguage().equals(locale.getLanguage())) {
                        for (protIndex = 0; protIndex < prototypeList.size(); ++protIndex) {
                            prot = (Prototype)prototypeList.get(protIndex);
                            extensionList = prot.getExtensions();
                            boolean bDoesNotContainLocaleExtension = true;
                            for (int extIndex2 = 0; extIndex2 < extensionList.size(); ++extIndex2) {
                                Extension extension2 = (Extension)extensionList.get(extIndex2);
                                if (!extension2.getName().equals("Locale")) continue;
                                bDoesNotContainLocaleExtension = false;
                            }
                            if (!bDoesNotContainLocaleExtension) continue;
                            prototype = prot;
                            break;
                        }
                    }
                }
            }
            boolean bAddPrototype = true;
            if (prototype == null && bAddPrototype && (prototype = ServerWizard.addPrototype(strAttribute, strValue, strContext, component, objectStore, null, boolList = new Vector())) != null) {
                bAddPrototype = false;
            }
            if (prototype == null) {
                boolList = new Vector();
                prototype = ServerWizard.addPrototype(strAttribute, strValue, strContext, component, objectStore, Locale.getDefault(), boolList);
            }
            if (prototype == null && bAddPrototype) {
                boolList = new Vector();
                prototype = ServerWizard.addPrototype(strAttribute, strValue, strContext, component, objectStore, PrototypeUtil.getLocale("en_US"), boolList);
                if (prototype != null) {
                    bAddPrototype = false;
                }
            }
        }
        catch (PrototypeNotAddedException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            if (bDisplayError) {
                MessageUtil.displayMessage((String)exc.getLocalizedMessage());
            }
            return prototype;
        }
        catch (MdException exc) {
            if (bDisplayError) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
            }
            return prototype;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        return prototype;
    }

    protected static Prototype getPrototype(String strAssociation, String strAttribute, String strValue, String strContext, MdObjectStore objectStore, Component component, WAWizardDialog wizard, String strPrototypeKey) {
        Prototype prototype = null;
        String strMetadataType = "ServerComponent";
        if (strPrototypeKey.equals("ServerContextPrototype")) {
            strMetadataType = "ServerContext";
        }
        if (wizard instanceof LibraryWizard) {
            strMetadataType = "SASLibrary";
        }
        if (wizard instanceof SchemaWizard) {
            strMetadataType = "DatabaseSchema";
        }
        try {
            prototype = PrototypeUtil.getPrototypeByIdentifier(Workspace.getWorkspace().getCMRHandle(), strAssociation, strAttribute, strValue, strContext, strMetadataType, null, (MdStore)objectStore);
            if (wizard != null) {
                wizard.addWizardData(strPrototypeKey, (Object)prototype);
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
            return prototype;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        boolean bAddPrototype = true;
        if (prototype == null && bAddPrototype) {
            try {
                Vector boolList = new Vector();
                prototype = ServerWizard.addPrototype(strAttribute, strValue, strContext, component, objectStore, null, boolList);
                bAddPrototype = false;
                if (wizard != null) {
                    wizard.addWizardData(strPrototypeKey, (Object)prototype);
                }
            }
            catch (PrototypeNotAddedException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }
        return prototype;
    }

    protected static Prototype addPrototype(String strAttribute, String strValue, String strContext, Component component, MdObjectStore objectStore, Locale locale, List boolList) throws PrototypeNotAddedException {
        Prototype prototype = null;
        String strXML = new String();
        Document doc = null;
        try {
            URL url = ResourceTemplateHelper.getURLfromPrototypeIndexFile();
            try {
                doc = Workspace.getMdFactory().getOMIUtil().parseXML(url);
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                return prototype;
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
            strXML = Workspace.getMdFactory().getUtil().createStringForNode((Node)doc);
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        if (strXML.equals("")) {
            return prototype;
        }
        component.setCursor(Cursor.getPredefinedCursor(3));
        strXML = strXML.substring(strXML.indexOf("<Prototypes"), strXML.indexOf("</Configuration"));
        if (doc != null) {
            Vector idList = new Vector();
            ServerWizard._buildData(doc, strAttribute, strValue, strContext, locale, boolList, idList);
            if (idList.size() > 0) {
                String strID = (String)idList.get(0);
                String strType = bundle.getString("Prototype.Type.notrans");
                String strTemplate = "<TEMPLATES><Prototype><Extensions/></Prototype></TEMPLATES>";
                String strSelect = "<XMLSELECT search=\"*[@Id='" + strID + "'\" />";
                String strOptions = strTemplate + strSelect;
                int flags = 8588;
                try {
                    List prototypeList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)objectStore, strContext, strType, flags, strOptions);
                    if (prototypeList.size() > 0) {
                        prototype = (Prototype)prototypeList.get(0);
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                }
                catch (RemoteException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                }
            }
        }
        component.setCursor(Cursor.getPredefinedCursor(0));
        return prototype;
    }

    private String[] refineClassIDs(String[] classIDs) {
        ArrayList<String> lstClassIDs = new ArrayList<String>();
        for (String strClassID : classIDs) {
            lstClassIDs.add(strClassID);
        }
        ArrayList<String> lstAppServerComponentClassIDs = new ArrayList<String>();
        for (int idIndex = 0; idIndex < lstClassIDs.size(); ++idIndex) {
            String strClassID = (String)lstClassIDs.get(idIndex);
            if (!strClassID.equalsIgnoreCase("d6644527-7a09-4fe2-8bac-1caca2f6a46c") && !strClassID.equalsIgnoreCase("e20e54b3-e5f4-47ed-b21d-03109bf9a4b8") && !strClassID.equalsIgnoreCase("a1ff485f-9e44-4c82-90b5-062916cfa9b9") && !strClassID.equalsIgnoreCase("D7E796B4-654C-4ab3-B690-657EE79309FB") && !strClassID.equalsIgnoreCase("0069e914-b58c-4094-a686-a87df433ec4b") && !strClassID.equalsIgnoreCase("0217e202-b560-11db-ad91-001083ff6836") && !strClassID.equalsIgnoreCase("f3f46472-1e31-11d5-87c2-00c04f38f9f6") && !strClassID.equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb") && !strClassID.equalsIgnoreCase("028e4060-d545-11d5-880d-aa0004006d06") && !strClassID.equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c") && !strClassID.equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c") && !strClassID.equalsIgnoreCase("510A5F10-8E07-44AC-942B-EFB5A4782A39") && !strClassID.equalsIgnoreCase("94D98CD0-56C5-40A3-A140-49D21D17BDCE")) continue;
            lstAppServerComponentClassIDs.add(strClassID);
            lstClassIDs.remove(strClassID);
            --idIndex;
        }
        if (lstAppServerComponentClassIDs.size() > 0 && !lstClassIDs.contains("SAS Application Server")) {
            lstClassIDs.add("SAS Application Server");
        }
        if (lstAppServerComponentClassIDs.size() > 0) {
            this.replaceWizardData("AppServerComponentClassIDs", lstAppServerComponentClassIDs);
        }
        return lstClassIDs.toArray(new String[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void _buildData(Node node, String strAttribute, String strValue, String strContext, Locale locale, List boolList, List idList) throws PrototypeNotAddedException {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 9: {
                NodeList children = node.getChildNodes();
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    ServerWizard._buildData(children.item(childIndex), strAttribute, strValue, strContext, locale, boolList, idList);
                }
                return;
            }
            case 1: {
                if (node.getNodeName().equals("Prototype")) {
                    NamedNodeMap childNodeMap = node.getAttributes();
                    String strPrototypeName = childNodeMap.getNamedItem(strAttribute).getNodeValue();
                    if (!strPrototypeName.equalsIgnoreCase(strValue)) return;
                    String strFileName = childNodeMap.getNamedItem("FileName").getNodeValue();
                    String strMetadataType = childNodeMap.getNamedItem("MetadataType").getNodeValue();
                    try {
                        URL url = XMLUtility.urlFromFile((String)strFileName);
                        if (locale != null && url.getFile().endsWith("_Template.xml")) {
                            return;
                        }
                        Document doc = null;
                        try {
                            doc = Workspace.getMdFactory().getOMIUtil().parseXML(url);
                        }
                        catch (MdException exc) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                            return;
                        }
                        catch (RemoteException exc) {
                            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                        }
                        String strContents = Workspace.getMdFactory().getUtil().createStringForNode((Node)doc);
                        int reposIndex = strContents.lastIndexOf("_ReposID_");
                        String strPrototypeXML = strContents.substring(0, reposIndex) + strContext + strContents.substring(reposIndex + 9);
                        try {
                            Document outDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(strPrototypeXML);
                            ServerWizard._getPrototypeID(outDoc, strMetadataType, idList);
                            boolList.add(Boolean.TRUE);
                            return;
                        }
                        catch (Exception exc) {
                            String strMessage = exc.getMessage();
                            if (!(exc instanceof MdException)) return;
                            throw new PrototypeNotAddedException(exc);
                        }
                    }
                    catch (IOException exc) {
                        exc.printStackTrace();
                    }
                    return;
                }
                NodeList children = node.getChildNodes();
                if (children == null) return;
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    ServerWizard._buildData(children.item(childIndex), strAttribute, strValue, strContext, locale, boolList, idList);
                }
                return;
            }
        }
    }

    private static void _getPrototypeID(Node node, String strMetadataType, List idList) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 9: {
                NodeList children = node.getChildNodes();
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    ServerWizard._getPrototypeID(children.item(childIndex), strMetadataType, idList);
                }
                break;
            }
            case 1: {
                if (node.getNodeName().equals("Prototype")) {
                    NamedNodeMap childNodeMap = node.getAttributes();
                    String strType = childNodeMap.getNamedItem("MetadataType").getNodeValue();
                    if (!strType.equalsIgnoreCase(strMetadataType)) break;
                    String strID = childNodeMap.getNamedItem("Id").getNodeValue();
                    idList.add(strID);
                    break;
                }
                NodeList children = node.getChildNodes();
                if (children == null) break;
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    ServerWizard._getPrototypeID(children.item(childIndex), strMetadataType, idList);
                }
                break;
            }
        }
    }
}

