/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.AttributeProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.COMConnection;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.OpenClientConnection;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.PrototypeProperty;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.ServiceType;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.Tree;
import com.sas.svcs.metadata.mgmt.impl.repository.ResourceTemplateHelper;
import com.sas.workspace.AbstractDesigner;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.IOMBridgeConnection;
import com.sas.workspace.mgmt.visuals.PrototypeNotAddedException;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import com.sas.workspace.mgmt.visuals.ServerConnectionInterface;
import com.sas.workspace.mgmt.visuals.ServerWizard;
import com.sas.workspace.visuals.PrototypeSelector;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Server {
    public static final String CLSID_ABM = "510A5F10-8E07-44AC-942B-EFB5A4782A39";
    public static final String CLSID_DATAMGTBATCH = "d6644527-7a09-4fe2-8bac-1caca2f6a46c";
    public static final String CLSID_DATASTEPBATCH = "e20e54b3-e5f4-47ed-b21d-03109bf9a4b8";
    public static final String CLSID_FTP = "CBA26437-1577-4FF8-93F6-9B68B4DD8D2E";
    public static final String CLSID_GENERICBATCH = "a1ff485f-9e44-4c82-90b5-062916cfa9b9";
    public static final String CLSID_GRID = "D7E796B4-654C-4ab3-B690-657EE79309FB";
    public static final String CLSID_HADOOP = "HADOOP";
    public static final String CLSID_HTTP = "DAC0D7F0-10DA-11D6-8816-AA0004006D06";
    public static final String CLSID_JAVABATCH = "0069e914-b58c-4094-a686-a87df433ec4b";
    public static final String CLSID_LASR = "SASIOLA";
    public static final String CLSID_METADATA = "0217e202-b560-11db-ad91-001083ff6836";
    public static final String CLSID_MSMQ = "MessageQueue.MSMQ";
    public static final String CLSID_OBJSPAWNER = "IOM Spawner";
    public static final String CLSID_OLAP = "f3f46472-1e31-11d5-87c2-00c04f38f9f6";
    public static final String CLSID_OSSCHEDULER = "b379c9c1-89e0-4e72-ba43-6a416899b5dd";
    public static final String CLSID_POOLEDWORKSPACE = "620963ee-32bf-4128-bf5f-4b0df8ff90eb";
    public static final String CLSID_POSTGRES = "Postgres";
    public static final String CLSID_PROCESSORCHESTRATION = "94D98CD0-56C5-40A3-A140-49D21D17BDCE";
    public static final String CLSID_SASAPPLICATIONSERVER = "SAS Application Server";
    public static final String CLSID_SASCONNECT = "028e4060-d545-11d5-880d-aa0004006d06";
    public static final String CLSID_SASCONNECTSPAWNER = "Connect Spawner";
    public static final String CLSID_SASINFRASTRUCTUREDATA = "SASInfrastructureData";
    public static final String CLSID_STOREDPROCESS = "15931e31-667f-11d5-8804-00c04f35ac8c";
    public static final String CLSID_TABLE = "e803e04b-aaf0-4c74-86a6-f7008aa702dc";
    public static final String CLSID_WEBSPHEREMQ = "MessageQueue.Websphere";
    public static final String CLSID_WORKSPACE = "440196d4-90f0-11d0-9f41-00a024bb830c";
    public static final String CLSID_REALTIME_ENGINE = "7BE029B7-95DF-41e6-A0C9-E05BC15D6704";
    public static final String CLSID_REALTIME_DECISION = "5C498B69-E34F-4e89-9B6A-C4744DF115EC";
    private static final String APPPROTOCOL_BRIDGE = "BRIDGE";
    protected DeployedComponent m_deployedComponent;
    protected String m_strContext;
    protected List m_logicalServerPrototypesList;
    protected Component m_component;
    protected ServerConnectionInterface m_serverConnection;
    protected MdObjectStore m_objectStore = null;
    protected static final WAdminResource bundle = new WAdminResource(Server.class);

    public Server(MdObjectStore objectStore, String strContext) {
        try {
            this.m_objectStore = objectStore;
            this.m_strContext = strContext;
            this.m_deployedComponent = (DeployedComponent)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, bundle.getString("Server.ServerIdentifierName.Server.txt"), "ServerComponent", strContext.substring(9), null);
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public Server(MdObjectStore objectStore, String strContext, DeployedComponent deployedComponent) {
        this.m_objectStore = objectStore;
        this.m_strContext = strContext;
        this.m_deployedComponent = deployedComponent;
    }

    public DeployedComponent getDeployedComponent() {
        return this.m_deployedComponent;
    }

    public void setDeployedComponent(DeployedComponent deployedComponent) {
        this.m_deployedComponent = deployedComponent;
    }

    public Component getParentComponent() {
        return this.m_component;
    }

    public void setParentComponent(Component component) {
        this.m_component = component;
    }

    public MdObjectStore getStore() {
        return this.m_objectStore;
    }

    public Prototype getDeployedComponentPrototype(Component parent) throws MdException, RemoteException {
        return this.getDeployedComponentPrototype(parent, false);
    }

    public Prototype getDeployedComponentPrototype(Component parent, boolean bShowPrototypeSelector) throws MdException, RemoteException {
        Prototype prototype = (Prototype)this.getDeployedComponent().getUsingPrototype();
        if (prototype != null) {
            String strTemplate = bundle.getString("Prototype.Template.All.notrans");
            int flags = 268;
            prototype = (Prototype)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)prototype, new Vector(), new Vector(), strTemplate, flags);
        }
        if (prototype != null) {
            AssociationList extensionList = PrototypeUtil.getParentPrototype(prototype, this.m_strContext).getExtensions();
            for (int extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                Extension extension = (Extension)extensionList.get(extIndex);
                if (!extension.getName().equals("Locale")) continue;
                String localeValue = extension.getValue();
                if (!localeValue.equalsIgnoreCase("Generic")) break;
                return prototype;
            }
        }
        Locale locale = Locale.getDefault();
        if (prototype != null) {
            AssociationList extensionList = PrototypeUtil.getParentPrototype(prototype, this.m_strContext).getExtensions();
            boolean bLocaleExtensionFound = false;
            for (int extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                Extension extension = (Extension)extensionList.get(extIndex);
                if (!extension.getName().equals("Locale")) continue;
                if (!PrototypeUtil.getLocale(extension.getValue()).equals(locale)) {
                    prototype = null;
                }
                bLocaleExtensionFound = true;
                break;
            }
            if (!bLocaleExtensionFound && !PrototypeUtil.getLocale("en_US").equals(locale)) {
                prototype = null;
            }
        }
        if (prototype == null) {
            int returnValue;
            String strClassID = this.getDeployedComponent().getClassIdentifier();
            String strMetadataType = "ServerComponent";
            if (this.getDeployedComponent() instanceof LogicalServer) {
                strMetadataType = "LogicalServer";
            }
            if (this.getDeployedComponent() instanceof ServerContext) {
                strMetadataType = "ServerContext";
            }
            if ((prototype = ServerWizard.getPrototype("PrototypeProperties", "ClassIdentifier", strClassID, this.getContext(), this.getStore(), parent, strMetadataType, bShowPrototypeSelector)) != null) {
                this.getDeployedComponent().setUsingPrototype((Root)prototype);
            } else if (bShowPrototypeSelector && (returnValue = MessageUtil.displayMessage((String)bundle.getString("ServerWizard.NoAssociatedResourceTemplate.Server.txt"), (String)bundle.getString("Common.Warning.txt"), (int)2, (int)0)) == 0) {
                prototype = Server.getPrototypeViaSelector(parent, strMetadataType, this.m_strContext, this.m_objectStore);
            }
        }
        return prototype;
    }

    public List getSourceConnectionPrototypes() throws MdException, RemoteException {
        Vector<Prototype> prototypesList = new Vector<Prototype>();
        AssociationList connectionsList = this.getDeployedComponent().getSourceConnections();
        for (int i = 0; i < connectionsList.size(); ++i) {
            Connection connection = (Connection)connectionsList.get(i);
            Prototype prototype = (Prototype)connection.getUsingPrototype();
            prototypesList.add(prototype);
        }
        return prototypesList;
    }

    public List getProviderConnectionPrototypes() throws MdException, RemoteException {
        Vector<Prototype> prototypesList = new Vector<Prototype>();
        AssociationList connectionsList = this.getDeployedComponent().getProviderConnections();
        for (int i = 0; i < connectionsList.size(); ++i) {
            Connection connection = (Connection)connectionsList.get(i);
            Prototype prototype = (Prototype)connection.getUsingPrototype();
            prototypesList.add(prototype);
        }
        return prototypesList;
    }

    public Prototype getConnectionPrototype(Connection connection, Component parent) throws MdException, RemoteException {
        return this.getConnectionPrototype(connection, parent, false);
    }

    public Prototype getConnectionPrototype(Connection connection, Component parent, boolean bShowPrototypeSelector) throws MdException, RemoteException {
        Prototype prototype = (Prototype)connection.getUsingPrototype();
        if (prototype != null) {
            String strTemplate = bundle.getString("Prototype.Template.All.notrans");
            int flags = 268;
            prototype = (Prototype)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)prototype, new Vector(), new Vector(), strTemplate, flags);
        }
        if (prototype != null) {
            AssociationList extensionList = PrototypeUtil.getParentPrototype(prototype, this.m_strContext).getExtensions();
            for (int extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                Extension extension = (Extension)extensionList.get(extIndex);
                if (!extension.getName().equals("Locale")) continue;
                String localeValue = extension.getValue();
                if (!localeValue.equalsIgnoreCase("Generic")) break;
                return prototype;
            }
        }
        Locale locale = Locale.getDefault();
        if (prototype != null) {
            AssociationList extensionList = PrototypeUtil.getParentPrototype(prototype, this.m_strContext).getExtensions();
            boolean bLocaleExtensionFound = false;
            for (int extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                Extension extension = (Extension)extensionList.get(extIndex);
                if (!extension.getName().equals("Locale")) continue;
                if (!PrototypeUtil.getLocale(extension.getValue()).equals(locale) && !PrototypeUtil.getLocale(extension.getValue()).getLanguage().equalsIgnoreCase(locale.getLanguage())) {
                    prototype = null;
                }
                bLocaleExtensionFound = true;
                break;
            }
            if (!bLocaleExtensionFound && !PrototypeUtil.getLocale("en_US").equals(locale)) {
                prototype = null;
            }
        }
        if (prototype == null) {
            Prototype dcPrototype = this.getDeployedComponentPrototype(parent, bShowPrototypeSelector);
            if (dcPrototype == null) {
                return prototype;
            }
            AssociationList assocPropertyList = dcPrototype.getAssociations();
            for (int j = 0; j < assocPropertyList.size(); ++j) {
                AssociationProperty ap = (AssociationProperty)assocPropertyList.get(j);
                if (!ap.getAssociationName().equals("SourceConnections")) continue;
                AssociationList prototypeList = ap.getAssociatedPrototypes();
                block3: for (int k = 0; k < prototypeList.size(); ++k) {
                    Prototype apPrototype = (Prototype)prototypeList.get(k);
                    if (apPrototype == dcPrototype) continue;
                    AssociationList propertyList = apPrototype.getPrototypeProperties();
                    for (int l = 0; l < propertyList.size(); ++l) {
                        AttributeProperty attribProperty;
                        AbstractProperty property = (AbstractProperty)propertyList.get(l);
                        if (!(property instanceof AttributeProperty) || !(attribProperty = (AttributeProperty)property).getPropertyName().equals("ApplicationProtocol")) continue;
                        String strAppProtocol = attribProperty.getDefaultValue();
                        if (strAppProtocol.equals(connection.getApplicationProtocol())) {
                            prototype = apPrototype;
                            connection.setUsingPrototype((Root)apPrototype);
                            continue block3;
                        }
                        PropertyType propertyType = attribProperty.getOwningType();
                        TextStore textStore = (TextStore)propertyType.getStoredConfiguration();
                        if (textStore == null) continue;
                        String strStoredText = textStore.getStoredText();
                        Vector valueList = new Vector();
                        Document doc = Workspace.getMdFactory().getOMIUtil().parseXML(strStoredText);
                        if (doc != null) {
                            this._getEnumeratedValues(doc, "Value", "name", valueList);
                        }
                        boolean bFound = false;
                        for (int valueIndex = 0; valueIndex < valueList.size(); ++valueIndex) {
                            String strValue = (String)valueList.get(valueIndex);
                            if (!strValue.equals(connection.getApplicationProtocol())) continue;
                            prototype = apPrototype;
                            connection.setUsingPrototype((Root)apPrototype);
                            bFound = true;
                            break;
                        }
                        if (bFound) continue block3;
                    }
                }
            }
        }
        return prototype;
    }

    public Prototype getTransformationPrototype(Transformation transformation, Component parent) throws MdException, RemoteException {
        Prototype prototype = (Prototype)transformation.getUsingPrototype();
        if (prototype != null) {
            String strTemplate = bundle.getString("Prototype.Template.All.notrans");
            int flags = 268;
            prototype = (Prototype)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)prototype, new Vector(), new Vector(), strTemplate, flags);
        }
        if (prototype != null) {
            AssociationList extensionList = PrototypeUtil.getParentPrototype(prototype, this.m_strContext).getExtensions();
            for (int extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                Extension extension = (Extension)extensionList.get(extIndex);
                if (!extension.getName().equals("Locale")) continue;
                String localeValue = extension.getValue();
                if (!localeValue.equalsIgnoreCase("Generic")) break;
                return prototype;
            }
        }
        Locale locale = Locale.getDefault();
        if (prototype != null) {
            AssociationList extensionList = PrototypeUtil.getParentPrototype(prototype, this.m_strContext).getExtensions();
            boolean bLocaleExtensionFound = false;
            for (int extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                Extension extension = (Extension)extensionList.get(extIndex);
                if (!extension.getName().equals("Locale")) continue;
                if (!PrototypeUtil.getLocale(extension.getValue()).equals(locale)) {
                    prototype = null;
                }
                bLocaleExtensionFound = true;
                break;
            }
            if (!bLocaleExtensionFound && !PrototypeUtil.getLocale("en_US").equals(locale)) {
                prototype = null;
            }
        }
        if (prototype == null) {
            Prototype dcPrototype = this.getDeployedComponentPrototype(parent);
            if (dcPrototype == null) {
                return prototype;
            }
            AssociationList assocPropertyList = dcPrototype.getAssociations();
            for (int j = 0; j < assocPropertyList.size(); ++j) {
                AssociationProperty ap = (AssociationProperty)assocPropertyList.get(j);
                if (!ap.getAssociationName().equals("InitProcesses")) continue;
                AssociationList prototypeList = ap.getAssociatedPrototypes();
                block3: for (int k = 0; k < prototypeList.size(); ++k) {
                    Prototype apPrototype = (Prototype)prototypeList.get(k);
                    if (apPrototype == dcPrototype) continue;
                    AssociationList propertyList = apPrototype.getPrototypeProperties();
                    for (int l = 0; l < propertyList.size(); ++l) {
                        String strRole;
                        AttributeProperty attribProperty;
                        AbstractProperty property = (AbstractProperty)propertyList.get(l);
                        if (!(property instanceof AttributeProperty) || !(attribProperty = (AttributeProperty)property).getPropertyName().equals("TransformRole") || !(strRole = attribProperty.getDefaultValue()).equals(transformation.getTransformRole())) continue;
                        prototype = apPrototype;
                        transformation.setUsingPrototype((Root)apPrototype);
                        continue block3;
                    }
                }
            }
        }
        return prototype;
    }

    public Prototype getTreePrototype(Tree tree, Component parent) throws MdException, RemoteException {
        Prototype prototype = (Prototype)tree.getUsingPrototype();
        if (prototype != null) {
            String strTemplate = bundle.getString("Prototype.Template.All.notrans");
            int flags = 268;
            prototype = (Prototype)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)prototype, new Vector(), new Vector(), strTemplate, flags);
        }
        if (prototype != null) {
            AssociationList extensionList = PrototypeUtil.getParentPrototype(prototype, this.m_strContext).getExtensions();
            for (int extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                Extension extension = (Extension)extensionList.get(extIndex);
                if (!extension.getName().equals("Locale")) continue;
                String localeValue = extension.getValue();
                if (!localeValue.equalsIgnoreCase("Generic")) break;
                return prototype;
            }
        }
        Locale locale = Locale.getDefault();
        if (prototype != null) {
            AssociationList extensionList = PrototypeUtil.getParentPrototype(prototype, this.m_strContext).getExtensions();
            boolean bLocaleExtensionFound = false;
            for (int extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                Extension extension = (Extension)extensionList.get(extIndex);
                if (!extension.getName().equals("Locale")) continue;
                if (!PrototypeUtil.getLocale(extension.getValue()).equals(locale)) {
                    prototype = null;
                }
                bLocaleExtensionFound = true;
                break;
            }
            if (!bLocaleExtensionFound && !PrototypeUtil.getLocale("en_US").equals(locale)) {
                prototype = null;
            }
        }
        if (prototype == null) {
            Prototype dcPrototype = this.getDeployedComponentPrototype(parent);
            if (dcPrototype == null) {
                return prototype;
            }
            AssociationList assocPropertyList = dcPrototype.getAssociations();
            for (int j = 0; j < assocPropertyList.size(); ++j) {
                AssociationProperty ap = (AssociationProperty)assocPropertyList.get(j);
                if (!ap.getAssociationName().equals("SoftwareTrees")) continue;
                AssociationList prototypeList = ap.getAssociatedPrototypes();
                block3: for (int k = 0; k < prototypeList.size(); ++k) {
                    Prototype apPrototype = (Prototype)prototypeList.get(k);
                    if (apPrototype == dcPrototype) continue;
                    AssociationList propertyList = apPrototype.getPrototypeProperties();
                    for (int l = 0; l < propertyList.size(); ++l) {
                        String strRole;
                        AttributeProperty attribProperty;
                        AbstractProperty property = (AbstractProperty)propertyList.get(l);
                        if (!(property instanceof AttributeProperty) || !(attribProperty = (AttributeProperty)property).getPropertyName().equals("TreeType") || !(strRole = attribProperty.getDefaultValue()).equals(tree.getTreeType())) continue;
                        prototype = apPrototype;
                        tree.setUsingPrototype((Root)apPrototype);
                        continue block3;
                    }
                }
            }
        }
        return prototype;
    }

    public String getContext() {
        return this.m_strContext;
    }

    public static Root createNewEditableObject(Root root) {
        try {
            MdObjectStore objectStore = Workspace.getMdFactory().createObjectStore((MdStore)Workspace.getMdFactory().getStore(), "Server - Create New Editable Object Store");
            Root editableObject = (Root)Workspace.getMdFactory().createComplexMetadataObject(objectStore, null, root.getName(), root.getCMetadataType(), root.getId());
            editableObject = Server._setAttrsAndAssocs(editableObject);
            return editableObject;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            return null;
        }
    }

    public static Root createObjectSpecific(Root root, MdObjectStore objectStore, String strType) {
        try {
            Root specificObject = (Root)Workspace.getMdFactory().createComplexMetadataObject(objectStore, null, root.getName(), strType, root.getFQID().substring(0, 9) + "$New", null);
            specificObject = Server._setAttrsAndAssocs(specificObject);
            return specificObject;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            return null;
        }
    }

    protected static Root _setAttrsAndAssocs(Root root) {
        try {
            Vector<String> attribs = new Vector<String>();
            Map metaAttrs = root.getAttrs();
            Set attrSet = metaAttrs.keySet();
            for (String strNext : attrSet) {
                if (strNext.equalsIgnoreCase("ID")) continue;
                attribs.add(strNext);
            }
            try {
                root = (Root)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)root, attribs, null, "", 8);
            }
            catch (MdException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
            return root;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            return null;
        }
    }

    public static String getXMLTagStringValue(String strXML, String strTag) {
        String strStart = "<" + strTag + ">";
        String strEnd = "</" + strTag + ">";
        if (strXML.indexOf(strStart) == -1 || strXML.indexOf(strEnd) == -1) {
            return "";
        }
        return strXML.substring(strXML.indexOf(strStart) + strStart.length(), strXML.indexOf(strEnd));
    }

    public void setLogicalServerPrototypes(List list) {
        this.m_logicalServerPrototypesList = list;
    }

    public List getLogicalServerPrototypes(Component parent) {
        if (this.m_logicalServerPrototypesList != null) {
            return this.m_logicalServerPrototypesList;
        }
        parent.setCursor(Cursor.getPredefinedCursor(3));
        this.m_logicalServerPrototypesList = new Vector();
        ServerContext serverContext = (ServerContext)this.getDeployedComponent();
        Vector<String> classIDList = new Vector<String>();
        try {
            AssociationList logicalServerList = serverContext.getUsingComponents();
            for (int i = 0; i < logicalServerList.size(); ++i) {
                LogicalServer ls = (LogicalServer)logicalServerList.get(i);
                classIDList.add(ls.getClassIdentifier());
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
            return this.m_logicalServerPrototypesList;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        String strTemplate = "<TEMPLATES><Prototype><Extensions/><PrototypeProperties/></Prototype><Extension/><PrototypeProperty/></TEMPLATES>";
        String strSelect = "<XMLSELECT search=\"*[@MetadataType='LogicalServer'][PrototypeProperties/AttributeProperty[@PropertyName='ClassIdentifier' AND (@DefaultValue='440196d4-90f0-11d0-9f41-00a024bb830c' OR @DefaultValue='15931e31-667f-11d5-8804-00c04f35ac8c' OR @DefaultValue='0217e202-b560-11db-ad91-001083ff6836' OR @DefaultValue='f3f46472-1e31-11d5-87c2-00c04f38f9f6' OR @DefaultValue='028e4060-d545-11d5-880d-aa0004006d06' OR @DefaultValue='D7E796B4-654C-4ab3-B690-657EE79309FB' OR @DefaultValue='d6644527-7a09-4fe2-8bac-1caca2f6a46c' OR @DefaultValue='e20e54b3-e5f4-47ed-b21d-03109bf9a4b8' OR @DefaultValue='0069e914-b58c-4094-a686-a87df433ec4b' OR @DefaultValue='a1ff485f-9e44-4c82-90b5-062916cfa9b9' OR @DefaultValue='620963ee-32bf-4128-bf5f-4b0df8ff90eb' OR @DefaultValue='510A5F10-8E07-44AC-942B-EFB5A4782A39' OR @DefaultValue='94D98CD0-56C5-40A3-A140-49D21D17BDCE')]]\"/>";
        String strOptions = strTemplate + strSelect;
        int flags = 8588;
        List prototypeList = null;
        try {
            prototypeList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.getStore(), this.getContext(), "Prototype", flags, strOptions);
            if (prototypeList.size() == 0) {
                Vector boolList = new Vector();
                ServerWizard.addPrototype("UITreeCategory", "SAS Servers.SAS Application Server Components", this.getContext(), parent, this.getStore(), PrototypeUtil.getLocale("en_US"), boolList);
                prototypeList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.getStore(), this.getContext(), "Prototype", flags, strOptions);
            }
        }
        catch (PrototypeNotAddedException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
            return this.m_logicalServerPrototypesList;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        for (int i = 0; i < prototypeList.size(); ++i) {
            Prototype prototype = (Prototype)prototypeList.get(i);
            try {
                boolean bAddPrototype = true;
                AssociationList propertiesList = prototype.getPrototypeProperties();
                for (int k = 0; k < propertiesList.size(); ++k) {
                    AttributeProperty ap;
                    PrototypeProperty property = (PrototypeProperty)propertiesList.get(k);
                    if (property instanceof AttributeProperty && (ap = (AttributeProperty)property).getPropertyName().equals("ClassIdentifier")) {
                        String strClassID = ap.getDefaultValue();
                        for (int l = 0; l < classIDList.size(); ++l) {
                            String strServerClassID = (String)classIDList.get(l);
                            if (!strClassID.equals(strServerClassID)) continue;
                            bAddPrototype = false;
                            break;
                        }
                    }
                    if (!bAddPrototype) break;
                }
                if (!bAddPrototype) continue;
                this.m_logicalServerPrototypesList.add(prototype);
                continue;
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                continue;
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }
        parent.setCursor(Cursor.getPredefinedCursor(0));
        return this.m_logicalServerPrototypesList;
    }

    public List getLogicalServerComponentPrototypes(Component parent) {
        Vector<Prototype> prototypesList = new Vector<Prototype>();
        List logicalPrototypesList = this.getLogicalServerPrototypes(parent);
        try {
            block3: for (int lpIndex = 0; lpIndex < logicalPrototypesList.size(); ++lpIndex) {
                Prototype lp = (Prototype)logicalPrototypesList.get(lpIndex);
                AssociationList assocPropertyList = lp.getAssociations();
                for (int apIndex = 0; apIndex < assocPropertyList.size(); ++apIndex) {
                    AssociationProperty ap = (AssociationProperty)assocPropertyList.get(apIndex);
                    if (!ap.getAssociationName().equals("UsedByComponents")) continue;
                    AssociationList assocPrototypesList = ap.getAssociatedPrototypes();
                    for (int protIndex = 0; protIndex < assocPrototypesList.size(); ++protIndex) {
                        Prototype prot = (Prototype)assocPrototypesList.get(protIndex);
                        if (!prot.getMetadataType().equals("ServerComponent")) continue;
                        prototypesList.add(prot);
                        continue block3;
                    }
                    continue block3;
                }
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        return prototypesList;
    }

    public static Prototype getPrototypeViaSelector(Component parent, String strMetadataType, String strReposID, MdObjectStore objectStore) {
        Prototype prototype = null;
        String strContents = new String();
        Vector dataList = new Vector();
        PrototypeSelector selector = new PrototypeSelector(bundle.getString("PrototypeSelector.Category.ResourceTemplates.txt"));
        Document doc = null;
        try {
            URL url = ResourceTemplateHelper.getURLfromPrototypeIndexFile();
            try {
                doc = Workspace.getMdFactory().getOMIUtil().parseXML(url);
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                return prototype;
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
            if (doc != null) {
                Server._buildData(doc, strMetadataType, dataList, selector);
            }
            strContents = Workspace.getMdFactory().getUtil().createStringForNode((Node)doc);
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        String strXML = strContents;
        strXML = strXML.substring(strXML.indexOf("<Prototypes"), strXML.indexOf("</Configuration"));
        WAPropertyDialog dialog = null;
        if (parent instanceof Frame) {
            dialog = new WAPropertyDialog((Frame)parent, bundle.getString("Server.SelectResourceTemplate.txt"), true);
        } else if (parent instanceof Dialog) {
            dialog = new WAPropertyDialog((Dialog)parent, bundle.getString("Server.SelectResourceTemplate.txt"), true);
        }
        dialog.setHelpProduct("templatedata");
        dialog.setHelpTopic("resource_template_selector");
        AbstractDesigner.cAbstractDesignerTree tree = selector.getTree();
        int rowCount = 0;
        while (rowCount != tree.getRowCount()) {
            for (int i = 0; i < tree.getRowCount(); ++i) {
                tree.expandRow(i);
            }
            rowCount = tree.getRowCount();
        }
        JScrollPane pane = new JScrollPane((Component)tree);
        pane.setBorder(BorderFactory.createLoweredBevelBorder());
        SelectorPanel panel = new SelectorPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gbl);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridwidth = 0;
        c.gridheight = 0;
        gbl.setConstraints(pane, c);
        panel.add(pane);
        dialog.setMainPanel((WAPanel)panel);
        dialog.show();
        if (dialog.getReturnValue() == 1) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
            String strPrototypeName = node.toString();
            for (int i = 0; i < dataList.size(); ++i) {
                String strDataName = (String)dataList.get(i);
                if (!PrototypeUtil.getDisplayString(strDataName).equals(strPrototypeName)) continue;
                prototype = ServerWizard.getPrototype(null, "Name", strDataName, strReposID, objectStore, parent, strMetadataType);
                break;
            }
        }
        return prototype;
    }

    private static void _buildData(Node node, String strMetadataType, List dataList, PrototypeSelector selector) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 9: {
                NodeList children = node.getChildNodes();
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    Server._buildData(children.item(childIndex), strMetadataType, dataList, selector);
                }
                break;
            }
            case 1: {
                if (node.getNodeName().equals("Prototype")) {
                    NamedNodeMap childNodeMap = node.getAttributes();
                    String strPrototypeName = PrototypeUtil.getDisplayString(childNodeMap.getNamedItem("Name").getNodeValue());
                    dataList.add(childNodeMap.getNamedItem("Name").getNodeValue());
                    String strType = childNodeMap.getNamedItem("MetadataType").getNodeValue();
                    if (!strType.equals(strMetadataType)) break;
                    String strCategory = "";
                    if (strType.equals("ServerComponent") || strType.equals("LogicalServer") || strType.equals("ServerContext")) {
                        strCategory = bundle.getString("PrototypeSelector.Category.Servers.txt");
                    }
                    if (strType.equals("SASLibrary")) {
                        strCategory = bundle.getString("PrototypeSelector.Category.Libraries.txt");
                    }
                    if (strType.equals("DatabaseSchema")) {
                        strCategory = bundle.getString("PrototypeSelector.Category.Schemas.txt");
                    }
                    String strSubCategory = PrototypeUtil.getDisplayString(childNodeMap.getNamedItem("UITreeCategory").getNodeValue());
                    String strName = strCategory + "." + strSubCategory + "." + strPrototypeName;
                    String strDesc = PrototypeUtil.getDisplayString(childNodeMap.getNamedItem("Desc").getNodeValue());
                    selector.buildTree(strName, strDesc);
                    break;
                }
                NodeList children = node.getChildNodes();
                if (children == null) break;
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    Server._buildData(children.item(childIndex), strMetadataType, dataList, selector);
                }
                break;
            }
        }
    }

    private void _getEnumeratedValues(Node node, String strNodeName, String strAttribute, List valueList) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 9: {
                NodeList children = node.getChildNodes();
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    this._getEnumeratedValues(children.item(childIndex), strNodeName, strAttribute, valueList);
                }
                break;
            }
            case 1: {
                if (node.getNodeName().equalsIgnoreCase(strNodeName)) {
                    NamedNodeMap childNodeMap = node.getAttributes();
                    String strValue = childNodeMap.getNamedItem(strAttribute).getNodeValue();
                    valueList.add(strValue);
                    break;
                }
                NodeList children = node.getChildNodes();
                if (children == null) break;
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    this._getEnumeratedValues(children.item(childIndex), strNodeName, strAttribute, valueList);
                }
                break;
            }
        }
    }

    public void persist() throws MdException, RemoteException {
        this.m_deployedComponent.updateMetadataAll();
    }

    public static boolean isIOMServer(DeployedComponent dc) {
        boolean bIsIOMServer = false;
        try {
            AssociationList serviceTypesList = dc.getServiceTypes();
            for (int typeIndex = 0; typeIndex < serviceTypesList.size(); ++typeIndex) {
                ServiceType type = (ServiceType)serviceTypesList.get(typeIndex);
                if (!type.getName().equalsIgnoreCase("IOM Server")) continue;
                bIsIOMServer = true;
                break;
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        return bIsIOMServer;
    }

    public static boolean isObjectSpawner(DeployedComponent dc) {
        boolean bIsObjectSpawner = false;
        try {
            AssociationList serviceTypesList = dc.getServiceTypes();
            for (int typeIndex = 0; typeIndex < serviceTypesList.size(); ++typeIndex) {
                ServiceType type = (ServiceType)serviceTypesList.get(typeIndex);
                if (!type.getName().equalsIgnoreCase(CLSID_OBJSPAWNER)) continue;
                bIsObjectSpawner = true;
                break;
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        return bIsObjectSpawner;
    }

    public ServerConnectionInterface getServerConnection(Connection connection) {
        try {
            if (this.m_serverConnection != null) {
                return this.m_serverConnection;
            }
            String strClassID = this.m_deployedComponent.getClassIdentifier();
            String strAppProtocol = connection.getApplicationProtocol();
            if (strClassID != null && (strClassID.equalsIgnoreCase(CLSID_WORKSPACE) || strClassID.equalsIgnoreCase(CLSID_STOREDPROCESS) || strClassID.equalsIgnoreCase(CLSID_OSSCHEDULER)) && strAppProtocol.equalsIgnoreCase(APPPROTOCOL_BRIDGE)) {
                this.m_serverConnection = new IOMBridgeConnection();
            }
            return this.m_serverConnection;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            return null;
        }
    }

    public boolean canTestConnection(Prototype prototype) {
        try {
            boolean bCanTest = false;
            String strClassID = this.m_deployedComponent.getClassIdentifier();
            String strAppProtocol = "";
            AssociationList propertiesList = prototype.getPrototypeProperties();
            for (int i = 0; i < propertiesList.size(); ++i) {
                AttributeProperty ap;
                AbstractProperty property = (AbstractProperty)propertiesList.get(i);
                if (!(property instanceof AttributeProperty) || !(ap = (AttributeProperty)property).getPropertyName().equals("ApplicationProtocol")) continue;
                strAppProtocol = ap.getDefaultValue();
                break;
            }
            if (strClassID != null && (strClassID.equalsIgnoreCase(CLSID_WORKSPACE) || strClassID.equalsIgnoreCase(CLSID_STOREDPROCESS)) && strAppProtocol.equalsIgnoreCase(APPPROTOCOL_BRIDGE)) {
                bCanTest = true;
            }
            return bCanTest;
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
            return false;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            return false;
        }
    }

    protected Machine getMachine(Connection sourceConnection) {
        Machine machine = null;
        try {
            TCPIPConnection conn;
            int flags = 8456;
            List machinesList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_objectStore, this.getContext(), "Machine", flags, "");
            String strHostName = null;
            if (sourceConnection instanceof TCPIPConnection) {
                conn = (TCPIPConnection)sourceConnection;
                strHostName = conn.getHostName();
            } else if (sourceConnection instanceof SASClientConnection) {
                conn = (SASClientConnection)sourceConnection;
                strHostName = conn.getRemoteAddress();
            } else if (sourceConnection instanceof COMConnection) {
                conn = (COMConnection)sourceConnection;
                strHostName = conn.getHostName();
            }
            boolean bFound = false;
            for (int i = 0; strHostName != null && i < machinesList.size(); ++i) {
                Machine mac = (Machine)machinesList.get(i);
                if (!mac.getName().equalsIgnoreCase(strHostName)) continue;
                bFound = true;
                machine = mac;
                break;
            }
            if (!bFound && strHostName != null && strHostName.length() > 0) {
                machine = this.addMachine();
                machine.setName(strHostName, 1);
            }
            if (machine == null) {
                machine = this.getDeployedComponent().getAssociatedMachine();
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        return machine;
    }

    public SoftwareComponent addSoftwareComponent() {
        try {
            SoftwareComponent softwareComponent = (SoftwareComponent)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, "SoftwareComponent", "SoftwareComponent", this.m_strContext.substring(9), null);
            this.getDeployedComponent().setDescriptiveComponent(softwareComponent);
            return softwareComponent;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            return null;
        }
    }

    public Machine addMachine() {
        try {
            Machine machine = (Machine)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, "Machine", "Machine", this.m_strContext.substring(9), null);
            this.getDeployedComponent().setAssociatedMachine(machine);
            return machine;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            return null;
        }
    }

    public ServiceType addServiceType() {
        ServiceType serviceType = null;
        try {
            serviceType = (ServiceType)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, "ServiceType", "ServiceType", this.m_strContext.substring(9), null);
            this.getDeployedComponent().getServiceTypes().add((Object)serviceType);
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        return serviceType;
    }

    public SASClientConnection addSASClientConnection() {
        try {
            SASClientConnection connection = null;
            connection = (SASClientConnection)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, "SASClientConnection", "SASClientConnection", this.m_strContext.substring(9), null);
            return connection;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            return null;
        }
    }

    public TCPIPConnection addTCPIPConnection() {
        try {
            TCPIPConnection connection = null;
            connection = (TCPIPConnection)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, "TCPIPConnection", "TCPIPConnection", this.m_strContext.substring(9), null);
            connection.removeElementFromChangeList((CMetadata)connection);
            return connection;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            return null;
        }
    }

    public COMConnection addCOMConnection() {
        try {
            COMConnection connection = null;
            connection = (COMConnection)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, "COMConnection", "COMConnection", this.m_strContext.substring(9), null);
            return connection;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            return null;
        }
    }

    public OpenClientConnection addOpenClientConnection() {
        try {
            OpenClientConnection connection = null;
            connection = (OpenClientConnection)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, "OpenClientConnection", "OpenClientConnection", this.m_strContext.substring(9), null);
            return connection;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            return null;
        }
    }

    public Connection addConnection() {
        try {
            Connection connection = null;
            connection = (Connection)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, "Connection", "Connection", this.m_strContext.substring(9), null);
            return connection;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            return null;
        }
    }

    public Transformation addTransformation() {
        try {
            Transformation transformation = null;
            transformation = (Transformation)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, "Transformation", "Transformation", this.m_strContext.substring(9), null);
            return transformation;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            return null;
        }
    }

    public static boolean isConnectServer(DeployedComponent dc) {
        boolean bIsConnectServer = false;
        try {
            if (dc.getClassIdentifier().equalsIgnoreCase(CLSID_SASCONNECT)) {
                bIsConnectServer = true;
            }
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        return bIsConnectServer;
    }

    public static boolean isConnectSpawner(DeployedComponent dc) {
        boolean bIsConnectSpawner = false;
        try {
            AssociationList serviceTypesList = dc.getServiceTypes();
            for (int typeIndex = 0; typeIndex < serviceTypesList.size(); ++typeIndex) {
                ServiceType type = (ServiceType)serviceTypesList.get(typeIndex);
                if (!type.getName().equalsIgnoreCase(CLSID_SASCONNECTSPAWNER)) continue;
                bIsConnectSpawner = true;
                break;
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        return bIsConnectSpawner;
    }

    public static class SelectorPanel
    extends WAPanel {
        private static final long serialVersionUID = -4903459000762515445L;

        public boolean doDataExchange(boolean bSaveToModel) {
            return true;
        }

        public boolean validateData() {
            return true;
        }
    }
}

