/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.IServer;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.services.session.SessionContextInterface;
import com.sas.svcs.metadata.mgmt.client.CustomRepository;
import com.sas.svcs.metadata.mgmt.client.FoundationRepository;
import com.sas.svcs.metadata.mgmt.client.MetadataRepositoryService;
import com.sas.svcs.metadata.mgmt.client.ProjectRepository;
import com.sas.svcs.metadata.mgmt.client.Repository;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATransitionWizardModel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAWizardModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WizardTabInfo;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.IdentityReposPair;
import com.sas.workspace.mgmt.NewReposIdentityTabInfo;
import com.sas.workspace.mgmt.RepositoryUtil;
import com.sas.workspace.mgmt.visuals.ActionLogger;
import com.sas.workspace.mgmt.visuals.BasicPathOptionsTab;
import com.sas.workspace.mgmt.visuals.GeneralRepositoryPropertyView;
import com.sas.workspace.mgmt.visuals.NewReposIdentityListPanel;
import com.sas.workspace.mgmt.visuals.RepositoryTypeView;
import com.sas.workspace.visuals.WizardFinishTab;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegisterReposWizard
extends WAWizardDialog {
    private static final long serialVersionUID = 1L;
    protected RepositoryTypeView reposTypeTab = null;
    protected GeneralRepositoryPropertyView nameDescTab = null;
    protected BasicPathOptionsTab pathOptionsTab = null;
    protected WizardFinishTab summaryTab = null;
    protected NewReposIdentityListPanel identityTab = null;
    protected WizardTabInfo lastTabInfo = null;
    protected WizardTabInfo pathTabInfo = null;
    private static WAdminResource bundle = WAdminResource.getBundle(RegisterReposWizard.class);
    protected static String defaultTitle = bundle.getString("RegisterReposWizard.DefaultTitle.txt");
    protected static String nameDescTabTitle = bundle.getString("NewReposWizard.GeneralRepositoryPropertyView.Title.txt");
    protected static String pathTabTitle = bundle.getString("NewReposWizard.BasicPathOptionsTab.Title.txt");
    protected static String summaryTabTitle = bundle.getString("NewReposWizard.SummaryTab.Title.txt");
    protected static String typeTabTitle = bundle.getString("NewReposWizard.TypeTab.Title.txt");
    protected static String identityTabTitle = bundle.getString("NewReposWizard.IdentityTab.Title.txt");
    protected IOMI m_omiConnection;
    protected String m_serverName;
    protected IServer m_server;
    protected Repository m_newRepos = null;
    protected Frame m_frame;
    protected String m_type;
    protected String m_repName;
    protected String m_repDesc;
    protected String m_repPath;
    protected String m_repOptions;
    protected String m_repEngine;
    protected boolean m_UserAllowedToRegister = true;
    protected static SessionContextInterface _session = null;
    MetadataRepositoryService repositoryService = null;
    protected static boolean _initResult = true;
    List<Logger> _loggers = null;
    private static final String MGMTSVCS_PACKAGE = "com.sas.svcs.metadata.mgmt";

    public RegisterReposWizard(Frame frame, String title, IOMI omiConnection, IServer server, String serverName, MetadataRepositoryService repositoryService) {
        super(frame, title, true);
        this.setHelpProduct("newrepository");
        this.m_omiConnection = omiConnection;
        this.m_serverName = serverName;
        this.m_server = server;
        this.m_frame = frame;
        this.repositoryService = repositoryService;
        this._initialize();
    }

    public RegisterReposWizard(Frame frame, IOMI omiConnection, IServer server, String serverName, MetadataRepositoryService repositoryService) {
        this(frame, defaultTitle, omiConnection, server, serverName, repositoryService);
    }

    protected void _initialize() {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        WATransitionWizardModel model = new WATransitionWizardModel();
        this.setWizardModel((WAWizardModel)model);
        this.reposTypeTab = new RepositoryTypeView(this.repositoryService);
        this.nameDescTab = new GeneralRepositoryPropertyView(this.m_omiConnection, 0);
        this.pathOptionsTab = new BasicPathOptionsTab(this.m_serverName);
        this.summaryTab = new WizardFinishTab(bundle.getString("RegisterReposWizard.SummaryTab.txt"));
        this.identityTab = new NewReposIdentityListPanel(new NewReposIdentityTabInfo(), this.repositoryService);
        this.reposTypeTab.setHelpTopic("newreposwiz_1");
        this.nameDescTab.setHelpTopic("reposinfo_2");
        this.pathOptionsTab.setHelpTopic("reposdsources_3");
        this.identityTab.setHelpTopic("reposowner");
        this.summaryTab.setHelpProduct("newrepository");
        this.summaryTab.setHelpTopic("cursets_6");
        this.addTab(typeTabTitle, "TypeTab", (WAPropertyTab)this.reposTypeTab, "TypeTabImage", bundle.getImageIcon("NewReposWizard.TypeTab.image"), false);
        this.addTab(nameDescTabTitle, "NameDescTab", (WAPropertyTab)this.nameDescTab, "NameDescImage", bundle.getImageIcon("Common.NameDescriptionTab.image"), false);
        this.pathTabInfo = this.addTab(pathTabTitle, "BaseEngineTab", (WAPropertyTab)this.pathOptionsTab, "PathOptionsImage", bundle.getImageIcon("NewReposWizard.PathOptionsTab.image"), false);
        this.addTab(identityTabTitle, "IdentityTab", (WAPropertyTab)this.identityTab, "IdentityTab", bundle.getImageIcon("NewReposWizard.IdentityTab.image"), false);
        this.lastTabInfo = this.addTab(summaryTabTitle, "SummaryTab", (WAPropertyTab)this.summaryTab, "FinishTab", bundle.getImageIcon("Common.FinishTab.image"), true);
        String[][] Transitions = new String[][]{{"TypeTab", "NEXT", "NameDescTab"}, {"TypeTab", "PROJECT", "IdentityTab"}, {"IdentityTab", "NEXT", "NameDescTab"}, {"NameDescTab", "NEXT", "BaseEngineTab"}, {"BaseEngineTab", "NEXT", "SummaryTab"}};
        model.addTransitions(Transitions);
        this.addWizardData("Access", bundle.getString("NewReposWizard.RepositoryAccess.Full.txt"));
        this.addWizardData("Name", null);
        this.addWizardData("Description", null);
        this.addWizardData("Engine", null);
        this.addWizardData("Path", null);
        this.addWizardData("Options", null);
        this.addWizardData("Readonly", null);
        this.addWizardData("Server", this.m_serverName);
        this.addWizardData("Connection", this.m_omiConnection);
        this.addWizardData("Type", null);
        this.addWizardData("ChangeManaged", "No");
        this.addWizardData("IdentityForProject", null);
        this.addWizardData("StoreUserDefinitions", null);
        this.addWizardData("PathToUserRootFolder", null);
        try {
            this.m_UserAllowedToRegister = RepositoryUtil.isConnectedUserAuthorizedforRepositoryAction(Workspace.getMdFactory());
            if (!this.m_UserAllowedToRegister) {
                MessageUtil.displayMessage((String)bundle.getString("RegisterReposWizard.UserNotAuthorized.Error.txt"), (int)0, (int)-1);
            }
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0, (int)-1);
            this.m_UserAllowedToRegister = false;
        }
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void onBack() {
        super.onBack();
    }

    protected boolean onFinish() {
        try {
            if (!super.onFinish()) {
                return false;
            }
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            this._loggers = new ArrayList<Logger>();
            this._loggers.add(LogManager.getLogger((String)MGMTSVCS_PACKAGE));
            ActionLogger registerLogger = new ActionLogger("RegisterRepository", this._loggers);
            registerLogger.setTimestampsEnabled(true);
            registerLogger.setLogLevel(Level.INFO);
            try {
                registerLogger.open();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            this.m_type = (String)this.getWizardData("Type");
            if ("Foundation".equalsIgnoreCase(this.m_type)) {
                this.m_newRepos = new FoundationRepository();
            } else if ("Custom".equalsIgnoreCase(this.m_type)) {
                this.m_newRepos = new CustomRepository();
            } else if ("Project".equalsIgnoreCase(this.m_type)) {
                this.m_newRepos = new ProjectRepository();
            }
            if (this.m_newRepos == null) {
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                return false;
            }
            this.m_repName = (String)this.getWizardData("Name");
            this.m_repDesc = (String)this.getWizardData("Description");
            this.m_repOptions = (String)this.getWizardData("Options");
            this.m_repEngine = (String)this.getWizardData("Engine");
            this.m_repPath = (String)this.getWizardData("Path");
            this.m_newRepos.setName(this.m_repName);
            this.m_newRepos.setDescription(this.m_repDesc);
            if (this.m_repEngine.equals(bundle.getString("NewReposWizard.GeneralRepositoryPropertyView.Default.txt"))) {
                this.m_newRepos.setEngine("");
            } else {
                this.m_newRepos.setEngine(this.m_repEngine);
            }
            this.m_newRepos.setPath(this.m_repPath);
            this.m_newRepos.setOptions(this.m_repOptions);
            try {
                String wizardAccess = (String)this.getWizardData("Access");
                if (wizardAccess.equals(bundle.getString("NewReposWizard.RepositoryAccess.Admin.txt"))) {
                    this.m_newRepos.setRegisteredAccess(Repository.Access.ADMIN);
                    this.m_newRepos.setEffectiveAccess(Repository.Access.ADMIN);
                } else if (wizardAccess.equals(bundle.getString("NewReposWizard.RepositoryAccess.Full.txt"))) {
                    this.m_newRepos.setRegisteredAccess(Repository.Access.ONLINE);
                    this.m_newRepos.setEffectiveAccess(Repository.Access.ONLINE);
                } else if (wizardAccess.equals(bundle.getString("NewReposWizard.RepositoryAccess.None.txt"))) {
                    this.m_newRepos.setRegisteredAccess(Repository.Access.OFFLINE);
                    this.m_newRepos.setEffectiveAccess(Repository.Access.ADMIN);
                } else if (wizardAccess.equals(bundle.getString("NewReposWizard.RepositoryAccess.Readonly.txt"))) {
                    this.m_newRepos.setRegisteredAccess(Repository.Access.READONLY);
                    this.m_newRepos.setEffectiveAccess(Repository.Access.ADMIN);
                }
                if (this.m_newRepos.isProject()) {
                    IdentityReposPair projUser = (IdentityReposPair)this.getWizardData("IdentityForProject");
                    if (projUser != null) {
                        ((ProjectRepository)this.m_newRepos).setProjectOwner(projUser.getOwner().getName());
                    }
                } else {
                    boolean isChangeMgmt = false;
                    String changeManaged = (String)this.getWizardData("ChangeManaged");
                    if (changeManaged.equalsIgnoreCase("Yes")) {
                        isChangeMgmt = true;
                    }
                    if (this.m_newRepos instanceof FoundationRepository) {
                        ((FoundationRepository)this.m_newRepos).setChangeManaged(isChangeMgmt);
                    } else if (this.m_newRepos instanceof CustomRepository) {
                        ((CustomRepository)this.m_newRepos).setChangeManaged(isChangeMgmt);
                    }
                }
                this.m_newRepos = this.repositoryService.registerRepository(this.m_newRepos);
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                if (this.m_newRepos == null) {
                    MessageUtil.displayMessage((String)bundle.getString("RegisterReposWizard.RegisterFailed.Error.txt"), (int)0, (int)-1);
                }
            }
            catch (Exception e) {
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                if (e.getMessage() != null) {
                    MessageUtil.displayMessage((String)e.getMessage(), (int)0, (int)-1);
                } else {
                    e.printStackTrace();
                }
                registerLogger.close();
                registerLogger.deleteLogFile();
                return true;
            }
            MdObjectStore oStore = (MdObjectStore)this.getWizardData("OBJECTSTORE");
            if (oStore != null) {
                oStore.dispose();
            }
            registerLogger.close();
            registerLogger.deleteLogFile();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return true;
    }

    protected boolean onCancel() {
        boolean brc = super.onCancel();
        try {
            MdObjectStore oStore = (MdObjectStore)this.getWizardData("OBJECTSTORE");
            if (oStore != null) {
                oStore.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return brc;
    }

    public boolean validateData() {
        return true;
    }

    public Repository getRepository() {
        if (this.m_newRepos != null && this.m_newRepos.getId() != "A0000001.A0000001") {
            return this.m_newRepos;
        }
        return null;
    }

    public void show() {
        if (!this.m_UserAllowedToRegister) {
            return;
        }
        super.show();
    }
}

