/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsRepositoryUtil;
import com.sas.workspace.mgmt.MnemonicModel;
import com.sas.workspace.mgmt.visuals.PropertiesPropertyView;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;

public class PrototypePropertiesDialog
extends WAStandardDialog {
    protected Root m_root;
    protected String m_strContext;
    protected MdObjectStore m_objectStore;
    protected Prototype m_prototype;
    protected Hashtable m_propertiesTable;
    protected PropertiesPropertyView m_view;
    private static final WAdminResource bundle = WAdminResource.getBundle(PrototypePropertiesDialog.class);
    private static final long serialVersionUID = 4357753887254396374L;

    public PrototypePropertiesDialog(Frame frame, MdObjectStore objectStore, String strContext, Prototype prototype, String strTitle) {
        this(frame, objectStore, strContext, prototype, strTitle, null, null);
    }

    public PrototypePropertiesDialog(Frame frame, MdObjectStore objectStore, String strContext, Prototype prototype, String strTitle, Root root) {
        this(frame, objectStore, strContext, prototype, strTitle, null, root);
    }

    public PrototypePropertiesDialog(Frame frame, MdObjectStore objectStore, String strContext, Prototype prototype, String strTitle, Hashtable propertiesTable) {
        this(frame, objectStore, strContext, prototype, strTitle, propertiesTable, null);
    }

    public PrototypePropertiesDialog(Frame frame, MdObjectStore objectStore, String strContext, Prototype prototype, String strTitle, Hashtable propertiesTable, Root root) {
        super(frame, strTitle, true);
        this._init(objectStore, strContext, prototype, propertiesTable, root);
    }

    public PrototypePropertiesDialog(Dialog dialog, MdObjectStore objectStore, String strContext, Prototype prototype, String strTitle) {
        this(dialog, objectStore, strContext, prototype, strTitle, null, null);
    }

    public PrototypePropertiesDialog(Dialog dialog, MdObjectStore objectStore, String strContext, Prototype prototype, String strTitle, Root root) {
        this(dialog, objectStore, strContext, prototype, strTitle, null, root);
    }

    public PrototypePropertiesDialog(Dialog dialog, MdObjectStore objectStore, String strContext, Prototype prototype, String strTitle, Hashtable propertiesTable) {
        this(dialog, objectStore, strContext, prototype, strTitle, propertiesTable, null);
    }

    public PrototypePropertiesDialog(Dialog dialog, MdObjectStore objectStore, String strContext, Prototype prototype, String strTitle, Hashtable propertiesTable, Root root) {
        super(dialog, strTitle, true);
        this._init(objectStore, strContext, prototype, propertiesTable, root);
    }

    protected void _init(MdObjectStore objectStore, String strContext, Prototype prototype, Hashtable propertiesTable, Root root) {
        this.m_objectStore = objectStore;
        this.m_strContext = strContext;
        this.m_prototype = prototype;
        this.m_propertiesTable = propertiesTable;
        this.m_root = root;
        this._initialize();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        boolean returnValue = this.m_view.doDataExchange(bSaveToModel);
        if (bSaveToModel) {
            String strReposType;
            if (this.m_root instanceof AuthenticationDomain && !(strReposType = WsRepositoryUtil.getRepositoryType((IOMI)Workspace.getWorkspace().getCMRHandle(), (String)this.m_strContext)).equalsIgnoreCase("FOUNDATION")) {
                String strTitle;
                Object[] options = new Object[]{MnemonicModel.getLabelWithoutMnemonic(bundle.getString("Common.Yes.txt")), MnemonicModel.getLabelWithoutMnemonic(bundle.getString("Common.No.txt"))};
                String strMessage = bundle.getString("AuthenticationDomainDialog.DomainInFoundationMessage.txt");
                int retValue = JOptionPane.showOptionDialog((Component)((Object)this), strMessage, strTitle = MnemonicModel.getLabelWithoutMnemonic(bundle.getString("Common.Warning.txt")), -1, 2, null, options, options[1]);
                if (retValue != 0) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return false;
                }
            }
            try {
                this.m_root.updateMetadataAll();
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        return returnValue;
    }

    public boolean validateData() {
        return this.m_view.validateData();
    }

    public Root getMetadataObject() {
        return this.m_root;
    }

    protected void _initialize() {
        try {
            if (this.m_root == null) {
                this.m_root = (Root)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, "", this.m_prototype.getMetadataType(), this.m_strContext.substring(9));
                Object value = null;
                if (this.m_propertiesTable != null) {
                    Enumeration e = this.m_propertiesTable.keys();
                    while (e.hasMoreElements()) {
                        Root key = (Root)e.nextElement();
                        if (!key.getCMetadataType().equalsIgnoreCase(this.m_root.getCMetadataType())) continue;
                        value = this.m_propertiesTable.remove(key);
                        if (key.getFQID().indexOf(36) == -1) continue;
                        Vector<Root> objectsToRemoveList = new Vector<Root>();
                        objectsToRemoveList.add(key);
                        try {
                            ((MdObjectStore)key.getObjectStore()).removeObjectsFromStore(objectsToRemoveList);
                            break;
                        }
                        catch (MdException exc) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                        }
                        catch (RemoteException re) {
                            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                        }
                    }
                    if (value != null) {
                        this.m_propertiesTable.put(this.m_root, value);
                    }
                }
            }
            PropertyGroup group = null;
            try {
                group = this.m_prototype.getPrimaryPropertyGroup();
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
            int mode = 0;
            try {
                mode = PrototypeUtil.isGroupEntirelyExpert(group) ? 1 : 0;
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
            this.m_view = new PropertiesPropertyView(this.m_root, group, 0, mode, this.m_propertiesTable, this.m_prototype);
            this.setMainPanel((WAPanel)this.m_view);
            try {
                AssociationList extensionList = group.getExtensions();
                for (int extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                    Extension extension = (Extension)extensionList.get(extIndex);
                    if (extension.getName().equalsIgnoreCase("HelpSet")) {
                        String strHelpSet = extension.getValue();
                        this.setHelpProduct(strHelpSet);
                    }
                    if (!extension.getName().equalsIgnoreCase(mode == 0 ? "HelpTopicSimple" : "HelpTopicAdvanced")) continue;
                    String strHelpTopic = extension.getValue();
                    this.setHelpTopic(strHelpTopic);
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }
}

