/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectFactoryListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.Root;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.visuals.MetadataObjectCellRenderer;
import com.sas.workspace.mgmt.visuals.OLAPSchemaWizard;
import com.sas.workspace.mgmt.visuals.Server;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OLAPSchemaView
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected Server m_server;
    protected int m_type;
    protected List m_schemaList;
    protected JLabel m_schemaLabel;
    protected JComboBox m_schemaChoice;
    protected JButton m_schemaButton;
    private static final WAdminResource bundle = WAdminResource.getBundle(OLAPSchemaView.class);

    public OLAPSchemaView(Server server, int type) {
        super(bundle.getString("OLAPSchemaView.WizardTitle.txt"));
        this.m_server = server;
        this.m_type = type;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel) {
            if (this.m_type == 1) {
                this._setViewProperties();
            }
        } else {
            int flags = 8604;
            try {
                this.m_schemaList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_server.getDeployedComponent().getObjectStore(), this.m_server.getContext(), "OLAPSchema", flags, "");
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                return false;
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
            this.m_schemaChoice.removeAllItems();
            if (this.m_schemaList != null) {
                for (int i = 0; i < this.m_schemaList.size(); ++i) {
                    OLAPSchema schema = (OLAPSchema)this.m_schemaList.get(i);
                    this.m_schemaChoice.addItem(schema);
                }
            }
            try {
                AssociationList dataPackagesList = this.m_server.getDeployedComponent().getDataPackages(true);
                for (int dpIndex = 0; dpIndex < dataPackagesList.size(); ++dpIndex) {
                    DeployedDataPackage ddp = (DeployedDataPackage)dataPackagesList.get(dpIndex);
                    if (!(ddp instanceof OLAPSchema)) continue;
                    OLAPSchema schema = (OLAPSchema)ddp;
                    this.m_schemaChoice.setSelectedItem(schema);
                    break;
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                return false;
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
        }
        return false;
    }

    public boolean validateData() {
        boolean bValid = true;
        if (this.m_schemaChoice.getSelectedItem() == null) {
            MessageUtil.displayMessage((String)bundle.getString("OLAPSchemaView.NoSchemaError.txt"), (String)bundle.getString("Common.Error.txt"), (int)0);
            bValid = false;
            return bValid;
        }
        return bValid;
    }

    public void onNewSchema() {
        try {
            ViewListener viewListener = new ViewListener(this.m_schemaChoice);
            Workspace.getMdFactory().addMdObjectFactoryListener((MdObjectFactoryListener)viewListener);
            Container parent = this.getTopLevelAncestor();
            OLAPSchemaWizard wizard = null;
            MdObjectStore objectStore = Workspace.getMdFactory().createObjectStore();
            if (parent instanceof JFrame) {
                wizard = new OLAPSchemaWizard((JFrame)parent, bundle.getString("OLAPSchemaWizard.title.txt"), this.m_server.getContext(), (MdStore)objectStore);
            } else if (parent instanceof Dialog) {
                wizard = new OLAPSchemaWizard((Dialog)parent, bundle.getString("OLAPSchemaWizard.title.txt"), this.m_server.getContext(), (MdStore)objectStore);
            }
            wizard.show();
            if (wizard.getReturnValue() == 2) {
                Workspace.getMdFactory().removeMdObjectFactoryListener((MdObjectFactoryListener)viewListener);
            }
            objectStore.dispose();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected void _setViewProperties() {
        try {
            AssociationList dataPackagesList = this.m_server.getDeployedComponent().getDataPackages();
            OLAPSchema schema = (OLAPSchema)this.m_schemaChoice.getSelectedItem();
            if (!dataPackagesList.contains(schema)) {
                for (int dpIndex = 0; dpIndex < dataPackagesList.size(); ++dpIndex) {
                    DeployedDataPackage ddp = (DeployedDataPackage)dataPackagesList.get(dpIndex);
                    if (!(ddp instanceof OLAPSchema)) continue;
                    dataPackagesList.remove(ddp);
                    dpIndex = 0;
                }
                dataPackagesList.add(schema);
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    public void onNext() {
        this._setViewProperties();
    }

    public void onBack() {
        this._setViewProperties();
    }

    public String createFinishString() {
        String strFinish = bundle.getString("OLAPSchemaView.SchemaLabel.txt") + "\n\t" + MetadataObjectCellRenderer.getDisplayName((Root)this.m_schemaChoice.getSelectedItem()) + "\n";
        return strFinish;
    }

    protected void _initialize() {
        this.setName(bundle.getString("OLAPSchemaView.TabName.txt"));
        this.setHelpProduct("newserver");
        this.setHelpTopic("servwiz_olap_schema");
        this.m_schemaLabel = new JLabel(bundle.getString("OLAPSchemaView.SchemaLabel.txt"));
        this.m_schemaChoice = new JComboBox();
        this.m_schemaButton = new JButton();
        this.m_schemaButton.setText(Util.getLabelWithoutMnemonic((String)bundle.getString("Common.New....txt")));
        this.m_schemaButton.setMnemonic(Util.getDisplayedMnemonic((String)bundle.getString("Common.New....txt")));
        this.m_schemaButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)bundle.getString("Common.New....txt")));
        this.m_schemaButton.setMargin(new Insets(0, 4, 0, 4));
        this.m_schemaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OLAPSchemaView.this.onNewSchema();
            }
        });
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_schemaLabel, gbc);
        this.add(this.m_schemaLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_schemaChoice, gbc);
        this.add(this.m_schemaChoice);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = gridy++;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_schemaButton, gbc);
        this.add(this.m_schemaButton);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }

    protected class ViewListener
    implements MdObjectFactoryListener {
        protected JComboBox m_choice;

        public ViewListener(JComboBox choice) {
            this.m_choice = choice;
        }

        public void MdObjectCreated(MdEvent event, String strID) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(strID);
            this._onCreate(list);
        }

        public void MdObjectsCreated(MdEvent event, List idList) {
            this._onCreate(idList);
        }

        public void MdObjectDeleted(MdEvent event, String strID) {
        }

        protected void _onCreate(List idList) {
            try {
                boolean bProcessed = false;
                for (int i = 0; i < idList.size(); ++i) {
                    String strID = (String)idList.get(i);
                    CMetadata meta = Workspace.getMdFactory().getObject(strID);
                    if (meta == null || !meta.getCMetadataType().equals("OLAPSchema")) continue;
                    Root root = (Root)meta;
                    this.m_choice.removeAllItems();
                    List itemsList = null;
                    int flags = 8604;
                    try {
                        itemsList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(OLAPSchemaView.this.m_server.getDeployedComponent().getObjectStore(), OLAPSchemaView.this.m_server.getContext(), "OLAPSchema", flags, "");
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                        return;
                    }
                    catch (RemoteException re) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                    }
                    for (int j = 0; itemsList != null && j < itemsList.size(); ++j) {
                        Root itemRoot = (Root)itemsList.get(j);
                        this.m_choice.addItem(itemRoot);
                        if (!itemRoot.getFQID().equals(root.getFQID())) continue;
                        this.m_choice.setSelectedItem(itemRoot);
                        bProcessed = true;
                    }
                }
                if (bProcessed) {
                    Workspace.getMdFactory().removeMdObjectFactoryListener((MdObjectFactoryListener)this);
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }
}

