/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidAuthType;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidCredHandle;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidResourceSpec;
import com.sas.meta.SASOMI.ISecurityPackage.NotTrustedUser;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdRepositoryUtil;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.util.XMLUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.mgmt.visuals.FolderUtil;
import com.sas.workspace.mgmt.visuals.OLAPSchemaFolderException;
import com.sas.workspace.mgmt.visuals.OLAPSchemaWizard;
import com.sas.workspace.visuals.WAGeneralPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;

public class OLAPSchemaGeneralTab
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(OLAPSchemaGeneralTab.class);
    private OLAPSchema olapSchema;
    private MdObjectStore objStore;
    private WAWizardDialog parent;
    private String repositoryId;
    private static final int flags = 8456;
    private String originalName = "";
    private static final String LAST_FOLDER = "LastSelectedTreeIDGroupPanel";
    private OLAPSchemaGeneralPanel m_panel;

    public OLAPSchemaGeneralTab(CMetadata schema, String reposid) {
        super(bundle.getString("OLAPSchemaGeneralTab.instruct.txt"));
        this.olapSchema = (OLAPSchema)schema;
        try {
            this.objStore = (MdObjectStore)this.olapSchema.getObjectStore();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            this.objStore = null;
        }
        this.repositoryId = reposid;
        this._initialize();
    }

    public OLAPSchemaGeneralTab(MdStore store, String reposid) {
        super(bundle.getString("OLAPSchemaGeneralTab.instruct.txt"));
        this.olapSchema = null;
        this.objStore = (MdObjectStore)store;
        this.repositoryId = reposid;
        this._initialize();
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (bSaveToModel) {
            this.moveDataToStore();
        } else {
            this.populateStore();
            this.moveDataToView();
        }
        return true;
    }

    public void populateStore() throws MdException, RemoteException {
        Container temp = this.getTopLevelAncestor();
        if (temp instanceof WAWizardDialog) {
            this.parent = (WAWizardDialog)temp;
        }
        if (this.objStore == null && this.parent != null) {
            this.objStore = (MdObjectStore)this.parent.getWizardData("OBJECTSTORE");
        }
        if (this.olapSchema == null) {
            String shortReposid = "";
            shortReposid = this.repositoryId != "" ? this.repositoryId.substring(9, 17) : Workspace.getMdFactory().getOMIUtil().getFoundationReposID().substring(9, 17);
            this.olapSchema = (OLAPSchema)Workspace.getMdFactory().createComplexMetadataObject(this.objStore, null, "", "OLAPSchema", shortReposid, null);
        } else {
            try {
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.olapSchema, null, null, "", 8456);
                this.originalName = this.olapSchema.getName();
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
        }
        if (this.parent != null) {
            Tree tree = (Tree)this.parent.getWizardData("GROUP");
            if (tree == null) {
                try {
                    tree = WsMetadataUtil.getDefaultFolder((MdObjectStore)this.objStore);
                }
                catch (MdException ex) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                }
                catch (ServiceException e) {
                    Workspace.handleServiceException((ServiceException)e);
                }
            }
            if (tree != null) {
                this.m_panel.setOwningTree(tree);
            }
        }
        this.m_panel.setMetadataObject((Root)this.olapSchema);
        this.m_panel.populateStore();
    }

    public void moveDataToView() throws MdException, RemoteException {
        if (!this.olapSchema.isNewObject()) {
            FolderUtil.setPanelLocationRepositoryFilter(this.m_panel, (Root)this.olapSchema);
        }
        this.m_panel.moveDataToView();
    }

    public boolean validateData() {
        boolean valid = this.m_panel.validateData();
        if (!valid) {
            return valid;
        }
        if (this.m_panel.getOwningTree() == null) {
            MessageUtil.displayMessage((String)bundle.getString("GroupPanel.Error.NoFolderSelected.txt"), (int)0);
            return false;
        }
        try {
            if (!this.olapSchema.isNewObject()) {
                MdFactory factory = Workspace.getMdFactory();
                MdRepositoryUtil repositoryUtil = factory.getRepositoryUtil();
                Tree newTree = this.m_panel.getOwningTree();
                String treeReposid = factory.getOMIUtil().getReposIdFromMetadataObject((CMetadata)newTree);
                String schemaReposid = factory.getOMIUtil().getReposIdFromMetadataObject((CMetadata)this.olapSchema);
                if (!repositoryUtil.isProjectType(schemaReposid) && !treeReposid.equals(schemaReposid)) {
                    MessageUtil.displayMessage((String)bundle.getString("OLAPSchemaGeneralTab.FolderRepository.Error.txt"));
                    return false;
                }
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
            return false;
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            return false;
        }
        String newName = this.m_panel.getNameText();
        if (this.originalName.length() != 0 && this.originalName.equalsIgnoreCase(newName)) {
            return true;
        }
        int flags1 = 8588;
        String normalizedName = XMLUtil.normalize((String)newName);
        String template = "<GetMetadataObjects><Reposid>" + this.repositoryId + "</Reposid><Type>OLAPSchema</Type><Objects/><NS>SAS</NS><Flags>" + flags1 + "</Flags><Options><XMLSelect search=\"@Name='" + normalizedName + "'\"/></Options></GetMetadataObjects>";
        if (this.getNumberOfItems(template) > 0) {
            MessageUtil.displayMessage((String)bundle.getString("OLAPSchemaGeneralTab.NameExistsError.txt"), (int)0);
            return false;
        }
        return true;
    }

    public void moveDataToStore() throws MdException, RemoteException {
        Tree tree = this.m_panel.getOwningTree();
        if (this.olapSchema.isNewObject()) {
            MdFactory factory = Workspace.getMdFactory();
            MdRepositoryUtil repositoryUtil = factory.getRepositoryUtil();
            if (!repositoryUtil.isProjectType(this.repositoryId) && !tree.getRepositoryID().equals(this.repositoryId)) {
                String shortReposid = tree.getRepositoryID();
                OLAPSchema newSchema = (OLAPSchema)Workspace.getMdFactory().createComplexMetadataObject(this.objStore, null, "", "OLAPSchema", shortReposid, null);
                this.objStore.deleteObjectFromStore(this.olapSchema.getFQID());
                this.objStore.deleteObject((CMetadata)this.olapSchema);
                this.olapSchema = newSchema;
            }
            this.parent.setMasterObject((CMetadata)this.olapSchema);
            this.m_panel.setMetadataObject((Root)this.olapSchema);
        }
        this.m_panel.moveDataToStore();
        try {
            OLAPSchemaWizard.setOLAPSchemaDefaults(this.olapSchema);
        }
        catch (OLAPSchemaFolderException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        if (tree != null) {
            String nodeID = tree.getFQID();
            this.setLastFolder(nodeID);
        }
        String newName = this.m_panel.getNameText();
        if (this.originalName.length() != 0 && !this.originalName.equalsIgnoreCase(newName)) {
            AssociationList cubes = this.olapSchema.getCubes(true);
            for (int i = cubes.size() - 1; i >= 0; --i) {
                Cube cube = (Cube)cubes.get(i);
                AssociationList classifierMaps = cube.getTargetClassifierMaps(true);
                if (classifierMaps.isEmpty()) continue;
                ClassifierMap classifierMap = (ClassifierMap)classifierMaps.get(0);
                AssociationList properties = classifierMap.getProperties(true);
                for (int j = properties.size() - 1; j >= 0; --j) {
                    Property property = (Property)properties.get(j);
                    if (property.getName().equalsIgnoreCase("OLAPCubeConnection")) {
                        // empty if block
                    }
                    property.setDefaultValue(cube.getName() + "/" + this.olapSchema.getName());
                }
            }
        }
    }

    public String createFinishString() {
        String strName = bundle.getString("OLAPSchemaGeneralTab.Finish.txt");
        String strFinish = strName + "\n\t" + this.m_panel.getNameText() + "\n\n";
        return strFinish;
    }

    private void _initialize() {
        this.setHelpProduct("olapschemawiz");
        this.setHelpTopic("os_general");
        this.m_panel = new OLAPSchemaGeneralPanel((CMetadata)this.olapSchema, this.olapSchema != null, this.objStore);
        this.setLayout(new GridBagLayout());
        this.add((Component)((Object)this.m_panel), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        super.listenForDataChangesTo((WAPanel)this.m_panel);
    }

    private void setLastFolder(String folderId) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyString(LAST_FOLDER, folderId);
    }

    private int getNumberOfItems(String template) {
        int numberOfItems = 0;
        try {
            VariableArray2dOfStringHolder returnAuths = new VariableArray2dOfStringHolder();
            IOMI omiHandle = Workspace.getWorkspace().getCMRHandle();
            ISecurity_1_1 security = Workspace.getMdFactory().getConnection().MakeISecurityConnection(omiHandle);
            security.GetAuthorizations("getCountNoSecurity", "", template, "", returnAuths);
            numberOfItems = Integer.valueOf(returnAuths.value[0][1]);
            Workspace.getMdFactory().getConnection().closeISecurityConnection((ISecurity)security);
        }
        catch (RemoteException error) {
            numberOfItems = 0;
        }
        catch (MdException error) {
            numberOfItems = 0;
        }
        catch (InvalidAuthType error) {
            numberOfItems = 0;
        }
        catch (InvalidCredHandle error) {
            numberOfItems = 0;
        }
        catch (NotTrustedUser error) {
            numberOfItems = 0;
        }
        catch (GenericError error) {
            numberOfItems = 0;
        }
        catch (InvalidResourceSpec error) {
            numberOfItems = 0;
        }
        return numberOfItems;
    }

    private class OLAPSchemaGeneralPanel
    extends WAGeneralPanel {
        private static final long serialVersionUID = 1L;

        public OLAPSchemaGeneralPanel(CMetadata meta, boolean showResp, MdObjectStore store) {
            super(meta, null, false, false, showResp, true, null);
            try {
                if (meta == null || meta != null && meta.isNewObject()) {
                    this.setCustomTreePath(WsMetadataUtil.getDefaultFolder((MdObjectStore)store));
                    this.m_bTreeChanged = true;
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (ServiceException e) {
                Workspace.handleServiceException((ServiceException)e);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            }
        }

        public String getNameText() {
            return this.m_txtName.getText().trim();
        }

        public boolean hasTreeChanged() {
            return this.m_bTreeChanged;
        }
    }
}

