/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class OLAPSchemaCubeListTab
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    private OLAPSchema currentSchema;
    private CollectionToListModelAdapter cubeExistModel;
    private CollectionToListModelAdapter cubeNotCreatedModel;
    private static final WAdminResource bundle = new WAdminResource(OLAPSchemaCubeListTab.class);

    public OLAPSchemaCubeListTab(CMetadata schema) {
        super(bundle.getString("OLAPSchemaCubeListTab.instruct.txt"));
        this.currentSchema = (OLAPSchema)schema;
        this.setHelpProduct("olapschemawiz");
        this.setHelpTopic("prop_schema_cubes");
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            AssociationList cubesList = null;
            List cubesListSubset = null;
            TreeSet existSet = (TreeSet)this.cubeExistModel.getModel();
            TreeSet notExistSet = (TreeSet)this.cubeNotCreatedModel.getModel();
            try {
                cubesList = this.currentSchema.getCubes(true);
                cubesListSubset = Workspace.removeCheckouts((List)cubesList);
                existSet.clear();
                notExistSet.clear();
                for (int i = 0; i < cubesListSubset.size(); ++i) {
                    Cube nextCube = (Cube)cubesList.get(i);
                    ComparableCube cube = new ComparableCube((CMetadata)nextCube);
                    String cubeName = nextCube.getCubeName();
                    if (cubeName.length() > 0) {
                        existSet.add(cube);
                        continue;
                    }
                    notExistSet.add(cube);
                }
                this.cubeExistModel.refresh();
                this.cubeNotCreatedModel.refresh();
            }
            catch (MdException MdError) {
                MessageUtil.displayMetadataExceptionMessage((MdException)MdError, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
        }
        return true;
    }

    public boolean validateData() {
        return true;
    }

    private void _layoutWidgets() {
        this.cubeExistModel = new CollectionToListModelAdapter(new TreeSet());
        JList cubesExist = new JList(this.cubeExistModel);
        cubesExist.setName("OLAPSchemaCubeListCreated");
        cubesExist.setToolTipText(bundle.getString("OLAPSchemaCubeListTab.Tooltip.ListboxRight.txt"));
        JScrollPane existPanel = new JScrollPane(cubesExist);
        TitledBorder titledBorder2 = new TitledBorder(bundle.getString("OLAPSchemaCubeListTab.ListboxRight.Title.txt"));
        existPanel.setBorder(titledBorder2);
        existPanel.setName("OLAPSchemaEXISTScrollPane");
        this.cubeNotCreatedModel = new CollectionToListModelAdapter(new TreeSet());
        JList cubesNotCreated = new JList(this.cubeNotCreatedModel);
        cubesNotCreated.setName("OLAPSchemaCubeListNotCreated");
        cubesNotCreated.setToolTipText(bundle.getString("OLAPSchemaCubeListTab.Tooltip.ListboxLeft.txt"));
        JScrollPane notPanel = new JScrollPane(cubesNotCreated);
        TitledBorder titledBorder1 = new TitledBorder(bundle.getString("OLAPSchemaCubeListTab.ListboxLeft.Title.txt"));
        notPanel.setBorder(titledBorder1);
        notPanel.setName("OLAPSchemaNOTEXISTScrollPane");
        this.setLayout(new GridBagLayout());
        this.add(notPanel, new GridBagConstraints(0, 0, 2, 2, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(existPanel, new GridBagConstraints(2, 0, 2, 2, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public class ComparableCube
    implements Comparable {
        private String name;

        public ComparableCube(CMetadata object) {
            try {
                this.name = object.getName();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        public String toString() {
            return this.name;
        }

        public int compareTo(Object o) {
            return this.toString().compareToIgnoreCase(o.toString());
        }
    }
}

