/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerContext;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.mgmt.MnemonicModel;
import com.sas.workspace.mgmt.visuals.Library;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableModel;

public class NewLibraryPathDialog
extends WAStandardDialog {
    private Library m_library;
    private WAPanel panel;
    private JLabel serverLabel;
    private JComboBox serverChoice;
    private JLabel pathLabel;
    private DynamicEditableList pathList;
    private JScrollPane pathScrollPane;
    private JButton pathButton;
    private static final long serialVersionUID = 1L;
    protected static final WAdminResource bundle = new WAdminResource(NewLibraryPathDialog.class);

    public NewLibraryPathDialog(Dialog parent, Library library) {
        super(parent, bundle.getString("NewLibraryPathDialog.DialogTitle.txt"), true);
        this.m_library = library;
        this._initialize();
        this._layoutPanel();
        this.setMainPanel(this.panel);
    }

    protected void _initialize() {
        this.setHelpProduct("templatedata");
        this.setHelpTopic("new_path");
        this.panel = new WAPanel();
        this.serverLabel = new JLabel();
        MnemonicModel.setLabelTextAndMnemonic(this.serverLabel, bundle.getString("NewLibraryPathDialog.ServerLabel.txt"));
        this.serverLabel.getAccessibleContext().setAccessibleName(bundle.getString("NewLibraryPathDialog.ServerLabel.notrans"));
        this.serverChoice = new JComboBox();
        this.serverChoice.getAccessibleContext().setAccessibleName(bundle.getString("NewLibraryPathDialog.ServerChoice.notrans"));
        this.serverLabel.setLabelFor(this.serverChoice);
        this.pathLabel = new JLabel();
        MnemonicModel.setLabelTextAndMnemonic(this.pathLabel, bundle.getString("NewLibraryPathDialog.PathLabel.txt"));
        this.pathLabel.getAccessibleContext().setAccessibleName(bundle.getString("NewLibraryPathDialog.PathLabel.notrans"));
        this.pathList = new DynamicEditableList();
        this.pathList.getAccessibleContext().setAccessibleName(bundle.getString("NewLibraryPathDialog.PathList.notrans"));
        this.pathLabel.setLabelFor(this.pathList);
        this.pathScrollPane = new JScrollPane(this.pathList);
        this.pathScrollPane.getViewport().setBackground(this.pathList.getBackground());
        this.pathButton = new JButton();
        MnemonicModel.setButtonTextAndMnemonic(this.pathButton, bundle.getString("NewLibraryPathDialog.PathSelectorButton.txt"));
        this.pathButton.getAccessibleContext().setAccessibleName(bundle.getString("NewLibraryPathDialog.PathSelectorButton.notrans"));
        this.pathButton.setMargin(new Insets(0, 4, 0, 4));
        this.pathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewLibraryPathDialog.this.onBrowse();
            }
        });
        AssociationList lib_serverList = new Vector();
        List m_serverList = new Vector();
        Vector<DeployedComponent> serverList = new Vector<DeployedComponent>();
        try {
            String strSelect;
            String strType = "ServerContext";
            String strOptions = strSelect = "<XMLSELECT search=\"*[UsingComponents/*[@ClassIdentifier='440196D4-90F0-11D0-9F41-00A024BB830C']]\"/>";
            int flags = 8584;
            m_serverList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_library.getStore(), this.m_library.getContext(), strType, flags, strOptions);
            lib_serverList = this.m_library.getDeployedDataPackage().getDeployedComponents();
            block3: for (int i = 0; i < lib_serverList.size(); ++i) {
                DeployedComponent lib_server = (DeployedComponent)lib_serverList.get(i);
                for (int j = 0; j < m_serverList.size(); ++j) {
                    DeployedComponent m_server = (DeployedComponent)m_serverList.get(j);
                    if (!lib_server.getFQID().equalsIgnoreCase(m_server.getFQID())) continue;
                    serverList.add(lib_server);
                    continue block3;
                }
            }
            if (serverList.size() == 0) {
                serverList = m_serverList;
            }
        }
        catch (MdException mde) {
            MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Reading");
            Workspace.getDefaultLogger().error((Object)mde.getLocalizedMessage());
        }
        catch (RemoteException re) {
            String msg = re.getLocalizedMessage();
            MessageUtil.displayMessage((String)msg, (int)0);
            Workspace.getDefaultLogger().error((Object)msg);
        }
        for (int i = 0; i < serverList.size(); ++i) {
            DeployedComponent assignedServer = (DeployedComponent)serverList.get(i);
            this.serverChoice.addItem(assignedServer);
        }
        int serverCount = this.serverChoice.getItemCount();
        if (serverCount <= 1) {
            this.serverChoice.setEnabled(false);
        }
        if (serverCount == 0) {
            this.pathButton.setEnabled(false);
        }
    }

    protected void _layoutPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.panel.setLayout((LayoutManager)gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.serverLabel, gbc);
        this.panel.add((Component)this.serverLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.serverChoice, gbc);
        this.panel.add((Component)this.serverChoice);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 18;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.pathLabel, gbc);
        this.panel.add((Component)this.pathLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.pathScrollPane, gbc);
        this.panel.add((Component)this.pathScrollPane);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = gridy++;
        gbc.anchor = 18;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.pathButton, gbc);
        this.panel.add((Component)this.pathButton);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.panel.add((Component)eaterPanel);
    }

    protected void onBrowse() {
        try {
            ServerContext serverContext = null;
            serverContext = (ServerContext)this.serverChoice.getSelectedItem();
            if (serverContext != null) {
                List selectedPathList = null;
                WsAppServer appServer = WsAppServer.createAppServer((ServerContext)serverContext);
                if (appServer != null) {
                    appServer.test();
                    selectedPathList = appServer.promptForDirectories(bundle.getString("NewLibraryPathDialog.PathSelectorTitle.txt"), null, null);
                    appServer.dispose();
                }
                if (this.pathList.isEditing()) {
                    this.pathList.getCellEditor(this.pathList.getEditingRow(), this.pathList.getEditingColumn()).stopCellEditing();
                }
                if (selectedPathList != null) {
                    for (int i = 0; i < selectedPathList.size(); ++i) {
                        String selectedPath = ((String)selectedPathList.get(i)).trim();
                        if (selectedPath.length() <= 0) continue;
                        Vector<String> newRow = new Vector<String>(1);
                        newRow.addElement(selectedPath);
                        int lastRow = this.pathList.getRowCount() - 1;
                        if (((String)this.pathList.getValueAt(lastRow, 0)).trim().length() == 0) {
                            ((DefaultTableModel)this.pathList.getModel()).removeRow(lastRow);
                        }
                        ((DefaultTableModel)this.pathList.getModel()).addRow(newRow);
                    }
                }
                int lastRow = this.pathList.getRowCount() - 1;
                this.pathList.changeSelection(lastRow, 0, false, false);
                this.pathList.requestFocusInWindow();
            }
        }
        catch (WsAppServerFailException wasfe) {
            String msg = wasfe.getLocalizedMessage();
            Workspace.getDefaultLogger().error((Object)msg);
            MessageUtil.displayMessage((String)msg, (int)0);
        }
        catch (GenericError ge) {
            String msg = ge.getLocalizedMessage();
            Workspace.getDefaultLogger().error((Object)msg);
            MessageUtil.displayMessage((String)msg, (int)0);
        }
    }

    protected boolean validateData() {
        boolean bValidated = true;
        if (this.pathList.isEditing()) {
            this.pathList.getCellEditor(this.pathList.getEditingRow(), this.pathList.getEditingColumn()).stopCellEditing();
        }
        if (this.pathList.getRowCount() == 1 && ((String)this.pathList.getValueAt(0, 0)).trim().length() == 0) {
            MessageUtil.displayMessage((String)bundle.getString("NewLibraryPathDialog.Path.Required.txt"), (int)0);
            bValidated = false;
        }
        return bValidated;
    }

    protected List getPaths() {
        Vector<Object> pList = new Vector<Object>();
        for (int i = 0; i < this.pathList.getRowCount(); ++i) {
            String item = (String)this.pathList.getValueAt(i, 0);
            if (item.trim().length() == 0) continue;
            pList.add(this.pathList.getValueAt(i, 0));
        }
        return pList;
    }

    protected class DynamicEditableList
    extends JTable {
        private static final long serialVersionUID = 1L;

        public DynamicEditableList() {
            Vector<String> rowOne = new Vector<String>(1);
            rowOne.addElement("");
            Vector<Vector<String>> rowData = new Vector<Vector<String>>(1);
            rowData.addElement(rowOne);
            Vector<String> columnNames = new Vector<String>(1);
            columnNames.addElement("");
            DefaultTableModel model = new DefaultTableModel(rowData, columnNames);
            this.setModel(model);
            this.setTableHeader(null);
            this.setShowGrid(false);
            this.setRowSelectionAllowed(false);
            this.setPreferredScrollableViewportSize(new Dimension(250, this.getRowHeight() * 4));
            this.changeSelection(0, 0, false, false);
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            super.editingStopped(e);
            int lastRow = this.getRowCount() - 1;
            if (((String)this.getValueAt(lastRow, 0)).trim().length() != 0) {
                Vector<String> newRow = new Vector<String>(1);
                newRow.addElement("");
                ((DefaultTableModel)this.getModel()).addRow(newRow);
                lastRow = this.getRowCount() - 1;
                this.changeSelection(lastRow, 0, false, false);
                this.requestFocusInWindow();
            }
            int i = 0;
            while (i < this.getRowCount() - 1) {
                if (((String)this.getValueAt(i, 0)).trim().length() == 0) {
                    ((DefaultTableModel)this.getModel()).removeRow(i);
                    i = 0;
                    continue;
                }
                ++i;
            }
        }
    }
}

