/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.MnemonicModel;
import com.sas.workspace.mgmt.visuals.AuthenticationDomainDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AuthenticationPropertyView
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    protected MdObjectStore m_objectStore;
    protected String m_strContext;
    protected int m_type;
    protected WATextArea m_titleText;
    protected JLabel m_domainLabel;
    protected JComboBox m_domainChoice;
    protected JButton m_newButton;
    protected boolean m_bTypeChoicePopulated = false;
    private static final WAdminResource bundle = WAdminResource.getBundle(AuthenticationPropertyView.class);

    public AuthenticationPropertyView(MdObjectStore objectStore, String strContext, int type) {
        this.m_objectStore = objectStore;
        this.m_strContext = strContext;
        this.m_type = type;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            try {
                int flags = 8456;
                List domainList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_objectStore, this.m_strContext, "AuthenticationDomain", flags, "");
                for (int i = 0; i < domainList.size(); ++i) {
                    AuthenticationDomain domain = (AuthenticationDomain)domainList.get(i);
                    this.m_domainChoice.addItem(domain);
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
        }
        return false;
    }

    public boolean validateData() {
        return true;
    }

    public AuthenticationDomain getDomain() {
        return (AuthenticationDomain)this.m_domainChoice.getSelectedItem();
    }

    public void setDomain(AuthenticationDomain domain) {
        this.m_domainChoice.setSelectedItem(domain);
    }

    public void onNew() {
        try {
            MdObjectStore dialogStore = Workspace.getMdFactory().createObjectStore((MdStore)this.m_objectStore);
            AuthenticationDomainDialog dialog = new AuthenticationDomainDialog((Dialog)((WAStandardDialog)this.getTopLevelAncestor()), dialogStore, this.m_strContext);
            dialog.show();
            if (dialog.getReturnValue() == 1) {
                AuthenticationDomain domain = dialog.getAuthenticationDomain();
                this.m_domainChoice.addItem(domain);
                this.m_domainChoice.setSelectedItem(domain);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void onNext() {
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        parent.addWizardData("Domain", this.m_domainChoice.getSelectedItem());
    }

    public void onBack() {
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        parent.removeWizardData("Domain");
    }

    protected void _initialize() {
        this.setName(bundle.getString("AuthenticationPropertyView.TabName.txt"));
        if (this.m_type == 0) {
            this.m_titleText = new WATextArea(bundle.getString("AuthenticationPropertyView.WizardTitle.txt"));
            this.m_titleText.setEditable(false);
            this.m_titleText.setLineWrap(true);
            this.m_titleText.setWrapStyleWord(true);
            this.m_titleText.setBorder(null);
            this.m_titleText.setBackground(this.getBackground());
        }
        this.m_domainLabel = new JLabel(bundle.getString("AuthenticationPropertyView.AuthDomain.txt"));
        this.m_domainChoice = new JComboBox();
        this.m_newButton = new JButton();
        MnemonicModel.setButtonTextAndMnemonic(this.m_newButton, bundle.getString("Common.New....txt"));
        this.m_newButton.setMargin(new Insets(0, 4, 0, 4));
        this.m_newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuthenticationPropertyView.this.onNew();
            }
        });
    }

    protected void _layoutWidgets() {
        GridBagConstraints gbc;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        if (this.m_type == 0) {
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.gridwidth = 0;
            gbc.fill = 2;
            gbc.insets = new Insets(12, 12, 0, 12);
            gridBagLayout.setConstraints((Component)this.m_titleText, gbc);
            this.add((Component)this.m_titleText);
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_domainLabel, gbc);
        this.add(this.m_domainLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = -1;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_domainChoice, gbc);
        this.add(this.m_domainChoice);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = gridy++;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_newButton, gbc);
        this.add(this.m_newButton);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.insets = new Insets(12, 12, 12, 12);
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }
}

