/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.IgnoreFilter;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.CursorNode;
import org.apache.derby.impl.sql.compile.DMLModStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.HalfOuterJoinNode;
import org.apache.derby.impl.sql.compile.HasNodeVisitor;
import org.apache.derby.impl.sql.compile.MatchingClauseNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.ScrollInsensitiveResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.StaticMethodCallNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.SubqueryNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

public final class MergeNode
extends DMLModStatementNode {
    public static final int SOURCE_TABLE_INDEX = 0;
    public static final int TARGET_TABLE_INDEX = 1;
    private static final String TARGET_ROW_LOCATION_NAME = "###TargetRowLocation";
    private FromBaseTable _targetTable;
    private FromTable _sourceTable;
    private ValueNode _searchCondition;
    private QueryTreeNodeVector<MatchingClauseNode> _matchingClauses;
    private ResultColumnList _selectList;
    private FromList _leftJoinFromList;
    private HalfOuterJoinNode _hojn;
    private ConstantAction _constantAction;
    private CursorNode _leftJoinCursor;

    public MergeNode(FromTable targetTable, FromTable sourceTable, ValueNode searchCondition, QueryTreeNodeVector<MatchingClauseNode> matchingClauses, ContextManager cm) throws StandardException {
        super(null, null, cm);
        if (!(targetTable instanceof FromBaseTable)) {
            this.notBaseTable();
        } else {
            this._targetTable = (FromBaseTable)targetTable;
        }
        this._sourceTable = sourceTable;
        this._searchCondition = searchCondition;
        this._matchingClauses = matchingClauses;
    }

    FromBaseTable getTargetTable() {
        return this._targetTable;
    }

    void associateColumn(FromList fromList, ColumnReference cr, int mergeTableID) throws StandardException {
        if (mergeTableID != 0) {
            cr.setMergeTableID(mergeTableID);
        } else {
            String columnsTableName = cr.getTableName();
            if (((FromTable)fromList.elementAt(0)).getMatchingColumn(cr) != null) {
                cr.setMergeTableID(1);
            } else if (((FromTable)fromList.elementAt(1)).getMatchingColumn(cr) != null) {
                cr.setMergeTableID(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindExpression(ValueNode value, FromList fromList) throws StandardException {
        CompilerContext cc = this.getCompilerContext();
        int previousReliability = cc.getReliability();
        cc.setReliability(previousReliability | 0x2000);
        cc.pushCurrentPrivType(0);
        try {
            value.bindExpression(fromList, new SubqueryList(this.getContextManager()), new ArrayList<AggregateNode>());
        }
        finally {
            cc.popCurrentPrivType();
            cc.setReliability(previousReliability);
        }
    }

    void getColumnsInExpression(HashMap<String, ColumnReference> map, ValueNode expression, int mergeTableID) throws StandardException {
        if (expression == null) {
            return;
        }
        List<ColumnReference> colRefs = this.getColumnReferences(expression);
        this.getColumnsFromList(map, colRefs, mergeTableID);
    }

    void getColumnsFromList(HashMap<String, ColumnReference> map, ResultColumnList rcl, int mergeTableID) throws StandardException {
        List<ColumnReference> colRefs = this.getColumnReferences(rcl);
        this.getColumnsFromList(map, colRefs, mergeTableID);
    }

    @Override
    public void bindStatement() throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        if (!(this._sourceTable instanceof FromVTI) && !(this._sourceTable instanceof FromBaseTable)) {
            throw StandardException.newException("42XAL", new Object[0]);
        }
        if (this.getExposedName(this._targetTable).equals(this.getExposedName(this._sourceTable))) {
            throw StandardException.newException("42XAM", new Object[0]);
        }
        this.forbidDerivedColumnLists();
        this.forbidSynonyms();
        IgnoreFilter ignorePermissions = new IgnoreFilter();
        this.getCompilerContext().addPrivilegeFilter(ignorePermissions);
        FromList dfl = new FromList(this.getContextManager());
        FromTable dflSource = this.cloneFromTable(this._sourceTable);
        FromBaseTable dflTarget = (FromBaseTable)this.cloneFromTable(this._targetTable);
        dfl.addFromTable(dflSource);
        dfl.addFromTable(dflTarget);
        dfl.bindTables(dd, new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager()));
        if (!this.targetIsBaseTable(dflTarget)) {
            this.notBaseTable();
        }
        this.getCompilerContext().removePrivilegeFilter(ignorePermissions);
        for (MatchingClauseNode mcn : this._matchingClauses) {
            FromList dummyFromList = this.cloneFromList(dd, dflTarget);
            FromBaseTable dummyTargetTable = (FromBaseTable)dummyFromList.elementAt(1);
            mcn.bind(dd, this, dummyFromList, dummyTargetTable);
            SelectNode.checkNoWindowFunctions(mcn, "matching clause");
            MergeNode.checkNoAggregates(mcn);
        }
        this.bindLeftJoin(dd);
    }

    static void checkNoAggregates(QueryTreeNode clause) throws StandardException {
        HasNodeVisitor visitor = new HasNodeVisitor(AggregateNode.class, SubqueryNode.class);
        clause.accept(visitor);
        if (visitor.hasNode()) {
            throw StandardException.newException("42Z09", new Object[0]);
        }
    }

    private String getExposedName(FromTable ft) throws StandardException {
        return ft.getTableName().getTableName();
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this._sourceTable.referencesSessionSchema() || this._targetTable.referencesSessionSchema() || this._searchCondition.referencesSessionSchema() || this._matchingClauses.referencesSessionSchema();
    }

    private void forbidDerivedColumnLists() throws StandardException {
        if (this._sourceTable.getResultColumns() != null || this._targetTable.getResultColumns() != null) {
            throw StandardException.newException("42XAQ", new Object[0]);
        }
    }

    private void forbidSynonyms() throws StandardException {
        this.forbidSynonyms(this._targetTable.getTableNameField().cloneMe());
        if (this._sourceTable instanceof FromBaseTable) {
            this.forbidSynonyms(((FromBaseTable)this._sourceTable).getTableNameField().cloneMe());
        }
    }

    private void forbidSynonyms(TableName tableName) throws StandardException {
        tableName.bind();
        TableName synonym = this.resolveTableToSynonym(tableName);
        if (synonym != null) {
            throw StandardException.newException("42XAP", new Object[0]);
        }
    }

    private void notBaseTable() throws StandardException {
        throw StandardException.newException("42XAK", new Object[0]);
    }

    private boolean targetIsBaseTable(FromBaseTable targetTable) throws StandardException {
        FromBaseTable fbt = targetTable;
        TableDescriptor desc = fbt.getTableDescriptor();
        if (desc == null) {
            return false;
        }
        switch (desc.getTableType()) {
            case 0: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private boolean sourceIsBase_or_VTI() throws StandardException {
        if (this._sourceTable instanceof FromVTI) {
            return true;
        }
        if (!(this._sourceTable instanceof FromBaseTable)) {
            return false;
        }
        FromBaseTable fbt = (FromBaseTable)this._sourceTable;
        TableDescriptor desc = fbt.getTableDescriptor();
        if (desc == null) {
            return false;
        }
        switch (desc.getTableType()) {
            case 0: 
            case 1: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindLeftJoin(DataDictionary dd) throws StandardException {
        CompilerContext cc = this.getCompilerContext();
        int previousReliability = cc.getReliability();
        try {
            cc.setReliability(previousReliability | 0x2000);
            IgnoreFilter ignorePermissions = new IgnoreFilter();
            this.getCompilerContext().addPrivilegeFilter(ignorePermissions);
            this._hojn = new HalfOuterJoinNode(this._sourceTable, this._targetTable, this._searchCondition, null, false, null, this.getContextManager());
            this._leftJoinFromList = this._hojn.makeFromList(true, true);
            this._leftJoinFromList.bindTables(dd, new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager()));
            if (!this.sourceIsBase_or_VTI()) {
                throw StandardException.newException("42XAL", new Object[0]);
            }
            FromList topFromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
            topFromList.addFromTable(this._hojn);
            this.getCompilerContext().removePrivilegeFilter(ignorePermissions);
            for (MatchingClauseNode mcn : this._matchingClauses) {
                mcn.bindRefinement(this, this._leftJoinFromList);
            }
            ResultColumnList selectList = this.buildSelectList();
            this._selectList = selectList.copyListAndObjects();
            this.resultSet = new SelectNode(selectList, topFromList, null, null, null, null, null, this.getContextManager());
            this._leftJoinCursor = new CursorNode("SELECT", this.resultSet, null, null, null, null, false, 1, null, true, this.getContextManager());
            this.getCompilerContext().addPrivilegeFilter(ignorePermissions);
            this._leftJoinCursor.bindStatement();
            this.getCompilerContext().removePrivilegeFilter(ignorePermissions);
            this.addOnClausePrivileges();
        }
        finally {
            cc.setReliability(previousReliability);
        }
    }

    private FromList cloneFromList(DataDictionary dd, FromBaseTable targetTable) throws StandardException {
        FromList dummyFromList = new FromList(this.getContextManager());
        FromBaseTable dummyTargetTable = new FromBaseTable(targetTable.getTableNameField(), targetTable.correlationName, null, null, this.getContextManager());
        FromTable dummySourceTable = this.cloneFromTable(this._sourceTable);
        dummyTargetTable.setMergeTableID(2);
        dummySourceTable.setMergeTableID(1);
        dummyFromList.addFromTable(dummySourceTable);
        dummyFromList.addFromTable(dummyTargetTable);
        IgnoreFilter ignorePermissions = new IgnoreFilter();
        this.getCompilerContext().addPrivilegeFilter(ignorePermissions);
        dummyFromList.bindTables(dd, new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager()));
        this.getCompilerContext().removePrivilegeFilter(ignorePermissions);
        return dummyFromList;
    }

    private FromTable cloneFromTable(FromTable fromTable) throws StandardException {
        if (fromTable instanceof FromVTI) {
            FromVTI source = (FromVTI)fromTable;
            return new FromVTI(source.methodCall, source.correlationName, source.getResultColumns(), null, source.exposedName, this.getContextManager());
        }
        if (fromTable instanceof FromBaseTable) {
            FromBaseTable source = (FromBaseTable)fromTable;
            return new FromBaseTable(source.tableName, source.correlationName, null, null, this.getContextManager());
        }
        throw StandardException.newException("42XAL", new Object[0]);
    }

    private void addOnClausePrivileges() throws StandardException {
        for (ColumnReference cr : this.getColumnReferences(this._searchCondition)) {
            this.addColumnPrivilege(cr);
        }
        for (StaticMethodCallNode routine : this.getRoutineReferences(this._searchCondition)) {
            this.addRoutinePrivilege(routine);
        }
        for (CastNode value : this.getCastNodes(this._searchCondition)) {
            this.addUDTUsagePriv(value);
        }
    }

    private void addColumnPrivilege(ColumnReference cr) throws StandardException {
        ColumnDescriptor colDesc;
        CompilerContext cc = this.getCompilerContext();
        ResultColumn rc = cr.getSource();
        if (rc != null && (colDesc = rc.getColumnDescriptor()) != null) {
            cc.pushCurrentPrivType(0);
            cc.addRequiredColumnPriv(colDesc);
            cc.popCurrentPrivType();
        }
    }

    private void addRoutinePrivilege(StaticMethodCallNode routine) throws StandardException {
        CompilerContext cc = this.getCompilerContext();
        cc.pushCurrentPrivType(6);
        cc.addRequiredRoutinePriv(routine.ad);
        cc.popCurrentPrivType();
    }

    private List<CastNode> getCastNodes(QueryTreeNode expression) throws StandardException {
        CollectNodesVisitor<CastNode> getCNs = new CollectNodesVisitor<CastNode>(CastNode.class);
        expression.accept(getCNs);
        return getCNs.getList();
    }

    private List<StaticMethodCallNode> getRoutineReferences(QueryTreeNode expression) throws StandardException {
        CollectNodesVisitor<StaticMethodCallNode> getSMCNs = new CollectNodesVisitor<StaticMethodCallNode>(StaticMethodCallNode.class);
        expression.accept(getSMCNs);
        return getSMCNs.getList();
    }

    private ResultColumnList buildSelectList() throws StandardException {
        HashMap<String, ColumnReference> drivingColumnMap = new HashMap<String, ColumnReference>();
        this.getColumnsInExpression(drivingColumnMap, this._searchCondition, 0);
        for (MatchingClauseNode mcn : this._matchingClauses) {
            mcn.getColumnsInExpressions(this, drivingColumnMap);
            int mergeTableID = mcn.isDeleteClause() ? 2 : 0;
            this.getColumnsFromList(drivingColumnMap, mcn.getThenColumns(), mergeTableID);
        }
        ResultColumnList selectList = new ResultColumnList(this.getContextManager());
        this.addColumns((FromTable)this._leftJoinFromList.elementAt(0), drivingColumnMap, selectList, 1);
        this.addColumns((FromTable)this._leftJoinFromList.elementAt(1), drivingColumnMap, selectList, 2);
        this.addTargetRowLocation(selectList);
        return selectList;
    }

    private void addTargetRowLocation(ResultColumnList selectList) throws StandardException {
        this._targetTable.setRowLocationColumnName(TARGET_ROW_LOCATION_NAME);
        TableName fromTableName = this._targetTable.getTableName();
        ColumnReference cr = new ColumnReference(TARGET_ROW_LOCATION_NAME, fromTableName, this.getContextManager());
        cr.setMergeTableID(2);
        ResultColumn rowLocationColumn = new ResultColumn((String)null, (ValueNode)cr, this.getContextManager());
        rowLocationColumn.markGenerated();
        selectList.addResultColumn(rowLocationColumn);
    }

    private void addColumns(FromTable fromTable, HashMap<String, ColumnReference> drivingColumnMap, ResultColumnList selectList, int mergeTableID) throws StandardException {
        String[] columnNames = this.getColumns(mergeTableID, drivingColumnMap);
        TableName tableName = fromTable.getTableName();
        for (int i = 0; i < columnNames.length; ++i) {
            ColumnReference cr = new ColumnReference(columnNames[i], tableName, this.getContextManager());
            cr.setMergeTableID(mergeTableID);
            ResultColumn rc = new ResultColumn((String)null, (ValueNode)cr, this.getContextManager());
            selectList.addResultColumn(rc);
        }
    }

    private String[] getColumns(int mergeTableID, HashMap<String, ColumnReference> map) {
        HashSet<String> set = new HashSet<String>();
        for (ColumnReference cr : map.values()) {
            if (cr.getMergeTableID() != mergeTableID) continue;
            set.add(cr.getColumnName());
        }
        Object[] retval = new String[set.size()];
        set.toArray(retval);
        Arrays.sort(retval);
        return retval;
    }

    private List<ColumnReference> getColumnReferences(QueryTreeNode expression) throws StandardException {
        CollectNodesVisitor<ColumnReference> getCRs = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
        expression.accept(getCRs);
        return getCRs.getList();
    }

    private void getColumnsFromList(HashMap<String, ColumnReference> map, List<ColumnReference> colRefs, int mergeTableID) throws StandardException {
        for (ColumnReference cr : colRefs) {
            this.addColumn(map, cr, mergeTableID);
        }
    }

    void addColumn(HashMap<String, ColumnReference> map, ColumnReference cr, int mergeTableID) throws StandardException {
        if (((ColumnReference)cr).getTableName() == null) {
            cr = ((ColumnReference)cr).bindExpression(this._leftJoinFromList, new SubqueryList(this.getContextManager()), (List)new ArrayList());
            TableName tableName = ((ColumnReference)cr).getQualifiedTableName();
            cr = new ColumnReference(((ColumnReference)cr).getColumnName(), tableName, this.getContextManager());
        }
        this.associateColumn(this._leftJoinFromList, (ColumnReference)cr, mergeTableID);
        String key = this.makeDCMKey(((ColumnReference)cr).getTableName(), ((ColumnReference)cr).getColumnName());
        ColumnReference mapCR = map.get(key);
        if (mapCR != null) {
            mapCR.setMergeTableID(((ColumnReference)cr).getMergeTableID());
        } else {
            map.put(key, (ColumnReference)cr);
        }
    }

    private String makeDCMKey(String tableName, String columnName) {
        return IdUtil.mkQualifiedName(tableName, columnName);
    }

    @Override
    public void optimizeStatement() throws StandardException {
        IgnoreFilter ignorePermissions = new IgnoreFilter();
        this.getCompilerContext().addPrivilegeFilter(ignorePermissions);
        this._leftJoinCursor.optimizeStatement();
        for (MatchingClauseNode mcn : this._matchingClauses) {
            mcn.optimize();
        }
        this.getCompilerContext().removePrivilegeFilter(ignorePermissions);
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        int clauseCount = this._matchingClauses.size();
        this.generateParameterValueSet(acb);
        acb.pushGetResultSetFactoryExpression(mb);
        this._leftJoinCursor.generate(acb, mb);
        ScrollInsensitiveResultSetNode sirs = (ScrollInsensitiveResultSetNode)this._leftJoinCursor.resultSet;
        ResultSetNode generatedScan = sirs.getChildResult();
        ConstantAction[] clauseActions = new ConstantAction[clauseCount];
        for (int i = 0; i < clauseCount; ++i) {
            MatchingClauseNode mcn = this._matchingClauses.elementAt(i);
            mcn.generate(acb, this._selectList, generatedScan, this._hojn, i);
            clauseActions[i] = mcn.makeConstantAction(acb);
        }
        this._constantAction = this.getGenericConstantActionFactory().getMergeConstantAction(clauseActions);
        mb.callMethod((short)185, null, "getMergeResultSet", "org.apache.derby.iapi.sql.ResultSet", 1);
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this._constantAction;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        if (this._leftJoinCursor != null) {
            this._leftJoinCursor.acceptChildren(v);
        } else {
            super.acceptChildren(v);
            this._targetTable.accept(v);
            this._sourceTable.accept(v);
            this._searchCondition.accept(v);
        }
        for (MatchingClauseNode mcn : this._matchingClauses) {
            mcn.accept(v);
        }
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        this.printLabel(depth, "targetTable: ");
        this._targetTable.treePrint(depth + 1);
        this.printLabel(depth, "sourceTable: ");
        this._sourceTable.treePrint(depth + 1);
        if (this._searchCondition != null) {
            this.printLabel(depth, "searchCondition: ");
            this._searchCondition.treePrint(depth + 1);
        }
        for (MatchingClauseNode mcn : this._matchingClauses) {
            this.printLabel(depth, mcn.toString());
            mcn.treePrint(depth + 1);
        }
    }

    @Override
    String statementToString() {
        return "MERGE";
    }
}

