/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class NetworkUtilities {
    private static final Logger LOGGER = LogManager.getLogger(NetworkUtilities.class);
    private static final String CONNECTION_ERROR = "Could not connect to {0}.  The operation could not be completed";

    public static void checkIsValidUrl(URL url) throws IOException {
        NetworkUtilities.checkUrlNotNull(url);
        try (InputStream stream = null;){
            stream = NetworkUtilities.getStreamForURL(url);
        }
    }

    private static void checkNotNull(Object object, String label) {
        if (object != null) {
            return;
        }
        String message = String.format("%s must not be null", label);
        throw new IllegalArgumentException(message);
    }

    private static void checkUrlNotNull(URL url) {
        NetworkUtilities.checkNotNull(url, "url");
    }

    private static String createConnectionErrorMessage(URL url, IOException exception) {
        String message = MessageFormat.format(CONNECTION_ERROR, url);
        LOGGER.info(message, (Throwable)exception);
        return message;
    }

    public static URLConnection getConnectionForURL(URL url) throws IOException {
        NetworkUtilities.checkUrlNotNull(url);
        try {
            return url.openConnection();
        }
        catch (IOException exception) {
            String message = NetworkUtilities.createConnectionErrorMessage(url, exception);
            throw new IOException(message, exception);
        }
    }

    public static InputStream getStreamForConnection(URLConnection connection) throws IOException {
        NetworkUtilities.checkNotNull(connection, "connection");
        try {
            return connection.getInputStream();
        }
        catch (IOException exception) {
            URL url = connection.getURL();
            String message = NetworkUtilities.createConnectionErrorMessage(url, exception);
            throw new IOException(message, exception);
        }
    }

    public static InputStream getStreamForURL(URL url) throws IOException {
        NetworkUtilities.checkUrlNotNull(url);
        try {
            return url.openStream();
        }
        catch (IOException exception) {
            String message = NetworkUtilities.createConnectionErrorMessage(url, exception);
            throw new IOException(message, exception);
        }
    }

    private NetworkUtilities() {
    }
}

