/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.utilities;

import com.sas.solstice.platform.core.dao.Results;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FileUtilities {
    public static final String COPY_ERROR = "The attempt to copy content to {0} failed.  The operation could not be completed.";
    public static final String PATH_CREATION_ERROR = "Unable to create destination directory {0}.";
    private static Logger logger = LogManager.getLogger(FileUtilities.class);
    private static final String OS_NAME_PROPERTY_KEY = "os.name";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, URI destinationURI, long contentLength) throws IOException {
        FileChannel dstChannel;
        ReadableByteChannel srcChannel = Channels.newChannel(inputStream);
        File destination = new File(destinationURI);
        File parent = destination.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            String message = MessageFormat.format(PATH_CREATION_ERROR, parent);
            IOException directoryCreationError = new IOException(message);
            FileUtilities.logError(message, directoryCreationError);
            throw directoryCreationError;
        }
        try {
            FileOutputStream stream = new FileOutputStream(destination);
            dstChannel = stream.getChannel();
        }
        catch (IOException exception) {
            FileUtilities.logError("Error writing to " + destinationURI, exception);
            throw exception;
        }
        try {
            try {
                long lastRead;
                for (long downloadedBytes = 0L; downloadedBytes < contentLength; downloadedBytes += lastRead) {
                    lastRead = dstChannel.transferFrom(srcChannel, 0L, contentLength - downloadedBytes);
                    if (lastRead != 0L) continue;
                    break;
                }
            }
            finally {
                srcChannel.close();
                dstChannel.close();
            }
        }
        catch (IOException exception) {
            String message = MessageFormat.format(COPY_ERROR, destinationURI);
            FileUtilities.logError(message, exception);
            throw new IOException(message, exception);
        }
    }

    private static void logError(String message, Exception exception) {
        logger.error(message, (Throwable)exception);
    }

    public static Results saveFile(byte[] bytes, String destinationFilePath, boolean deleteExistingDestinationFile) {
        return FileUtilities.saveFile(bytes, destinationFilePath, deleteExistingDestinationFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Results doExec(String[] args, int timeOut) {
        Results results = new Results();
        Runtime rt = Runtime.getRuntime();
        Process proc = null;
        try {
            proc = rt.exec(args);
            Worker worker = new Worker(proc);
            worker.start();
            try {
                int total = timeOut * 1000;
                Long longTimeOut = total;
                worker.join(longTimeOut);
                Integer exit = worker.getExit();
                int status = 2;
                int substatus = 0;
                String message = "Operation timed out";
                if (exit != null) {
                    status = 0;
                    substatus = exit;
                    if (substatus != 0) {
                        status = 4;
                    }
                    message = FileUtilities.constructProcMessage(worker);
                }
                results.setStatus(status);
                results.setSubstatus(substatus);
                results.setMessage(message);
            }
            catch (InterruptedException ex) {
                worker.interrupt();
                Thread.currentThread().interrupt();
                results.setStatus(2);
                results.setMessage("Operation was interrupted");
            }
            finally {
                proc.destroy();
            }
        }
        catch (IOException e) {
            results.setStatus(4);
            results.setMessage(e.getMessage());
            results.setException(e);
        }
        return results;
    }

    private static String constructProcMessage(Worker worker) {
        StringBuffer message = new StringBuffer("");
        Integer exit = worker.getExit();
        if (exit == null) {
            return message.toString();
        }
        message.append(String.format("Return code: %s", exit));
        if (exit == 0) {
            return message.toString();
        }
        String value = worker.getErrorMessage();
        message.append(String.format("\nErrorStream: %s", value));
        return message.toString();
    }

    public static int getPosixFilePermissions(String filePath) throws Exception {
        if (FileUtilities.isWindows()) {
            return 0;
        }
        int filemode = FileUtilities.GetOctalFileMode(filePath);
        return filemode;
    }

    public static void setPosixFilePermissions(String filePath, int mode) throws Exception {
        if (FileUtilities.isWindows()) {
            return;
        }
        int success = FileUtilities.SetOctalFileMode(filePath, mode);
        if (success != 0) {
            throw new Exception("Error setting permissions to " + mode + " for file " + filePath);
        }
    }

    private static boolean isWindows() {
        String name = FileUtilities.getOperatingSystemName();
        boolean state = name.contains("win");
        return state;
    }

    private static String getOperatingSystemName() {
        String value = FileUtilities.getProperty(OS_NAME_PROPERTY_KEY);
        value = FileUtilities.toLowercase(value);
        return value;
    }

    private static String toLowercase(String value) {
        Locale locale = Locale.getDefault();
        return value.toLowerCase(locale);
    }

    private static String getProperty(String key) {
        return System.getProperty(key);
    }

    public static Results saveFile(byte[] bytes, String destinationFilePath, boolean deleteExistingDestinationFile, boolean overwriteReadOnlyDestinationFile) {
        boolean deleted;
        File file = new File(destinationFilePath);
        Results results = FileUtilities.canSaveFile(file, overwriteReadOnlyDestinationFile);
        if (!results.isOk()) {
            return results;
        }
        if (deleteExistingDestinationFile && file.isFile() && !(deleted = file.delete())) {
            String message = String.format("Failed to delete the destination file: \"%s\"", file);
            results.setStatus(4);
            results.setMessage(message);
            logger.debug(message);
            return results;
        }
        File parent = file.getParentFile();
        boolean success = parent.mkdirs();
        if (success) {
            String message = String.format("Created the parent directory \"%s\"", parent);
            logger.debug(message);
        }
        try {
            boolean created = file.createNewFile();
            if (created) {
                String message = String.format("Created the file \"%s\"", file);
                logger.debug(message);
            }
            FileUtilities.append(file, bytes);
        }
        catch (IOException exception) {
            String message = exception.getMessage();
            results.setMessage(message);
            results.setStatus(4);
        }
        return results;
    }

    private static Results canSaveFile(File file, boolean overwriteReadOnlyDestinationFile) {
        Results result = new Results();
        result.setStatus(0);
        boolean isDirectory = file.isDirectory();
        if (isDirectory) {
            String message = String.format("The destination file must not be a directory: \"%s\"", file);
            result.setStatus(4);
            result.setMessage(message);
            logger.debug(message);
            return result;
        }
        boolean exists = file.isFile();
        if (!exists) {
            return result;
        }
        if (!overwriteReadOnlyDestinationFile && !file.canWrite()) {
            String message = String.format("The destination file is read-only: \"%s\"", file);
            result.setStatus(4);
            result.setMessage(message);
            logger.debug(message);
            return result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void append(File file, byte[] bytes) throws IOException {
        long length = file.length();
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            raf.seek(length);
            raf.write(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyDirectory(File source, File target) throws IOException {
        if (source.isDirectory()) {
            if (!target.exists()) {
                target.mkdir();
            }
            String[] children = source.list();
            for (int i = 0; i < children.length; ++i) {
                FileUtilities.copyDirectory(new File(source, children[i]), new File(target, children[i]));
            }
        } else {
            FileInputStream in = new FileInputStream(source);
            FileOutputStream out = new FileOutputStream(target);
            try {
                int len;
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
            }
            finally {
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
        }
    }

    public static int GetOctalFileMode(String filepath) {
        String retval = Integer.toOctalString(FileUtilities.GetFileMode(filepath));
        int length = retval.length();
        if (length > 9) {
            retval = retval.substring(length - 9, length);
        }
        return Integer.parseInt(retval);
    }

    public static int SetOctalFileMode(String filepath, int mode) throws Exception {
        if (!new File(filepath).exists()) {
            throw new Exception("Missing file " + filepath + " when try to set  mode to " + mode);
        }
        String fileMode = String.valueOf(mode);
        return FileUtilities.SetFileMode(filepath, Integer.valueOf(fileMode, 8));
    }

    public static int GetFileMode(String filepath) {
        int return_value = 0;
        File filename = new File(filepath);
        if (!FileUtilities.isWindows() && filename.exists()) {
            try {
                Map<String, Object> mapFileAttrs = Files.readAttributes(filename.toPath(), "unix:mode", new LinkOption[0]);
                return_value = (Integer)mapFileAttrs.get("mode");
                return_value &= 0x1FF;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return return_value;
    }

    public static int SetFileMode(String filepath, int mode) {
        int return_value = 0;
        File filename = new File(filepath);
        if (!FileUtilities.isWindows() && filename.exists()) {
            try {
                Files.setAttribute(filename.toPath(), "unix:mode", mode, new LinkOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return return_value;
    }

    private static final class Worker
    extends Thread {
        private final Process process;
        private Integer exit;

        private Worker(Process process) {
            this.process = process;
        }

        public String getErrorMessage() {
            InputStream stream = this.process.getErrorStream();
            if (stream == null) {
                return "No output available from process";
            }
            return this.getErrorString(stream);
        }

        private String getErrorString(InputStream stream) {
            try {
                return new Scanner(stream).useDelimiter("\\A").next();
            }
            catch (Exception e) {
                return "Unable to get error stream from process";
            }
        }

        private Integer getExit() {
            return this.exit;
        }

        @Override
        public void run() {
            try {
                this.exit = this.process.waitFor();
            }
            catch (InterruptedException ignore) {
                return;
            }
        }
    }
}

