/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.core.password.crypto.sas;

import com.sas.solstice.platform.core.password.crypto.CipherInterface;
import com.sas.solstice.platform.core.password.crypto.Crypto;
import com.sas.solstice.platform.core.password.crypto.CryptoException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public final class SasCrypto
extends Crypto
implements CipherInterface {
    public static final String PROPERTYNAME_KEY = SasCrypto.class.getPackage().getName() + ".KEY";
    public static final String PROPERTYNAME_POWER = SasCrypto.class.getPackage().getName() + ".POWER";
    public static final String PROPERTYNAME_RADIX = SasCrypto.class.getPackage().getName() + ".RADIX";
    private static final String name = "SASPROPRIETARY";
    private static final long intMask = 0xFFFFFFFFL;
    private static final long shortMask = 65535L;
    private static final long byteMask = 255L;
    private static final int encryptPower = 1083423147;
    private static final int decryptPower = 3;
    private static final int maxPlain = 65535;
    private static final int maxCipher = 87384;
    private static final int minBuffer = 1024;
    private byte[] encodeBuffer = new byte[1024];
    private byte[] decodeBuffer = new byte[1024];
    private int key;
    private int power;

    public SasCrypto(Properties properties) {
        String radixS = properties != null ? properties.getProperty(PROPERTYNAME_RADIX) : null;
        int radix = radixS != null ? Integer.parseInt(radixS) : 10;
        String keyS = properties != null ? properties.getProperty(PROPERTYNAME_KEY) : null;
        this.key = keyS == null ? 1625277439 : Integer.parseInt(keyS, radix);
        String powerS = properties != null ? properties.getProperty(PROPERTYNAME_POWER) : null;
        this.power = powerS == null ? 1083423147 : Integer.parseInt(powerS, radix);
    }

    @Override
    public String getSupportedNames() {
        return name;
    }

    @Override
    public CipherInterface openCipher() throws CryptoException {
        return this;
    }

    @Override
    public void keyExchange(InputStream iStream, OutputStream oStream) throws IOException, CryptoException {
    }

    @Override
    public int getCipherTextLength(int plainTextLength) {
        if (plainTextLength == 0) {
            return 0;
        }
        int segments = plainTextLength / 65535;
        int remainder = plainTextLength % 65535;
        return segments * 87384 + (remainder + 5) / 3 * 4;
    }

    @Override
    public int getMaxPlainTextLength(int cipherTextLength) {
        if (cipherTextLength < 4) {
            return 0;
        }
        int segments = cipherTextLength / 87384;
        int remainder = cipherTextLength % 87384;
        return segments * 65535 + remainder * 3 / 4 - 5 + 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int encrypt(byte[] plainText, int offset, int plainTextLength, OutputStream oStream) throws IOException, CryptoException {
        if (plainTextLength == 0) {
            return 0;
        }
        int bufferLength = plainTextLength > 65535 ? 87384 : this.getCipherTextLength(plainTextLength);
        int segments = plainTextLength / 65535;
        int cipherTotalLength = 0;
        int cipherSegmentLength = 0;
        byte[] byArray = this.encodeBuffer;
        synchronized (this.encodeBuffer) {
            if (this.encodeBuffer.length < bufferLength) {
                this.encodeBuffer = new byte[bufferLength];
            }
            for (int i = 0; i < segments; ++i) {
                cipherSegmentLength = SasCrypto.zscode(this.key, this.power, plainText, offset, 65535, false, this.encodeBuffer, 0);
                oStream.write(this.encodeBuffer, 0, cipherSegmentLength);
                cipherTotalLength += cipherSegmentLength;
                offset += 65535;
                plainTextLength -= 65535;
            }
            cipherSegmentLength = SasCrypto.zscode(this.key, this.power, plainText, offset, plainTextLength, false, this.encodeBuffer, 0);
            oStream.write(this.encodeBuffer, 0, cipherSegmentLength);
            oStream.flush();
            // ** MonitorExit[var9_9] (shouldn't be in output)
            return cipherTotalLength += cipherSegmentLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int decrypt(InputStream iStream, int cipherTextLength, byte[] buffer, int offset) throws IOException, CryptoException {
        if (cipherTextLength < 4) {
            return 0;
        }
        for (int i = offset; i < buffer.length; ++i) {
            buffer[i] = 120;
        }
        int segments = cipherTextLength / 87384;
        int plainTotalLength = 0;
        int plainSegmentLength = 0;
        int bufferLength = cipherTextLength > 87384 ? 87384 : cipherTextLength;
        byte[] byArray = this.decodeBuffer;
        synchronized (this.decodeBuffer) {
            if (this.decodeBuffer.length < bufferLength) {
                this.decodeBuffer = new byte[bufferLength];
            }
            for (int i = 0; i < segments; ++i) {
                SasCrypto.readFully(iStream, this.decodeBuffer, 0, 87384);
                cipherTextLength -= 87384;
                plainSegmentLength = SasCrypto.zscode(this.key, 3, this.decodeBuffer, 0, 87384, true, buffer, offset);
                plainTotalLength += plainSegmentLength;
                offset += plainSegmentLength;
            }
            SasCrypto.readFully(iStream, this.decodeBuffer, 0, cipherTextLength);
            plainSegmentLength = SasCrypto.zscode(this.key, 3, this.decodeBuffer, 0, cipherTextLength, true, buffer, offset);
            // ** MonitorExit[var9_9] (shouldn't be in output)
            return plainTotalLength += plainSegmentLength;
        }
    }

    @Override
    public void close() throws CryptoException {
    }

    public String toString() {
        return name;
    }

    private static int zscode(int key, int power, byte[] si, int iOff, int iLen, boolean flag, byte[] so, int oOff) {
        long ukey = (long)key & 0xFFFFFFFFL;
        long upower = (long)power & 0xFFFFFFFFL;
        long v0 = ukey >>> 16;
        long c = v0 >>> 8;
        long cc = 1L;
        long cd = c >>> 1;
        while (cd != 0L) {
            cd >>>= 1;
            cc <<= 1;
        }
        --cc;
        int i = 0;
        long m = 0L;
        long ca = 0L;
        int n = 0;
        long[] pl = new long[2];
        long[] ql = new long[2];
        if (flag) {
            v0 = 0L;
            for (i = 3; i >= 0; --i) {
                v0 = (v0 << 8) + ((long)si[i + iOff] & 0xFFL);
            }
            c = SasCrypto.zpowmod(v0, upower, ukey, pl, ql) & 0xFFFFFFFFL;
            m = c & 0xFFFFL;
            ca = m & 0xFFL;
            i = iOff + 4;
            n = oOff;
        } else {
            m = (long)si[iOff + (iLen >>> 1)] & 0xFFL;
            v0 = (m << 16) + (long)iLen;
            c = SasCrypto.zpowmod(v0, upower, ukey, pl, ql) & 0xFFFFFFFFL;
            m = ((long)iLen + 5L) / 3L << 2;
            for (i = 0; i < 4; ++i) {
                so[i + oOff] = (byte)(c & 0xFFL);
                c >>= 8;
            }
            ca = (long)so[oOff] & 0xFFL;
            i = iOff;
            n = oOff + 4;
        }
        int end = (int)m + oOff;
        byte[] a = new byte[4];
        while (i < iOff + iLen) {
            int j;
            v0 = flag ? (long)si[i++] & 0xFFL : cc & ca;
            for (j = 0; j < 3; ++j) {
                v0 = (v0 << 8) + (i < iOff + iLen ? (long)si[i++] & 0xFFL : 0L);
            }
            c = SasCrypto.zpowmod(v0, upower, ukey, pl, ql);
            for (j = 0; j < 4; ++j) {
                a[j] = (byte)(c & 0xFFL);
                c >>= 8;
            }
            if (!flag) {
                so[n++] = a[3];
            }
            if (n < end) {
                so[n++] = a[2];
            }
            if (n < end) {
                so[n++] = a[1];
            }
            if (n >= end) continue;
            ca = a[0];
            so[n++] = a[0];
        }
        return (int)m;
    }

    private static long zpowmod(long b, long p, long m, long[] pl, long[] ql) {
        long r = 1L;
        if (p == 0L) {
            return r;
        }
        while (true) {
            if (b > Integer.MAX_VALUE) {
                if ((p & 1L) != 0L) {
                    r = SasCrypto.zmod4(r, b, m, pl, ql);
                    if (p == 1L) break;
                }
                b = SasCrypto.zmod4(b, b, m, pl, ql);
            } else {
                if ((p & 1L) != 0L) {
                    r = r > Integer.MAX_VALUE ? SasCrypto.zmod4(r, b, m, pl, ql) : r * b % m;
                    if (p == 1L) break;
                }
                b = b * b % m;
            }
            p /= 2L;
        }
        return r & 0xFFFFFFFFL;
    }

    private static long zmod4(long a, long b, long m, long[] pl, long[] ql) {
        int il;
        for (il = 0; il < pl.length; ++il) {
            pl[il] = 0L;
        }
        for (il = 0; il < ql.length; ++il) {
            ql[il] = 0L;
        }
        long s = 0L;
        SasCrypto.zprod4(a &= 0xFFFFFFFFL, b &= 0xFFFFFFFFL, pl);
        pl[0] = pl[0] & 0xFFFFFFFFL;
        pl[0] = pl[0] % (m &= 0xFFFFFFFFL);
        int shift = 0;
        while ((m & Integer.MIN_VALUE) == 0L) {
            m &= 0xFFFFFFFFL;
            pl[0] = pl[0] << 1;
            pl[0] = pl[0] & 0xFFFFFFFFL;
            if ((pl[1] & Integer.MIN_VALUE) != 0L) {
                pl[0] = pl[0] + 1L;
                pl[0] = pl[0] & 0xFFFFFFFFL;
            }
            pl[1] = pl[1] << 1;
            pl[1] = pl[1] & 0xFFFFFFFFL;
            ++shift;
            m <<= 1;
        }
        for (int i = 0; i < 2; ++i) {
            s = pl[0];
            if (i == 1) {
                s <<= 16;
                s &= 0xFFFFFFFFL;
                s += pl[1] >>> 16;
                s &= 0xFFFFFFFFL;
            }
            a = s / (m >>> 16 & 0xFFFFFFFFL);
            if (i == 0) {
                a <<= 16;
            }
            SasCrypto.zprod4(a &= 0xFFFFFFFFL, m, ql);
            if (ql[1] > pl[1]) {
                pl[0] = pl[0] - 1L;
                pl[0] = pl[0] & 0xFFFFFFFFL;
            }
            pl[1] = pl[1] - ql[1];
            pl[1] = pl[1] & 0xFFFFFFFFL;
            pl[0] = pl[0] - ql[0];
            pl[0] = pl[0] & 0xFFFFFFFFL;
            while ((pl[0] & 0x80000000L) != 0L) {
                pl[1] = pl[1] + m;
                pl[1] = pl[1] & 0xFFFFFFFFL;
                if (pl[1] >= m) continue;
                pl[0] = pl[0] + 1L;
                pl[0] = pl[0] & 0xFFFFFFFFL;
            }
        }
        return pl[1] >>> shift & 0xFFFFFFFFL;
    }

    private static void zprod4(long a, long b, long[] c) {
        long s11 = 0L;
        long s10 = 0L;
        long s01 = 0L;
        long s00 = 0L;
        long b1 = 0L;
        s00 = (b &= 0xFFFFFFFFL) >>> 16;
        b1 = b - (s00 << 16 & 0xFFFFFFFFL);
        s10 = a >>> 16;
        s01 = a - (s10 << 16 & 0xFFFFFFFFL);
        s11 = (b1 &= 0xFFFFFFFFL) * s01;
        s01 *= s00;
        s00 *= s10;
        s10 *= b1;
        s00 &= 0xFFFFFFFFL;
        s10 &= 0xFFFFFFFFL;
        s11 &= 0xFFFFFFFFL;
        s10 += (s01 &= 0xFFFFFFFFL);
        if ((s10 &= 0xFFFFFFFFL) < s01) {
            s00 += 65536L;
        }
        s00 &= 0xFFFFFFFFL;
        s01 = s10 >>> 16;
        b1 = s10 - (s01 << 16 & 0xFFFFFFFFL);
        b1 &= 0xFFFFFFFFL;
        b1 <<= 16;
        s11 += (b1 &= 0xFFFFFFFFL);
        if ((s11 &= 0xFFFFFFFFL) < b1) {
            ++s00;
        }
        s00 &= 0xFFFFFFFFL;
        s00 += s01;
        c[0] = s00 &= 0xFFFFFFFFL;
        c[1] = s11;
        c[0] = c[0] & 0xFFFFFFFFL;
        c[1] = c[1] & 0xFFFFFFFFL;
    }

    private static void readFully(InputStream iStream, byte[] buffer, int offset, int length) throws IOException {
        int i;
        int bytesRead = 0;
        do {
            if ((i = iStream.read(buffer, offset + bytesRead, length - bytesRead)) >= 0) continue;
            throw new EOFException();
        } while ((bytesRead += i) < length);
    }
}

