/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.core.dao;

import com.sas.solstice.platform.core.access.IResults;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Results
implements IResults,
Serializable {
    private static final long serialVersionUID = 2013574081589984618L;
    private int status;
    private int _substatus;
    private String host;
    private Properties props;
    private Map<String, Object> _requestParameters = new LinkedHashMap<String, Object>();
    private String _message;
    private Exception _exception;
    private List<Results> _children;

    public void addRequestParameter(String key, Object requestParameter) {
        this._requestParameters.put(key, requestParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(Results results) {
        Results results2 = this;
        synchronized (results2) {
            if (this._children == null) {
                this._children = new ArrayList<Results>();
            }
            this._children.add(results);
        }
    }

    public Results[] getChildren() {
        if (this._children == null) {
            return new Results[0];
        }
        Results[] children = new Results[this._children.size()];
        return this._children.toArray(children);
    }

    @Override
    public Exception getException() {
        return this._exception;
    }

    public String getHost() {
        return this.host;
    }

    @Override
    public String getMessage() {
        return this._message;
    }

    public Properties getProperties() {
        return this.props;
    }

    public Map<String, Object> getRequestParameters() {
        return this._requestParameters;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    private String getStatusLabel() {
        int status = this.getStatus();
        if (status == 0) {
            return "OK";
        }
        if (status == 1) {
            return "INFO";
        }
        if (status == 4) {
            return "ERROR";
        }
        if (status == 8) {
            return "CANCEL";
        }
        return String.format("<Unknown:%d>", status);
    }

    @Override
    public int getSubstatus() {
        return this._substatus;
    }

    public boolean hasChildren() {
        return this._children != null && !this._children.isEmpty();
    }

    public boolean hasRequestParameters() {
        return !this._requestParameters.isEmpty();
    }

    @Override
    public boolean isOk() {
        return this.status == 0;
    }

    public boolean needParameters() {
        return !this.hasRequestParameters();
    }

    private void printExceptionOn(StringBuffer buffer) {
        Exception exception = this.getException();
        if (exception == null) {
            return;
        }
        String message = exception.getMessage();
        if (message == null) {
            return;
        }
        String value = String.format(", exception=\"%s\"", message);
        buffer.append(value);
    }

    private void printMessageOn(StringBuffer buffer) {
        String message = this.getMessage();
        if (message == null) {
            return;
        }
        String value = String.format(", message=\"%s\"", message);
        buffer.append(value);
    }

    private void printOn(StringBuffer buffer) {
        this.printStatusOn(buffer);
        this.printMessageOn(buffer);
        this.printExceptionOn(buffer);
    }

    private void printStatusOn(StringBuffer buffer) {
        String label = this.getStatusLabel();
        String value = String.format(", status=%s", label);
        buffer.append(value);
    }

    public void setException(Exception exception) {
        this._exception = exception;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setMessage(String message) {
        this._message = message;
    }

    public void setProperties(Properties props) {
        this.props = props;
    }

    public void setRequestParameters(Map<String, Object> requestParameters) {
        this._requestParameters = requestParameters;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setSubstatus(int status) {
        this._substatus = status;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        String value = super.toString();
        buffer.append(value);
        this.printOn(buffer);
        return buffer.toString();
    }
}

